package com.hippo.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.hippo.R;
import com.hippo.model.ContentValue;

import java.util.ArrayList;

/**
 * Created by gurmail on 06/02/19.
 *
 * @author gurmail
 */
public class BotActionButtonAdapter extends RecyclerView.Adapter<BotActionButtonAdapter.ActionButtonViewHolder> {

    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private ArrayList<ContentValue> mActionButtons;

    public BotActionButtonAdapter(Context mContext, ArrayList<ContentValue> mActionButtons) {
        this.mContext = mContext;
        mLayoutInflater = LayoutInflater.from(mContext);
        this.mActionButtons = mActionButtons;
    }

    @NonNull
    @Override
    public ActionButtonViewHolder onCreateViewHolder(final ViewGroup parent, final int viewType) {
        View main = mLayoutInflater.inflate(R.layout.hippo_list_item_action_button, parent, false);
        return new ActionButtonViewHolder(main);
    }

    @Override
    public void onBindViewHolder(@NonNull ActionButtonViewHolder holder, int i) {
        int pos = holder.getAdapterPosition();
        ContentValue actionButton = mActionButtons.get(pos);
        holder.btnAction.setText(actionButton.getBtnTitle());

    }

    @Override
    public int getItemCount() {
        return mActionButtons.size();
    }

    /**
     * Action Button ViewHolder
     */
    class ActionButtonViewHolder extends RecyclerView.ViewHolder {

        Button btnAction;

        ActionButtonViewHolder(final View itemView) {
            super(itemView);
            btnAction = itemView.findViewById(R.id.btnAction);
//            btnAction.setOnClickListener(new View.OnClickListener() {
//                @Override
//                public void onClick(final View v) {
//                    ((FuguChatActivity) mContext).onCustomActionClicked(mActionButtons.get(getAdapterPosition())
//                            .getButtonAction());
//                }
//            });
        }
    }
}
