package com.hippo;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.PermissionChecker;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import com.downloader.PRDownloader;
import com.downloader.PRDownloaderConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.hippo.activity.CustomerInitalActivity;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentBroadcastActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.ConversationMode;
import com.hippo.agent.Util.SPLabels;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.agent.listeners.AgentListener;
import com.hippo.agent.model.ApiResponseFlags;
import com.hippo.agent.model.GetConversationResponse;
import com.hippo.agent.model.LoginModel.UserData;
import com.hippo.agent.model.LoginResponse;
import com.hippo.agent.model.broadcastStatus.BroadcastResponseModel;
import com.hippo.agent.model.getConversationResponse.Conversation;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.interfaces.fayeClient;
import com.hippo.model.*;
import com.hippo.receiver.FuguNetworkStateReceiver;
import com.hippo.retrofit.*;
import com.hippo.support.HippoSupportActivity;
import com.hippo.utils.*;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.loadingBox.LoadingBox;
import faye.FayeClient;
import faye.MetaMessage;
import io.paperdb.Paper;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.*;

import static android.content.Context.ACTIVITY_SERVICE;


/**
 * Created by gurmail on 27/12/18.
 *
 * @author gurmail
 */
public class HippoConfig implements FuguAppConstant {

    private static final String TAG = HippoConfig.class.getSimpleName();
    private static HippoConfig hippoConfig;
    private CaptureUserData userData;
    private static HippoConfigAttributes configAttributes;

    private String serverUrl = "";

    //Drawable
    private int homeUpIndicatorDrawableId = R.drawable.hippo_ic_arrow_back;
    private int videoCallNotificationDrawable = R.drawable.hippo_default_notif_icon;
    private int videoCallDrawableId = -1;//R.drawable.hippo_ic_info;
    private int audioCallDrawableId = -1;
    private int chatInfoDrawable = -1;
    private int homeIconDrawable = -1;
    private int broadcastDrawable = -1;

    public String appKey = "";
    private String appType = "1";
//    private String agentAuthToken = "";
    private HippoConfigAttributes attributes;

    private static String mResellerToken;
    private static int mReferenceId = -1;

    protected Context context;
    private Activity activity;
    private long lastClickTime = 0;

    private boolean isDataCleared = true;
    public static boolean DEBUG = false;
    private boolean isChannelActivity;
    private static boolean isUnreadRequired;

    // Initial Meta FuguMessage
    private static MetaMessage meta = new MetaMessage();
    // Initinal FayeClient
    private static FayeClient mClient;
    public static boolean progressLoader = true;

    private HippoConfig() {

    }

    public static long getMaxSize() {
        try {
            Long maxFileSize = 26214400l;
            if(AgentCommonData.isAgentFlow()) {
                maxFileSize = AgentCommonData.getUserData().getMaxFileSize();
            } else {
                maxFileSize = CommonData.getUserDetails().getData().getMaxFileSize();
            }
            return maxFileSize;
        } catch (Exception e) {
            if(HippoConfig.DEBUG)
                e.printStackTrace();
        }
        return 26214400;
    }

    public Context getContext() {
        return context;
    }

    public static HippoConfig getInstance() {
        if(hippoConfig == null) {
            hippoConfig = new HippoConfig();
        }
        return hippoConfig;
    }

    private HippoConfigAttributes getAttributes() {
        if(attributes == null) {
            attributes = CommonData.getAttributes();
        }
        return attributes;
    }

    public static HippoConfig initHippoConfig(Activity activity, HippoConfigAttributes attributes) {
        hippoConfig = getInstance();
        Paper.init(activity);

        DEBUG = attributes.isShowLog();
        HippoConfig.getInstance().activity = activity;
        AgentCommonData.setAgentLoginInit(attributes.isManager());
        if (!CommonData.getClearHippoDataKey()) {
            try {
                CommonData.clearData();
                CommonData.setClearHippoDataKey(true);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (TextUtils.isEmpty(attributes.getProvider())) {
            new CustomAlertDialog.Builder(activity)
                    .setMessage("Provider cannot be null")
                    .setPositiveButton("Ok", new CustomAlertDialog.CustomDialogInterface.OnClickListener() {
                        @Override
                        public void onClick() {
                            HippoConfig.getInstance().activity.finish();
                        }
                    })
                    .show();
        } else {
            CommonData.setProvider(attributes.getProvider());
        }
        if(attributes.getColorConfig() != null) {
            CommonData.setColorConfig(attributes.getColorConfig());
        }
        try {
            CommonData.saveDeviceToken(attributes.getDeviceToken());
        } catch (Exception e) {
            if(HippoConfig.DEBUG)
                e.printStackTrace();
        }
        CommonData.saveFuguConfigAttribute(attributes);
        HippoLog.v("inside initHippoConfig", "inside initHippoConfig");
        hippoConfig.setFuguConfig(activity, attributes);

        return hippoConfig;
    }

    private void initDownloader() {
        PRDownloaderConfig config = PRDownloaderConfig.newBuilder()
                .setDatabaseEnabled(true)
                .setReadTimeout(30_000)
                .setConnectTimeout(30_000)
                .build();
        PRDownloader.initialize(activity, config);
    }

    private void setFuguConfig(final Activity activity, HippoConfigAttributes attributes) {
        String environment = TextUtils.isEmpty(attributes.getEnvironment()) ? "live" : attributes.getEnvironment();
        if (environment != null && environment.equalsIgnoreCase("test")) {
            HippoConfig.getInstance().serverUrl = TEST_SERVER;
            CommonData.setServerUrl(TEST_SERVER);
        } else if(environment != null && environment.equalsIgnoreCase("dev")) {
            HippoConfig.getInstance().serverUrl = DEV_SERVER;
            CommonData.setServerUrl(DEV_SERVER);
        } else if (environment != null && environment.equalsIgnoreCase("beta-live")) {
            HippoConfig.getInstance().serverUrl = BETA_LIVE_SERVER; //test server
            CommonData.setServerUrl(BETA_LIVE_SERVER);
        } else {
            HippoConfig.getInstance().serverUrl = LIVE_SERVER; // live server
            CommonData.setServerUrl(LIVE_SERVER);
        }
        this.attributes = attributes;
        registerNetworkListener(activity);

        if(attributes.isManager()) {
            initHippoManager(activity, attributes);
        } else {
            if(!TextUtils.isEmpty(CommonData.getUserCountryCode())) {
                initHippoCustomer(activity, attributes);
            } else {
                new ApiPutUserDetails(activity, null).getUserContryInfo(attributes, new ApiPutUserDetails.UserCallback() {
                    @Override
                    public void onSuccess(UserInfoModel userInfoModel, HippoConfigAttributes attributes) {
                        initHippoCustomer(activity, attributes);
                    }
                });
            }

        }

    }

    private void initHippoCustomer(Activity activity, HippoConfigAttributes attributes) {
        HippoConfig.getInstance().appKey = attributes.getAppKey();
        HippoConfig.getInstance().appType = attributes.getAppType();
        if(HippoConfig.getInstance().appKey != null)
            CommonData.setAppSecretKey(HippoConfig.getInstance().appKey);
        CommonData.setAppType(HippoConfig.getInstance().appType);
        CommonData.clearLeftTimeInSec();
        updateUserDetails(activity, attributes);
    }

    private void initHippoManager(Activity activity, HippoConfigAttributes attributes) {
//        HippoConfig.getInstance().agentAuthToken = attributes.getAuthToken();
        AgentCommonData.setPagerOrder(attributes.isReversePageOrder());
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().context = activity;
        HippoConfig.getInstance().appType = attributes.getAppType();
        CommonData.setAppType(HippoConfig.getInstance().appType);

        if(attributes.isWhitelabel()) {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(FuguAppConstant.AGENT_SECRET_KEY, attributes.getAuthToken())
                    .add(FuguAppConstant.DEVICE_TYPE, 1)
                    .add(FuguAppConstant.DEVICE_TOKEN, hippoConfig.getAttributes().getDeviceToken())
                    .add("device_id", UniqueIMEIID.getUniqueIMEIId(activity))
                    .add(DEVICE_DETAILS, CommonData.deviceDetails(activity))
                    .add(APP_VERSION, BuildConfig.VERSION_CODE)
                    .add(APP_SOURCE, String.valueOf(2))
                    .add(APP_TYPE, appType)
                    .build(2);
            getAgentToken(activity, commonParams.getMap(), attributes.getCustomAttributes());
        } else {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(FuguAppConstant.AUTH_TOKEN, attributes.getAuthToken())
                    .add(FuguAppConstant.DEVICE_TYPE, 1)
                    .add(FuguAppConstant.DEVICE_TOKEN, hippoConfig.getAttributes().getDeviceToken())
                    .add("device_id", UniqueIMEIID.getUniqueIMEIId(activity))
                    .add(DEVICE_DETAILS, CommonData.deviceDetails(activity))
                    .add(APP_VERSION, BuildConfig.VERSION_CODE)
                    .add(APP_SOURCE, String.valueOf(2))
                    .add(APP_TYPE, appType)
                    .build(2);
            agentTokenVerfy(activity, commonParams.getMap(), attributes.getCustomAttributes());
        }
    }

    private void updateUserDetails(Activity activity, final HippoConfigAttributes attributes) {
        HippoConfig.getInstance().isDataCleared = false;
        CommonData.setIsDataCleared(false);
        HippoConfig.getInstance().activity = activity;
        HippoConfig.getInstance().context = activity;
        HippoConfig.getInstance().appType = attributes.getAppType();
        HippoConfig.getInstance().userData = attributes.getCaptureUserData() == null ? new CaptureUserData()
                : attributes.getCaptureUserData();
        CommonData.saveUserData(HippoConfig.getInstance().userData);

        new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback() {
            @Override
            public void onSuccess() {
                if(attributes.isUnreadCount())
                    getUnreadCount(HippoConfig.getInstance().activity, CommonData.getUserDetails().getData().getEn_user_id());
            }

            @Override
            public void onFailure() {

            }
        }).sendUserDetails(attributes.getResellerToken(), attributes.getReferenceId());
    }

    private void getAgentToken(final Activity activity, final Map<String, Object> stringMap,
                               final HashMap<String, Object> customAttributes) {
        apiInProgress = true;
        RestClient.getAgentApiInterface().getAgentToken(stringMap)
                .enqueue(new ResponseResolver<LoginResponse>() {
                    @Override
                    public void success(LoginResponse loginResponse) {
                        CommonParams.Builder builder = new CommonParams.Builder();
                        builder.add(FuguAppConstant.ACCESS_TOKEN, loginResponse.getUserData().getAccessToken());
                        builder.add(FuguAppConstant.DEVICE_TYPE, 1);
                        builder.add(FuguAppConstant.DEVICE_TOKEN, hippoConfig.getAttributes().getDeviceToken());
                        builder.add(DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity));
                        builder.add(DEVICE_DETAILS, CommonData.deviceDetails(activity));
                        builder.add(APP_SOURCE, String.valueOf(2));
                        builder.add(APP_VERSION, BuildConfig.VERSION_CODE);
                        builder.add(APP_TYPE, stringMap.get(APP_TYPE));
                        if (customAttributes != null && customAttributes.size()>0 && !customAttributes.isEmpty()) {
                            builder.add(CUSTOM_ATTRIBUTES, new JSONObject(customAttributes));
                        }

                        CommonParams commonParams = builder.build(2);
                        agentTokenLogin(activity, commonParams.getMap());
                    }

                    @Override
                    public void failure(APIError error) {
                        LoadingBox.hide();
                        Log.e(TAG, "Token not verified: " + error.getMessage());
                        clearLocalData();
                        apiInProgress = false;
                    }
                });
    }
    private void agentTokenVerfy(final Activity activity, final Map<String, Object> stringMap,
                                 final HashMap<String, Object> customAttributes) {
        apiInProgress = true;
        RestClient.getAgentApiInterface().verifyAuthToken(stringMap)
                .enqueue(new ResponseResolver<LoginResponse>() {
                    @Override
                    public void success(LoginResponse loginResponse) {
                        CommonParams.Builder builder = new CommonParams.Builder();
                        builder.add(FuguAppConstant.ACCESS_TOKEN, loginResponse.getUserData().getAccessToken());
                        builder.add(FuguAppConstant.DEVICE_TYPE, 1);
                        builder.add(FuguAppConstant.DEVICE_TOKEN, hippoConfig.getAttributes().getDeviceToken());
                        builder.add(DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity));
                        builder.add(DEVICE_DETAILS, CommonData.deviceDetails(activity));
                        builder.add(APP_SOURCE, String.valueOf(2));
                        builder.add(APP_VERSION, BuildConfig.VERSION_CODE);
                        builder.add(APP_TYPE, stringMap.get(APP_TYPE));
                        if (customAttributes != null && customAttributes.size()>0 && !customAttributes.isEmpty()) {
                            builder.add(CUSTOM_ATTRIBUTES, new JSONObject(customAttributes));
                        }

                        CommonParams commonParams = builder.build(2);
                        agentTokenLogin(activity, commonParams.getMap());
                    }

                    @Override
                    public void failure(APIError error) {
                        LoadingBox.hide();
                        Log.e(TAG, "Token not verified: " + error.getMessage());
                        clearLocalData();
                        apiInProgress = false;
                    }
                });
    }

    private void agentTokenLogin(final Activity activity, Map<String, Object> stringMap) {
        RestClient.getAgentApiInterface().login(stringMap)
                .enqueue(new ResponseResolver<LoginResponse>() {
                    @Override
                    public void success(LoginResponse loginResponse) {
                        try {
                            if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == loginResponse.getStatusCode()) {

                                Paper.book().delete(SPLabels.USER_DATA);
                                Paper.book().delete(SPLabels.TAGS);
                                AgentCommonData.saveUserData(loginResponse.getUserData());
                                AgentCommonData.saveTags(loginResponse.getUserData().getTags());
                                CommonData.setUserId(String.valueOf(loginResponse.getUserData().getUserId()));
                                apiInProgress = false;
                                HippoConfig.getInstance().isDataCleared = false;
                                checkSavedQueue();

                            } else {
                                Toast.makeText(activity, loginResponse.getMessage(), Toast.LENGTH_SHORT).show();
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        apiInProgress = false;
                        LoadingBox.hide();
                    }

                    @Override
                    public void failure(APIError error) {
                        apiInProgress = false;
                        clearLocalData();
                        Log.e(TAG, "Agent Login failed: " + error.getMessage());
                        LoadingBox.hide();
                    }
                });
    }

    private void checkSavedQueue() {
        for (String str : objectQueue) {
            switch (str) {
                case "open_agent_screen":
                    Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
                    intent.putExtra("title", chatTitle);
                    activity.startActivity(intent);
                    break;
                case "get_agent_count":
                    UnreadCountHelper.getInstance().getUpdatedUnreadCount(strings, unreadCount);
                    break;
                case "start_conversation":
                    Intent intent1 = new Intent(activity.getApplicationContext(), AgentListActivity.class);
                    intent1.putExtra("title", title);
                    intent1.putExtra("user_unique_key", userUniqueKey);
                    activity.startActivity(intent1);
                    break;
                case "agent_total_count":
                    getTotalUnreadCount();
                    break;
                case "send_broadcast_message":
                    Intent intent2 = new Intent(activity.getApplicationContext(), AgentBroadcastActivity.class);
                    intent2.putExtra("title", title);
                    activity.startActivity(intent2);
                    break;
                case "open_one_two_one":
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-1L);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setChatType(2);
                    conversation.setLabel(title);
                    conversation.setUnreadCount(0);

                    Intent intent3 = new Intent(activity.getApplicationContext(), AgentChatActivity.class);
                    intent3.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                    intent3.putExtra(FuguAppConstant.CREATE_NEW_CHAT, true);
                    intent3.putExtra("is_one_two_one", true);
                    intent3.putExtra("one_two_one_email", email);
                    activity.startActivity(intent3);
                    break;
                default:

                    break;
            }
        }
        objectQueue.clear();
    }

    public void startOneToOneConversation(String email) {
        if(AgentCommonData.isAgentFlow()) {
            if(Utils.isEmailValid(email)) {
                if (AgentCommonData.getUserData() == null || apiInProgress) {
                    objectQueue.add("open_one_two_one");
                    this.email = email;
                    LoadingBox.showOn(activity);
                    if (!apiInProgress) { // Check apiInProgress set false before opening class
                        initHippoManager(activity, hippoConfig.getAttributes());
                    }
                } else {
                    Conversation conversation = new Conversation();
                    conversation.setChannelId(-1L);
                    conversation.setChannelName("dummyChannelName");
                    conversation.setStatus(-2);
                    conversation.setAgentId(-2);
                    conversation.setChatType(2);
                    conversation.setLabel(title);
                    conversation.setUnreadCount(0);

                    Intent intent = new Intent(activity.getApplicationContext(), AgentChatActivity.class);
                    intent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, Conversation.class));
                    intent.putExtra(FuguAppConstant.CREATE_NEW_CHAT, true);
                    intent.putExtra("is_one_two_one", true);
                    intent.putExtra("one_two_one_email", email);
                    activity.startActivity(intent);
                }
            } else {
                Log.e(TAG, "Enter valid email");
            }
        } else {
            Log.e(TAG, "Can't call this method in Client flow");
        }
    }

    public void sendBroadcastMessage(Activity activity, String title) {
        if(AgentCommonData.isAgentFlow()) {
            if(!getAttributes().isBroadcastEnabled()) {
                Log.e(TAG, "Broadcast isn't enabled");
                return;
            }
            if (AgentCommonData.getUserData() == null || apiInProgress) {
                this.title = title;
                objectQueue.add("send_broadcast_message");
                LoadingBox.showOn(activity);
                if (!apiInProgress) { // Check apiInProgress set false before opening class
                    initHippoManager(activity, hippoConfig.getAttributes());
                }
            } else {
                Intent intent = new Intent(activity.getApplicationContext(), AgentBroadcastActivity.class);
                intent.putExtra("title", title);
                activity.startActivity(intent);
            }
        } else {
            Log.e(TAG, "Can't call this method in Client flow");
        }
    }

    String title = "";
    String userUniqueKey = "";
    private ArrayList<String> strings;
    String email;

    public void openConversation(Activity activity, String title) {
        if (AgentCommonData.getUserData() == null || apiInProgress) {
            this.title = title;
            objectQueue.add("open_agent_screen");
            LoadingBox.showOn(activity);
            if (!apiInProgress) { // Check apiInProgress set false before opening class
                initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
            intent.putExtra("title", title);
            activity.startActivity(intent);
        }
    }
    public void openConversationFor(Activity activity, String otherUserUniqueKey, String title) {
        if (AgentCommonData.getUserData() == null || apiInProgress) {
            this.title = title;
            this.userUniqueKey = otherUserUniqueKey;
            objectQueue.add("start_conversation");
            LoadingBox.showOn(activity);
            if (!apiInProgress) { // Check apiInProgress set false before opening class
                initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else {
            Intent intent = new Intent(activity.getApplicationContext(), AgentListActivity.class);
            intent.putExtra("title", title);
            if(!TextUtils.isEmpty(otherUserUniqueKey))
                intent.putExtra("user_unique_key", otherUserUniqueKey);
            activity.startActivity(intent);
        }
    }


    public void setUnreadCount(AgentUnreadCountListener unreadCount) {
        this.unreadCount = unreadCount;
    }

    private AgentUnreadCountListener unreadCount;

    public void getUnreadCountFor(ArrayList<String> strings) {
        AgentCommonData.setAgentUniqueKey(strings);
        if (AgentCommonData.getUserData() == null || apiInProgress) {
            this.strings = strings;
            objectQueue.add("get_agent_count");
            //LoadingBox.showOn(activity);
            if (!apiInProgress) { // Check apiInProgress set false before opening class
                initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else {
            UnreadCountHelper.getInstance().getUpdatedUnreadCount(strings);
        }
    }

    public void getTotalUnreadCount() {
        try {
            ActivityManager mngr = (ActivityManager) activity.getSystemService(ACTIVITY_SERVICE);
            List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);
            if (taskList.get(0).topActivity.getClassName().equals("com.hippo.agent.AgentChatActivity")) {
                UnreadCountHelper.getInstance().sendTotalUnreadCount();
                return;
            }
        } catch (Exception e) {
            //e.printStackTrace();
        }
        try {
            getTotalUnreadCountData();
        } catch (Exception e) {
            if(HippoConfig.DEBUG)
                e.printStackTrace();
        }
    }


    private void getTotalUnreadCountData() throws Exception {
        if (HippoConfig.getInstance().getCallbackListener() == null) {
            Log.e(TAG, "Set CallbackListener first");
            return;
        }
        if (AgentCommonData.getUserData() == null || apiInProgress) {
            objectQueue.add("agent_total_count");
            //LoadingBox.showOn(activity);
            if (!apiInProgress) { // Check apiInProgress set false before opening class
                initHippoManager(activity, hippoConfig.getAttributes());
            }
        } else {
            int[] typeIntArray = new int[]{ConversationMode.ALL.getOrdinal(), ConversationMode.DEFAULT.getOrdinal()};
            UserData userData = AgentCommonData.getUserData();
            String userID = String.valueOf(userData.getEnUserId());
            String accessToken = userData.getAccessToken();
            HashMap<String, Object> params = new HashMap<>();
            params.put(FuguAppConstant.EN_USER_ID, userID);
            params.put(FuguAppConstant.ACCESS_TOKEN, accessToken);
            params.put(FuguAppConstant.STATUS, "[1]");
            params.put(FuguAppConstant.DEVICE_TYPE, 1);
            params.put(FuguAppConstant.TYPE, Arrays.toString(typeIntArray));

            CommonParams commonParams = new CommonParams.Builder()
                    .addAll(params)
                    .build(2);

            RestClient.getAgentApiInterface().getConversation(commonParams.getMap()).enqueue(new ResponseResolver<GetConversationResponse>() {
                @Override
                public void success(GetConversationResponse getConversationResponse) {
                    try {
                        if (getConversationResponse != null) { // Null handled in try catch
                            if (ApiResponseFlags.ACTION_COMPLETE.getOrdinal() == getConversationResponse.getStatusCode()) {
                                HashMap<Integer, Integer> hashMap = AgentCommonData.getTotalUnreadCount();
                                int totalCount = 0;
                                for (Conversation conversation : getConversationResponse.getData().getConversation()) {
                                    hashMap.put(conversation.getChannelId().intValue(), conversation.getUnreadCount());
                                    totalCount += conversation.getUnreadCount();
                                }
                                AgentCommonData.addTotalUnreadCount(hashMap);

                                UnreadCountHelper.getInstance().sendTotalUnreadCount();
                                if (HippoConfig.getInstance().getCallbackListener() != null) {
                                    HippoConfig.getInstance().getCallbackListener().count(totalCount);
                                }
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                @Override
                public void failure(APIError error) {

                }
            });
        }
    }

    /*public static HippoConfig initHippoManagerConfig(Activity activity) {
        hippoConfig = getInstance();
        Paper.init(activity);

        return hippoConfig;
    }*/

    public static void clearHippoData(Activity activity) {
        try {
            if (AgentCommonData.isAgentFlow()) {
                logoutAgent(activity);
            } else {
                logOutUser(activity);
            }
        } catch (Exception e) {

        }
        try {
            hippoConfig.clearLocalData();
            Prefs.with(activity).removeAll();
        } catch (Exception e) {

        }
    }

    private void clearLocalData() {
        HippoConfig.getInstance().isDataCleared = true;
        CommonData.setIsDataCleared(true);
        try {
            CommonData.clearData();
            AgentCommonData.clearAgentData();
            userData = null;
        } catch (Exception e) {

        }
    }

    //Get client connection
    public static void getClient(fayeClient listener) {
            meta = new MetaMessage();
            JSONObject jsonExt = new JSONObject();
            try {
                if (HippoConfig.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", HippoConfig.getInstance().getUserData().getUserId());
                    jsonExt.put("device_type", 1);
                    jsonExt.put("source", 1);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            if (CommonData.getServerUrl().equals(LIVE_SERVER)) {
                mClient = new FayeClient(CommonData.getServerUrl() + ":3002/faye", meta);
            } else if (CommonData.getServerUrl().equals(TEST_SERVER) || CommonData.getServerUrl().equals(BETA_LIVE_SERVER)) {
                mClient = new FayeClient("https://hippo-api-dev.fuguchat.com:3012/faye", meta);
            } else if (CommonData.getServerUrl().equals(DEV_SERVER)) {
                mClient = new FayeClient("https://hippo-api-dev.fuguchat.com:3004/faye", meta);
            } else {
                mClient = new FayeClient(LIVE_SERVER + ":3002/faye", meta);
            }

        listener.Listener(mClient);
    }

    /**
     * @deprecated
     * @return
     */
    public static FayeClient getClient() {
        if (mClient == null) {
            meta = new MetaMessage();
            JSONObject jsonExt = new JSONObject();
            try {
                if (HippoConfig.getInstance().getUserData() != null) {
                    jsonExt.put("user_id", HippoConfig.getInstance().getUserData().getUserId());
                    jsonExt.put("device_type", 1);
                    jsonExt.put("source", 1);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            meta.setAllExt(jsonExt.toString());
            if (CommonData.getServerUrl().equals(LIVE_SERVER)) {
                mClient = new FayeClient(CommonData.getServerUrl() + ":3002/faye", meta);
            } else if (CommonData.getServerUrl().equals(TEST_SERVER) || CommonData.getServerUrl().equals(BETA_LIVE_SERVER)) {
                mClient = new FayeClient("https://hippo-api-dev.fuguchat.com:3012/faye", meta);
            } else if (CommonData.getServerUrl().equals(DEV_SERVER)) {
                mClient = new FayeClient("https://hippo-api-dev.fuguchat.com:3004/faye", meta);
            } else {
                mClient = new FayeClient(LIVE_SERVER + ":3002/faye", meta);
            }
        }

        return mClient;
    }

    public String getAppKey() {
        if(TextUtils.isEmpty(appKey))
            appKey = CommonData.getAppSecretKey();
        return appKey;
    }

    public static String getmResellerToken() {
        if(TextUtils.isEmpty(mResellerToken))
            mResellerToken = CommonData.getResellerToken();
        return mResellerToken;
    }

    public static int getmReferenceId() {
        if(mReferenceId == -1)
            mReferenceId = CommonData.getReferenceId();
        return mReferenceId;
    }

    public String getAppType() {
        return HippoConfig.getInstance().appType;
    }

    public boolean isDataCleared() {
        return isDataCleared;
    }

    public boolean isChannelActivity() {
        return isChannelActivity;
    }

    public void setChannelActivity(boolean channelActivity) {
        isChannelActivity = channelActivity;
    }

    public void setRideTime(long timeInSecs) {
        if(timeInSecs > 0) {
            CommonData.setLeftTimeInSec(timeInSecs);
        } else {
            CommonData.clearLeftTimeInSec();
        }
    }

    public void stopOnlineStatus(Activity activity) {
        CommonData.clearLeftTimeInSec();
        new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback() {
            @Override
            public void onSuccess() {

            }

            @Override
            public void onFailure() {

            }
        }).stopRideStatus();
    }

    public void discartEstimatedTime() {
        CommonData.clearLeftTimeInSec();
    }

    public void showConversations(final Activity activity, final String title) {
        if(AgentCommonData.isAgentFlow()) {
            Log.e(TAG, "Can't call this method with manager flow");
            return;
        }

        CommonData.setChatTitle(title);
        if (CommonData.isFirstTimeWithNotification() || (CommonData.getConversationList() != null
                && CommonData.getConversationList().size() <= 0)) {
            new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback() {
                @Override
                public void onSuccess() {
                    CommonData.setNotificationFirstClick(false);
                    if (CommonData.getConversationList().size() == 0) {
                        caseOne(title);
                    } else {
                        caseElse(title);
                    }
                }

                @Override
                public void onFailure() {
                    CommonData.setNotificationFirstClick(false);
                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId());
        } else {
            if (CommonData.getConversationList().size() == 0) {
                caseOne(title);
            } else {
                caseElse(title);
            }
        }
    }

    public void openChat(Activity activity, Long messageChannelId) {
        openChat(activity, messageChannelId, null);
    }

    public void openChat(final Activity activity, final Long messageChannelId, final String titleString) {

        if (HippoConfig.getInstance().getUserData() == null || userData.getUserId().compareTo(-1l) == 0) {
            HippoLog.v("In openChat before FuguChatActivity", "userData null");
            new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback() {
                @Override
                public void onSuccess() {
                    Intent chatIntent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
                    FuguConversation conversation = new FuguConversation();
                    conversation.setLabelId(messageChannelId);
                    conversation.setLabel(titleString);
                    conversation.setOpenChat(true);
                    conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
                    conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
                    conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
                    chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
                    activity.startActivity(chatIntent);
                }

                @Override
                public void onFailure() {

                }
            }).sendUserDetails(HippoConfig.getInstance().getmResellerToken(), HippoConfig.getInstance().getmReferenceId());
        } else {
            Intent chatIntent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            FuguConversation conversation = new FuguConversation();
            conversation.setLabelId(messageChannelId);
            conversation.setLabel(titleString);
            conversation.setOpenChat(true);
            conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
            activity.startActivity(chatIntent);
        }


    }

    public void openChatByUniqueId(ChatByUniqueIdAttributes attributes) {
        String[] data = attributes.getChannelName().split("");
        String transactionId = attributes.getTransactionId();
        String userUniqueKey = attributes.getUserUniqueKey();
        ArrayList<String> otherUserUniqueKeys = attributes.getOtherUserUniqueKeys();
        String channelName = attributes.getChannelName();
        ArrayList<String> tags = attributes.getTags();
        int chatType = 0;//attributes.getChatType() == null ? 2 : attributes.getChatType().chatType;
        String[] message = attributes.getMessage();
        ArrayList<String> groupingTags = attributes.getGroupingTags();
        String isSupportTicket = attributes.isSupportTicket() ? "1" : "0";
        CustomAttributes customAttributes = attributes.getCustomAttributes();

        showGroupChat(transactionId, userUniqueKey, otherUserUniqueKeys, channelName, tags, chatType, message,
                groupingTags, isSupportTicket, customAttributes);
    }

    private void showGroupChat(final String transactionId, final String userUniqueKey, final ArrayList<String> otherUserUniqueKeys,
                final String channelName, final ArrayList<String> tags, final int chatType, final String[] message,
                final ArrayList<String> groupingTags, final String isSupportTicket, final CustomAttributes customAttributes) {
        HippoLog.i("showGroupChat", "In ShowGroupChat");
        if (HippoConfig.getInstance().getUserData() == null || getUserData().getUserId().compareTo(-1l) == 0) {

            new ApiPutUserDetails(activity, new ApiPutUserDetails.Callback() {
                @Override
                public void onSuccess() {
                    showGroupChats(transactionId, userUniqueKey, otherUserUniqueKeys, channelName, tags, chatType, message,
                            groupingTags, isSupportTicket, customAttributes);
                }
                @Override
                public void onFailure() {

                }
            }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId(), true);
        } else {
            showGroupChats(transactionId, userUniqueKey, otherUserUniqueKeys, channelName, tags, chatType,
                    message, groupingTags, isSupportTicket, customAttributes);
        }

    }

    private void showGroupChats(String transactionId, String userUniqueKey, ArrayList<String> otherUserUniqueKeys,
                                String channelName, ArrayList<String> tags, int chatType, String[] message,
                                ArrayList<String> groupingTags, String isSupportTicket, CustomAttributes customAttributes) {
        HippoLog.i("showGroupChat", "userData not null");
        Intent chatIntent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
        HippoLog.d("UserName", "showGroupChat" + HippoConfig.getInstance().getUserData().getUserId());
        FuguConversation conversation = new FuguConversation();
        conversation.setLabelId(-1l);
        conversation.setLabel(CommonData.getUserDetails().getData().getBusinessName());
        conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
        conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
        conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
        chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));

        if(otherUserUniqueKeys != null && otherUserUniqueKeys.size()>0 && !TextUtils.isEmpty(otherUserUniqueKeys.get(0))) {
            chatType = 2;
        } else {
            chatType = 3;
        }
        chatIntent.putExtra(CHAT_TYPE, chatType);

        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;
        JsonArray tagsArray = null;

        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }

        if (tags != null) {
            tagsArray = gson.toJsonTree(tags).getAsJsonArray();
        }

        FuguCreateConversationParams fuguPeerChatParams = new FuguCreateConversationParams();
        fuguPeerChatParams.setAppSecretKey(HippoConfig.getInstance().getAppKey());
        fuguPeerChatParams.setChannelName(channelName);
        fuguPeerChatParams.setTransactionId(transactionId);
        fuguPeerChatParams.setLabelId(-1l);
        fuguPeerChatParams.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
        fuguPeerChatParams.setUserId(HippoConfig.getInstance().getUserData().getUserId());
        fuguPeerChatParams.setChatType(chatType);
        if(!TextUtils.isEmpty(userUniqueKey)) {
            fuguPeerChatParams.setUserUniqueKey(userUniqueKey);
        }
        chatType = 0;
        if(otherUserUniqueKeys != null && otherUserUniqueKeys.size()>0 && !TextUtils.isEmpty(otherUserUniqueKeys.get(0))) {
            fuguPeerChatParams.setOtherUserUniqueKeys(otherUsersArray);
            if (otherUserUniqueKeys != null) {
                //chatType = 2;
                if (otherUserUniqueKeys.size() > 1) {
                    chatType = 1;
                } else {
                    chatType = 1;
                }
            } else {
                chatType = 0;
            }
        }

        fuguPeerChatParams.setChatType(chatType);
        if(message != null && message.length>0 && !TextUtils.isEmpty(message[0])) {
            fuguPeerChatParams.setUser_first_messages(message);
        }

        try {
            if(customAttributes != null)
                fuguPeerChatParams.setCustomAttributes(customAttributes);

            if(!TextUtils.isEmpty(isSupportTicket) && Integer.parseInt(isSupportTicket) == 1)
                fuguPeerChatParams.setIsSupportTicket(Integer.parseInt(isSupportTicket));

            if(groupingTags != null && groupingTags.size()>0) {
                fuguPeerChatParams.setGroupingTags(groupingTags);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

        chatIntent.putExtra(FuguAppConstant.PEER_CHAT_PARAMS,
                new Gson().toJson(fuguPeerChatParams, FuguCreateConversationParams.class));

        activity.startActivity(chatIntent);
    }

    /**
     * Open Support menu
     * @param HippoTicketAttributes
     */
    public void showFAQSupport(HippoTicketAttributes HippoTicketAttributes) {
        // preventing double, using threshold of 1000 ms
        if (SystemClock.elapsedRealtime() - lastClickTime < 1000){
            return;
        }
        if(HippoTicketAttributes != null) {
            openSupportScreen(HippoTicketAttributes.getmFaqName(), HippoTicketAttributes.getmTransactionId());
        } else {
            openSupportScreen(null, null);
        }
        lastClickTime = SystemClock.elapsedRealtime();
    }

    private void openSupportScreen(final String categoryId, final String transactionId) {
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                openFuguSupportActivity(categoryId, transactionId);
            }
        }, 100);
    }

    private static void logoutAgent(Activity activity) throws Exception {
        if (AgentCommonData.getUserData() != null) {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(FuguAppConstant.ACCESS_TOKEN, AgentCommonData.getUserData().getAccessToken())
                    .add(DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity))
                    .add(DEVICE_TYPE, ANDROID_USER)
                    .add(APP_VERSION, BuildConfig.VERSION_CODE)
                    .add(APP_SOURCE_TYPE, String.valueOf(1))
                    .build(2);

            RestClient.getAgentApiInterface().logout(commonParams.getMap())
                    .enqueue(new ResponseResolver<LoginResponse>() {
                        @Override
                        public void success(LoginResponse loginResponse) {

                        }

                        @Override
                        public void failure(APIError error) {

                        }
                    });
        }
    }

    private static void logOutUser(Activity activity) throws Exception {
        if (HippoConfig.getInstance().getUserData() != null && HippoConfig.getInstance().getUserData().getEnUserId() != null) {
            CommonParams commonParams = new CommonParams.Builder()
                    .add(APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                    .add(EN_USER_ID, HippoConfig.getInstance().getUserData().getEnUserId())
                    .add(APP_VERSION, BuildConfig.VERSION_NAME)
                    .add("device_id", UniqueIMEIID.getUniqueIMEIId(activity))
                    .add(DEVICE_TYPE, 1)
                    .build();
            RestClient.getApiInterface().logOut(commonParams.getMap())
                    .enqueue(new ResponseResolver<CommonResponse>(activity, false, false) {
                        @Override
                        public void success(CommonResponse commonResponse) {

                        }

                        @Override
                        public void failure(APIError error) {

                        }
                    });
        }
    }

    private void openUserInitForm() {
        Intent intent = new Intent(activity.getApplicationContext(), CustomerInitalActivity.class);
        activity.startActivity(intent);
    }

    private void caseOne(String title) {
        HippoLog.e("Case 1", "case 1");
        if(CommonData.getUpdatedDetails().getData().getCustomerInitialFormInfo() != null) {
            openUserInitForm();
        } else {
            Intent chatIntent = new Intent(activity.getApplicationContext(), FuguChatActivity.class);
            FuguConversation conversation = new FuguConversation();
            conversation.setBusinessName(title);
            conversation.setOpenChat(true);
            conversation.setUserName(StringUtil.toCamelCase(HippoConfig.getInstance().getUserData().getFullName()));
            conversation.setUserId(HippoConfig.getInstance().getUserData().getUserId());
            conversation.setEnUserId(HippoConfig.getInstance().getUserData().getEnUserId());
            chatIntent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));
            activity.startActivity(chatIntent);
        }
    }

    private void caseElse(String title) {
        HippoLog.e("Case else", "case else");
        if(CommonData.getUpdatedDetails().getData().getCustomerInitialFormInfo() != null) {
            openUserInitForm();
        } else {
            Intent conversationsIntent = new Intent(activity.getApplicationContext(), FuguChannelsActivity.class);
            conversationsIntent.putExtra("title", title);
            conversationsIntent.putExtra("appVersion", getAppVersion());
            activity.startActivity(conversationsIntent);
        }
    }

    private void openFuguSupportActivity(String faqName, String transactionId) {
        Intent intent = new Intent(activity.getApplicationContext(), HippoSupportActivity.class);
        intent.putExtra(FuguAppConstant.SUPPORT_ID, faqName);
        intent.putExtra(FuguAppConstant.SUPPORT_TRANSACTION_ID, transactionId);
        //intent.putExtra("userData", getUserData());
        activity.startActivity(intent);
    }


    private int getAppVersion() {
        try {
            return HippoConfig.getInstance().context.getPackageManager().getPackageInfo(HippoConfig.getInstance()
                    .context.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public CaptureUserData getUserData() {
        return getUserData(true);
    }

    public CaptureUserData getUserData(boolean fetchSavedData) {
        if(userData == null)
            userData = CommonData.getUserData();

        if(fetchSavedData) {
            try {
                if(TextUtils.isEmpty(userData.getEnUserId())) {
                    FuguPutUserDetailsResponse response = CommonData.getUpdatedDetails();
                    if(response != null && response.getData() != null && !TextUtils.isEmpty(response.getData().getEn_user_id())) {
                        userData.setEnUserId(response.getData().getEn_user_id());
                        userData.setUserId(response.getData().getUserId());
                        userData.setFullName(response.getData().getFullName());
                        userData.setEmail(response.getData().getEmail());
                    } else if(context != null) {
                        userData.setEnUserId(Prefs.with(context).getString("en_user_id", ""));
                        userData.setUserId(Prefs.with(context).getLong("user_id", -1l));
                        userData.setFullName(Prefs.with(context).getString("full_name", ""));
                        userData.setEmail(Prefs.with(context).getString("email", ""));
                    }
                }
            } catch (Exception e) {
                if(HippoConfig.DEBUG)
                    e.printStackTrace();
                try {
                    if(context != null) {
                        userData.setEnUserId(Prefs.with(context).getString("en_user_id", ""));
                        userData.setUserId(Prefs.with(context).getLong("user_id", -1l));
                        userData.setFullName(Prefs.with(context).getString("full_name", ""));
                        userData.setEmail(Prefs.with(context).getString("email", ""));
                    }
                } catch (Exception e1) {

                }
            }
        }

        return userData;
    }

    public void getUnreadCount() {
        getUnreadCount(activity, HippoConfig.getInstance().getUserData().getEnUserId());
    }

    private void getUnreadCount(Activity activity, String enUserId) {
        new UnreadCountApi().getConversations(activity, enUserId, new UnreadCountApi.CountUnread() {
            @Override
            public void countValue(int count) {
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(count);
                }
            }
        });
    }

    private HashMap<String, Long> channelIds = new HashMap<>();

    public void setChannelIds(String transactionId, Long channelId) {
        channelIds.put(transactionId, channelId);
    }

    public Long getChannelId(String transactionId) {
        return channelIds.get(transactionId);
    }

    // For permission

    public int getTargetSDKVersion() {
        return targetSDKVersion;
    }

    private int targetSDKVersion = 0;
    /**
     * Method to check whether the Permission is Granted by the User
     * <p/>
     * permission type: DANGEROUS
     *
     * @param activity
     * @param permission
     * @return
     */
    public boolean isPermissionGranted(Context activity, String permission) {

        PackageManager pm = activity.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(HippoConfig.getInstance().activity.getPackageName(), 0);
            if (applicationInfo != null) {
                targetSDKVersion = applicationInfo.targetSdkVersion;
            }
        } catch (Exception e) {

        }

        if (targetSDKVersion > 22) {
            return ContextCompat.checkSelfPermission(activity, permission) == PackageManager.PERMISSION_GRANTED;
        } else {
            return PermissionChecker.checkSelfPermission(activity, permission) == PermissionChecker.PERMISSION_GRANTED;
        }
    }

    /**
     * Method to check whether the Permission is Granted by the User
     * <p/>
     * permission type: DANGEROUS
     *
     * @param activity
     * @param permission
     * @return
     */
    public boolean askUserToGrantPermission(Activity activity, String permission, String explanation, int code) {
        HippoLog.e(TAG, "permissions" + permission);
        return askUserToGrantPermission(activity, new String[]{permission}, explanation, code);
    }

    /**
     * Method to check whether the Permission is Granted by the User
     * <p/>
     * permission type: DANGEROUS
     *
     * @param activity
     * @param permissions
     * @param explanation
     * @param requestCode
     * @return
     */
    public boolean askUserToGrantPermission(Activity activity, String[] permissions, String explanation, int requestCode) {
        String permissionRequired = null;

        for (String permission : permissions)
            if (!isPermissionGranted(activity, permission)) {
                permissionRequired = permission;
                break;
            }

        // Check if the Permission is ALREADY GRANTED
        if (permissionRequired == null) return true;

        // Check if there is a need to show the PERMISSION DIALOG
        boolean explanationRequired = ActivityCompat.shouldShowRequestPermissionRationale(activity, permissionRequired);

        // Convey the EXPLANATION if required
        if (explanationRequired) {

            if (explanation == null) explanation = "Please grant permission";
            Toast.makeText(activity, explanation, Toast.LENGTH_SHORT).show();
        } else {

            // We can request the permission, if no EXPLANATIONS required
            ActivityCompat.requestPermissions(activity, permissions, requestCode);
        }

        return false;
    }


    //**************************** For Agent SDK *************************

    //Get unread count
    private UnreadCount callbackListener;
    private AgentUnreadCountListener countListener;

    private boolean openAgentScreen;
    private boolean apiInProgress;
    private String chatTitle = "Chat";
    private Queue<String> objectQueue = new LinkedList();

    public UnreadCount getCallbackListener() {
        return callbackListener;
    }

    public AgentUnreadCountListener getAgentCountListener() {
        return countListener;
    }

    public void setCountForCallbackListener(AgentUnreadCountListener countListener) {
        this.countListener = countListener;
    }

    public void setCallbackListener(UnreadCount callbackListener) {
        this.callbackListener = callbackListener;
    }


    private Map<Class<? extends AgentListener>, Collection<? extends AgentListener>> agentListeners;

    @SuppressWarnings("unchecked")
    private <T extends AgentListener> Collection<T> getOrCreateUIListeners(Class<T> cls) {
        if(agentListeners == null)
            agentListeners = new HashMap<>();
        Collection<T> collection = (Collection<T>) agentListeners.get(cls);
        if (collection == null) {
            collection = new ArrayList<T>();
            agentListeners.put(cls, collection);
        }
        return collection;
    }

    /**
     * @param cls Requested class of listeners.
     * @return List of registered UI listeners.
     */
    public <T extends AgentListener> Collection<T> getUIListeners(Class<T> cls) {
//        if (closed) {
//            return Collections.emptyList();
//        }
        return Collections.unmodifiableCollection(getOrCreateUIListeners(cls));
    }

    /**
     * Register new listener.
     * <p/>
     * Should be called from {@link Activity#onResume()}.
     */
    public <T extends AgentListener> void addUIListener(Class<T> cls, T listener) {
        getOrCreateUIListeners(cls).add(listener);
    }

    public <T extends AgentListener> void addOrUpdateUIListener(Class<T> cls, T listener) {
        try {
            if(getUIListeners(cls).size() == 0) {
                getOrCreateUIListeners(cls).add(listener);
            }
        } catch (Exception e) {

        }
    }

    /**
     * Unregister listener.
     * <p/>
     * Should be called from {@link Activity#onPause()}.
     */
    public <T extends AgentListener> void removeUIListener(Class<T> cls, T listener) {
        getOrCreateUIListeners(cls).remove(listener);
    }

    private void registerNetworkListener(Context context) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            try {
                context.registerReceiver(new FuguNetworkStateReceiver(),
                        new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
            } catch (Exception e) {
                HippoLog.e(TAG, "Error in broadcasting");
            }
        }
    }

    private CallData callData;
    private HippoLifeCycle lifeCycle;

    public CallData getCallData() {
        return callData;
    }
    public void setCallListener(CallData callData) {
        this.callData = callData;
    }

    public void setLifeCyclerListener(HippoLifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    public HippoLifeCycle getLifeCyclerListener() {
        return lifeCycle;
    }

    /**
     *
     * @param context Activity context of the class
     * @param callType 1 for video call, 2 for audio call
     * @param transactionId unique Id
     * @param otherUserName End user name
     * @param userUniqueKey User unique key
     * @param otherUserUniqueKeys Other user unique key
     */
    public void startCall(Context context, String callType, String transactionId, String userUniqueKey, String otherUserName, ArrayList<String>  otherUserUniqueKeys, String otheruserImageUrl) {
        if(callType.equalsIgnoreCase("video") && !CommonData.getVideoCallStatus()) {
            Toast.makeText(context, "This feature not supported", Toast.LENGTH_SHORT).show();
            return;
        }
        if(callType.equalsIgnoreCase("audio") && !CommonData.getAudioCallStatus()) {
            Toast.makeText(context, "This feature not supported", Toast.LENGTH_SHORT).show();
            return;
        }
        if(TextUtils.isEmpty(transactionId)) {
            Toast.makeText(context, "TransactionId can't be null", Toast.LENGTH_SHORT).show();
            return;
        }
        if(TextUtils.isEmpty(userUniqueKey)) {
            Toast.makeText(context, "User unique key can't be null", Toast.LENGTH_SHORT).show();
            return;
        }
        if(TextUtils.isEmpty(otherUserName)) {
            Toast.makeText(context, "other user name can't be null", Toast.LENGTH_SHORT).show();
            return;
        }
        if(otherUserUniqueKeys == null || otherUserUniqueKeys.size() == 0) {
            Toast.makeText(context, "Otheruser unique key can't be null", Toast.LENGTH_SHORT).show();
            return;
        }


        Gson gson = new GsonBuilder().create();
        JsonArray otherUsersArray = null;
        JsonArray tagsArray = null;


        if (otherUserUniqueKeys != null) {
            otherUsersArray = gson.toJsonTree(otherUserUniqueKeys).getAsJsonArray();
        }

        FuguCreateConversationParams fuguPeerChatParams = new FuguCreateConversationParams(HippoConfig.getInstance().getAppKey()
                , -1l, transactionId, userUniqueKey, otherUsersArray, transactionId, tagsArray,
                HippoConfig.getInstance().getUserData().getEnUserId());

        Long userId = CommonData.getUserDetails().getData().getUserId();
        String fullname = otherUserName;

        if (HippoConfig.getInstance().getCallData() != null) {
            HippoConfig.getInstance().getCallData().onExternalClick(context, callType, userId, fullname, new Gson().toJson(fuguPeerChatParams, FuguCreateConversationParams.class), otheruserImageUrl);
        } else {
            Log.e(TAG, "Please call setCallListener before this method");
        }

    }

}
