/*
 * Decompiled with CFR 0.152.
 */
package faye;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MetaMessage {
    public static final String KEY_CHANNEL = "channel";
    public static final String KEY_VERSION = "version";
    public static final String KEY_MIN_VERSION = "minimumVersion";
    public static final String KEY_SUPPORT_CONNECTION_TYPES = "supportedConnectionTypes";
    public static final String KEY_CLIENT_ID = "clientId";
    public static final String KEY_SUBSCRIPTION = "subscription";
    public static final String KEY_CONNECTION_TYPE = "connectionType";
    public static final String KEY_DATA = "data";
    public static final String KEY_EXT = "ext";
    public static final String KEY_ID = "id";
    public static final String HANDSHAKE_CHANNEL = "/meta/handshake";
    public static final String CONNECT_CHANNEL = "/meta/connect";
    public static final String DISCONNECT_CHANNEL = "/meta/disconnect";
    public static final String SUBSCRIBE_CHANNEL = "/meta/subscribe";
    public static final String UNSUBSCRIBE_CHANNEL = "/meta/unsubscribe";
    private String mVersion = "1.0";
    private String mMinimumVersion = "1.0beta";
    private String mClientId;
    private JSONArray mSupportConnectionTypes;
    private String mConnectionType = "long-polling";
    private String mHandShakeExt;
    private String mHandShakeId;
    private String mConnectExt;
    private String mConnectId;
    private String mDisconnectExt;
    private String mDisconnectId;
    private String mSubscribeExt;
    private String mSubscribeId;
    private String mUnsubscribeExt;
    private String mUnsubscribeId;

    public void setSupportConnectionTypes(String ... support) {
        JSONArray arr = null;
        if (support.length != 0) {
            arr = new JSONArray();
            for (String type : support) {
                arr.put((Object)type);
            }
            this.mSupportConnectionTypes = arr;
        }
    }

    public String handShake() throws JSONException {
        JSONArray arr;
        JSONObject obj;
        JSONObject json = new JSONObject();
        json.put(KEY_CHANNEL, (Object)HANDSHAKE_CHANNEL).put(KEY_MIN_VERSION, (Object)this.mMinimumVersion).put(KEY_VERSION, (Object)this.mVersion);
        if (this.mSupportConnectionTypes == null) {
            this.mSupportConnectionTypes = new JSONArray();
            this.mSupportConnectionTypes.put((Object)"long-polling");
            this.mSupportConnectionTypes.put((Object)"callback-polling");
            this.mSupportConnectionTypes.put((Object)"iframe");
            this.mSupportConnectionTypes.put((Object)"websocket");
        }
        json.put(KEY_SUPPORT_CONNECTION_TYPES, (Object)this.mSupportConnectionTypes);
        if (this.mHandShakeExt != null) {
            obj = this.isJSONObject(this.mHandShakeExt);
            arr = this.isJSONArray(this.mHandShakeExt);
            if (obj != null) {
                json.put(KEY_EXT, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_EXT, (Object)arr);
            } else {
                json.put(KEY_EXT, (Object)this.mHandShakeExt);
            }
        }
        if (this.mHandShakeId != null) {
            obj = this.isJSONObject(this.mHandShakeId);
            arr = this.isJSONArray(this.mHandShakeId);
            if (obj != null) {
                json.put(KEY_ID, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_ID, (Object)arr);
            } else {
                json.put(KEY_ID, (Object)this.mHandShakeId);
            }
        }
        return json.toString();
    }

    public void setHandshakeExt(String ext) {
        this.mHandShakeExt = ext;
    }

    public void setHandShakeId(String id2) {
        this.mHandShakeId = id2;
    }

    public void setClient(String id2) {
        this.mClientId = id2;
    }

    public void setConnectionType(String type) {
        this.mConnectionType = type;
    }

    public void setConnectExt(String ext) {
        this.mConnectExt = ext;
    }

    public void setConnectId(String id2) {
        this.mConnectId = id2;
    }

    public String connect() throws JSONException {
        JSONArray arr;
        JSONObject obj;
        JSONObject json = new JSONObject();
        json.put(KEY_CHANNEL, (Object)CONNECT_CHANNEL).put(KEY_CLIENT_ID, (Object)this.mClientId).put(KEY_CONNECTION_TYPE, (Object)this.mConnectionType);
        if (this.mConnectExt != null) {
            obj = this.isJSONObject(this.mConnectExt);
            arr = this.isJSONArray(this.mConnectExt);
            if (obj != null) {
                json.put(KEY_EXT, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_EXT, (Object)arr);
            } else {
                json.put(KEY_EXT, (Object)this.mConnectExt);
            }
        }
        if (this.mConnectId != null) {
            obj = this.isJSONObject(this.mConnectId);
            arr = this.isJSONArray(this.mConnectId);
            if (obj != null) {
                json.put(KEY_ID, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_ID, (Object)arr);
            } else {
                json.put(KEY_ID, (Object)this.mConnectId);
            }
        }
        return json.toString();
    }

    public void setDisconnectExt(String ext) {
        this.mDisconnectExt = ext;
    }

    public void setDisconnectId(String id2) {
        this.mDisconnectId = id2;
    }

    public String disconnect() throws JSONException {
        JSONArray arr;
        JSONObject obj;
        JSONObject json = new JSONObject();
        json.put(KEY_CHANNEL, (Object)DISCONNECT_CHANNEL).put(KEY_CLIENT_ID, (Object)this.mClientId);
        if (this.mDisconnectExt != null) {
            obj = this.isJSONObject(this.mDisconnectExt);
            arr = this.isJSONArray(this.mDisconnectExt);
            if (obj != null) {
                json.put(KEY_EXT, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_EXT, (Object)arr);
            } else {
                json.put(KEY_EXT, (Object)this.mDisconnectExt);
            }
        }
        if (this.mDisconnectId != null) {
            obj = this.isJSONObject(this.mDisconnectId);
            arr = this.isJSONArray(this.mDisconnectId);
            if (obj != null) {
                json.put(KEY_ID, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_ID, (Object)arr);
            } else {
                json.put(KEY_ID, (Object)this.mDisconnectId);
            }
        }
        return json.toString();
    }

    public void setSubscribeExt(String ext) {
        this.mSubscribeExt = ext;
    }

    public void setSubscribeId(String id2) {
        this.mSubscribeId = id2;
    }

    public String subscribe(String subscription) throws JSONException {
        JSONArray arr;
        JSONObject obj;
        JSONObject json = new JSONObject();
        json.put(KEY_CHANNEL, (Object)SUBSCRIBE_CHANNEL).put(KEY_CLIENT_ID, (Object)this.mClientId).put(KEY_SUBSCRIPTION, (Object)subscription);
        if (this.mSubscribeExt != null) {
            obj = this.isJSONObject(this.mSubscribeExt);
            arr = this.isJSONArray(this.mSubscribeExt);
            if (obj != null) {
                json.put(KEY_EXT, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_EXT, (Object)arr);
            } else {
                json.put(KEY_EXT, (Object)this.mSubscribeExt);
            }
        }
        if (this.mSubscribeId != null) {
            obj = this.isJSONObject(this.mSubscribeId);
            arr = this.isJSONArray(this.mSubscribeId);
            if (obj != null) {
                json.put(KEY_ID, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_ID, (Object)arr);
            } else {
                json.put(KEY_ID, (Object)this.mSubscribeId);
            }
        }
        return json.toString();
    }

    public void setUnsubscribeExt(String ext) {
        this.mUnsubscribeExt = ext;
    }

    public void setUnsubscribeId(String id2) {
        this.mUnsubscribeId = id2;
    }

    public String unsubscribe(String subscription) throws JSONException {
        JSONArray arr;
        JSONObject obj;
        JSONObject json = new JSONObject();
        json.put(KEY_CHANNEL, (Object)UNSUBSCRIBE_CHANNEL).put(KEY_CLIENT_ID, (Object)this.mClientId).put(KEY_SUBSCRIPTION, (Object)subscription);
        if (this.mUnsubscribeExt != null) {
            obj = this.isJSONObject(this.mUnsubscribeExt);
            arr = this.isJSONArray(this.mUnsubscribeExt);
            if (obj != null) {
                json.put(KEY_EXT, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_EXT, (Object)arr);
            } else {
                json.put(KEY_EXT, (Object)this.mUnsubscribeExt);
            }
        }
        if (this.mUnsubscribeId != null) {
            obj = this.isJSONObject(this.mUnsubscribeId);
            arr = this.isJSONArray(this.mUnsubscribeId);
            if (obj != null) {
                json.put(KEY_ID, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_ID, (Object)arr);
            } else {
                json.put(KEY_ID, (Object)this.mUnsubscribeId);
            }
        }
        return json.toString();
    }

    public void setAllExt(String ext) {
        this.mHandShakeExt = ext;
        this.mConnectExt = ext;
        this.mDisconnectExt = ext;
        this.mSubscribeExt = ext;
        this.mUnsubscribeExt = ext;
    }

    public void setAllId(String id2) {
        this.mHandShakeId = id2;
        this.mConnectId = id2;
        this.mDisconnectId = id2;
        this.mSubscribeId = id2;
        this.mUnsubscribeId = id2;
    }

    public String publish(String channel, JSONObject data, String ext, String id2) throws JSONException {
        JSONArray arr;
        JSONObject obj;
        JSONObject json = new JSONObject();
        json.put(KEY_CHANNEL, (Object)channel).put(KEY_DATA, (Object)data);
        if (this.mClientId != null) {
            json.put(KEY_CLIENT_ID, (Object)this.mClientId);
        }
        if (ext != null) {
            obj = this.isJSONObject(ext);
            arr = this.isJSONArray(ext);
            if (obj != null) {
                json.put(KEY_EXT, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_EXT, (Object)arr);
            } else {
                json.put(KEY_EXT, (Object)ext);
            }
        }
        if (id2 != null) {
            obj = this.isJSONObject(id2);
            arr = this.isJSONArray(id2);
            if (obj != null) {
                json.put(KEY_ID, (Object)obj);
            } else if (arr != null) {
                json.put(KEY_ID, (Object)arr);
            } else {
                json.put(KEY_ID, (Object)id2);
            }
        }
        return json.toString();
    }

    private JSONObject isJSONObject(String context) {
        if (context.startsWith("{")) {
            try {
                return new JSONObject(context);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return null;
    }

    private JSONArray isJSONArray(String content) {
        if (content.startsWith("[")) {
            try {
                return new JSONArray(content);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return null;
    }
}

