/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import com.hippo.utils.filepicker.CompressorListener;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

class ImageUtil {
    private ImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void compressImage(File imageFile, ImageFile actualFile, float reqWidth, float reqHeight, Bitmap.CompressFormat compressFormat, int quality, String destinationPath, CompressorListener compressorListener) throws IOException {
        OutputStream fileOutputStream = null;
        ArrayList<Integer> integers = new ArrayList<Integer>();
        integers.add(700);
        integers.add(700);
        File file = new File(destinationPath).getParentFile();
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            Bitmap bitmap = ImageUtil.decodeSampledBitmapFromFile(imageFile, reqWidth, reqHeight);
            fileOutputStream = new FileOutputStream(destinationPath);
            bitmap.compress(compressFormat, quality, fileOutputStream);
            if (bitmap.getHeight() > 0) {
                integers.add(0, bitmap.getHeight());
            }
            if (bitmap.getWidth() > 0) {
                integers.add(1, bitmap.getWidth());
            }
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.flush();
                ((FileOutputStream)fileOutputStream).close();
            }
        }
        if (compressorListener != null) {
            File file1 = new File(destinationPath);
            actualFile.setSize(file1.length());
            actualFile.setPath(destinationPath);
            compressorListener.onImageCompressed(file1, destinationPath, actualFile, integers);
        }
    }

    static Bitmap decodeSampledBitmapFromFile(File imageFile, float reqWidth, float reqHeight) throws IOException {
        Bitmap scaledBitmap = null;
        Bitmap bmp = null;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bmp = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        int actualHeight = options.outHeight;
        int actualWidth = options.outWidth;
        float imgRatio = (float)actualWidth / (float)actualHeight;
        float maxRatio = reqWidth / reqHeight;
        if ((float)actualHeight > reqHeight || (float)actualWidth > reqWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = reqHeight / (float)actualHeight;
                actualWidth = (int)(imgRatio * (float)actualWidth);
                actualHeight = (int)reqHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = reqWidth / (float)actualWidth;
                actualHeight = (int)(imgRatio * (float)actualHeight);
                actualWidth = (int)reqWidth;
            } else {
                actualHeight = (int)reqHeight;
                actualWidth = (int)reqWidth;
            }
        }
        options.inSampleSize = ImageUtil.calculateInSampleSize(options, actualWidth, actualHeight);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        try {
            bmp = BitmapFactory.decodeFile((String)imageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        try {
            scaledBitmap = Bitmap.createBitmap((int)actualWidth, (int)actualHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError exception) {
            exception.printStackTrace();
        }
        float ratioX = (float)actualWidth / (float)options.outWidth;
        float ratioY = (float)actualHeight / (float)options.outHeight;
        float middleX = (float)actualWidth / 2.0f;
        float middleY = (float)actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bmp, middleX - (float)(bmp.getWidth() / 2), middleY - (float)(bmp.getHeight() / 2), new Paint(2));
        bmp.recycle();
        try {
            ExifInterface exif = new ExifInterface(imageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 0);
            Matrix matrix = new Matrix();
            if (orientation == 6) {
                matrix.postRotate(90.0f);
            } else if (orientation == 3) {
                matrix.postRotate(180.0f);
            } else if (orientation == 8) {
                matrix.postRotate(270.0f);
            }
            scaledBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return scaledBitmap;
    }

    private static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            inSampleSize *= 2;
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize >= reqHeight && halfWidth / inSampleSize >= reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }
}

