/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.fileUpload;

import android.os.Handler;
import android.os.Looper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ProgressRequestBody
extends RequestBody {
    private File mFile;
    private String mPath;
    private UploadCallbacks mListener;
    private String mMimeType;
    private String mfileUrl;
    private int mMessageIndex;
    private String muid;
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public ProgressRequestBody(File file, UploadCallbacks listener, String mimeType, String fileUrl, int messageIndex, String muid) {
        this.mFile = file;
        this.mListener = listener;
        this.mMimeType = mimeType;
        this.mfileUrl = fileUrl;
        this.mMessageIndex = messageIndex;
        this.muid = muid;
    }

    public MediaType contentType() {
        try {
            return MediaType.parse((String)this.mMimeType);
        }
        catch (Exception e) {
            return MediaType.parse((String)"jpg");
        }
    }

    public long contentLength() throws IOException {
        return this.mFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        long fileLength = this.mFile.length();
        byte[] buffer = new byte[2048];
        FileInputStream in = new FileInputStream(this.mFile);
        long uploaded = 0L;
        Handler handler = new Handler(Looper.getMainLooper());
        if (fileLength > 0L) {
            try {
                int read;
                while ((read = in.read(buffer)) != -1) {
                    if ((int)(100L * uploaded / fileLength) > 0 && (int)(100L * uploaded / fileLength) % 10 == 0) {
                        this.mListener.onProgressUpdate((int)(100L * uploaded / fileLength), this.mMessageIndex, this.muid);
                    }
                    uploaded += (long)read;
                    sink.write(buffer, 0, read);
                }
                this.mListener.onFinish((int)uploaded, this.mMessageIndex, this.muid);
            }
            catch (Exception e) {
                handler.post((Runnable)new ProgressUpdaterFailure(uploaded, this.mMessageIndex, this.muid));
            }
            finally {
                in.close();
            }
        }
    }

    private class ProgressUpdaterFailure
    implements Runnable {
        private int messageIndex;
        private String muid;
        private long percentage;

        public ProgressUpdaterFailure(long percentage, int messageIndex, String muid) {
            this.messageIndex = messageIndex;
            this.muid = muid;
            this.percentage = percentage;
        }

        @Override
        public void run() {
            ProgressRequestBody.this.mListener.onError((int)this.percentage, this.messageIndex, this.muid);
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private long mUploaded = 0L;
        private long mTotal = 0L;
        private int messageIndex;
        private String muid;
        int currentProgress = -1;

        public ProgressUpdater(long uploaded, long total, int messageIndex, String muid) {
            this.mUploaded = uploaded;
            this.mTotal = total;
            this.messageIndex = messageIndex;
            this.muid = muid;
        }

        @Override
        public void run() {
            if ((int)(100L * this.mUploaded / this.mTotal) == 100) {
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        ProgressRequestBody.this.mListener.onFinish((int)ProgressUpdater.this.mUploaded, ProgressRequestBody.this.mMessageIndex, ProgressUpdater.this.muid);
                    }
                }, 2000L);
            }
            if ((int)(100L * this.mUploaded / this.mTotal) > 0 && (int)(100L * this.mUploaded / this.mTotal) % 10 == 0) {
                ProgressRequestBody.this.mListener.onProgressUpdate((int)(100L * this.mUploaded / this.mTotal), ProgressRequestBody.this.mMessageIndex, this.muid);
            }
        }
    }

    public static interface UploadCallbacks {
        public void onProgressUpdate(int var1, int var2, String var3);

        public void onError(int var1, int var2, String var3);

        public void onFinish(int var1, int var2, String var3);
    }
}

