/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.easypermissions;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v4.app.Fragment;
import com.hippo.R;
import com.hippo.utils.easypermissions.helper.PermissionHelper;
import java.util.Arrays;

public final class PermissionRequest {
    private final PermissionHelper mHelper;
    private final String[] mPerms;
    private final int mRequestCode;
    private final String mRationale;
    private final String mPositiveButtonText;
    private final String mNegativeButtonText;
    private final int mTheme;

    private PermissionRequest(PermissionHelper helper, String[] perms, int requestCode, String rationale, String positiveButtonText, String negativeButtonText, int theme) {
        this.mHelper = helper;
        this.mPerms = (String[])perms.clone();
        this.mRequestCode = requestCode;
        this.mRationale = rationale;
        this.mPositiveButtonText = positiveButtonText;
        this.mNegativeButtonText = negativeButtonText;
        this.mTheme = theme;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PermissionHelper getHelper() {
        return this.mHelper;
    }

    @NonNull
    public String[] getPerms() {
        return (String[])this.mPerms.clone();
    }

    public int getRequestCode() {
        return this.mRequestCode;
    }

    @NonNull
    public String getRationale() {
        return this.mRationale;
    }

    @NonNull
    public String getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    @NonNull
    public String getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    @StyleRes
    public int getTheme() {
        return this.mTheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionRequest request = (PermissionRequest)o;
        return Arrays.equals(this.mPerms, request.mPerms) && this.mRequestCode == request.mRequestCode;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mPerms);
        result = 31 * result + this.mRequestCode;
        return result;
    }

    public String toString() {
        return "PermissionRequest{mHelper=" + this.mHelper + ", mPerms=" + Arrays.toString(this.mPerms) + ", mRequestCode=" + this.mRequestCode + ", mRationale='" + this.mRationale + '\'' + ", mPositiveButtonText='" + this.mPositiveButtonText + '\'' + ", mNegativeButtonText='" + this.mNegativeButtonText + '\'' + ", mTheme=" + this.mTheme + '}';
    }

    public static final class Builder {
        private final PermissionHelper mHelper;
        private final int mRequestCode;
        private final String[] mPerms;
        private String mRationale;
        private String mPositiveButtonText;
        private String mNegativeButtonText;
        private int mTheme = -1;

        public Builder(@NonNull Activity activity, int requestCode, String ... perms) {
            this.mHelper = PermissionHelper.newInstance(activity);
            this.mRequestCode = requestCode;
            this.mPerms = perms;
        }

        public Builder(@NonNull Fragment fragment, int requestCode, String ... perms) {
            this.mHelper = PermissionHelper.newInstance(fragment);
            this.mRequestCode = requestCode;
            this.mPerms = perms;
        }

        @NonNull
        public Builder setRationale(@Nullable String rationale) {
            this.mRationale = rationale;
            return this;
        }

        @NonNull
        public Builder setRationale(@StringRes int resId) {
            this.mRationale = this.mHelper.getContext().getString(resId);
            return this;
        }

        @NonNull
        public Builder setPositiveButtonText(@Nullable String positiveButtonText) {
            this.mPositiveButtonText = positiveButtonText;
            return this;
        }

        @NonNull
        public Builder setPositiveButtonText(@StringRes int resId) {
            this.mPositiveButtonText = this.mHelper.getContext().getString(resId);
            return this;
        }

        @NonNull
        public Builder setNegativeButtonText(@Nullable String negativeButtonText) {
            this.mNegativeButtonText = negativeButtonText;
            return this;
        }

        @NonNull
        public Builder setNegativeButtonText(@StringRes int resId) {
            this.mNegativeButtonText = this.mHelper.getContext().getString(resId);
            return this;
        }

        @NonNull
        public Builder setTheme(@StyleRes int theme) {
            this.mTheme = theme;
            return this;
        }

        @NonNull
        public PermissionRequest build() {
            if (this.mRationale == null) {
                this.mRationale = this.mHelper.getContext().getString(R.string.hippo_rationale_ask);
            }
            if (this.mPositiveButtonText == null) {
                this.mPositiveButtonText = this.mHelper.getContext().getString(17039370);
            }
            if (this.mNegativeButtonText == null) {
                this.mNegativeButtonText = this.mHelper.getContext().getString(0x1040000);
            }
            return new PermissionRequest(this.mHelper, this.mPerms, this.mRequestCode, this.mRationale, this.mPositiveButtonText, this.mNegativeButtonText, this.mTheme);
        }
    }
}

