/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.google.gson.Gson;
import com.hippo.support.model.SupportDataList;
import com.hippo.utils.HippoLog;
import java.util.Map;

public class HippoDatabase {
    private static HippoDatabase INSTANCE;
    private static final String DATABASE_NAME = "hippo_database";
    private static final int DATABASE_VERSION = 1;
    private DbHelper dbHelper;
    private SQLiteDatabase database;
    private static final String TABLE_SUPPORT_DATA = "table_support_data";
    private static final String SUPPORT_CATEGORY = "support_category";
    private static final String SUPPORT_CATEGORY_NAME = "support_category_name";
    private static final String SUPPORT_DATA = "support_data";

    private static void createTable(SQLiteDatabase database) {
        database.execSQL(" CREATE TABLE IF NOT EXISTS table_support_data (support_category INTEGER, support_category_name TEXT, support_data TEXT);");
    }

    public static HippoDatabase getInstance(Context context) {
        if (INSTANCE == null) {
            INSTANCE = new HippoDatabase(context);
        } else if (!HippoDatabase.INSTANCE.database.isOpen()) {
            INSTANCE = null;
            INSTANCE = new HippoDatabase(context);
        }
        return INSTANCE;
    }

    private HippoDatabase(Context context) {
        this.dbHelper = new DbHelper(context);
        this.database = this.dbHelper.getWritableDatabase();
        HippoDatabase.createTable(this.database);
    }

    public void close() {
        try {
            this.database.close();
            this.dbHelper.close();
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertSupportData(int category, String supportData) {
        try {
            ContentValues contentValues = new ContentValues();
            contentValues.put(SUPPORT_CATEGORY, Integer.valueOf(category));
            contentValues.put(SUPPORT_DATA, supportData);
            this.database.insert(TABLE_SUPPORT_DATA, null, contentValues);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertUpdateSupportData(Map<String, SupportDataList> itemData) {
        this.deleteSupportData();
        if (itemData == null) {
            return;
        }
        this.database.beginTransaction();
        Gson gson = new Gson();
        try {
            for (Map.Entry<String, SupportDataList> jsonString : itemData.entrySet()) {
                ContentValues contentValues = new ContentValues();
                contentValues.put(SUPPORT_CATEGORY, Integer.valueOf(Integer.parseInt(jsonString.getKey())));
                contentValues.put(SUPPORT_CATEGORY_NAME, jsonString.getValue().getCategoryName().toLowerCase().trim());
                contentValues.put(SUPPORT_DATA, gson.toJson((Object)jsonString.getValue()));
                this.database.insert(TABLE_SUPPORT_DATA, null, contentValues);
            }
            this.database.setTransactionSuccessful();
        }
        catch (Exception e) {
            HippoLog.e("Error in transaction", "" + e.toString());
        }
        finally {
            this.database.endTransaction();
        }
    }

    public SupportDataList getSupportDataItems(int category) {
        SupportDataList menu2 = new SupportDataList();
        try {
            String[] columns = new String[]{SUPPORT_DATA};
            Cursor cursor = this.database.query(TABLE_SUPPORT_DATA, columns, "support_category=" + category, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                String data = cursor.getString(cursor.getColumnIndex(SUPPORT_DATA));
                Gson gson = new Gson();
                menu2 = (SupportDataList)gson.fromJson(data, SupportDataList.class);
            } else {
                menu2 = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            menu2 = null;
        }
        return menu2;
    }

    public SupportDataList getSupportDataItems(String categoryName) {
        SupportDataList menu2 = new SupportDataList();
        try {
            String[] columns = new String[]{SUPPORT_DATA};
            Cursor cursor = this.database.query(TABLE_SUPPORT_DATA, columns, "support_category_name='" + categoryName + "'", null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                String data = cursor.getString(cursor.getColumnIndex(SUPPORT_DATA));
                Gson gson = new Gson();
                menu2 = (SupportDataList)gson.fromJson(data, SupportDataList.class);
            } else {
                menu2 = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            menu2 = null;
        }
        return menu2;
    }

    public SupportDataList getSupportDataListLike(String categoryName) {
        SupportDataList menu2 = new SupportDataList();
        try {
            String[] columns = new String[]{SUPPORT_DATA};
            Cursor cursor = this.database.query(true, TABLE_SUPPORT_DATA, columns, "support_category_name LIKE ?", new String[]{"%" + categoryName + "%"}, null, null, null, null);
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                String data = cursor.getString(cursor.getColumnIndex(SUPPORT_DATA));
                Gson gson = new Gson();
                menu2 = (SupportDataList)gson.fromJson(data, SupportDataList.class);
            } else {
                menu2 = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            menu2 = null;
        }
        return menu2;
    }

    public void deleteSupportData() {
        this.database.delete(TABLE_SUPPORT_DATA, null, null);
    }

    private static class DbHelper
    extends SQLiteOpenHelper {
        public DbHelper(Context context) {
            super(context, HippoDatabase.DATABASE_NAME, null, 1);
        }

        public DbHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
            super(context, name, factory, version);
        }

        public void onCreate(SQLiteDatabase sqLiteDatabase) {
            HippoDatabase.createTable(sqLiteDatabase);
        }

        public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
            this.onCreate(sqLiteDatabase);
        }
    }
}

