/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.support;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.google.gson.Gson;
import com.hippo.R;
import com.hippo.database.CommonData;
import com.hippo.support.Utils.Constants;
import com.hippo.support.callback.OnActionTypeCallback;
import com.hippo.support.fragment.HippoSupportDetailFragment;
import com.hippo.support.fragment.HippoSupportFragment;
import com.hippo.support.model.Item;
import java.util.ArrayList;

public class HippoSupportActivity
extends AppCompatActivity
implements OnActionTypeCallback {
    private static final String TAG = HippoSupportActivity.class.getSimpleName();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fugu_support_activity);
        String faqName = this.getIntent().getStringExtra("support_id");
        String transactionId = this.getIntent().getStringExtra("support_transaction_id");
        this.initView(faqName, transactionId);
    }

    private void initView(String faqName, String transactionId) {
        if (TextUtils.isEmpty((CharSequence)faqName)) {
            faqName = CommonData.getDefaultCategory();
        }
        CommonData.clearPathList();
        this.loadFragment(null, null, null, 0, faqName, transactionId, null, true);
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 1) {
            this.finish();
        } else {
            super.onBackPressed();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.hippo_home, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.hideKeyboard((Activity)this);
                this.onBackPressed();
                break;
            }
            default: {
                return super.onOptionsItemSelected(item);
            }
        }
        return true;
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private void loadFragment(ArrayList<Item> items, String path, String title, int support_db_version, String faqName, String transactionId, String categoryData, boolean powerFlag) {
        HippoSupportFragment fragment = new HippoSupportFragment();
        Bundle bundle = new Bundle();
        if (items != null) {
            try {
                bundle.putString("default_support", new Gson().toJson(items, Constants.listType));
            }
            catch (Exception e) {
                e.printStackTrace();
                bundle.putString("default_support", new Gson().toJson(items));
            }
        }
        if (!TextUtils.isEmpty((CharSequence)path)) {
            bundle.putString("support_path", path);
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            bundle.putString("support_title", title);
        }
        if (support_db_version > 0) {
            bundle.putInt("support_db_version", support_db_version);
        }
        if (!TextUtils.isEmpty((CharSequence)faqName)) {
            bundle.putString("support_category_id", faqName);
        }
        if (!TextUtils.isEmpty((CharSequence)transactionId)) {
            bundle.putString("support_transaction_id", transactionId);
        }
        bundle.putString("support_category_data", categoryData);
        bundle.putBoolean("powered_via", powerFlag);
        fragment.setArguments(bundle);
        this.openFragment(fragment);
    }

    private void openFragment(Fragment fragment) {
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        FragmentTransaction transaction = fragmentManager.beginTransaction();
        transaction.add(R.id.container, fragment, fragment.getClass().getName());
        transaction.addToBackStack(fragment.getClass().getName());
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            transaction.hide(this.getSupportFragmentManager().findFragmentByTag(this.getSupportFragmentManager().getBackStackEntryAt(this.getSupportFragmentManager().getBackStackEntryCount() - 1).getName()));
        }
        transaction.commitAllowingStateLoss();
    }

    @Override
    public void onActionType(ArrayList<Item> items, String path, String title, String transactionId, String categoryData) {
        this.loadFragment(items, path, title, -1, "", transactionId, categoryData, false);
    }

    @Override
    public void openDetailPage(Item items, String path, String transactionId, String categoryData) {
        HippoSupportDetailFragment detailFragment = new HippoSupportDetailFragment();
        Bundle bundle = new Bundle();
        bundle.putString("default_support", new Gson().toJson((Object)items));
        if (!TextUtils.isEmpty((CharSequence)path)) {
            bundle.putString("support_path", path);
        }
        if (!TextUtils.isEmpty((CharSequence)transactionId)) {
            bundle.putString("support_transaction_id", transactionId);
        }
        bundle.putString("support_category_data", categoryData);
        detailFragment.setArguments(bundle);
        this.openFragment(detailFragment);
    }

    @Override
    public void removeFragment() {
        FragmentManager fm = this.getSupportFragmentManager();
        for (int i = 0; i < fm.getBackStackEntryCount() - 1; ++i) {
            fm.popBackStack();
        }
    }

    private void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            if (view == null) {
                return;
            }
            InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

