/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.agent.Util;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.DrawableRes;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.hippo.R;
import com.hippo.agent.Util.Utils;
import com.hippo.agent.Util.tagview.TagView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TagContainerLayout
extends ViewGroup {
    private int mVerticalInterval;
    private ArrayList<Integer> mColorArrayList;
    private int mHorizontalInterval;
    private float mBorderWidth = 0.5f;
    private float mBorderRadius = 10.0f;
    private float mSensitivity = 1.0f;
    private int mChildHeight;
    private int mBorderColor = Color.parseColor((String)"#22FF0000");
    private int mBackgroundColor = Color.parseColor((String)"#11FF0000");
    private int mGravity = 3;
    private int mMaxLines = 0;
    private int mTagMaxLength = 23;
    private float mTagBorderWidth = 0.5f;
    private float mTagBorderRadius = 15.0f;
    private float mTagTextSize = 14.0f;
    private int mTagTextDirection = 3;
    private int mTagHorizontalPadding = 10;
    private int mTagVerticalPadding = 8;
    private int mTagBorderColor = Color.parseColor((String)"#88F44336");
    private int mTagBackgroundColor = Color.parseColor((String)"#33F44336");
    private int mTagTextColor = Color.parseColor((String)"#FF666666");
    private Typeface mTagTypeface = Typeface.DEFAULT;
    private boolean isTagViewClickable;
    private List<String> mTags;
    private boolean mDragEnable;
    private int mTagViewState = 0;
    private float mTagBdDistance = 2.75f;
    private TagView.OnTagClickListener mOnTagClickListener;
    private boolean mTagSupportLettersRTL = false;
    private Paint mPaint;
    private RectF mRectF;
    private ViewDragHelper mViewDragHelper;
    private List<View> mChildViews;
    private int[] mViewPos;
    private int mTheme = 1;
    private static final float DEFAULT_INTERVAL = 5.0f;
    private static final int TAG_MIN_LENGTH = 3;
    private int mRippleDuration = 1000;
    private int mRippleColor;
    private int mRippleAlpha = 128;
    private boolean mEnableCross = false;
    private float mCrossAreaWidth = 0.0f;
    private float mCrossAreaPadding = 10.0f;
    private int mCrossColor = -16777216;
    private float mCrossLineWidth = 1.0f;
    private int mTagBackgroundResource;

    public TagContainerLayout(Context context) {
        this(context, null);
    }

    public TagContainerLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TagContainerLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.AndroidTagView, defStyleAttr, 0);
        this.mVerticalInterval = (int)attributes.getDimension(R.styleable.AndroidTagView_vertical_interval, Utils.dp2px(context, 5.0f));
        this.mHorizontalInterval = (int)attributes.getDimension(R.styleable.AndroidTagView_horizontal_interval, Utils.dp2px(context, 5.0f));
        this.mBorderWidth = attributes.getDimension(R.styleable.AndroidTagView_container_border_width, Utils.dp2px(context, this.mBorderWidth));
        this.mBorderRadius = attributes.getDimension(R.styleable.AndroidTagView_container_border_radius, Utils.dp2px(context, this.mBorderRadius));
        this.mTagBdDistance = attributes.getDimension(R.styleable.AndroidTagView_tag_bd_distance, Utils.dp2px(context, this.mTagBdDistance));
        this.mBorderColor = attributes.getColor(R.styleable.AndroidTagView_container_border_color, this.mBorderColor);
        this.mBackgroundColor = attributes.getColor(R.styleable.AndroidTagView_container_background_color, this.mBackgroundColor);
        this.mDragEnable = attributes.getBoolean(R.styleable.AndroidTagView_container_enable_drag, false);
        this.mSensitivity = attributes.getFloat(R.styleable.AndroidTagView_container_drag_sensitivity, this.mSensitivity);
        this.mGravity = attributes.getInt(R.styleable.AndroidTagView_container_gravity, this.mGravity);
        this.mMaxLines = attributes.getInt(R.styleable.AndroidTagView_container_max_lines, this.mMaxLines);
        this.mTagMaxLength = attributes.getInt(R.styleable.AndroidTagView_tag_max_length, this.mTagMaxLength);
        this.mTheme = attributes.getInt(R.styleable.AndroidTagView_tag_theme, this.mTheme);
        this.mTagBorderWidth = attributes.getDimension(R.styleable.AndroidTagView_tag_border_width, Utils.dp2px(context, this.mTagBorderWidth));
        this.mTagBorderRadius = attributes.getDimension(R.styleable.AndroidTagView_tag_corner_radius, Utils.dp2px(context, this.mTagBorderRadius));
        this.mTagHorizontalPadding = (int)attributes.getDimension(R.styleable.AndroidTagView_tag_horizontal_padding, Utils.dp2px(context, this.mTagHorizontalPadding));
        this.mTagVerticalPadding = (int)attributes.getDimension(R.styleable.AndroidTagView_tag_vertical_padding, Utils.dp2px(context, this.mTagVerticalPadding));
        this.mTagTextSize = attributes.getDimension(R.styleable.AndroidTagView_tag_text_size, Utils.sp2px(context, this.mTagTextSize));
        this.mTagBorderColor = attributes.getColor(R.styleable.AndroidTagView_tag_border_color, this.mTagBorderColor);
        this.mTagBackgroundColor = attributes.getColor(R.styleable.AndroidTagView_tag_background_color, this.mTagBackgroundColor);
        this.mTagTextColor = attributes.getColor(R.styleable.AndroidTagView_tag_text_color, this.mTagTextColor);
        this.mTagTextDirection = attributes.getInt(R.styleable.AndroidTagView_tag_text_direction, this.mTagTextDirection);
        this.isTagViewClickable = attributes.getBoolean(R.styleable.AndroidTagView_tag_clickable, false);
        this.mRippleColor = attributes.getColor(R.styleable.AndroidTagView_tag_ripple_color, Color.parseColor((String)"#EEEEEE"));
        this.mRippleAlpha = attributes.getInteger(R.styleable.AndroidTagView_tag_ripple_alpha, this.mRippleAlpha);
        this.mRippleDuration = attributes.getInteger(R.styleable.AndroidTagView_tag_ripple_duration, this.mRippleDuration);
        this.mEnableCross = attributes.getBoolean(R.styleable.AndroidTagView_tag_enable_cross, this.mEnableCross);
        this.mCrossAreaWidth = attributes.getDimension(R.styleable.AndroidTagView_tag_cross_width, Utils.dp2px(context, this.mCrossAreaWidth));
        this.mCrossAreaPadding = attributes.getDimension(R.styleable.AndroidTagView_tag_cross_area_padding, Utils.dp2px(context, this.mCrossAreaPadding));
        this.mCrossColor = attributes.getColor(R.styleable.AndroidTagView_tag_cross_color, this.mCrossColor);
        this.mCrossLineWidth = attributes.getDimension(R.styleable.AndroidTagView_tag_cross_line_width, Utils.dp2px(context, this.mCrossLineWidth));
        this.mTagSupportLettersRTL = attributes.getBoolean(R.styleable.AndroidTagView_tag_support_letters_rlt, this.mTagSupportLettersRTL);
        this.mTagBackgroundResource = attributes.getResourceId(R.styleable.AndroidTagView_tag_background, this.mTagBackgroundResource);
        attributes.recycle();
        this.mPaint = new Paint(1);
        this.mRectF = new RectF();
        this.mChildViews = new ArrayList<View>();
        this.mViewDragHelper = ViewDragHelper.create((ViewGroup)this, (float)this.mSensitivity, (ViewDragHelper.Callback)new DragHelperCallBack());
        this.setWillNotDraw(false);
        this.setTagMaxLength(this.mTagMaxLength);
        this.setTagHorizontalPadding(this.mTagHorizontalPadding);
        this.setTagVerticalPadding(this.mTagVerticalPadding);
        if (this.isInEditMode()) {
            this.addTag("sample tag");
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int childCount = this.getChildCount();
        int lines = childCount == 0 ? 0 : this.getChildLines(childCount);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (childCount == 0) {
            this.setMeasuredDimension(0, 0);
        } else if (heightSpecMode == Integer.MIN_VALUE || heightSpecMode == 0) {
            this.setMeasuredDimension(widthSpecSize, (this.mVerticalInterval + this.mChildHeight) * lines - this.mVerticalInterval + this.getPaddingTop() + this.getPaddingBottom());
        } else {
            this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mRectF.set(0.0f, 0.0f, (float)w, (float)h);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        View childView;
        int i;
        int childCount = this.getChildCount();
        if (childCount <= 0) {
            return;
        }
        int availableW = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int curRight = this.getMeasuredWidth() - this.getPaddingRight();
        int curTop = this.getPaddingTop();
        int curLeft = this.getPaddingLeft();
        int sPos = 0;
        this.mViewPos = new int[childCount * 2];
        for (i = 0; i < childCount; ++i) {
            childView = this.getChildAt(i);
            if (childView.getVisibility() == 8) continue;
            int width = childView.getMeasuredWidth();
            if (this.mGravity == 5) {
                if (curRight - width < this.getPaddingLeft()) {
                    curRight = this.getMeasuredWidth() - this.getPaddingRight();
                    curTop += this.mChildHeight + this.mVerticalInterval;
                }
                this.mViewPos[i * 2] = curRight - width;
                this.mViewPos[i * 2 + 1] = curTop;
                curRight -= width + this.mHorizontalInterval;
                continue;
            }
            if (this.mGravity == 17) {
                int j;
                int leftW;
                if (curLeft + width - this.getPaddingLeft() > availableW) {
                    leftW = this.getMeasuredWidth() - this.mViewPos[(i - 1) * 2] - this.getChildAt(i - 1).getMeasuredWidth() - this.getPaddingRight();
                    for (j = sPos; j < i; ++j) {
                        this.mViewPos[j * 2] = this.mViewPos[j * 2] + leftW / 2;
                    }
                    sPos = i;
                    curLeft = this.getPaddingLeft();
                    curTop += this.mChildHeight + this.mVerticalInterval;
                }
                this.mViewPos[i * 2] = curLeft;
                this.mViewPos[i * 2 + 1] = curTop;
                curLeft += width + this.mHorizontalInterval;
                if (i != childCount - 1) continue;
                leftW = this.getMeasuredWidth() - this.mViewPos[i * 2] - childView.getMeasuredWidth() - this.getPaddingRight();
                for (j = sPos; j < childCount; ++j) {
                    this.mViewPos[j * 2] = this.mViewPos[j * 2] + leftW / 2;
                }
                continue;
            }
            if (curLeft + width - this.getPaddingLeft() > availableW) {
                curLeft = this.getPaddingLeft();
                curTop += this.mChildHeight + this.mVerticalInterval;
            }
            this.mViewPos[i * 2] = curLeft;
            this.mViewPos[i * 2 + 1] = curTop;
            curLeft += width + this.mHorizontalInterval;
        }
        for (i = 0; i < this.mViewPos.length / 2; ++i) {
            childView = this.getChildAt(i);
            childView.layout(this.mViewPos[i * 2], this.mViewPos[i * 2 + 1], this.mViewPos[i * 2] + childView.getMeasuredWidth(), this.mViewPos[i * 2 + 1] + this.mChildHeight);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mBackgroundColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mBorderWidth);
        this.mPaint.setColor(this.mBorderColor);
        canvas.drawRoundRect(this.mRectF, this.mBorderRadius, this.mBorderRadius, this.mPaint);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mViewDragHelper.shouldInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mViewDragHelper.processTouchEvent(event);
        return true;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mViewDragHelper.continueSettling(true)) {
            this.requestLayout();
        }
    }

    private int getChildLines(int childCount) {
        int availableW = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
        int lines = 1;
        int curLineW = 0;
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            int dis = childView.getMeasuredWidth() + this.mHorizontalInterval;
            int height = childView.getMeasuredHeight();
            int n = this.mChildHeight = i == 0 ? height : Math.min(this.mChildHeight, height);
            if ((curLineW += dis) - this.mHorizontalInterval <= availableW) continue;
            ++lines;
            curLineW = dis;
        }
        return this.mMaxLines <= 0 ? lines : this.mMaxLines;
    }

    private void onSetTag() {
        if (this.mTags == null) {
            throw new RuntimeException("NullPointer exception!");
        }
        this.removeAllTags();
        if (this.mTags.size() == 0) {
            return;
        }
        for (int i = 0; i < this.mTags.size(); ++i) {
            this.onAddTag(this.mTags.get(i), this.mChildViews.size());
        }
        this.postInvalidate();
    }

    private void onAddTag(String text, int position) {
        if (position < 0 || position > this.mChildViews.size()) {
            throw new RuntimeException("Illegal position!");
        }
        TagView tagView = new TagView(this.getContext(), text);
        this.initTagView(tagView, position);
        this.mChildViews.add(position, tagView);
        if (position < this.mChildViews.size()) {
            for (int i = position; i < this.mChildViews.size(); ++i) {
                this.mChildViews.get(i).setTag((Object)i);
            }
        } else {
            tagView.setTag(position);
        }
        this.addView(tagView, position);
    }

    private void initTagView(TagView tagView, int position) {
        if (this.mColorArrayList != null && this.mColorArrayList.size() > 0) {
            if (this.mColorArrayList.size() == this.mTags.size()) {
                ArrayList<Integer> colors = this.mColorArrayList;
                tagView.setTagBackgroundColor(colors.get(position));
                tagView.setTagBorderColor(colors.get(position));
                tagView.setTagTextColor(-1);
                tagView.setTagMaxLength(this.mTagMaxLength);
                tagView.setTextDirection(this.mTagTextDirection);
                tagView.setTypeface(this.mTagTypeface);
                tagView.setBorderWidth(this.mTagBorderWidth);
                tagView.setBorderRadius(this.mTagBorderRadius);
                tagView.setTextSize(this.mTagTextSize);
                tagView.setHorizontalPadding(this.mTagHorizontalPadding);
                tagView.setVerticalPadding(this.mTagVerticalPadding);
                tagView.setIsViewClickable(this.isTagViewClickable);
                tagView.setBdDistance(this.mTagBdDistance);
                tagView.setOnTagClickListener(this.mOnTagClickListener);
                tagView.setRippleAlpha(this.mRippleAlpha);
                tagView.setRippleColor(this.mRippleColor);
                tagView.setRippleDuration(this.mRippleDuration);
                tagView.setEnableCross(this.mEnableCross);
                tagView.setCrossAreaWidth(this.mCrossAreaWidth);
                tagView.setCrossAreaPadding(this.mCrossAreaPadding);
                tagView.setCrossColor(this.mCrossColor);
                tagView.setCrossLineWidth(this.mCrossLineWidth);
                tagView.setTagSupportLettersRTL(this.mTagSupportLettersRTL);
                tagView.setBackgroundResource(this.mTagBackgroundResource);
            } else {
                throw new RuntimeException("Illegal color list!");
            }
        }
    }

    private void invalidateTags() {
        for (View view : this.mChildViews) {
            TagView tagView = (TagView)view;
            tagView.setOnTagClickListener(this.mOnTagClickListener);
        }
    }

    private void onRemoveTag(int position) {
        if (position < 0 || position >= this.mChildViews.size()) {
            throw new RuntimeException("Illegal position!");
        }
        this.mChildViews.remove(position);
        this.removeViewAt(position);
        for (int i = position; i < this.mChildViews.size(); ++i) {
            this.mChildViews.get(i).setTag((Object)i);
        }
    }

    private int[] onGetNewPosition(View view) {
        int left = view.getLeft();
        int top = view.getTop();
        int bestMatchLeft = this.mViewPos[(Integer)view.getTag() * 2];
        int bestMatchTop = this.mViewPos[(Integer)view.getTag() * 2 + 1];
        int tmpTopDis = Math.abs(top - bestMatchTop);
        for (int i = 0; i < this.mViewPos.length / 2; ++i) {
            if (Math.abs(top - this.mViewPos[i * 2 + 1]) >= tmpTopDis) continue;
            bestMatchTop = this.mViewPos[i * 2 + 1];
            tmpTopDis = Math.abs(top - this.mViewPos[i * 2 + 1]);
        }
        int rowChildCount = 0;
        int tmpLeftDis = 0;
        for (int i = 0; i < this.mViewPos.length / 2; ++i) {
            if (this.mViewPos[i * 2 + 1] != bestMatchTop) continue;
            if (rowChildCount == 0) {
                bestMatchLeft = this.mViewPos[i * 2];
                tmpLeftDis = Math.abs(left - bestMatchLeft);
            } else if (Math.abs(left - this.mViewPos[i * 2]) < tmpLeftDis) {
                bestMatchLeft = this.mViewPos[i * 2];
                tmpLeftDis = Math.abs(left - bestMatchLeft);
            }
            ++rowChildCount;
        }
        return new int[]{bestMatchLeft, bestMatchTop};
    }

    private int onGetCoordinateReferPos(int left, int top) {
        int pos = 0;
        for (int i = 0; i < this.mViewPos.length / 2; ++i) {
            if (left != this.mViewPos[i * 2] || top != this.mViewPos[i * 2 + 1]) continue;
            pos = i;
        }
        return pos;
    }

    private void onChangeView(View view, int newPos, int originPos) {
        this.mChildViews.remove(originPos);
        this.mChildViews.add(newPos, view);
        for (View child : this.mChildViews) {
            child.setTag((Object)this.mChildViews.indexOf(child));
        }
        this.removeViewAt(originPos);
        this.addView(view, newPos);
    }

    private int ceilTagBorderWidth() {
        return (int)Math.ceil(this.mTagBorderWidth);
    }

    public int getTagViewState() {
        return this.mTagViewState;
    }

    public float getTagBdDistance() {
        return this.mTagBdDistance;
    }

    public void setTagBdDistance(float tagBdDistance) {
        this.mTagBdDistance = Utils.dp2px(this.getContext(), tagBdDistance);
    }

    public void setTags(List<String> tags) {
        this.mTags = tags;
        this.onSetTag();
    }

    public void setTags(List<String> tags, ArrayList<Integer> colorArrayList) {
        this.mTags = tags;
        this.mColorArrayList = colorArrayList;
        this.onSetTag();
    }

    public void setTags(String ... tags) {
        this.mTags = Arrays.asList(tags);
        this.onSetTag();
    }

    public void addTag(String text) {
        this.addTag(text, this.mChildViews.size());
    }

    public void addTag(String text, int position) {
        this.onAddTag(text, position);
        this.postInvalidate();
    }

    public void removeTag(int position) {
        this.onRemoveTag(position);
        this.postInvalidate();
    }

    public void removeAllTags() {
        this.mChildViews.clear();
        this.removeAllViews();
        this.postInvalidate();
    }

    public void setOnTagClickListener(TagView.OnTagClickListener listener) {
        this.mOnTagClickListener = listener;
        this.invalidateTags();
    }

    public String getTagText(int position) {
        return ((TagView)this.mChildViews.get(position)).getText();
    }

    public List<String> getTags() {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (View view : this.mChildViews) {
            if (!(view instanceof TagView)) continue;
            tmpList.add(((TagView)view).getText());
        }
        return tmpList;
    }

    public void setDragEnable(boolean enable) {
        this.mDragEnable = enable;
    }

    public boolean getDragEnable() {
        return this.mDragEnable;
    }

    public void setVerticalInterval(float interval) {
        this.mVerticalInterval = (int)Utils.dp2px(this.getContext(), interval);
        this.postInvalidate();
    }

    public int getVerticalInterval() {
        return this.mVerticalInterval;
    }

    public void setHorizontalInterval(float interval) {
        this.mHorizontalInterval = (int)Utils.dp2px(this.getContext(), interval);
        this.postInvalidate();
    }

    public int getHorizontalInterval() {
        return this.mHorizontalInterval;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(float width) {
        this.mBorderWidth = width;
    }

    public float getBorderRadius() {
        return this.mBorderRadius;
    }

    public void setBorderRadius(float radius) {
        this.mBorderRadius = radius;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int color2) {
        this.mBorderColor = color2;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public void setGravity(int gravity) {
        this.mGravity = gravity;
    }

    public float getSensitivity() {
        return this.mSensitivity;
    }

    public void setSensitivity(float sensitivity) {
        this.mSensitivity = sensitivity;
    }

    public void setMaxLines(int maxLines) {
        this.mMaxLines = maxLines;
        this.postInvalidate();
    }

    public int getMaxLines() {
        return this.mMaxLines;
    }

    public void setTagMaxLength(int maxLength) {
        this.mTagMaxLength = maxLength < 3 ? 3 : maxLength;
    }

    public int getTagMaxLength() {
        return this.mTagMaxLength;
    }

    public void setTheme(int theme) {
        this.mTheme = theme;
    }

    public int getTheme() {
        return this.mTheme;
    }

    public boolean getIsTagViewClickable() {
        return this.isTagViewClickable;
    }

    public void setIsTagViewClickable(boolean clickable) {
        this.isTagViewClickable = clickable;
    }

    public float getTagBorderWidth() {
        return this.mTagBorderWidth;
    }

    public void setTagBorderWidth(float width) {
        this.mTagBorderWidth = width;
    }

    public float getTagBorderRadius() {
        return this.mTagBorderRadius;
    }

    public void setTagBorderRadius(float radius) {
        this.mTagBorderRadius = radius;
    }

    public float getTagTextSize() {
        return this.mTagTextSize;
    }

    public void setTagTextSize(float size) {
        this.mTagTextSize = size;
    }

    public int getTagHorizontalPadding() {
        return this.mTagHorizontalPadding;
    }

    public void setTagHorizontalPadding(int padding) {
        int ceilWidth = this.ceilTagBorderWidth();
        this.mTagHorizontalPadding = padding < ceilWidth ? ceilWidth : padding;
    }

    public int getTagVerticalPadding() {
        return this.mTagVerticalPadding;
    }

    public void setTagVerticalPadding(int padding) {
        int ceilWidth = this.ceilTagBorderWidth();
        this.mTagVerticalPadding = padding < ceilWidth ? ceilWidth : padding;
    }

    public int getTagBorderColor() {
        return this.mTagBorderColor;
    }

    public void setTagBorderColor(int color2) {
        this.mTagBorderColor = color2;
    }

    public int getTagBackgroundColor() {
        return this.mTagBackgroundColor;
    }

    public void setTagBackgroundColor(int color2) {
        this.mTagBackgroundColor = color2;
    }

    public int getTagTextColor() {
        return this.mTagTextColor;
    }

    public void setTagTextDirection(int textDirection) {
        this.mTagTextDirection = textDirection;
    }

    public Typeface getTagTypeface() {
        return this.mTagTypeface;
    }

    public void setTagTypeface(Typeface typeface) {
        this.mTagTypeface = typeface;
    }

    public int getTagTextDirection() {
        return this.mTagTextDirection;
    }

    public void setTagTextColor(int color2) {
        this.mTagTextColor = color2;
    }

    public int getRippleAlpha() {
        return this.mRippleAlpha;
    }

    public void setRippleAlpha(int mRippleAlpha) {
        this.mRippleAlpha = mRippleAlpha;
    }

    public int getRippleColor() {
        return this.mRippleColor;
    }

    public void setRippleColor(int mRippleColor) {
        this.mRippleColor = mRippleColor;
    }

    public int getRippleDuration() {
        return this.mRippleDuration;
    }

    public void setRippleDuration(int mRippleDuration) {
        this.mRippleDuration = mRippleDuration;
    }

    public int getCrossColor() {
        return this.mCrossColor;
    }

    public void setCrossColor(int mCrossColor) {
        this.mCrossColor = mCrossColor;
    }

    public float getCrossAreaPadding() {
        return this.mCrossAreaPadding;
    }

    public void setCrossAreaPadding(float mCrossAreaPadding) {
        this.mCrossAreaPadding = mCrossAreaPadding;
    }

    public boolean isEnableCross() {
        return this.mEnableCross;
    }

    public void setEnableCross(boolean mEnableCross) {
        this.mEnableCross = mEnableCross;
    }

    public float getCrossAreaWidth() {
        return this.mCrossAreaWidth;
    }

    public void setCrossAreaWidth(float mCrossAreaWidth) {
        this.mCrossAreaWidth = mCrossAreaWidth;
    }

    public float getCrossLineWidth() {
        return this.mCrossLineWidth;
    }

    public void setCrossLineWidth(float mCrossLineWidth) {
        this.mCrossLineWidth = mCrossLineWidth;
    }

    public boolean isTagSupportLettersRTL() {
        return this.mTagSupportLettersRTL;
    }

    public void setTagSupportLettersRTL(boolean mTagSupportLettersRTL) {
        this.mTagSupportLettersRTL = mTagSupportLettersRTL;
    }

    public TagView getTagView(int position) {
        if (position < 0 || position >= this.mChildViews.size()) {
            throw new RuntimeException("Illegal position!");
        }
        return (TagView)this.mChildViews.get(position);
    }

    public int getTagBackgroundResource() {
        return this.mTagBackgroundResource;
    }

    public void setTagBackgroundResource(@DrawableRes int tagBackgroundResource) {
        this.mTagBackgroundResource = tagBackgroundResource;
    }

    private class DragHelperCallBack
    extends ViewDragHelper.Callback {
        private DragHelperCallBack() {
        }

        public void onViewDragStateChanged(int state) {
            super.onViewDragStateChanged(state);
            TagContainerLayout.this.mTagViewState = state;
        }

        public boolean tryCaptureView(View child, int pointerId) {
            TagContainerLayout.this.requestDisallowInterceptTouchEvent(true);
            return TagContainerLayout.this.mDragEnable;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            int leftX = TagContainerLayout.this.getPaddingLeft();
            int rightX = TagContainerLayout.this.getWidth() - child.getWidth() - TagContainerLayout.this.getPaddingRight();
            return Math.min(Math.max(left, leftX), rightX);
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            int topY = TagContainerLayout.this.getPaddingTop();
            int bottomY = TagContainerLayout.this.getHeight() - child.getHeight() - TagContainerLayout.this.getPaddingBottom();
            return Math.min(Math.max(top, topY), bottomY);
        }

        public int getViewHorizontalDragRange(View child) {
            return TagContainerLayout.this.getMeasuredWidth() - child.getMeasuredWidth();
        }

        public int getViewVerticalDragRange(View child) {
            return TagContainerLayout.this.getMeasuredHeight() - child.getMeasuredHeight();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            TagContainerLayout.this.requestDisallowInterceptTouchEvent(false);
            int[] pos = TagContainerLayout.this.onGetNewPosition(releasedChild);
            int posRefer = TagContainerLayout.this.onGetCoordinateReferPos(pos[0], pos[1]);
            TagContainerLayout.this.onChangeView(releasedChild, posRefer, (Integer)releasedChild.getTag());
            TagContainerLayout.this.mViewDragHelper.settleCapturedViewAt(pos[0], pos[1]);
            TagContainerLayout.this.invalidate();
        }
    }
}

