/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.app.Activity;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.text.TextUtilsCompat;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.AppCompatImageView;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ImageSpan;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.downloader.Error;
import com.downloader.OnDownloadListener;
import com.downloader.OnPauseListener;
import com.downloader.OnProgressListener;
import com.downloader.OnStartOrResumeListener;
import com.downloader.PRDownloader;
import com.downloader.Progress;
import com.hippo.HippoColorConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.activity.ImageDisplayActivity;
import com.hippo.activity.VideoPlayerActivity;
import com.hippo.adapter.ButtonsAdapter;
import com.hippo.adapter.CustomActionButtonsAdapter;
import com.hippo.adapter.CustomActionDescriptionAdapter;
import com.hippo.adapter.DataFormAdapter;
import com.hippo.adapter.EventItem;
import com.hippo.adapter.HeaderItem;
import com.hippo.adapter.HippoQuickReplayAdapter;
import com.hippo.adapter.ListItem;
import com.hippo.adapter.OnRecyclerListener;
import com.hippo.adapter.QRCallback;
import com.hippo.adapter.QuickReplyAdapaterActivityCallback;
import com.hippo.adapter.UserConcentListener;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.CustomAction;
import com.hippo.model.FuguConversation;
import com.hippo.model.FuguFileDetails;
import com.hippo.model.Image;
import com.hippo.model.Message;
import com.hippo.utils.CommonMediaPlayer;
import com.hippo.utils.DateUtils;
import com.hippo.utils.GridDividerItemDecoration;
import com.hippo.utils.HippoLog;
import com.hippo.utils.MyCustomEditTextListener;
import com.hippo.utils.RoundedCornersTransformation;
import com.hippo.utils.Utils;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.loadingBox.ProgressWheel;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class FuguMessageAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements FuguAppConstant,
QRCallback,
OnRecyclerListener,
UserConcentListener {
    private static final String TAG = FuguMessageAdapter.class.getSimpleName();
    private final int FUGU_TYPE_HEADER = 0;
    private final int FUGU_ITEM_TYPE_OTHER = 1;
    private final int FUGU_ITEM_TYPE_SELF = 2;
    private final int FUGU_RATING_VIEW = 3;
    private final int FUGU_GALLERY_VIEW = -990;
    private final int FUGU_TEXT_VIEW = 15;
    private final int FUGU_QUICK_REPLY_VIEW = 16;
    private final int FUGU_FORUM_VIEW = 17;
    private final int FUGU_VIDEO_CALL_VIEW = 18;
    private final int FUGU_OTHER_VIDEO_CALL_VIEW = 19;
    private final int HIPPO_FILE_SENT_VIEW = 10;
    private final int HIPPO_FILE_RECEIVED_VIEW = 11;
    private final int HIPPO_VIDEO_MESSGAE_SELF = 12;
    private final int HIPPO_VIDEO_MESSGAE_OTHER = 13;
    private final int HIPPO_UNKNOWN_MESSAGE_SELF = -2;
    private final int HIPPO_UNKNOWN_MESSAGE_OTHER = -1;
    private final int HIPPO_USER_CONCENT_VIEW = 20;
    private DateUtils fuguDateUtil = DateUtils.getInstance();
    private Long fuguLabelId;
    private OnRetryListener mOnRetry;
    private onVideoCall onVideoCall;
    private HippoColorConfig hippoColorConfig;
    private Activity activity;
    private FuguConversation fuguConversation;
    private FuguChatActivity fuguChatActivity;
    private Configuration config;
    private QuickReplyAdapaterActivityCallback qrCallback;
    private OnRatingListener onRatingListener;
    private OnUserConcent onUserConcent;
    private FragmentManager fragmentManager;
    private String agentName = "";
    private boolean isVideoCallEnabled = false;
    private boolean isAudioCallEnabled = false;
    String callType = "video";
    boolean isSourceMessageEnabled = false;
    @NonNull
    private List<ListItem> fuguItems = Collections.emptyList();
    private RecyclerView recyclerView;
    int currentProgress = -1;
    boolean receiverRegistered;
    private BroadcastReceiver mProgressReceiver = null;

    public FuguMessageAdapter(Activity activity, @NonNull List<ListItem> fuguItems, RecyclerView recyclerView, Long fuguLabelId, FuguConversation fuguConversation, OnRatingListener onRatingListener, QuickReplyAdapaterActivityCallback callback, FragmentManager fragmentManager, OnUserConcent onUserConcent, boolean isSourceMessageEnabled) {
        this.fuguItems = fuguItems;
        this.activity = activity;
        this.recyclerView = recyclerView;
        this.fuguLabelId = fuguLabelId;
        this.fuguConversation = fuguConversation;
        this.removeDefaultMsgTime();
        this.hippoColorConfig = CommonData.getColorConfig();
        this.config = activity.getResources().getConfiguration();
        this.onRatingListener = onRatingListener;
        this.onUserConcent = onUserConcent;
        this.qrCallback = callback;
        this.fragmentManager = fragmentManager;
        this.isSourceMessageEnabled = isSourceMessageEnabled;
    }

    public void setOnRetryListener(OnRetryListener OnRetryListener2) {
        this.mOnRetry = OnRetryListener2;
    }

    public void setOnVideoCallListener(onVideoCall onVideoCall2) {
        this.onVideoCall = onVideoCall2;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void isVideoCallEnabled(boolean isVideoCallEnabled) {
        this.isVideoCallEnabled = isVideoCallEnabled;
    }

    public void isAudioCallEnabled(boolean isAudioCallEnabled) {
        this.isAudioCallEnabled = isAudioCallEnabled;
    }

    @Override
    public void onFormClickListener(int id2, Message currentFormMsg) {
        this.onRatingListener.onFormDataCallback(currentFormMsg);
    }

    @Override
    public void DataFormCallback() {
    }

    @Override
    public void onClickListener(Message message, int pos, QuickReplyViewHolder viewHolder) {
        viewHolder.list_qr.setVisibility(8);
        this.qrCallback.QuickReplyListener(message, pos);
    }

    @Override
    public void onItemClick(View viewClicked, View parentView, int position) {
        int positionInList = this.recyclerView.getChildLayoutPosition(parentView);
        if (positionInList != -1) {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Message otherVideoMessage = ((EventItem)this.fuguItems.get(positionInList)).getEvent();
            String fname = Util.getFileName(otherVideoMessage.getFileName(), otherVideoMessage.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(otherVideoMessage.getDocumentType()));
            Intent intent = new Intent((Context)this.activity, VideoPlayerActivity.class);
            intent.putExtra("url", localPath);
            intent.putExtra("title", otherVideoMessage.getFileName());
            this.activity.startActivity(intent);
        }
    }

    @Override
    public void onUserConcent(int position, String btnId, Message message) {
        if (this.onUserConcent != null) {
            this.onUserConcent.onConcentClicked(message);
        }
    }

    public void updateList(@NonNull List<ListItem> items) {
        this.updateList(items, true);
    }

    public void updateList(@NonNull List<ListItem> items, boolean flag) {
        this.fuguItems = items;
        if (flag) {
            this.removeDefaultMsgTime();
        }
    }

    private void removeDefaultMsgTime() {
        if (this.fuguItems.size() > 0) {
            for (int i = 0; i < 2 && i < this.fuguItems.size(); ++i) {
                if (this.fuguItems.get(i).getType() != 1 || this.fuguLabelId.compareTo(-1L) == 0) continue;
                ((EventItem)this.fuguItems.get(i)).getEvent().setSentAtUtc("");
                break;
            }
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 2: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView);
            }
            case 1: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView);
            }
            case 0: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_item_message_date, parent, false);
                return new DateViewHolder(normalView);
            }
            case 17: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_data_fourm, parent, false);
                return new ForumViewHolder(normalView);
            }
            case 15: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_text_item, parent, false);
                return new SimpleTextView(normalView);
            }
            case 10: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_file_sent, parent, false);
                return new SentFileViewHolder(normalView);
            }
            case 11: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_file_received, parent, false);
                return new ReceivedFileViewHolder(normalView);
            }
            case 12: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_item_video_self, parent, false);
                return new SelfVideoMessageViewHolder(normalView);
            }
            case 13: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_item_video_other, parent, false);
                return new OtherVideoMessageViewHolder(normalView, this);
            }
            case 16: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_item_quick_replay, parent, false);
                return new QuickReplyViewHolder(normalView);
            }
            case -990: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_item_gallery, parent, false);
                return new GalleryViewHolder(normalView);
            }
            case 3: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_feedback_dialog, parent, false);
                return new RatingViewHolder(normalView, new MyCustomEditTextListener());
            }
            case 18: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_video_self_side, parent, false);
                return new SelfVideoViewHolder(normalView);
            }
            case 19: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_video_other_side, parent, false);
                return new VideoViewHolder(normalView);
            }
            case 20: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.hippo_user_concent, parent, false);
                return new UserConcentViewHolder(normalView);
            }
            case -2: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_item_message_right, parent, false);
                return new SelfMessageViewHolder(normalView);
            }
            case -1: {
                View normalView = LayoutInflater.from((Context)this.activity).inflate(R.layout.fugu_item_message_left, parent, false);
                return new OtherMessageViewHolder(normalView);
            }
        }
        return null;
    }

    private int pxToDp(int dpParam) {
        float d = this.activity.getResources().getDisplayMetrics().density;
        return (int)((float)dpParam * d);
    }

    private Long downloadFile(String url, String fileName, String ext) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
        request.setDescription((CharSequence)CommonData.getUserDetails().getData().getBusinessName());
        request.setTitle((CharSequence)fileName);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, fileName + ext);
        DownloadManager manager = (DownloadManager)this.activity.getSystemService("download");
        if (manager != null) {
            return manager.enqueue(request);
        }
        return null;
    }

    private void setImageClick(int item, ImageView ... imageViews) {
        int width = (int)this.convertDpToPixel(40.0f);
        int height = (int)this.convertDpToPixel(40.0f);
        block14: for (int i = 1; i <= imageViews.length; ++i) {
            if (i == item) {
                int length = (int)this.convertDpToPixel(60.0f);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(length, length);
                imageViews[i - 1].setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                switch (item) {
                    case 1: {
                        imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_terrible_image_selected);
                        break;
                    }
                    case 2: {
                        imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_bad_image_selected);
                        break;
                    }
                    case 3: {
                        imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_okay_image_selected);
                        break;
                    }
                    case 4: {
                        imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_good_image_selected);
                        break;
                    }
                    case 5: {
                        imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_great_image_selected);
                        break;
                    }
                }
                continue;
            }
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(width, height);
            imageViews[i - 1].setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            switch (i) {
                case 1: {
                    imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_terrible_image);
                    continue block14;
                }
                case 2: {
                    imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_bad_image);
                    continue block14;
                }
                case 3: {
                    imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_okay_image);
                    continue block14;
                }
                case 4: {
                    imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_good_image);
                    continue block14;
                }
                case 5: {
                    imageViews[i - 1].setBackgroundResource(R.drawable.hippo_ic_great_image);
                    continue block14;
                }
            }
        }
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int pos) {
        final int position = holder.getAdapterPosition();
        int itemType = this.getItemViewType(position);
        this.fuguChatActivity = (FuguChatActivity)this.activity;
        boolean isRightToLeft = false;
        try {
            isRightToLeft = Build.VERSION.SDK_INT >= 17 ? this.config.getLayoutDirection() == 1 : TextUtilsCompat.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (itemType) {
            case 18: {
                SelfVideoViewHolder videoViewHolder = (SelfVideoViewHolder)holder;
                final Message videoMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                this.callType = "video";
                if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    this.callType = "voice";
                }
                if (videoMessage.getMessageState() != null && videoMessage.getMessageState() == 2) {
                    videoViewHolder.tvMsg.setText((CharSequence)(this.agentName + " missed a " + this.callType + " call with you"));
                } else {
                    videoViewHolder.tvMsg.setText((CharSequence)("The " + this.callType + " call ended"));
                }
                if (videoMessage.getSentAtUtc().isEmpty()) {
                    videoViewHolder.tvTime.setVisibility(8);
                } else {
                    videoViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.fuguDateUtil.convertToLocal(videoMessage.getSentAtUtc())));
                    videoViewHolder.tvTime.setVisibility(0);
                }
                if (videoMessage.getVideoCallDuration() > 0) {
                    videoViewHolder.ivCallIcon.setVisibility(0);
                    videoViewHolder.tvDuration.setVisibility(0);
                    videoViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(videoMessage.getVideoCallDuration()) + " at "));
                } else {
                    videoViewHolder.ivCallIcon.setVisibility(8);
                    videoViewHolder.tvDuration.setVisibility(8);
                }
                if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    if (!CommonData.getAudioCallStatus() || !this.isAudioCallEnabled) {
                        videoViewHolder.callAgain.setVisibility(8);
                    }
                } else if (!CommonData.getVideoCallStatus() || !this.isVideoCallEnabled) {
                    videoViewHolder.callAgain.setVisibility(8);
                }
                videoViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguMessageAdapter.this.onVideoCall != null) {
                            int callType = 1;
                            if (!TextUtils.isEmpty((CharSequence)videoMessage.getCallType()) && videoMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                callType = 2;
                            }
                            FuguMessageAdapter.this.onVideoCall.onVideoCallClicked(callType);
                        }
                    }
                });
                break;
            }
            case 19: {
                VideoViewHolder videoOtherViewHolder = (VideoViewHolder)holder;
                final Message videoOtherMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                this.callType = "video";
                if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    this.callType = "voice";
                }
                if (videoOtherMessage.getMessageState() != null && videoOtherMessage.getMessageState() == 2) {
                    videoOtherViewHolder.tvMsg.setText((CharSequence)("You missed a " + this.callType + " call with " + videoOtherMessage.getfromName()));
                } else {
                    videoOtherViewHolder.tvMsg.setText((CharSequence)("The " + this.callType + " call ended"));
                }
                if (videoOtherMessage.getSentAtUtc().isEmpty()) {
                    videoOtherViewHolder.tvTime.setVisibility(8);
                } else {
                    videoOtherViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.fuguDateUtil.convertToLocal(videoOtherMessage.getSentAtUtc())));
                    videoOtherViewHolder.tvTime.setVisibility(0);
                }
                if (videoOtherMessage.getVideoCallDuration() > 0) {
                    videoOtherViewHolder.ivCallIcon.setVisibility(0);
                    videoOtherViewHolder.tvDuration.setVisibility(0);
                    videoOtherViewHolder.tvDuration.setText((CharSequence)(this.convertSeconds(videoOtherMessage.getVideoCallDuration()) + " at "));
                } else {
                    videoOtherViewHolder.ivCallIcon.setVisibility(8);
                    videoOtherViewHolder.tvDuration.setVisibility(8);
                }
                if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                    if (!CommonData.getAudioCallStatus() || !this.isAudioCallEnabled) {
                        videoOtherViewHolder.callAgain.setVisibility(8);
                    }
                } else if (!CommonData.getVideoCallStatus() || !this.isVideoCallEnabled) {
                    videoOtherViewHolder.callAgain.setVisibility(8);
                }
                NinePatchDrawable drawable4 = (NinePatchDrawable)videoOtherViewHolder.llMessage.getBackground();
                drawable4.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                videoOtherViewHolder.callAgain.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguMessageAdapter.this.onVideoCall != null) {
                            int callType = 1;
                            if (!TextUtils.isEmpty((CharSequence)videoOtherMessage.getCallType()) && videoOtherMessage.getCallType().equalsIgnoreCase(FuguAppConstant.CallType.AUDIO.toString())) {
                                callType = 2;
                            }
                            FuguMessageAdapter.this.onVideoCall.onVideoCallClicked(callType);
                        }
                    }
                });
                break;
            }
            case 10: {
                Integer dimage;
                final SentFileViewHolder sentFileViewHolder = (SentFileViewHolder)holder;
                final Message fileSentMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                this.setSelfMessageBackground((View)sentFileViewHolder.llRoot, (View)sentFileViewHolder.llMessage, position);
                NinePatchDrawable drawable9 = (NinePatchDrawable)sentFileViewHolder.llMessage.getBackground();
                drawable9.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                sentFileViewHolder.circleProgress.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                String fileExt = Util.getExtension(fileSentMessage.getFileName());
                if (TextUtils.isEmpty((CharSequence)fileExt)) {
                    fileExt = Util.getExtension(fileSentMessage.getFileUrl());
                }
                if ((dimage = (Integer)IMAGE_MAP.get(fileExt.toLowerCase())) != null) {
                    sentFileViewHolder.ivFileImage.setImageResource(dimage.intValue());
                } else {
                    sentFileViewHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                sentFileViewHolder.tvFileName.setText((CharSequence)fileSentMessage.getFileName());
                if (fileExt.length() > 4) {
                    fileExt = fileExt.substring(0, 4) + "..";
                }
                sentFileViewHolder.tvFileExtension.setText((CharSequence)fileExt);
                if (!TextUtils.isEmpty((CharSequence)fileSentMessage.getFileSize())) {
                    try {
                        sentFileViewHolder.tvFileSize.setText((CharSequence)fileSentMessage.getFileSize());
                    }
                    catch (Exception e) {
                        sentFileViewHolder.tvFileSize.setText((CharSequence)fileSentMessage.getFileSize());
                    }
                }
                this.setIntegrationSource(sentFileViewHolder.messageSourceType, sentFileViewHolder.messageSourceType1, fileSentMessage.getIntegrationSource());
                this.messageStatusTick(sentFileViewHolder.ivMessageState, fileSentMessage);
                this.setFileUploadStatus(sentFileViewHolder.ivFileImage, sentFileViewHolder.ivFilePlay, sentFileViewHolder.circleProgress, sentFileViewHolder.ivFileDownload, sentFileViewHolder.ivFileUpload, fileSentMessage, position);
                this.setDownloadClick(sentFileViewHolder.ivFileDownload, sentFileViewHolder.circleProgress, fileSentMessage, position);
                this.setUploadClick(sentFileViewHolder.ivFileUpload, sentFileViewHolder.circleProgress, fileSentMessage);
                sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                if (!fileSentMessage.isAudioPlaying()) {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    sentFileViewHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                this.setFileCLickListener(sentFileViewHolder.llMessage, fileSentMessage, sentFileViewHolder.ivFilePlay, position);
                sentFileViewHolder.ivFileUpload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = sentFileViewHolder.getAdapterPosition();
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(fileSentMessage.getMuid(), pos);
                        }
                    }
                });
                break;
            }
            case 11: {
                String fileExt1;
                ReceivedFileViewHolder fHolder = (ReceivedFileViewHolder)holder;
                Message fileReceivedMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                fHolder.progressBar.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                String fuserNameText = "";
                int fuserNameStringCount = 1;
                if (!TextUtils.isEmpty((CharSequence)fileReceivedMessage.getfromName())) {
                    if (fileReceivedMessage.getfromName().split(" ").length > 0) {
                        fuserNameStringCount = fileReceivedMessage.getfromName().trim().split(" ").length;
                    }
                    String[] fuserNameSplitArray = fileReceivedMessage.getfromName().trim().split(" ");
                    for (int i = 0; i < fuserNameStringCount; ++i) {
                        fuserNameText = fuserNameText.concat(fuserNameSplitArray[i].substring(0, 1).toUpperCase());
                        fuserNameText = fuserNameText.concat(fuserNameSplitArray[i].substring(1).toLowerCase());
                        fuserNameText = fuserNameText.concat(" ");
                    }
                }
                this.setIntegrationSource(fHolder.messageSourceType, fHolder.messageSourceType1, fileReceivedMessage.getIntegrationSource());
                this.setFileMessageOther((View)fHolder.llRoot, (View)fHolder.llMessage, position, fHolder.tvUserName, fuserNameText);
                NinePatchDrawable drawable6 = (NinePatchDrawable)fHolder.llMessage.getBackground();
                drawable6.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                String receivedFileExt = Util.getExtension(fileReceivedMessage.getFileUrl());
                Integer dimage1 = (Integer)IMAGE_MAP.get(receivedFileExt.toLowerCase());
                if (dimage1 != null) {
                    fHolder.ivFileImage.setImageResource(dimage1.intValue());
                } else {
                    fHolder.ivFileImage.setImageResource(R.drawable.hippo_attachment);
                }
                fHolder.tvFileName.setText((CharSequence)fileReceivedMessage.getFileName());
                String string2 = fileExt1 = TextUtils.isEmpty((CharSequence)fileReceivedMessage.getFileExtension()) ? receivedFileExt : fileReceivedMessage.getFileExtension();
                if (fileExt1.length() > 4) {
                    fileExt1 = fileExt1.substring(0, 4) + "..";
                }
                fHolder.tvFileExtension.setText((CharSequence)fileExt1);
                fHolder.tvFileSize.setText((CharSequence)fileReceivedMessage.getFileSize());
                this.setFileDownLoadStatus(fHolder.ivFileImage, fHolder.ivFilePlay, fHolder.progressBar, fHolder.ivFileDownload, fHolder.ivFileUpload, fileReceivedMessage, position);
                this.setDownloadClick(fHolder.ivFileDownload, fHolder.progressBar, fileReceivedMessage, position);
                if (!fileReceivedMessage.isAudioPlaying()) {
                    fHolder.ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                } else {
                    fHolder.ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                }
                this.setFileCLickListener(fHolder.llMessage, fileReceivedMessage, fHolder.ivFilePlay, position);
                break;
            }
            case 12: {
                final SelfVideoMessageViewHolder selfVideoMessageViewHolder = (SelfVideoMessageViewHolder)holder;
                final Message selfVideoMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                this.setSelfMessageBackground((View)selfVideoMessageViewHolder.llRoot, (View)selfVideoMessageViewHolder.llImageMessage, position);
                NinePatchDrawable drawable5 = (NinePatchDrawable)selfVideoMessageViewHolder.llImageMessage.getBackground();
                drawable5.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
                selfVideoMessageViewHolder.circle_progress.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setTime(selfVideoMessageViewHolder.tvImageTime, selfVideoMessage.getSentAtUtc());
                this.setMessageStatus(selfVideoMessageViewHolder.ivMessageState, selfVideoMessage.getMessageStatus(), true);
                if (!TextUtils.isEmpty((CharSequence)selfVideoMessage.getThumbnailUrl())) {
                    this.setImage(this.activity, selfVideoMessageViewHolder.ivImageMsg, selfVideoMessage.getThumbnailUrl());
                } else {
                    selfVideoMessageViewHolder.ivImageMsg.setVisibility(8);
                }
                this.setImageHeightAndWidth((ImageView)selfVideoMessageViewHolder.ivImageMsg, selfVideoMessageViewHolder.rlImageMessage, selfVideoMessageViewHolder.llImageMessage, selfVideoMessage, true);
                selfVideoMessageViewHolder.ivPlay.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (!Utils.preventMultipleClicks()) {
                            return;
                        }
                        String fname = Util.getFileName(selfVideoMessage.getFileName(), selfVideoMessage.getMuid());
                        String localPath = FileManager.getInstance().getLocalPath(fname, FuguAppConstant.FOLDER_TYPE.get(selfVideoMessage.getDocumentType()));
                        if (TextUtils.isEmpty((CharSequence)localPath)) {
                            localPath = selfVideoMessage.getFileUrl();
                        }
                        Intent intent = new Intent((Context)FuguMessageAdapter.this.activity, VideoPlayerActivity.class);
                        intent.putExtra("url", localPath);
                        intent.putExtra("title", selfVideoMessage.getFileName());
                        FuguMessageAdapter.this.activity.startActivity(intent);
                    }
                });
                this.setIntegrationSource(selfVideoMessageViewHolder.messageSourceType, selfVideoMessageViewHolder.messageSourceType1, selfVideoMessage.getIntegrationSource());
                this.setVideoUiStatus(true, selfVideoMessage, selfVideoMessageViewHolder.llDownload, selfVideoMessageViewHolder.ivPlay, selfVideoMessageViewHolder.btnRetry, selfVideoMessageViewHolder.btnCancel, selfVideoMessageViewHolder.circle_progress);
                selfVideoMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = selfVideoMessageViewHolder.getAdapterPosition();
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            FuguMessageAdapter.this.mOnRetry.onMessageCancel(selfVideoMessage.getMuid(), pos);
                        }
                    }
                });
                selfVideoMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int pos = selfVideoMessageViewHolder.getAdapterPosition();
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(selfVideoMessage.getMuid(), pos);
                        }
                    }
                });
                selfVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        String fullPath;
                        File file;
                        String fileName;
                        selfVideoMessageViewHolder.circle_progress.setVisibility(0);
                        selfVideoMessageViewHolder.llDownload.setVisibility(8);
                        String docType = "video";
                        if (selfVideoMessage.getMessageType() == 11) {
                            docType = selfVideoMessage.getDocumentType();
                        }
                        if (TextUtils.isEmpty((CharSequence)(fileName = selfVideoMessage.getFileName()))) {
                            String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                            fileName = "Hippochat_" + timeStamp + ".jpg";
                        }
                        if (!(file = new File(fullPath = Util.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType)))).exists()) {
                            file.mkdir();
                        }
                        int downloadId = FuguMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, selfVideoMessage, position);
                        selfVideoMessage.setDownloadId(downloadId);
                    }
                });
                break;
            }
            case 13: {
                final OtherVideoMessageViewHolder otherVideoMessageViewHolder = (OtherVideoMessageViewHolder)holder;
                final Message otherVideoMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                otherVideoMessageViewHolder.progressBar.setBarColor(this.hippoColorConfig.getHippoThemeColorPrimary());
                this.setTime(otherVideoMessageViewHolder.tvImageTime, otherVideoMessage.getSentAtUtc());
                if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getThumbnailUrl())) {
                    this.setImage(this.activity, otherVideoMessageViewHolder.ivImageMsg, otherVideoMessage.getThumbnailUrl());
                } else {
                    otherVideoMessageViewHolder.ivImageMsg.setVisibility(8);
                }
                this.setImageHeightAndWidth((ImageView)otherVideoMessageViewHolder.ivImageMsg, otherVideoMessageViewHolder.rlImageMessage, otherVideoMessageViewHolder.llImageMessage, otherVideoMessage, true);
                this.setVideoDownloadStatus(otherVideoMessageViewHolder.llDownload, otherVideoMessageViewHolder.ivPlay, otherVideoMessageViewHolder.tvFileSize, otherVideoMessageViewHolder.progressBar, otherVideoMessage, position);
                String vuserNameText = "";
                int vuserNameStringCount1 = 1;
                if (!TextUtils.isEmpty((CharSequence)otherVideoMessage.getfromName())) {
                    if (otherVideoMessage.getfromName().split(" ").length > 0) {
                        vuserNameStringCount1 = otherVideoMessage.getfromName().trim().split(" ").length;
                    }
                    String[] vuserNameSplitArray = otherVideoMessage.getfromName().trim().split(" ");
                    for (int i = 0; i < vuserNameStringCount1; ++i) {
                        vuserNameText = vuserNameText.concat(vuserNameSplitArray[i].substring(0, 1).toUpperCase());
                        vuserNameText = vuserNameText.concat(vuserNameSplitArray[i].substring(1).toLowerCase());
                        vuserNameText = vuserNameText.concat(" ");
                    }
                }
                this.setFileMessageOther((View)otherVideoMessageViewHolder.llRoot, (View)otherVideoMessageViewHolder.llImageMessage, position, otherVideoMessageViewHolder.tvUserName, vuserNameText);
                this.setIntegrationSource(otherVideoMessageViewHolder.messageSourceType, otherVideoMessageViewHolder.messageSourceType1, otherVideoMessage.getIntegrationSource());
                otherVideoMessageViewHolder.llDownload.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (FuguMessageAdapter.this.fuguChatActivity.isNetworkAvailable()) {
                            String fullPath;
                            File file;
                            String fileName;
                            otherVideoMessageViewHolder.progressBar.setVisibility(0);
                            otherVideoMessageViewHolder.llDownload.setVisibility(8);
                            String docType = "video";
                            if (otherVideoMessage.getMessageType() == 11) {
                                docType = otherVideoMessage.getDocumentType();
                            }
                            if (TextUtils.isEmpty((CharSequence)(fileName = otherVideoMessage.getFileName()))) {
                                String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                                fileName = "Hippochat_" + timeStamp + ".jpg";
                            }
                            if (!(file = new File(fullPath = Util.getDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType)))).exists()) {
                                file.mkdir();
                            }
                            int downloadId = FuguMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, otherVideoMessage, position);
                            otherVideoMessage.setDownloadId(downloadId);
                        } else {
                            Toast.makeText((Context)FuguMessageAdapter.this.activity, (CharSequence)FuguMessageAdapter.this.activity.getString(R.string.fugu_unable_to_connect_internet), (int)0).show();
                        }
                    }
                });
                break;
            }
            case -990: {
                int count = 4;
                GalleryViewHolder viewHolder1 = (GalleryViewHolder)holder;
                this.setView(viewHolder1.llGalleryButtonLayout, count);
                break;
            }
            case 15: {
                SimpleTextView textView = (SimpleTextView)holder;
                Message msg = ((EventItem)this.fuguItems.get(position)).getEvent();
                textView.tvText.setText((CharSequence)msg.getMessage());
                break;
            }
            case 3: {
                final RatingViewHolder viewHolder = (RatingViewHolder)holder;
                final Message currentMessage = ((EventItem)this.fuguItems.get(position)).getEvent();
                if (currentMessage.isRatingGiven()) {
                    viewHolder.askRateLayout.setVisibility(8);
                    viewHolder.ratedLayout.setVisibility(0);
                    String title = currentMessage.getLineAfterFeedback_1() + "  ";
                    SpannableStringBuilder ssb = new SpannableStringBuilder((CharSequence)title);
                    Drawable android = this.activity.getResources().getDrawable(R.drawable.hippo_ic_okay_image_selected);
                    switch (currentMessage.getRatingGiven()) {
                        case 1: {
                            android = this.activity.getResources().getDrawable(R.drawable.hippo_ic_terrible_image_selected);
                            break;
                        }
                        case 2: {
                            android = this.activity.getResources().getDrawable(R.drawable.hippo_ic_bad_image_selected);
                            break;
                        }
                        case 3: {
                            android = this.activity.getResources().getDrawable(R.drawable.hippo_ic_okay_image_selected);
                            break;
                        }
                        case 4: {
                            android = this.activity.getResources().getDrawable(R.drawable.hippo_ic_good_image_selected);
                            break;
                        }
                        case 5: {
                            android = this.activity.getResources().getDrawable(R.drawable.hippo_ic_great_image_selected);
                            break;
                        }
                    }
                    int size = (int)this.convertDpToPixel(34.0f);
                    android.setBounds(0, 0, size, size);
                    ImageSpan image = new ImageSpan(android, 0);
                    ssb.setSpan((Object)image, title.length() - 1, title.length(), 18);
                    viewHolder.ratedTitle.setText((CharSequence)ssb, TextView.BufferType.SPANNABLE);
                    viewHolder.ratedSubTitle.setText((CharSequence)currentMessage.getLineAfterFeedback_2());
                    if (!TextUtils.isEmpty((CharSequence)currentMessage.getComment())) {
                        viewHolder.ratedMessage.setText((CharSequence)("" + currentMessage.getComment()));
                        viewHolder.messageLayout.setVisibility(0);
                    } else {
                        viewHolder.messageLayout.setVisibility(8);
                    }
                } else {
                    viewHolder.askRateLayout.setVisibility(0);
                    viewHolder.ratedLayout.setVisibility(8);
                    viewHolder.titleTxt.setText((CharSequence)currentMessage.getLineBeforeFeedback());
                    viewHolder.myCustomEditTextListener.updatePosition(currentMessage);
                    viewHolder.editText.setText((CharSequence)currentMessage.getComment());
                    if (currentMessage.getRatingGiven() > 0) {
                        this.setImageClick(currentMessage.getRatingGiven(), viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage);
                    } else {
                        this.setImageClick(3, viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage);
                        currentMessage.setRatingGiven(3);
                    }
                }
                viewHolder.sendBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.onRatingListener.onSubmitRating(viewHolder.editText.getText().toString(), currentMessage, position);
                        viewHolder.editText.setText((CharSequence)"");
                    }
                });
                viewHolder.terribleImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.setImageClick(1, new ImageView[]{viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage});
                        FuguMessageAdapter.this.onRatingListener.onRatingSelected(1, currentMessage);
                    }
                });
                viewHolder.badImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.setImageClick(2, new ImageView[]{viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage});
                        FuguMessageAdapter.this.onRatingListener.onRatingSelected(2, currentMessage);
                    }
                });
                viewHolder.okayImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.setImageClick(3, new ImageView[]{viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage});
                        FuguMessageAdapter.this.onRatingListener.onRatingSelected(3, currentMessage);
                    }
                });
                viewHolder.goodImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.setImageClick(4, new ImageView[]{viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage});
                        FuguMessageAdapter.this.onRatingListener.onRatingSelected(4, currentMessage);
                    }
                });
                viewHolder.greatImage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.setImageClick(5, new ImageView[]{viewHolder.terribleImage, viewHolder.badImage, viewHolder.okayImage, viewHolder.goodImage, viewHolder.greatImage});
                        FuguMessageAdapter.this.onRatingListener.onRatingSelected(5, currentMessage);
                    }
                });
                break;
            }
            case 16: {
                QuickReplyViewHolder qrViewHolder = (QuickReplyViewHolder)holder;
                Message currentFormMsg = ((EventItem)this.fuguItems.get(position)).getEvent();
                LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.activity);
                layoutManager.setOrientation(0);
                qrViewHolder.list_qr.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
                HippoQuickReplayAdapter replayAdapter = new HippoQuickReplayAdapter(currentFormMsg, this, qrViewHolder);
                qrViewHolder.list_qr.setAdapter((RecyclerView.Adapter)replayAdapter);
                break;
            }
            case 17: {
                Message currentFormDataMsg = ((EventItem)this.fuguItems.get(position)).getEvent();
                ForumViewHolder forumViewHolder = (ForumViewHolder)holder;
                LinearLayoutManager mlayoutManager = new LinearLayoutManager((Context)this.activity);
                forumViewHolder.rvDataForm.setLayoutManager((RecyclerView.LayoutManager)mlayoutManager);
                DataFormAdapter dataFormAdapter = new DataFormAdapter(currentFormDataMsg, this, this.fragmentManager);
                forumViewHolder.rvDataForm.setNestedScrollingEnabled(true);
                forumViewHolder.rvDataForm.setAdapter((RecyclerView.Adapter)dataFormAdapter);
                break;
            }
            case 0: {
                DateViewHolder dateViewHolder = (DateViewHolder)holder;
                HeaderItem headerItem = (HeaderItem)this.fuguItems.get(position);
                if (headerItem.getDate().isEmpty()) {
                    dateViewHolder.tvDate.setVisibility(8);
                } else {
                    DateUtils.getInstance();
                    String date = DateUtils.getDate(headerItem.getDate());
                    dateViewHolder.tvDate.setText((CharSequence)date);
                    dateViewHolder.tvDate.setVisibility(0);
                }
                GradientDrawable drawable2 = (GradientDrawable)dateViewHolder.tvDate.getBackground();
                drawable2.setStroke((int)this.activity.getResources().getDimension(R.dimen.fugu_border_width), this.hippoColorConfig.getHippoBorderColor());
                dateViewHolder.tvDate.setTextColor(this.hippoColorConfig.getHippoChatDateText());
                break;
            }
            case 1: {
                final OtherMessageViewHolder otherMessageViewHolder = (OtherMessageViewHolder)holder;
                final Message currentOrderItem = ((EventItem)this.fuguItems.get(position)).getEvent();
                otherMessageViewHolder.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherMessageViewHolder.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherMessageViewHolder.tvMsg.setAutoLinkMask(15);
                otherMessageViewHolder.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
                this.setIntegrationSource(otherMessageViewHolder.messageSourceType, otherMessageViewHolder.messageSourceType1, currentOrderItem.getIntegrationSource());
                if (currentOrderItem.getMessage().isEmpty()) {
                    otherMessageViewHolder.tvMsg.setVisibility(4);
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, -1);
                    params2.weight = 1.0f;
                    params2.gravity = 0x800005;
                    otherMessageViewHolder.rlMessages.setLayoutParams((ViewGroup.LayoutParams)params2);
                    otherMessageViewHolder.tvMsg.setTextSize((float)this.pxToDp(3));
                } else {
                    otherMessageViewHolder.tvMsg.setText((CharSequence)currentOrderItem.getMessage());
                    otherMessageViewHolder.tvMsg.setTextSize(17.0f);
                    otherMessageViewHolder.tvMsg.setVisibility(0);
                }
                otherMessageViewHolder.tvMsg.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        ClipboardManager cm = (ClipboardManager)FuguMessageAdapter.this.activity.getSystemService("clipboard");
                        cm.setText(otherMessageViewHolder.tvMsg.getText());
                        Toast.makeText((Context)FuguMessageAdapter.this.activity, (CharSequence)"Copied to clipboard", (int)0).show();
                        return true;
                    }
                });
                String userNameText = "";
                int userNameStringCount = 1;
                if (!TextUtils.isEmpty((CharSequence)currentOrderItem.getfromName())) {
                    if (currentOrderItem.getfromName().split(" ").length > 0) {
                        userNameStringCount = currentOrderItem.getfromName().trim().split(" ").length;
                    }
                    String[] userNameSplitArray = currentOrderItem.getfromName().trim().split(" ");
                    for (int i = 0; i < userNameStringCount; ++i) {
                        userNameText = userNameText.concat(userNameSplitArray[i].substring(0, 1).toUpperCase());
                        userNameText = userNameText.concat(userNameSplitArray[i].substring(1).toLowerCase());
                        userNameText = userNameText.concat(" ");
                    }
                } else {
                    userNameText = !TextUtils.isEmpty((CharSequence)this.fuguConversation.getBusinessName()) ? this.fuguConversation.getBusinessName() : this.activity.getString(R.string.fugu_support);
                }
                this.setTextMessageOther(position, currentOrderItem, otherMessageViewHolder.llMessageBg, otherMessageViewHolder.tvUserName, otherMessageViewHolder.llRoot, otherMessageViewHolder.tvMsg, otherMessageViewHolder.ivMsgImage, userNameText);
                if (currentOrderItem.getSentAtUtc().isEmpty()) {
                    otherMessageViewHolder.tvTime.setVisibility(8);
                } else {
                    otherMessageViewHolder.tvTime.setText((CharSequence)DateUtils.getTime(this.fuguDateUtil.convertToLocal(currentOrderItem.getSentAtUtc())));
                    otherMessageViewHolder.tvTime.setVisibility(0);
                }
                if (otherMessageViewHolder.tvUserName.length() > otherMessageViewHolder.tvMsg.length() + otherMessageViewHolder.tvTime.length() && otherMessageViewHolder.tvUserName.getVisibility() == 0) {
                    switch (otherMessageViewHolder.tvMsg.length()) {
                        case 1: {
                            int i;
                            int length = otherMessageViewHolder.tvUserName.length() - otherMessageViewHolder.tvMsg.length() - otherMessageViewHolder.tvTime.length() + 2;
                            for (i = 0; i < length; ++i) {
                                otherMessageViewHolder.tvMsg.append((CharSequence)this.activity.getString(R.string.hippo_space));
                            }
                            break;
                        }
                        case 2: {
                            int i;
                            int length = otherMessageViewHolder.tvUserName.length() - otherMessageViewHolder.tvMsg.length() - otherMessageViewHolder.tvTime.length();
                            for (i = 0; i < length; ++i) {
                                otherMessageViewHolder.tvMsg.append((CharSequence)this.activity.getString(R.string.hippo_space));
                            }
                            break;
                        }
                        case 3: {
                            int i;
                            int length = otherMessageViewHolder.tvUserName.length() - otherMessageViewHolder.tvMsg.length() - otherMessageViewHolder.tvTime.length() - 1;
                            for (i = 0; i < length; ++i) {
                                otherMessageViewHolder.tvMsg.append((CharSequence)this.activity.getString(R.string.hippo_space));
                            }
                            break;
                        }
                        default: {
                            int i;
                            int length = otherMessageViewHolder.tvUserName.length() - otherMessageViewHolder.tvMsg.length() - otherMessageViewHolder.tvTime.length() - 1;
                            for (i = 0; i < length; ++i) {
                                otherMessageViewHolder.tvMsg.append((CharSequence)this.activity.getString(R.string.hippo_space));
                            }
                        }
                    }
                }
                NinePatchDrawable drawable2 = (NinePatchDrawable)otherMessageViewHolder.llMessageBg.getBackground();
                drawable2.setColorFilter(this.hippoColorConfig.getHippoBgMessageFrom(), PorterDuff.Mode.MULTIPLY);
                if (!currentOrderItem.getThumbnailUrl().isEmpty()) {
                    new RequestOptions();
                    RequestOptions myOptions = RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder)).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).error(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder));
                    Glide.with((Activity)this.activity).load(currentOrderItem.getThumbnailUrl()).apply(myOptions).into(otherMessageViewHolder.ivMsgImage);
                    otherMessageViewHolder.rlImageMessage.setVisibility(0);
                } else {
                    otherMessageViewHolder.rlImageMessage.setVisibility(8);
                }
                otherMessageViewHolder.rlImageMessage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        FuguMessageAdapter.this.showImageDialog((Context)FuguMessageAdapter.this.activity, currentOrderItem.getUrl(), otherMessageViewHolder.ivMsgImage, currentOrderItem);
                    }
                });
                if (currentOrderItem.getMessageType() == 11) {
                    otherMessageViewHolder.llFileRoot.setVisibility(0);
                    otherMessageViewHolder.tvFileName.setText((CharSequence)currentOrderItem.getFileName());
                    otherMessageViewHolder.ivDownload.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            otherMessageViewHolder.ivDownload.setVisibility(8);
                            otherMessageViewHolder.rlStopDownload.setVisibility(0);
                        }
                    });
                    otherMessageViewHolder.rlStopDownload.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            otherMessageViewHolder.ivDownload.setVisibility(0);
                            otherMessageViewHolder.rlStopDownload.setVisibility(8);
                            DownloadManager manager = (DownloadManager)FuguMessageAdapter.this.activity.getSystemService("download");
                            if (manager != null) {
                                manager.remove(new long[]{currentOrderItem.getDownloadId()});
                            }
                        }
                    });
                    otherMessageViewHolder.llFileDetails.setVisibility(0);
                    otherMessageViewHolder.tvFileSize.setText((CharSequence)currentOrderItem.getFileSize());
                    otherMessageViewHolder.tvExtension.setText((CharSequence)currentOrderItem.getFileExtension());
                } else {
                    otherMessageViewHolder.llFileRoot.setVisibility(8);
                }
                if (currentOrderItem.getMessageType() == 12 || currentOrderItem.getMessageType() == 19) {
                    CustomAction customAction;
                    otherMessageViewHolder.rlCustomAction.setVisibility(0);
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)otherMessageViewHolder.rlCustomAction.getLayoutParams();
                    if (otherMessageViewHolder.llMessageBg.getBackground().getConstantState() == ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_chat_bg_left).getConstantState()) {
                        layoutParams.setMargins(this.pxToDp(13), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
                        if (Build.VERSION.SDK_INT >= 17) {
                            layoutParams.setMarginStart(this.pxToDp(13));
                            layoutParams.setMarginEnd(this.pxToDp(10));
                        }
                    } else {
                        layoutParams.setMargins(this.pxToDp(10), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
                    }
                    if ((customAction = currentOrderItem.getCustomAction()) == null) break;
                    if (customAction.getTitle() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitle())) {
                        otherMessageViewHolder.tvActionTitle.setVisibility(0);
                        otherMessageViewHolder.tvActionTitle.setText((CharSequence)customAction.getTitle());
                    } else {
                        otherMessageViewHolder.tvActionTitle.setVisibility(8);
                    }
                    if (customAction.getTitleDescription() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitleDescription())) {
                        otherMessageViewHolder.tvActionTitleDescription.setVisibility(0);
                        otherMessageViewHolder.tvActionTitleDescription.setText((CharSequence)customAction.getTitleDescription());
                    } else {
                        otherMessageViewHolder.tvActionTitleDescription.setVisibility(8);
                    }
                    if (customAction.getImageUrl() != null && !TextUtils.isEmpty((CharSequence)customAction.getImageUrl())) {
                        otherMessageViewHolder.llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_bottom);
                        otherMessageViewHolder.ivActionImage.setVisibility(0);
                        RequestOptions myOptions = RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder)).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).error(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder));
                        Glide.with((Activity)this.activity).load(customAction.getImageUrl()).apply(myOptions).into(otherMessageViewHolder.ivActionImage);
                    } else {
                        otherMessageViewHolder.ivActionImage.setVisibility(8);
                        otherMessageViewHolder.llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_all_sides);
                    }
                    if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                        otherMessageViewHolder.rvActionDescription.setVisibility(0);
                        otherMessageViewHolder.rvActionDescription.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.activity));
                        otherMessageViewHolder.rvActionDescription.setNestedScrollingEnabled(false);
                        otherMessageViewHolder.rvActionDescription.setAdapter((RecyclerView.Adapter)new CustomActionDescriptionAdapter((Context)this.activity, customAction.getDescriptionObjects()));
                    } else {
                        otherMessageViewHolder.rvActionDescription.setVisibility(8);
                    }
                    if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                        otherMessageViewHolder.vwActionButtonDivider.setVisibility(0);
                        otherMessageViewHolder.rvActionButtons.setVisibility(0);
                        otherMessageViewHolder.rvActionButtons.setNestedScrollingEnabled(false);
                        int span = 2;
                        int size = customAction.getActionButtons().size();
                        span = size == 1 ? 1 : (size % 3 == 0 ? 3 : 2);
                        otherMessageViewHolder.rvActionButtons.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.activity, span));
                        otherMessageViewHolder.rvActionButtons.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration((Context)this.activity));
                        boolean disAbleClick = false;
                        otherMessageViewHolder.rvActionButtons.setAdapter((RecyclerView.Adapter)new CustomActionButtonsAdapter((Context)this.activity, customAction.getActionButtons(), disAbleClick));
                        break;
                    }
                    otherMessageViewHolder.vwActionButtonDivider.setVisibility(8);
                    otherMessageViewHolder.rvActionButtons.setVisibility(8);
                    break;
                }
                otherMessageViewHolder.rlCustomAction.setVisibility(8);
                break;
            }
            case 2: {
                final SelfMessageViewHolder selfMessageViewHolder = (SelfMessageViewHolder)holder;
                final Message currentOrderItem2 = ((EventItem)this.fuguItems.get(position)).getEvent();
                this.setTextMessageSelf(isRightToLeft, position, selfMessageViewHolder.fuguLlRoot, selfMessageViewHolder.fuguRlImageMessage, selfMessageViewHolder.fuguRlMessages, selfMessageViewHolder.FuguLlMessageBg, selfMessageViewHolder.fuguTvMsg, selfMessageViewHolder.fuguTvTime);
                this.setIntegrationSource(selfMessageViewHolder.messageSourceType, selfMessageViewHolder.messageSourceType1, currentOrderItem2.getIntegrationSource());
                if (currentOrderItem2.getMessage().isEmpty()) {
                    selfMessageViewHolder.fuguTvMsg.setVisibility(4);
                    LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(-2, 50);
                    params2.weight = 1.0f;
                    params2.gravity = 0x800005;
                    selfMessageViewHolder.fuguRlMessages.setLayoutParams((ViewGroup.LayoutParams)params2);
                    selfMessageViewHolder.fuguTvMsg.setTextSize((float)this.pxToDp(3));
                } else {
                    selfMessageViewHolder.fuguTvMsg.setText((CharSequence)currentOrderItem2.getMessage());
                    LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
                    selfMessageViewHolder.fuguRlMessages.setLayoutParams((ViewGroup.LayoutParams)params);
                    selfMessageViewHolder.fuguTvMsg.setTextSize(17.0f);
                    selfMessageViewHolder.fuguTvMsg.setVisibility(0);
                }
                selfMessageViewHolder.fuguTvMsg.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        ClipboardManager cm = (ClipboardManager)FuguMessageAdapter.this.activity.getSystemService("clipboard");
                        cm.setText(selfMessageViewHolder.fuguTvMsg.getText());
                        Toast.makeText((Context)FuguMessageAdapter.this.activity, (CharSequence)"Copied to clipboard", (int)0).show();
                        return true;
                    }
                });
                if (currentOrderItem2.getSentAtUtc().isEmpty()) {
                    selfMessageViewHolder.fuguTvTime.setVisibility(8);
                } else {
                    selfMessageViewHolder.fuguTvTime.setText((CharSequence)DateUtils.getTime(this.fuguDateUtil.convertToLocal(currentOrderItem2.getSentAtUtc())));
                    selfMessageViewHolder.fuguTvTime.setVisibility(0);
                }
                if (!TextUtils.isEmpty((CharSequence)currentOrderItem2.getThumbnailUrl()) || !TextUtils.isEmpty((CharSequence)currentOrderItem2.getLocalImagePath())) {
                    this.showImageView(selfMessageViewHolder.fuguIvMsgImage, currentOrderItem2);
                    if (currentOrderItem2.getMessageStatus() == 4 || currentOrderItem2.getMessageStatus() == 5 || currentOrderItem2.getMessageStatus() == 6) {
                        if (currentOrderItem2.getMessageStatus() == 5 || currentOrderItem2.getMessageStatus() == 6) {
                            selfMessageViewHolder.fuguPbLoading.setVisibility(8);
                            selfMessageViewHolder.btnRetry.setVisibility(0);
                            selfMessageViewHolder.btnCancel.setVisibility(0);
                        } else {
                            selfMessageViewHolder.fuguPbLoading.setVisibility(0);
                            selfMessageViewHolder.btnRetry.setVisibility(8);
                            selfMessageViewHolder.btnCancel.setVisibility(8);
                        }
                    } else {
                        selfMessageViewHolder.fuguPbLoading.setVisibility(8);
                        selfMessageViewHolder.btnRetry.setVisibility(8);
                        selfMessageViewHolder.btnCancel.setVisibility(8);
                    }
                    selfMessageViewHolder.fuguRlImageMessage.setVisibility(0);
                } else {
                    selfMessageViewHolder.fuguRlImageMessage.setVisibility(8);
                }
                selfMessageViewHolder.fuguRlImageMessage.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (currentOrderItem2.getMessageStatus() == 4 || currentOrderItem2.getMessageStatus() == 5 || currentOrderItem2.getMessageStatus() == 6) {
                            return;
                        }
                        FuguMessageAdapter.this.showImageDialog((Context)FuguMessageAdapter.this.activity, currentOrderItem2.getUrl(), selfMessageViewHolder.fuguIvMsgImage, currentOrderItem2);
                    }
                });
                if (currentOrderItem2.getIsMessageExpired() == 1 && currentOrderItem2.getMessageType() != 10) {
                    selfMessageViewHolder.llRetry.setVisibility(0);
                    selfMessageViewHolder.tvTryAgain.setTag((Object)position);
                    selfMessageViewHolder.tvCancel.setTag((Object)position);
                    selfMessageViewHolder.fuguPbLoading.setVisibility(8);
                    selfMessageViewHolder.tvTryAgain.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (FuguMessageAdapter.this.mOnRetry != null) {
                                String muid = currentOrderItem2.getMuid();
                                int pos = selfMessageViewHolder.getAdapterPosition();
                                if (TextUtils.isEmpty((CharSequence)currentOrderItem2.getThumbnailUrl())) {
                                    FuguMessageAdapter.this.mOnRetry.onMessageRetry(muid, pos);
                                } else {
                                    FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(muid, pos);
                                }
                            }
                        }
                    });
                    selfMessageViewHolder.tvCancel.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            if (FuguMessageAdapter.this.mOnRetry != null) {
                                String muid = currentOrderItem2.getMuid();
                                FuguMessageAdapter.this.mOnRetry.onMessageCancel(muid, pos);
                            }
                        }
                    });
                } else {
                    selfMessageViewHolder.llRetry.setVisibility(8);
                }
                switch (currentOrderItem2.getMessageStatus()) {
                    case 4: 
                    case 5: 
                    case 6: {
                        selfMessageViewHolder.fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                        selfMessageViewHolder.fuguIvMessageState.setVisibility(0);
                        selfMessageViewHolder.fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                        break;
                    }
                    case 3: {
                        selfMessageViewHolder.fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                        selfMessageViewHolder.fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                        selfMessageViewHolder.fuguIvMessageState.setVisibility(0);
                        selfMessageViewHolder.llRetry.setVisibility(8);
                        break;
                    }
                    case 1: {
                        selfMessageViewHolder.fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                        selfMessageViewHolder.fuguIvMessageState.setVisibility(0);
                        selfMessageViewHolder.fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                        selfMessageViewHolder.llRetry.setVisibility(8);
                        break;
                    }
                    case 2: {
                        selfMessageViewHolder.fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                        if (Build.VERSION.SDK_INT >= 21) {
                            selfMessageViewHolder.fuguIvMessageState.getDrawable().setTint(ContextCompat.getColor((Context)this.activity, (int)R.color.fugu_drawable_color));
                        }
                        selfMessageViewHolder.fuguIvMessageState.setVisibility(0);
                        selfMessageViewHolder.fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                        selfMessageViewHolder.llRetry.setVisibility(8);
                        break;
                    }
                    default: {
                        selfMessageViewHolder.fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                        selfMessageViewHolder.fuguIvMessageState.setVisibility(0);
                        selfMessageViewHolder.fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                        selfMessageViewHolder.llRetry.setVisibility(8);
                    }
                }
                selfMessageViewHolder.fuguBtnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            selfMessageViewHolder.fuguPbLoading.setVisibility(0);
                            selfMessageViewHolder.fuguBtnRetry.setVisibility(8);
                            FuguMessageAdapter.this.mOnRetry.onRetry(currentOrderItem2.getUrl(), currentOrderItem2.getMessageIndex(), 10, null, currentOrderItem2.getMuid());
                        }
                    }
                });
                selfMessageViewHolder.btnRetry.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            selfMessageViewHolder.fuguPbLoading.setVisibility(0);
                            selfMessageViewHolder.btnRetry.setVisibility(8);
                            String muid = currentOrderItem2.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            FuguMessageAdapter.this.mOnRetry.onFileMessageRetry(muid, pos);
                        }
                    }
                });
                selfMessageViewHolder.btnCancel.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (FuguMessageAdapter.this.mOnRetry != null) {
                            String muid = currentOrderItem2.getMuid();
                            int pos = selfMessageViewHolder.getAdapterPosition();
                            FuguMessageAdapter.this.mOnRetry.onMessageCancel(muid, pos);
                        }
                    }
                });
                if (currentOrderItem2.getMessageType() == 11) {
                    selfMessageViewHolder.fuguLlFileRoot.setVisibility(0);
                    selfMessageViewHolder.fuguTvFileName.setText((CharSequence)currentOrderItem2.getFileName());
                    selfMessageViewHolder.fuguIvUpload.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (FuguMessageAdapter.this.mOnRetry != null) {
                                FuguFileDetails fileDetails = new FuguFileDetails();
                                fileDetails.setFilePath(currentOrderItem2.getFilePath());
                                fileDetails.setFileExtension(currentOrderItem2.getFileExtension());
                                fileDetails.setFileSize(currentOrderItem2.getFileSize());
                                fileDetails.setFileName(currentOrderItem2.getFileName());
                                selfMessageViewHolder.fuguRlStopUpload.setVisibility(0);
                                selfMessageViewHolder.fuguIvUpload.setVisibility(8);
                                FuguMessageAdapter.this.mOnRetry.onRetry(currentOrderItem2.getUrl(), currentOrderItem2.getMessageIndex(), 11, fileDetails, currentOrderItem2.getMuid());
                            }
                        }
                    });
                    selfMessageViewHolder.fuguLlFileDetails.setVisibility(0);
                    selfMessageViewHolder.fuguTvFileSize.setText((CharSequence)currentOrderItem2.getFileSize());
                    selfMessageViewHolder.fuguTvExtension.setText((CharSequence)currentOrderItem2.getFileExtension());
                } else {
                    selfMessageViewHolder.fuguLlFileRoot.setVisibility(8);
                }
                if (currentOrderItem2.getMessageStatus() == 6) {
                    selfMessageViewHolder.fuguRlStopUpload.setVisibility(8);
                    selfMessageViewHolder.fuguIvUpload.setVisibility(0);
                } else if (currentOrderItem2.getMessageStatus() == 4) {
                    selfMessageViewHolder.fuguRlStopUpload.setVisibility(0);
                    selfMessageViewHolder.fuguIvUpload.setVisibility(8);
                } else {
                    selfMessageViewHolder.fuguRlStopUpload.setVisibility(8);
                    selfMessageViewHolder.fuguIvUpload.setVisibility(8);
                }
                selfMessageViewHolder.fuguLlFileRoot.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (!HippoConfig.getInstance().askUserToGrantPermission(FuguMessageAdapter.this.activity, "android.permission.WRITE_EXTERNAL_STORAGE", "Please grant permission to Storage", 6)) {
                            return;
                        }
                        try {
                            Intent photoPickerIntent = new Intent("android.intent.action.VIEW");
                            File file = new File(currentOrderItem2.getFilePath());
                            photoPickerIntent.setData(Uri.fromFile((File)file));
                            FuguMessageAdapter.this.activity.startActivity(photoPickerIntent);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Toast.makeText((Context)FuguMessageAdapter.this.activity.getApplicationContext(), (CharSequence)FuguMessageAdapter.this.activity.getString(R.string.fugu_file_not_found), (int)0).show();
                        }
                    }
                });
                if (currentOrderItem2.getMessageType() == 12 || currentOrderItem2.getMessageType() == 19) {
                    CustomAction customAction;
                    selfMessageViewHolder.rlCustomAction.setVisibility(0);
                    LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)selfMessageViewHolder.rlCustomAction.getLayoutParams();
                    if (selfMessageViewHolder.FuguLlMessageBg.getBackground().getConstantState() == ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_chat_bg_left).getConstantState()) {
                        layoutParams.setMargins(this.pxToDp(13), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
                        if (Build.VERSION.SDK_INT >= 17) {
                            layoutParams.setMarginStart(this.pxToDp(13));
                            layoutParams.setMarginEnd(this.pxToDp(10));
                        }
                    } else {
                        layoutParams.setMargins(this.pxToDp(10), this.pxToDp(10), this.pxToDp(10), this.pxToDp(10));
                    }
                    if ((customAction = currentOrderItem2.getCustomAction()) == null) break;
                    if (customAction.getTitle() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitle())) {
                        selfMessageViewHolder.tvActionTitle.setVisibility(0);
                        selfMessageViewHolder.tvActionTitle.setText((CharSequence)customAction.getTitle());
                    } else {
                        selfMessageViewHolder.tvActionTitle.setVisibility(8);
                    }
                    if (customAction.getTitleDescription() != null && !TextUtils.isEmpty((CharSequence)customAction.getTitleDescription())) {
                        selfMessageViewHolder.tvActionTitleDescription.setVisibility(0);
                        selfMessageViewHolder.tvActionTitleDescription.setText((CharSequence)customAction.getTitleDescription());
                    } else {
                        selfMessageViewHolder.tvActionTitleDescription.setVisibility(8);
                    }
                    if (customAction.getImageUrl() != null && !TextUtils.isEmpty((CharSequence)customAction.getImageUrl())) {
                        selfMessageViewHolder.llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_bottom);
                        selfMessageViewHolder.ivActionImage.setVisibility(0);
                        RequestOptions myOptions = RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder)).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).error(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder));
                        Glide.with((Activity)this.activity).load(customAction.getImageUrl()).apply(myOptions).into(selfMessageViewHolder.ivActionImage);
                    } else {
                        selfMessageViewHolder.ivActionImage.setVisibility(8);
                        selfMessageViewHolder.llTextualContent.setBackgroundResource(R.drawable.fugu_white_background_curved_all_sides);
                    }
                    if (customAction.getDescriptionObjects() != null && customAction.getDescriptionObjects().size() != 0) {
                        selfMessageViewHolder.rvActionDescription.setVisibility(0);
                        selfMessageViewHolder.rvActionDescription.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.activity));
                        selfMessageViewHolder.rvActionDescription.setNestedScrollingEnabled(false);
                        selfMessageViewHolder.rvActionDescription.setAdapter((RecyclerView.Adapter)new CustomActionDescriptionAdapter((Context)this.activity, customAction.getDescriptionObjects()));
                    } else {
                        selfMessageViewHolder.rvActionDescription.setVisibility(8);
                    }
                    if (customAction.getActionButtons() != null && customAction.getActionButtons().size() != 0) {
                        selfMessageViewHolder.vwActionButtonDivider.setVisibility(0);
                        selfMessageViewHolder.rvActionButtons.setVisibility(0);
                        selfMessageViewHolder.rvActionButtons.setNestedScrollingEnabled(false);
                        int span = 2;
                        int size = customAction.getActionButtons().size();
                        span = size == 1 ? 1 : (size % 3 == 0 ? 3 : 2);
                        boolean disAbleClick = false;
                        if (currentOrderItem2.getUserId().compareTo(CommonData.getUpdatedDetails().getData().getUserId()) == 0) {
                            disAbleClick = true;
                        }
                        selfMessageViewHolder.rvActionButtons.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this.activity, span));
                        selfMessageViewHolder.rvActionButtons.addItemDecoration((RecyclerView.ItemDecoration)new GridDividerItemDecoration((Context)this.activity));
                        selfMessageViewHolder.rvActionButtons.setAdapter((RecyclerView.Adapter)new CustomActionButtonsAdapter((Context)this.activity, customAction.getActionButtons(), true));
                        break;
                    }
                    selfMessageViewHolder.vwActionButtonDivider.setVisibility(8);
                    selfMessageViewHolder.rvActionButtons.setVisibility(8);
                    break;
                }
                selfMessageViewHolder.rlCustomAction.setVisibility(8);
                break;
            }
            case -1: {
                OtherMessageViewHolder otherUnknownView = (OtherMessageViewHolder)holder;
                Message unknownItemOther = ((EventItem)this.fuguItems.get(position)).getEvent();
                otherUnknownView.tvUserName.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFromName());
                otherUnknownView.tvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherUnknownView.tvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgFrom());
                otherUnknownView.tvMsg.setAutoLinkMask(15);
                otherUnknownView.tvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgFrom());
                otherUnknownView.tvMsg.setText((CharSequence)CommonData.getUserDetails().getData().getUnsupportedMessage());
                otherUnknownView.tvMsg.setTextSize(17.0f);
                otherUnknownView.tvMsg.setVisibility(0);
                String userNameText1 = "";
                int userNameStringCount1 = 1;
                if (!TextUtils.isEmpty((CharSequence)unknownItemOther.getfromName())) {
                    if (unknownItemOther.getfromName().split(" ").length > 0) {
                        int n = unknownItemOther.getfromName().trim().split(" ").length;
                    }
                    String[] userNameSplitArray1 = unknownItemOther.getfromName().trim().split(" ");
                    for (int i = 0; i < userNameStringCount1; ++i) {
                        userNameText1 = userNameText1.concat(userNameSplitArray1[i].substring(0, 1).toUpperCase());
                        userNameText1 = userNameText1.concat(userNameSplitArray1[i].substring(1).toLowerCase());
                        userNameText1 = userNameText1.concat(" ");
                    }
                } else {
                    userNameText1 = !TextUtils.isEmpty((CharSequence)this.fuguConversation.getBusinessName()) ? this.fuguConversation.getBusinessName() : this.activity.getString(R.string.fugu_support);
                }
                this.setTextMessageOther(position, unknownItemOther, otherUnknownView.llMessageBg, otherUnknownView.tvUserName, otherUnknownView.llRoot, otherUnknownView.tvMsg, otherUnknownView.ivMsgImage, userNameText1);
                break;
            }
            case -2: {
                SelfMessageViewHolder selfUnknownView = (SelfMessageViewHolder)holder;
                Message unknownItemSelf = ((EventItem)this.fuguItems.get(position)).getEvent();
                this.setTextMessageSelf(isRightToLeft, position, selfUnknownView.fuguLlRoot, selfUnknownView.fuguRlImageMessage, selfUnknownView.fuguRlMessages, selfUnknownView.FuguLlMessageBg, selfUnknownView.fuguTvMsg, selfUnknownView.fuguTvTime);
                selfUnknownView.fuguTvMsg.setText((CharSequence)CommonData.getUserDetails().getData().getUnsupportedMessage());
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -1);
                selfUnknownView.fuguRlMessages.setLayoutParams((ViewGroup.LayoutParams)params);
                selfUnknownView.fuguTvMsg.setTextSize(17.0f);
                selfUnknownView.fuguTvMsg.setVisibility(0);
                if (unknownItemSelf.getSentAtUtc().isEmpty()) {
                    selfUnknownView.fuguTvTime.setVisibility(8);
                    break;
                }
                selfUnknownView.fuguTvTime.setText((CharSequence)DateUtils.getTime(this.fuguDateUtil.convertToLocal(unknownItemSelf.getSentAtUtc())));
                selfUnknownView.fuguTvTime.setVisibility(0);
                break;
            }
            case 20: {
                UserConcentViewHolder concentViewHolder = (UserConcentViewHolder)holder;
                Message userConcentMsg = ((EventItem)this.fuguItems.get(position)).getEvent();
                concentViewHolder.tvMsg.setText((CharSequence)userConcentMsg.getMessage());
                LinearLayoutManager layoutManager1 = new LinearLayoutManager((Context)this.activity);
                layoutManager1.setOrientation(1);
                String selectedBtnId = "";
                if (!TextUtils.isEmpty((CharSequence)userConcentMsg.getSelectedBtnId())) {
                    selectedBtnId = userConcentMsg.getSelectedBtnId();
                }
                ButtonsAdapter adapter = new ButtonsAdapter((Context)this.activity, userConcentMsg, (ArrayList)userConcentMsg.getContentValue(), this, concentViewHolder.rvActionButtons, userConcentMsg.getIsActive());
                concentViewHolder.rvActionButtons.setLayoutManager((RecyclerView.LayoutManager)layoutManager1);
                concentViewHolder.rvActionButtons.setAdapter((RecyclerView.Adapter)adapter);
            }
        }
    }

    private void setTextMessageOther(int position, Message currentOrderItem, LinearLayout llMessageBg, TextView tvUserName, LinearLayout llRoot, TextView tvMsg, ImageView ivMsgImage, String userNameText) {
        int dp_1 = this.pxToDp(1);
        int dp_2 = this.pxToDp(2);
        int dp_4 = this.pxToDp(4);
        int dp_5 = this.pxToDp(5);
        int dp_7 = this.pxToDp(7);
        int dp_8 = this.pxToDp(8);
        int dp_10 = this.pxToDp(10);
        int dp_15 = this.pxToDp(15);
        int dp_17 = this.pxToDp(17);
        if (position != 0 && this.getItemViewType(position - 1) == 1) {
            Message lastOrderItem = ((EventItem)this.fuguItems.get(position - 1)).getEvent();
            if (currentOrderItem.getUserId().compareTo(lastOrderItem.getUserId()) != 0) {
                llMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
                tvUserName.setVisibility(0);
                tvUserName.setText((CharSequence)userNameText);
                if (Build.VERSION.SDK_INT >= 17) {
                    llRoot.setPaddingRelative(dp_10, dp_8, 0, dp_1);
                    tvUserName.setPaddingRelative(dp_15, dp_7, dp_10, 0);
                    tvMsg.setPaddingRelative(dp_15, dp_7, dp_2, dp_7);
                    ivMsgImage.setPaddingRelative(0, dp_5, 0, 0);
                } else {
                    llRoot.setPadding(dp_10, dp_8, 0, dp_1);
                    tvUserName.setPadding(dp_15, dp_7, dp_10, 0);
                    tvMsg.setPadding(dp_15, dp_7, dp_2, dp_7);
                    ivMsgImage.setPadding(0, dp_5, 0, 0);
                }
            } else if (position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) != 1) {
                tvUserName.setVisibility(8);
                llMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                if (Build.VERSION.SDK_INT >= 17) {
                    llRoot.setPaddingRelative(dp_17, dp_1, 0, dp_4);
                    tvUserName.setPaddingRelative(dp_8, dp_7, dp_10, 0);
                    tvMsg.setPaddingRelative(dp_8, dp_7, dp_2, dp_7);
                    ivMsgImage.setPaddingRelative(0, dp_5, 0, 0);
                } else {
                    llRoot.setPadding(dp_17, dp_1, 0, dp_4);
                    tvUserName.setPadding(dp_8, dp_7, dp_10, 0);
                    tvMsg.setPadding(dp_8, dp_7, dp_2, dp_7);
                    ivMsgImage.setPadding(0, dp_5, 0, 0);
                }
            } else {
                tvUserName.setVisibility(8);
                llMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
                if (Build.VERSION.SDK_INT >= 17) {
                    llRoot.setPaddingRelative(dp_17, dp_1, 0, dp_1);
                    tvUserName.setPaddingRelative(dp_8, dp_7, dp_10, 0);
                    tvMsg.setPaddingRelative(dp_8, dp_7, dp_2, dp_7);
                    ivMsgImage.setPaddingRelative(0, dp_5, 0, 0);
                } else {
                    llRoot.setPadding(dp_17, dp_1, 0, dp_1);
                    tvUserName.setPadding(dp_8, dp_7, dp_10, 0);
                    tvMsg.setPadding(dp_8, dp_7, dp_2, dp_7);
                    ivMsgImage.setPadding(0, dp_5, 0, 0);
                }
            }
        } else if (position != 0 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) == 1) {
            int tvMsgTopPadding = currentOrderItem.getMessageType() == 1 ? 0 : (currentOrderItem.getMessageType() == 12 || currentOrderItem.getMessageType() == 19 ? this.pxToDp(10) : this.pxToDp(5));
            tvUserName.setVisibility(0);
            tvUserName.setText((CharSequence)userNameText);
            llMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            if (Build.VERSION.SDK_INT >= 17) {
                llRoot.setPaddingRelative(this.pxToDp(10), this.pxToDp(4), this.pxToDp(0), this.pxToDp(1));
                tvUserName.setPaddingRelative(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPaddingRelative(this.pxToDp(15), this.pxToDp(tvMsgTopPadding), this.pxToDp(2), this.pxToDp(7));
                ivMsgImage.setPaddingRelative(dp_5, 0, 0, 0);
            } else {
                llRoot.setPadding(this.pxToDp(10), this.pxToDp(4), this.pxToDp(0), this.pxToDp(1));
                tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPadding(this.pxToDp(15), this.pxToDp(tvMsgTopPadding), this.pxToDp(2), this.pxToDp(7));
                ivMsgImage.setPadding(dp_5, 0, 0, 0);
            }
        } else {
            int tvMsgTopPadding = currentOrderItem.getMessageType() == 1 ? 0 : (currentOrderItem.getMessageType() == 12 || currentOrderItem.getMessageType() == 19 ? this.pxToDp(10) : this.pxToDp(5));
            tvUserName.setVisibility(0);
            tvUserName.setText((CharSequence)userNameText);
            llMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            if (Build.VERSION.SDK_INT >= 17) {
                llRoot.setPaddingRelative(this.pxToDp(10), this.pxToDp(4), 0, this.pxToDp(4));
                tvUserName.setPaddingRelative(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPaddingRelative(this.pxToDp(15), this.pxToDp(tvMsgTopPadding), this.pxToDp(2), this.pxToDp(7));
                ivMsgImage.setPaddingRelative(this.pxToDp(5), this.pxToDp(0), 0, this.pxToDp(0));
            } else {
                llRoot.setPadding(this.pxToDp(10), this.pxToDp(4), 0, this.pxToDp(4));
                tvUserName.setPadding(this.pxToDp(15), this.pxToDp(7), this.pxToDp(10), this.pxToDp(0));
                tvMsg.setPadding(this.pxToDp(15), this.pxToDp(tvMsgTopPadding), this.pxToDp(2), this.pxToDp(7));
                ivMsgImage.setPadding(this.pxToDp(5), this.pxToDp(0), 0, this.pxToDp(0));
            }
        }
    }

    private void setTextMessageSelf(boolean isRightToLeft, int position, LinearLayout fuguLlRoot, RelativeLayout fuguRlImageMessage, RelativeLayout fuguRlMessages, LinearLayout FuguLlMessageBg, TextView fuguTvMsg, TextView fuguTvTime) {
        int start = 0;
        int firstMsgStart = 0;
        int startImage = 0;
        int endImage = 0;
        int right = this.pxToDp(17);
        if (isRightToLeft) {
            start = this.pxToDp(4);
            firstMsgStart = this.pxToDp(10);
            startImage = this.pxToDp(2);
            endImage = this.pxToDp(14);
            right = this.pxToDp(10);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            if (position != 0 && this.getItemViewType(position - 1) == 2 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) == 2) {
                fuguLlRoot.setPaddingRelative(this.pxToDp(0), this.pxToDp(1), right, this.pxToDp(1));
                fuguRlImageMessage.setPaddingRelative(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
            } else if (position != 0 && this.getItemViewType(position - 1) == 2 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) != 2 || position - 1 >= 0 && this.getItemViewType(position - 1) == 2) {
                if (position == this.fuguItems.size() - 1) {
                    fuguLlRoot.setPaddingRelative(start, this.pxToDp(1), right, this.pxToDp(1));
                    fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
                } else {
                    fuguLlRoot.setPaddingRelative(start, this.pxToDp(1), right, this.pxToDp(4));
                    fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
                }
            } else if (position != 0 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) == 2) {
                fuguLlRoot.setPaddingRelative(start, this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
                fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
            } else if (position == this.fuguItems.size() - 1) {
                fuguLlRoot.setPaddingRelative(start, this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
                fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
            } else {
                fuguLlRoot.setPaddingRelative(start, this.pxToDp(4), this.pxToDp(10), this.pxToDp(4));
                fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
            }
            if (position != 0 && this.getItemViewType(position - 1) != 2) {
                FuguLlMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
                fuguRlMessages.setPaddingRelative(firstMsgStart, this.pxToDp(0), this.pxToDp(12), this.pxToDp(0));
                fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
            } else {
                FuguLlMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
                fuguRlMessages.setPaddingRelative(start, this.pxToDp(0), this.pxToDp(4), this.pxToDp(0));
                fuguRlImageMessage.setPaddingRelative(startImage, this.pxToDp(4), endImage, this.pxToDp(4));
            }
        } else {
            if (position != 0 && this.getItemViewType(position - 1) == 2 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) == 2) {
                fuguLlRoot.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
                fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
            } else if (position != 0 && this.getItemViewType(position - 1) == 2 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) != 2 || position - 1 >= 0 && this.getItemViewType(position - 1) == 2) {
                if (position == this.fuguItems.size() - 1) {
                    fuguLlRoot.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(1));
                    fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
                } else {
                    fuguLlRoot.setPadding(this.pxToDp(0), this.pxToDp(1), this.pxToDp(17), this.pxToDp(4));
                    fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
                }
            } else if (position != 0 && position + 1 != this.fuguItems.size() && this.getItemViewType(position + 1) == 2) {
                fuguLlRoot.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
                fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
            } else if (position == this.fuguItems.size() - 1) {
                fuguLlRoot.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(1));
                fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
            } else {
                fuguLlRoot.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(10), this.pxToDp(4));
                fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(0), this.pxToDp(4));
            }
            if (position != 0 && this.getItemViewType(position - 1) != 2) {
                FuguLlMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
                fuguRlMessages.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(12), this.pxToDp(0));
                fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), this.pxToDp(4), this.pxToDp(4));
            } else {
                FuguLlMessageBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
                fuguRlMessages.setPadding(this.pxToDp(0), this.pxToDp(0), this.pxToDp(4), this.pxToDp(0));
                fuguRlImageMessage.setPadding(this.pxToDp(0), this.pxToDp(4), 0, this.pxToDp(4));
            }
        }
        NinePatchDrawable drawable3 = (NinePatchDrawable)FuguLlMessageBg.getBackground();
        drawable3.setColorFilter(this.hippoColorConfig.getHippoBgMessageYou(), PorterDuff.Mode.MULTIPLY);
        fuguTvMsg.setTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        fuguTvMsg.setLinkTextColor(this.hippoColorConfig.getHippoPrimaryTextMsgYou());
        fuguTvMsg.setAutoLinkMask(15);
        fuguTvTime.setTextColor(this.hippoColorConfig.getHippoSecondaryTextMsgYou());
    }

    private void setView(LinearLayout llGalleryButtonLayout, int count) {
        llGalleryButtonLayout.removeAllViews();
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Amit");
        strings.add("Gurmail");
        strings.add("Ankush");
        strings.add("Vishal");
        strings.add("Gagan");
        for (int i = 0; i < count; ++i) {
            final int pos = i;
            LayoutInflater layoutInflater = (LayoutInflater)this.activity.getBaseContext().getSystemService("layout_inflater");
            View view = layoutInflater.inflate(R.layout.hippo_layout_gallery_button, null);
            TextView textView = (TextView)view.findViewById(R.id.tvButton);
            textView.setText((CharSequence)strings.get(i));
            textView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Toast.makeText((Context)FuguMessageAdapter.this.activity, (CharSequence)("Button" + String.valueOf(pos) + "clicked"), (int)0).show();
                }
            });
            llGalleryButtonLayout.addView(view);
        }
    }

    public int getItemViewType(int position) {
        return this.fuguItems.get(position).getType();
    }

    private float convertDpToPixel(float dp) {
        DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return Math.round(px);
    }

    public int getItemCount() {
        return this.fuguItems.size();
    }

    private void setTime(AppCompatTextView tvImageTime, String sentAtUtc) {
        tvImageTime.setText((CharSequence)DateUtils.getTime(this.fuguDateUtil.convertToLocal(sentAtUtc)));
    }

    private void setIntegrationSource(ImageView source, ImageView messenger, int type) {
        source.setVisibility(8);
        messenger.setVisibility(8);
        if (!this.isSourceMessageEnabled) {
            return;
        }
        int color2 = this.hippoColorConfig.getHippoSourceType();
        switch (type) {
            case 5: {
                source.setImageResource(R.drawable.hippo_ic_email);
                source.setVisibility(0);
                source.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
                break;
            }
            case 6: {
                messenger.setVisibility(0);
                break;
            }
            case 7: {
                source.setImageResource(R.drawable.hippo_ic_sms);
                source.setVisibility(0);
                source.setColorFilter((ColorFilter)new PorterDuffColorFilter(color2, PorterDuff.Mode.SRC_IN));
                break;
            }
            default: {
                source.setVisibility(8);
                messenger.setVisibility(8);
            }
        }
    }

    private void showImageView(ImageView imageView, Message message) {
        String fname = Util.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.IMAGE.toString()));
        HippoLog.e("localPath", "localPath = " + localPath);
        RequestOptions myOptions = RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)this.activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder)).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).error(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.hippo_placeholder));
        Glide.with((Activity)this.activity).load(TextUtils.isEmpty((CharSequence)localPath) ? message.getThumbnailUrl() : new File(localPath)).apply(myOptions).into(imageView);
    }

    private void setMessageStatus(AppCompatImageView ivMessageState, int messageStatus, Boolean isImage) {
        if (isImage.booleanValue()) {
            switch (messageStatus) {
                case 1: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single_white));
                    break;
                }
                case 4: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 2: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 3: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 6: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
                case 5: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting_white));
                    break;
                }
            }
        } else {
            switch (messageStatus) {
                case 1: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                    break;
                }
                case 4: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 2: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 3: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                    break;
                }
                case 6: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
                case 5: {
                    ivMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                    break;
                }
            }
        }
    }

    private void setImageHeightAndWidth(ImageView imageView, RelativeLayout rlImageMessage, LinearLayoutCompat llImageMessage, Message message, Boolean isSpiked) {
        int imageHeight = message.getImageHeight();
        int imageWidth = message.getImageWidth();
        if (imageHeight != 0 && message.getImageWidth() != 0) {
            float ratio = imageHeight / imageWidth;
            if (ratio < 1.0f) {
                rlImageMessage.getLayoutParams().height = (int)((float)this.pxToDp(250) * ratio);
                rlImageMessage.getLayoutParams().width = this.pxToDp(250);
                llImageMessage.getLayoutParams().width = isSpiked.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            } else {
                rlImageMessage.getLayoutParams().height = this.pxToDp(250);
                rlImageMessage.getLayoutParams().width = this.pxToDp(250);
                llImageMessage.getLayoutParams().width = isSpiked.booleanValue() ? this.pxToDp(255) : this.pxToDp(252);
            }
        } else {
            rlImageMessage.getLayoutParams().height = this.pxToDp(250);
            rlImageMessage.getLayoutParams().width = this.pxToDp(250);
            llImageMessage.getLayoutParams().width = isSpiked != false ? this.pxToDp(255) : this.pxToDp(252);
        }
    }

    private void setVideoDownloadStatus(LinearLayout videoDownloadStatus, ImageView playBtn, TextView fileSize, ProgressWheel progressBar, Message message, int position) {
        String fname = Util.getFileName(message.getFileName(), message.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(message.getDocumentType()));
        videoDownloadStatus.setVisibility(8);
        progressBar.setVisibility(8);
        playBtn.setVisibility(8);
        if (!(TextUtils.isEmpty((CharSequence)localPath) || message.getMessageStatus() != 3 && message.getMessageStatus() != 2 && message.getMessageStatus() != 1)) {
            playBtn.setVisibility(0);
        } else {
            switch (message.getDownloadStatus()) {
                case 1: {
                    progressBar.setVisibility(0);
                    break;
                }
                case 3: {
                    playBtn.setVisibility(0);
                    break;
                }
                default: {
                    videoDownloadStatus.setVisibility(0);
                    fileSize.setText((CharSequence)message.getFileSize());
                }
            }
        }
    }

    private void setVideoUiStatus(boolean isSelf, Message message, LinearLayout download, ImageView playBtn, AppCompatButton btnRetry, AppCompatButton btnCancel, ProgressWheel progress) {
        if (isSelf) {
            download.setVisibility(8);
            playBtn.setVisibility(8);
            btnRetry.setVisibility(8);
            btnCancel.setVisibility(8);
            progress.setVisibility(8);
            if (message.getMessageStatus() == 3 || message.getMessageStatus() == 2 || message.getMessageStatus() == 1) {
                String fname = Util.getFileName(message.getFileName(), message.getMuid());
                String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(message.getDocumentType()));
                if (TextUtils.isEmpty((CharSequence)localPath)) {
                    download.setVisibility(0);
                } else {
                    playBtn.setVisibility(0);
                }
            } else if (message.getUploadStatus() == 1) {
                progress.setVisibility(0);
            } else if (message.getIsMessageExpired() == 1) {
                btnRetry.setVisibility(0);
                btnCancel.setVisibility(0);
            }
        }
    }

    private void setVideoUploadStatus(AppCompatTextView tvImageTime, ProgressWheel circleProgress, AppCompatButton fuguBtnRetry, ImageView ivPlay, Message currentOrderItem2, ImageView ivDownload) {
        switch (currentOrderItem2.getUploadStatus()) {
            case 0: {
                if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
                    circleProgress.setVisibility(8);
                    fuguBtnRetry.setVisibility(8);
                    ivPlay.setVisibility(0);
                    break;
                }
                fuguBtnRetry.setVisibility(0);
                circleProgress.setVisibility(8);
                ivPlay.setVisibility(8);
                break;
            }
            case 1: {
                circleProgress.setVisibility(0);
                fuguBtnRetry.setVisibility(8);
                ivPlay.setVisibility(8);
                break;
            }
            case 3: {
                circleProgress.setVisibility(8);
                fuguBtnRetry.setVisibility(8);
                if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
                    ivPlay.setVisibility(0);
                    break;
                }
                ivPlay.setVisibility(8);
                break;
            }
            default: {
                tvImageTime.append((CharSequence)"10");
                circleProgress.setVisibility(8);
                fuguBtnRetry.setVisibility(8);
                if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
                    ivPlay.setVisibility(0);
                    break;
                }
                ivPlay.setVisibility(8);
            }
        }
        if (currentOrderItem2.getIsMessageExpired() == 1) {
            fuguBtnRetry.setVisibility(0);
        } else if (currentOrderItem2.getMessageStatus() == 3 || currentOrderItem2.getMessageStatus() == 2 || currentOrderItem2.getMessageStatus() == 1) {
            circleProgress.setVisibility(8);
            fuguBtnRetry.setVisibility(8);
            ivPlay.setVisibility(0);
            String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(FuguAppConstant.DocumentType.VIDEO.toString()));
            if (TextUtils.isEmpty((CharSequence)localPath)) {
                ivDownload.setVisibility(0);
                ivPlay.setVisibility(8);
            }
        }
    }

    private void setFileCLickListener(LinearLayoutCompat llFile, final Message message, final AppCompatImageView ivFilePlay, final int position) {
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguMessageAdapter.this.onPlaySound(message, ivFilePlay, position);
            }
        });
        llFile.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                block4: {
                    try {
                        if (message.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            return;
                        }
                        String fname = Util.getFileName(message.getFileName(), message.getMuid());
                        String localPath = FileManager.getInstance().getLocalPath(fname, FuguAppConstant.FOLDER_TYPE.get(message.getDocumentType()));
                        if (!TextUtils.isEmpty((CharSequence)localPath)) {
                            FileManager.getInstance().openFileInDevice((Context)FuguMessageAdapter.this.activity, localPath, new FileManager.FileCopyListener(){

                                @Override
                                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                                }

                                @Override
                                public void largeFileSize() {
                                }

                                @Override
                                public void onError() {
                                    Toast.makeText((Context)FuguMessageAdapter.this.activity, (CharSequence)FuguMessageAdapter.this.activity.getString(R.string.no_handler), (int)1).show();
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        if (!HippoConfig.DEBUG) break block4;
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void setFileDownLoadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, ProgressWheel circleProgress, AppCompatImageView ivFileDownload, AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        ivFileDownload.setVisibility(8);
        circleProgress.setVisibility(8);
        ivFileUpload.setVisibility(8);
        ivFilePlay.setVisibility(8);
        String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        HippoLog.v("localPath", "localPath ********* = " + localPath);
        if (!TextUtils.isEmpty((CharSequence)localPath)) {
            if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                ivFilePlay.setVisibility(0);
            }
        } else {
            switch (currentOrderItem2.getDownloadStatus()) {
                case 1: {
                    circleProgress.setVisibility(0);
                    break;
                }
                case 3: {
                    if (!currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) break;
                    ivFilePlay.setVisibility(0);
                    break;
                }
                default: {
                    ivFileDownload.setVisibility(0);
                }
            }
        }
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguMessageAdapter.this.onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void setFileUploadStatus(ImageView fileView, final AppCompatImageView ivFilePlay, ProgressWheel circleProgress, AppCompatImageView ivFileDownload, AppCompatImageView ivFileUpload, final Message currentOrderItem2, final int position) {
        block10: {
            block11: {
                block9: {
                    ivFileDownload.setVisibility(8);
                    circleProgress.setVisibility(8);
                    ivFileUpload.setVisibility(8);
                    ivFilePlay.setVisibility(8);
                    if (currentOrderItem2.getIsMessageExpired() != 1) break block9;
                    ivFileUpload.setVisibility(0);
                    break block10;
                }
                if (currentOrderItem2.getMessageStatus() != 4) break block11;
                switch (currentOrderItem2.getUploadStatus()) {
                    case 0: {
                        ivFileUpload.setVisibility(0);
                        break;
                    }
                    case 1: {
                        circleProgress.setVisibility(0);
                        break;
                    }
                    case 3: {
                        if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                            ivFilePlay.setVisibility(0);
                            break;
                        } else {
                            break;
                        }
                    }
                }
                break block10;
            }
            String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
            String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
            HippoLog.v("localPath", "localPath ********* = " + currentOrderItem2.getFileName());
            if (!TextUtils.isEmpty((CharSequence)localPath)) {
                if (currentOrderItem2.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.AUDIO.toString())) {
                    ivFilePlay.setVisibility(0);
                }
            } else {
                ivFileDownload.setVisibility(0);
            }
        }
        ivFilePlay.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FuguMessageAdapter.this.onPlaySound(currentOrderItem2, ivFilePlay, position);
            }
        });
    }

    private void onPlaySound(final Message currentOrderItem2, final AppCompatImageView ivFilePlay, final int position) {
        if (!TextUtils.isEmpty((CharSequence)this.fuguChatActivity.audioMuid)) {
            if (this.fuguChatActivity.audioMuid.equalsIgnoreCase(currentOrderItem2.getMuid())) {
                this.fuguChatActivity.audioMuid = "";
                currentOrderItem2.setAudioPlaying(false);
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                CommonMediaPlayer.getInstance().stopMedia();
                this.notifyItemChanged(position);
                return;
            }
            ListItem listItem = this.fuguItems.get(this.fuguChatActivity.playingItem);
            ((EventItem)listItem).getEvent().setAudioPlaying(false);
            this.notifyItemChanged(this.fuguChatActivity.playingItem);
        }
        String fname = Util.getFileName(currentOrderItem2.getFileName(), currentOrderItem2.getMuid());
        String localPath = FileManager.getInstance().getLocalPath(fname, (String)FOLDER_TYPE.get(currentOrderItem2.getDocumentType()));
        CommonMediaPlayer.getInstance().playMediaPlayer((Context)this.activity, localPath, new CommonMediaPlayer.MediaPlayerStatus(){

            @Override
            public void onPlaying() {
                currentOrderItem2.setAudioPlaying(true);
                ((FuguMessageAdapter)FuguMessageAdapter.this).fuguChatActivity.audioMuid = currentOrderItem2.getMuid();
                ((FuguMessageAdapter)FuguMessageAdapter.this).fuguChatActivity.playingItem = position;
                ivFilePlay.setImageResource(R.drawable.hippo_song_pause);
                currentOrderItem2.setAudioPlaying(true);
                FuguMessageAdapter.this.notifyItemChanged(position);
            }

            @Override
            public void onCompletion(MediaPlayer mp) {
                ((FuguMessageAdapter)FuguMessageAdapter.this).fuguChatActivity.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguMessageAdapter.this.notifyItemChanged(position);
            }

            @Override
            public void onError(MediaPlayer mp, int what, int extra) {
                ((FuguMessageAdapter)FuguMessageAdapter.this).fuguChatActivity.audioMuid = "";
                ivFilePlay.setImageResource(R.drawable.hippo_music_player);
                currentOrderItem2.setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
                FuguMessageAdapter.this.notifyItemChanged(position);
            }
        });
    }

    private void setDownloadClick(final AppCompatImageView ivFileDownload, final ProgressWheel circleProgress, final Message message, final int position) {
        if (!this.fuguChatActivity.isNetworkAvailable()) {
            return;
        }
        ivFileDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String fileName;
                if (!FuguMessageAdapter.this.fuguChatActivity.checkPermission()) {
                    FuguMessageAdapter.this.fuguChatActivity.readExternalStorage();
                    return;
                }
                circleProgress.setVisibility(0);
                ivFileDownload.setVisibility(8);
                String docType = "image";
                if (message.getMessageType() == 11) {
                    docType = message.getDocumentType();
                }
                if (TextUtils.isEmpty((CharSequence)(fileName = message.getFileName()))) {
                    String timeStamp = new SimpleDateFormat("ddMMyyyy_hhmmss", Locale.ENGLISH).format(new Date());
                    fileName = "Hippochat_" + timeStamp + ".jpg";
                }
                String fullPath = Util.getOrCreateDirectoryPath(FuguAppConstant.FOLDER_TYPE.get(docType));
                int downloadId = FuguMessageAdapter.this.downloadFileFromUrl(fullPath, fileName, message, position);
                message.setDownloadId(downloadId);
            }
        });
    }

    private int downloadFileFromUrl(String dirPath, String fileName, final Message message, final int position) {
        if (!fileName.contains(message.getMuid())) {
            String muid = message.getMuid();
            String ext = Util.getExtension(fileName);
            String name = Util.extractFileNameWithoutSuffix(fileName);
            fileName = name + "_" + muid + "." + ext;
        }
        this.currentProgress = -1;
        return PRDownloader.download((String)message.getFileUrl(), (String)dirPath, (String)fileName).build().setOnStartOrResumeListener(new OnStartOrResumeListener(){

            public void onStartOrResume() {
                HippoLog.v(TAG, "OnStartOrResumeListener");
            }
        }).setOnPauseListener(new OnPauseListener(){

            public void onPause() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_PAUSED.downloadStatus);
            }
        }).setOnProgressListener(new OnProgressListener(){

            public void onProgress(Progress progress) {
                int cProgress = (int)(progress.currentBytes * 100L / progress.totalBytes);
                if (FuguMessageAdapter.this.currentProgress < cProgress) {
                    ++FuguMessageAdapter.this.currentProgress;
                }
                message.setCurrentprogress(cProgress);
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_IN_PROGRESS.downloadStatus);
            }
        }).start(new OnDownloadListener(){

            public void onDownloadComplete() {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                Intent mIntent = FuguMessageAdapter.this.getIntentExtraData(position, 100, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_COMPLETED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguMessageAdapter.this.activity).sendBroadcast(mIntent);
            }

            public void onError(Error error) {
                message.setDownloadStatus(FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                Intent mIntent = FuguMessageAdapter.this.getIntentExtraData(position, 0, message.getMuid(), FuguAppConstant.DownloadStatus.DOWNLOAD_FAILED.downloadStatus);
                LocalBroadcastManager.getInstance((Context)FuguMessageAdapter.this.activity).sendBroadcast(mIntent);
            }
        });
    }

    private Intent getIntentExtraData(int position, int progress, String muid, int status) {
        Intent mIntent = new Intent("hippo_progress_intent");
        mIntent.putExtra("hippo_position", position);
        mIntent.putExtra("hippo_progress", progress);
        mIntent.putExtra("muid", muid);
        mIntent.putExtra("hippo_statusUpload", status);
        return mIntent;
    }

    private void messageStatusTick(ImageView fuguIvMessageState, Message currentOrderItem2) {
        switch (currentOrderItem2.getMessageStatus()) {
            case 4: 
            case 5: 
            case 6: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_ic_waiting));
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            case 3: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoMessageRead(), PorterDuff.Mode.SRC_ATOP);
                fuguIvMessageState.setVisibility(0);
                break;
            }
            case 1: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            case 2: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_double));
                if (Build.VERSION.SDK_INT >= 21) {
                    fuguIvMessageState.getDrawable().setTint(ContextCompat.getColor((Context)this.activity, (int)R.color.fugu_drawable_color));
                }
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
                break;
            }
            default: {
                fuguIvMessageState.setImageDrawable(ContextCompat.getDrawable((Context)this.activity, (int)R.drawable.fugu_tick_single));
                fuguIvMessageState.setVisibility(0);
                fuguIvMessageState.getDrawable().setColorFilter(this.hippoColorConfig.getHippoSecondaryTextMsgYou(), PorterDuff.Mode.SRC_ATOP);
            }
        }
    }

    private void setUploadClick(AppCompatImageView ivFileUpload, ProgressWheel circleProgress, Message message) {
        ivFileUpload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!((FuguChatActivity)FuguMessageAdapter.this.activity).isNetworkAvailable() || FuguMessageAdapter.this.mOnRetry != null) {
                    // empty if block
                }
            }
        });
    }

    private boolean setOtherMessageBackground(View viewMessage, View viewBg, int position, TextView viewUsername) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        int eight = this.pxToDp(8);
        if (this.fuguItems.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            viewMessage.setPadding(eight, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            return true;
        }
        if (position == 0) {
            viewMessage.setPadding(eight, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            if (viewUsername != null) {
                viewUsername.setPadding(eight, 0, 0, 0);
            }
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            return true;
        }
        if (this.getItemViewType(position - 1) == 1 || this.getItemViewType(position - 1) == 19 || this.getItemViewType(position - 1) == 13) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            if (viewUsername != null) {
                viewUsername.setVisibility(8);
            }
            viewMessage.setPadding(this.pxToDp(15), oneDp, 0, oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            return false;
        }
        viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
        viewMessage.setPadding(eight, sevenDp, 0, oneDp);
        viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
        return true;
    }

    private boolean setSelfMessageBackground(View viewMessage, View viewBg, int position) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        if (this.fuguItems.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
            viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
            return true;
        }
        if (position == 0) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
            viewMessage.setPadding(0, sixDp, this.pxToDp(7), sevenDp);
            viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
            return true;
        }
        if (this.getItemViewType(position - 1) == 2 || this.getItemViewType(position - 1) == 18 || this.getItemViewType(position - 1) == 10 || this.getItemViewType(position - 1) == 12) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right_normal);
            viewMessage.setPadding(0, oneDp, this.pxToDp(15), oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            return false;
        }
        viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_right);
        viewMessage.setPadding(0, sixDp, sevenDp, oneDp);
        viewBg.setPadding(sixDp, sixDp, this.pxToDp(17), sixDp);
        return true;
    }

    private boolean setFileMessageOther(View viewMessage, View viewBg, int position, TextView userName, String name) {
        int oneDp = this.pxToDp(1);
        int sixDp = this.pxToDp(6);
        int sevenDp = this.pxToDp(7);
        int eightDp = this.pxToDp(8);
        if (this.fuguItems.size() == 1) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
            return true;
        }
        if (position == 0) {
            viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
            viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
            if (userName != null) {
                userName.setVisibility(0);
                userName.setText((CharSequence)name);
            } else if (TextUtils.isEmpty((CharSequence)name)) {
                userName.setVisibility(8);
            }
            return true;
        }
        if (this.getItemViewType(position - 1) == 1 || this.getItemViewType(position - 1) == 19 || this.getItemViewType(position - 1) == 13 || this.getItemViewType(position - 1) == 11) {
            viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left_normal);
            viewMessage.setPadding(this.pxToDp(15), oneDp, 0, oneDp);
            viewBg.setPadding(sixDp, sixDp, sixDp, sixDp);
            if (userName != null) {
                userName.setVisibility(8);
            }
            return true;
        }
        viewBg.setBackgroundResource(R.drawable.hippo_chat_bg_left);
        viewMessage.setPadding(eightDp, sevenDp, 0, oneDp);
        viewBg.setPadding(this.pxToDp(13), sixDp, sixDp, sixDp);
        if (userName != null) {
            userName.setVisibility(0);
            userName.setText((CharSequence)name);
        } else if (TextUtils.isEmpty((CharSequence)name)) {
            userName.setVisibility(8);
        }
        return true;
    }

    private void setImage(Activity activity, AppCompatImageView ivImageMessage, String thumbnailUrl) {
        try {
            HippoLog.e(TAG, "thumbnailUrl = " + thumbnailUrl);
            RequestOptions myOptions = RequestOptions.bitmapTransform((Transformation)new RoundedCornersTransformation((Context)activity, 7, 2)).placeholder(ContextCompat.getDrawable((Context)activity, (int)R.drawable.hippo_placeholder)).dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).error(ContextCompat.getDrawable((Context)activity, (int)R.drawable.hippo_placeholder));
            Glide.with((Activity)activity).load(thumbnailUrl).apply(myOptions).into((ImageView)ivImageMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showImageDialog(Context activity, String imgUrl, ImageView imageView, Message message) {
        try {
            if (!Utils.preventMultipleClicks()) {
                return;
            }
            Intent imageIntent = new Intent(activity, ImageDisplayActivity.class);
            Image image = new Image(message.getUrl(), message.getThumbnailUrl(), message.getMuid(), message.getSentAtUtc(), "");
            imageIntent.putExtra("image", (Serializable)image);
            activity.startActivity(imageIntent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String convertSeconds(int seconds) {
        int h = seconds / 3600;
        int m = seconds % 3600 / 60;
        int s = seconds % 60;
        String sh = h > 0 ? String.valueOf(h) + " h" : "";
        String sm = (m < 10 && m > 0 && h > 0 ? "0" : "") + (m > 0 ? (h > 0 && s == 0 ? String.valueOf(m) : String.valueOf(m) + " min") : "");
        String ss = s == 0 && (h > 0 || m > 0) ? "" : (s < 10 && (h > 0 || m > 0) ? "0" : "") + String.valueOf(s) + " sec";
        return sh + (h > 0 ? " " : "") + sm + (m > 0 ? " " : "") + ss;
    }

    public void attachObservers(Boolean attach) {
        if (attach.booleanValue()) {
            this.attachObserver();
        } else {
            this.detachObserver();
        }
    }

    private void detachObserver() {
        this.receiverRegistered = false;
        try {
            LocalBroadcastManager.getInstance((Context)this.activity).unregisterReceiver(this.mProgressReceiver);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void attachObserver() {
        if (this.mProgressReceiver == null) {
            if (this.receiverRegistered) {
                return;
            }
            this.initializeReciever();
        }
        LocalBroadcastManager.getInstance((Context)this.activity).registerReceiver(this.mProgressReceiver, new IntentFilter("hippo_progress_intent"));
        this.receiverRegistered = true;
    }

    private void initializeReciever() {
        this.mProgressReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, final Intent intent) {
                FuguMessageAdapter.this.activity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            try {
                                int position = intent.getIntExtra("hippo_position", 0);
                                String muid = intent.getStringExtra("muid");
                                Message message = ((EventItem)FuguMessageAdapter.this.fuguItems.get(position)).getEvent();
                                if (message.getMuid().equals(muid)) {
                                    this.checkHolderAndUpdateProgress(message, position);
                                    break block4;
                                }
                                for (int i = FuguMessageAdapter.this.fuguItems.size() - 1; i > 0; --i) {
                                    message = ((EventItem)FuguMessageAdapter.this.fuguItems.get(position)).getEvent();
                                    if (!message.getMuid().equals(muid)) continue;
                                    position = i;
                                    this.checkHolderAndUpdateProgress(message, position);
                                    break;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }

                    private void checkHolderAndUpdateProgress(Message currentOrderItem, int position) {
                        currentOrderItem.setCurrentprogress(intent.getIntExtra("hippo_progress", 0));
                        currentOrderItem.setUploadStatus(intent.getIntExtra("hippo_statusUpload", 1));
                        if (FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position) instanceof ReceivedFileViewHolder) {
                            this.setOtherHolderFileProgress(currentOrderItem, position);
                        } else if (FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position) instanceof SentFileViewHolder) {
                            this.setSelfHolderFileProgress(currentOrderItem, position);
                        } else if (FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position) instanceof SelfVideoMessageViewHolder) {
                            this.setSelfHolderVideoProgress(currentOrderItem, position);
                        } else if (FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position) instanceof OtherVideoMessageViewHolder) {
                            this.setOtherHolderVideoProgress(currentOrderItem, position);
                        }
                    }

                    private void setOtherHolderImageProgress(Message currentOrderItem, int position) {
                    }

                    private void setSelfHolderImageProgress(Message currentOrderItem, int position) {
                    }

                    private void setOtherHolderVideoProgress(Message currentOrderItem, int position) {
                        OtherVideoMessageViewHolder otherImageMessageViewHolder = (OtherVideoMessageViewHolder)FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position);
                        currentOrderItem.setCurrentprogress(intent.getIntExtra("hippo_progress", 0));
                        otherImageMessageViewHolder.llDownload.setVisibility(8);
                        currentOrderItem.setDownloadStatus(intent.getIntExtra("hippo_statusUpload", 1));
                        FuguMessageAdapter.this.notifyItemChanged(position);
                    }

                    private void setSelfHolderVideoProgress(Message currentOrderItem, int position) {
                        SelfVideoMessageViewHolder selfImageMessageViewHolder = (SelfVideoMessageViewHolder)FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position);
                        currentOrderItem.setCurrentprogress(intent.getIntExtra("hippo_progress", 0));
                        selfImageMessageViewHolder.circle_progress.setVisibility(0);
                        currentOrderItem.setDownloadStatus(intent.getIntExtra("hippo_statusUpload", 1));
                        FuguMessageAdapter.this.notifyItemChanged(position);
                    }

                    private void setOtherHolderFileProgress(Message currentOrderItem, int position) {
                        ReceivedFileViewHolder otherFileMessageViewHolder = (ReceivedFileViewHolder)FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position);
                        currentOrderItem.setCurrentprogress(intent.getIntExtra("hippo_progress", 0));
                        otherFileMessageViewHolder.progressBar.setVisibility(0);
                        otherFileMessageViewHolder.ivFilePlay.setVisibility(8);
                        FuguMessageAdapter.this.notifyItemChanged(position);
                    }

                    private void setSelfHolderFileProgress(Message currentOrderItem, int position) {
                        SentFileViewHolder selfFileMessageViewHolder = (SentFileViewHolder)FuguMessageAdapter.this.recyclerView.findViewHolderForAdapterPosition(position);
                        currentOrderItem.setCurrentprogress(intent.getIntExtra("hippo_progress", 0));
                        selfFileMessageViewHolder.circleProgress.setVisibility(0);
                        selfFileMessageViewHolder.ivFilePlay.setVisibility(8);
                        currentOrderItem.setDownloadStatus(intent.getIntExtra("hippo_statusUpload", 1));
                        FuguMessageAdapter.this.notifyItemChanged(position);
                    }
                });
            }
        };
    }

    public static interface OnUserConcent {
        public void onConcentClicked(Message var1);
    }

    public static interface onVideoCall {
        public void onVideoCallClicked(int var1);
    }

    public static interface OnRatingListener {
        public void onSubmitRating(String var1, Message var2, int var3);

        public void onRatingSelected(int var1, Message var2);

        public void onFormDataCallback(Message var1);
    }

    class OtherVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private LinearLayout llDownload;
        private TextView tvUserName;
        private TextView tvFileSize;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatTextView tvImageTime;
        private AppCompatTextView tvImgWithText;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public OtherVideoMessageViewHolder(final View itemView, final OnRecyclerListener itemClickListener) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)itemView.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.ivImageMsg = (AppCompatImageView)itemView.findViewById(R.id.ivImageMsg);
            this.tvImageTime = (AppCompatTextView)itemView.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (AppCompatTextView)itemView.findViewById(R.id.tvImgWithText);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.progressBar = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.ivPlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    itemClickListener.onItemClick((View)OtherVideoMessageViewHolder.this.llRoot, itemView, OtherVideoMessageViewHolder.this.getAdapterPosition());
                }
            });
        }
    }

    class SelfVideoMessageViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llDownload;
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llImageMessage;
        private RelativeLayout rlImageMessage;
        private AppCompatImageView ivImageMsg;
        private AppCompatImageView ivMessageState;
        private ImageView ivPlay;
        private ImageView ivDownload;
        private AppCompatTextView tvImageTime;
        private TextView tvFileSize;
        private TextView tvImgWithText;
        private AppCompatButton btnRetry;
        private AppCompatButton btnCancel;
        private ProgressWheel circle_progress;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SelfVideoMessageViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llImageMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llImageMessage);
            this.llDownload = (LinearLayout)itemView.findViewById(R.id.llDownload);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.ivImageMsg = (AppCompatImageView)itemView.findViewById(R.id.ivImageMsg);
            this.ivPlay = (ImageView)itemView.findViewById(R.id.ivPlay);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.ivMessageState = (AppCompatImageView)itemView.findViewById(R.id.ivMessageState);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvImageTime = (AppCompatTextView)itemView.findViewById(R.id.tvImageTime);
            this.tvImgWithText = (TextView)itemView.findViewById(R.id.tvImgWithText);
            this.circle_progress = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.btnRetry = (AppCompatButton)itemView.findViewById(R.id.btnRetry);
            this.btnCancel = (AppCompatButton)itemView.findViewById(R.id.btnCancel);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class SentFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llImages;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFileUpload;
        private ImageView ivFileImage;
        private ImageView ivMessageState;
        private ProgressWheel circleProgress;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public SentFileViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llMessage);
            this.llImages = (LinearLayoutCompat)itemView.findViewById(R.id.llImages);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)itemView.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)itemView.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)itemView.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)itemView.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)itemView.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)itemView.findViewById(R.id.ivFileUpload);
            this.ivMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.circleProgress = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class ReceivedFileViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayoutCompat llRoot;
        private LinearLayoutCompat llMessage;
        private LinearLayoutCompat llFile;
        private LinearLayoutCompat llImages;
        private TextView tvUserName;
        private TextView tvFileName;
        private TextView tvFileSize;
        private TextView tvFileExtension;
        private TextView tvFileTime;
        private ImageView ivFileImage;
        private AppCompatImageView ivFileDownload;
        private AppCompatImageView ivFilePlay;
        private AppCompatImageView ivFileUpload;
        private ProgressWheel progressBar;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        public ReceivedFileViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayoutCompat)itemView.findViewById(R.id.llRoot);
            this.llMessage = (LinearLayoutCompat)itemView.findViewById(R.id.llMessage);
            this.llFile = (LinearLayoutCompat)itemView.findViewById(R.id.llFile);
            this.llImages = (LinearLayoutCompat)itemView.findViewById(R.id.llImages);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvFileExtension = (TextView)itemView.findViewById(R.id.tvFileExtension);
            this.tvFileTime = (TextView)itemView.findViewById(R.id.tvFileTime);
            this.ivFileImage = (ImageView)itemView.findViewById(R.id.ivFileImage);
            this.ivFilePlay = (AppCompatImageView)itemView.findViewById(R.id.ivFilePlay);
            this.ivFileDownload = (AppCompatImageView)itemView.findViewById(R.id.ivFileDownload);
            this.ivFileUpload = (AppCompatImageView)itemView.findViewById(R.id.ivFileUpload);
            this.progressBar = (ProgressWheel)itemView.findViewById(R.id.circle_progress);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class DateViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvDate;

        DateViewHolder(View itemView) {
            super(itemView);
            this.tvDate = (TextView)itemView.findViewById(R.id.tvDate);
        }
    }

    class GalleryViewHolder
    extends RecyclerView.ViewHolder {
        private LinearLayout llGalleryButtonLayout;
        private TextView tvButton;

        public GalleryViewHolder(View itemView) {
            super(itemView);
            this.tvButton = (TextView)itemView.findViewById(R.id.tvButton);
            this.llGalleryButtonLayout = (LinearLayout)itemView.findViewById(R.id.llGalleryButtonLayout);
        }
    }

    class RatingViewHolder
    extends RecyclerView.ViewHolder {
        public MyCustomEditTextListener myCustomEditTextListener;
        private LinearLayout ratedLayout;
        private LinearLayout askRateLayout;
        private LinearLayout messageLayout;
        private TextView titleTxt;
        private TextView ratedTitle;
        private TextView ratedSubTitle;
        private TextView ratedMessage;
        private ImageView terribleImage;
        private ImageView badImage;
        private ImageView okayImage;
        private ImageView goodImage;
        private ImageView greatImage;
        private EditText editText;
        private Button sendBtn;
        private RelativeLayout sendFeedback;

        public RatingViewHolder(View itemView, MyCustomEditTextListener myCustomEditTextListener) {
            super(itemView);
            this.titleTxt = (TextView)itemView.findViewById(R.id.title_view);
            this.ratedTitle = (TextView)itemView.findViewById(R.id.rated_title);
            this.ratedSubTitle = (TextView)itemView.findViewById(R.id.rated_sub_title);
            this.ratedMessage = (TextView)itemView.findViewById(R.id.rated_message);
            this.editText = (EditText)itemView.findViewById(R.id.ed_rating_txt);
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.editText.addTextChangedListener((TextWatcher)myCustomEditTextListener);
            this.sendFeedback = (RelativeLayout)itemView.findViewById(R.id.send_btn);
            this.sendBtn = (Button)itemView.findViewById(R.id.sendBtn);
            this.ratedLayout = (LinearLayout)itemView.findViewById(R.id.rated_layout);
            this.askRateLayout = (LinearLayout)itemView.findViewById(R.id.ask_rate_layout);
            this.messageLayout = (LinearLayout)itemView.findViewById(R.id.message_layout);
            this.terribleImage = (ImageView)itemView.findViewById(R.id.terrible_image);
            this.badImage = (ImageView)itemView.findViewById(R.id.bad_image);
            this.okayImage = (ImageView)itemView.findViewById(R.id.okay_image);
            this.goodImage = (ImageView)itemView.findViewById(R.id.good_image);
            this.greatImage = (ImageView)itemView.findViewById(R.id.great_image);
        }
    }

    class VideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private ImageView ivCallIcon;
        private LinearLayout llMessage;

        public VideoViewHolder(View itemView) {
            super(itemView);
            this.llMessage = (LinearLayout)itemView.findViewById(R.id.llMessage);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.callAgain = (TextView)itemView.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tvDuration);
            this.ivCallIcon = (ImageView)itemView.findViewById(R.id.ivCallIcon);
        }
    }

    class SelfVideoViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private TextView tvTime;
        private TextView callAgain;
        private TextView tvDuration;
        private LinearLayout llMessage;
        private ImageView ivCallIcon;

        public SelfVideoViewHolder(View itemView) {
            super(itemView);
            this.llMessage = (LinearLayout)itemView.findViewById(R.id.llMessage);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.callAgain = (TextView)itemView.findViewById(R.id.callAgain);
            this.tvDuration = (TextView)itemView.findViewById(R.id.tvDuration);
            this.ivCallIcon = (ImageView)itemView.findViewById(R.id.ivCallIcon);
        }
    }

    class QuickReplyViewHolder
    extends RecyclerView.ViewHolder {
        private RecyclerView list_qr;
        private TextView title_view_text;

        QuickReplyViewHolder(View itemView) {
            super(itemView);
            this.list_qr = (RecyclerView)itemView.findViewById(R.id.list_qr);
            this.title_view_text = (TextView)itemView.findViewById(R.id.title_view_text);
        }
    }

    class SimpleTextView
    extends RecyclerView.ViewHolder {
        private TextView tvText;

        public SimpleTextView(View itemView) {
            super(itemView);
            this.tvText = (TextView)itemView.findViewById(R.id.tvText);
        }
    }

    class ForumViewHolder
    extends RecyclerView.ViewHolder {
        private RecyclerView rvDataForm;

        ForumViewHolder(View itemView) {
            super(itemView);
            this.rvDataForm = (RecyclerView)itemView.findViewById(R.id.rvDataForm);
        }
    }

    class SelfMessageViewHolder
    extends RecyclerView.ViewHolder {
        private TextView fuguTvMsg;
        private TextView fuguTvTime;
        private RelativeLayout fuguRlImageMessage;
        private ImageView fuguIvMessageState;
        private ImageView fuguIvMsgImage;
        private ProgressBar fuguPbLoading;
        private Button fuguBtnRetry;
        private Button btnRetry;
        private Button btnCancel;
        private LinearLayout FuguLlMessageBg;
        private LinearLayout fuguLlRoot;
        private TextView tvTryAgain;
        private TextView tvCancel;
        private LinearLayout fuguLlFileRoot;
        private TextView fuguTvFileName;
        private ImageView fuguIvUpload;
        private RelativeLayout fuguRlStopUpload;
        private RelativeLayout fuguRlMessages;
        private LinearLayout fuguLlFileDetails;
        private TextView fuguTvFileSize;
        private TextView fuguTvExtension;
        private LinearLayout llRetry;
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        SelfMessageViewHolder(View itemView) {
            super(itemView);
            this.fuguLlRoot = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.FuguLlMessageBg = (LinearLayout)itemView.findViewById(R.id.llMessageBg);
            this.fuguTvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.fuguTvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.fuguRlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.fuguRlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.fuguIvMessageState = (ImageView)itemView.findViewById(R.id.ivMessageState);
            this.fuguIvMsgImage = (ImageView)itemView.findViewById(R.id.ivMsgImage);
            this.fuguPbLoading = (ProgressBar)itemView.findViewById(R.id.pbLoading);
            this.fuguBtnRetry = (Button)itemView.findViewById(R.id.btnRetry);
            this.tvTryAgain = (TextView)itemView.findViewById(R.id.tvTryAgain);
            this.tvCancel = (TextView)itemView.findViewById(R.id.tvCancel);
            this.llRetry = (LinearLayout)itemView.findViewById(R.id.llRetry);
            this.btnRetry = (Button)itemView.findViewById(R.id.btnRetry);
            this.btnCancel = (Button)itemView.findViewById(R.id.btnCancel);
            this.fuguLlFileRoot = (LinearLayout)itemView.findViewById(R.id.llFileRoot);
            this.fuguTvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.fuguIvUpload = (ImageView)itemView.findViewById(R.id.ivUpload);
            this.fuguRlStopUpload = (RelativeLayout)itemView.findViewById(R.id.rlStopUpload);
            this.fuguLlFileDetails = (LinearLayout)itemView.findViewById(R.id.llFileDetails);
            this.fuguTvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.fuguTvExtension = (TextView)itemView.findViewById(R.id.tvExtension);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
            this.rlCustomAction = (RelativeLayout)itemView.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)itemView.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)itemView.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)itemView.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)itemView.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)itemView.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)itemView.findViewById(R.id.llTextualContent);
        }
    }

    class OtherMessageViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvUserName;
        private TextView tvMsg;
        private TextView tvTime;
        private RelativeLayout rlImageMessage;
        private ImageView ivMsgImage;
        private LinearLayout llMessageBg;
        private LinearLayout llRoot;
        private LinearLayout llFileRoot;
        private TextView tvFileName;
        private ImageView ivDownload;
        private RelativeLayout rlStopDownload;
        private RelativeLayout rlMessages;
        private LinearLayout llFileDetails;
        private TextView tvFileSize;
        private TextView tvExtension;
        private RelativeLayout rlCustomAction;
        private ImageView ivActionImage;
        private TextView tvActionTitle;
        private TextView tvActionTitleDescription;
        private RecyclerView rvActionDescription;
        private RecyclerView rvActionButtons;
        private View vwActionButtonDivider;
        private LinearLayout llTextualContent;
        private ImageView messageSourceType;
        private ImageView messageSourceType1;

        OtherMessageViewHolder(View itemView) {
            super(itemView);
            this.llRoot = (LinearLayout)itemView.findViewById(R.id.llRoot);
            this.llMessageBg = (LinearLayout)itemView.findViewById(R.id.llMessageBg);
            this.tvUserName = (TextView)itemView.findViewById(R.id.tvUserName);
            this.tvMsg = (TextView)itemView.findViewById(R.id.tvMsg);
            this.tvTime = (TextView)itemView.findViewById(R.id.tvTime);
            this.rlImageMessage = (RelativeLayout)itemView.findViewById(R.id.rlImageMessage);
            this.ivMsgImage = (ImageView)itemView.findViewById(R.id.ivMsgImage);
            this.llFileRoot = (LinearLayout)itemView.findViewById(R.id.llFileRoot);
            this.tvFileName = (TextView)itemView.findViewById(R.id.tvFileName);
            this.ivDownload = (ImageView)itemView.findViewById(R.id.ivDownload);
            this.rlStopDownload = (RelativeLayout)itemView.findViewById(R.id.rlStopDownload);
            this.llFileDetails = (LinearLayout)itemView.findViewById(R.id.llFileDetails);
            this.tvFileSize = (TextView)itemView.findViewById(R.id.tvFileSize);
            this.tvExtension = (TextView)itemView.findViewById(R.id.tvExtension);
            this.rlMessages = (RelativeLayout)itemView.findViewById(R.id.rlMessages);
            this.rlCustomAction = (RelativeLayout)itemView.findViewById(R.id.layoutCustomAction);
            this.tvActionTitle = (TextView)itemView.findViewById(R.id.tvActionTitle);
            this.rvActionDescription = (RecyclerView)itemView.findViewById(R.id.rvActionDescription);
            this.rvActionButtons = (RecyclerView)itemView.findViewById(R.id.rvActionButtons);
            this.ivActionImage = (ImageView)itemView.findViewById(R.id.ivActionImage);
            this.vwActionButtonDivider = itemView.findViewById(R.id.vwActionButtonDivider);
            this.tvActionTitleDescription = (TextView)itemView.findViewById(R.id.tvActionDescription);
            this.llTextualContent = (LinearLayout)itemView.findViewById(R.id.llTextualContent);
            this.messageSourceType = (ImageView)itemView.findViewById(R.id.message_source_type);
            this.messageSourceType1 = (ImageView)itemView.findViewById(R.id.message_source_type1);
        }
    }

    class UserConcentViewHolder
    extends RecyclerView.ViewHolder {
        private TextView tvMsg;
        private RecyclerView rvActionButtons;

        public UserConcentViewHolder(View itemView) {
            super(itemView);
            this.rvActionButtons = (RecyclerView)itemView.findViewById(R.id.btn_list);
            this.tvMsg = (TextView)itemView.findViewById(R.id.text_message);
        }
    }

    public static interface OnRetryListener {
        public void onRetry(String var1, int var2, int var3, FuguFileDetails var4, String var5);

        public void onMessageRetry(String var1, int var2);

        public void onMessageCancel(String var1, int var2);

        public void onFileMessageRetry(String var1, int var2);
    }
}

