/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.support.annotation.NonNull;
import com.hippo.adapter.ListItem;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.Message;

public class EventItem
extends ListItem
implements FuguAppConstant {
    @NonNull
    private Message event;

    public EventItem(@NonNull Message event) {
        this.event = event;
    }

    @NonNull
    public Message getEvent() {
        return this.event;
    }

    @Override
    public int getType() {
        int messageType = this.event.getMessageType();
        switch (messageType) {
            case 1: 
            case 10: 
            case 12: 
            case 15: 
            case 19: {
                if (this.event.isSelf()) {
                    return 2;
                }
                return 1;
            }
            case 11: {
                if (this.event.isSelf()) {
                    if (this.event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                        return 12;
                    }
                    return 10;
                }
                if (this.event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                    return 13;
                }
                return 11;
            }
            case 14: {
                return 3;
            }
            case 16: {
                if (this.event.getValues() == null || this.event.getValues().size() == 0) {
                    return 16;
                }
                return 1;
            }
            case 17: {
                return 17;
            }
            case 18: {
                if (this.event.isSelf()) {
                    return 18;
                }
                return 19;
            }
            case -990: {
                return -990;
            }
            case 20: {
                return 20;
            }
        }
        if (this.event.isSelf()) {
            return -2;
        }
        return -1;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EventItem) {
            Message message = ((EventItem)obj).getEvent();
            try {
                if (message.getId() != null && this.getEvent().getId() != null) {
                    return message.getId().equals(this.getEvent().getId());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

