/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.hippo.R;
import com.hippo.adapter.QRCallback;
import com.hippo.model.Message;
import com.hippo.utils.Utils;
import com.hippo.utils.countrypicker.Country;
import com.hippo.utils.countrypicker.CountryPicker;
import com.hippo.utils.countrypicker.OnCountryPickerListener;
import java.util.ArrayList;
import java.util.Objects;

public class DataFormAdapter
extends RecyclerView.Adapter<QRViewHolder> {
    private static final String TAG = DataFormAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<String> arrayList;
    private QRCallback qrCallback;
    private ArrayList<Question> question = new ArrayList();
    private Message currentFormMsg;
    private FragmentManager fragmentManager;

    public DataFormAdapter(Message currentFormMsg, QRCallback qrCallback, FragmentManager fragmentManager) {
        this.currentFormMsg = currentFormMsg;
        this.qrCallback = qrCallback;
        this.fragmentManager = fragmentManager;
        this.question.clear();
        try {
            if (currentFormMsg.getContentValue() != null && currentFormMsg.getContentValue().size() > 0 && currentFormMsg.getContentValue().get(0).getQuestions() != null) {
                for (int i = 0; i < currentFormMsg.getContentValue().get(0).getQuestions().size(); ++i) {
                    if (currentFormMsg.getValues() == null || currentFormMsg.getValues().size() <= i) {
                        this.question.add(new Question(currentFormMsg.getContentValue().get(0).getQuestions().get(i), null, currentFormMsg.getContentValue().get(0).getData_type().get(i), currentFormMsg.getContentValue().get(0).getTextValue(), currentFormMsg.getContentValue().get(0).getCountryCode()));
                        return;
                    }
                    this.question.add(new Question(currentFormMsg.getContentValue().get(0).getQuestions().get(i), currentFormMsg.getValues().get(i), currentFormMsg.getContentValue().get(0).getData_type().get(i), null, null));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public QRViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        this.context = parent.getContext();
        View view = LayoutInflater.from((Context)this.context).inflate(R.layout.hippo_item_data_form, parent, false);
        return new QRViewHolder(view, new MyFormEditTextListener());
    }

    @RequiresApi(api=19)
    public void onBindViewHolder(QRViewHolder holder, int position) {
        if (Objects.equals(this.question.get((int)position).type, "phone")) {
            holder.title.setText((CharSequence)(this.question.get(position).getQuestion() + " with country code"));
            holder.title.setText((CharSequence)"Enter your phone");
            holder.title.setTextSize(2, 14.0f);
        } else {
            holder.title.setText((CharSequence)this.question.get(position).getQuestion());
        }
        try {
            if (position == 0) {
                holder.countView.setVisibility(0);
                holder.countView.setText((CharSequence)(this.question.size() + "/" + this.currentFormMsg.getContentValue().get(0).getQuestions().size()));
            } else {
                holder.countView.setVisibility(8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.question.get(position).isAnswered()) {
            holder.etInputData.setText((CharSequence)this.question.get(position).getAnswer());
            holder.etInputData.setEnabled(false);
            holder.etInputData.setFocusable(false);
            holder.etInputData.setFocusableInTouchMode(false);
            holder.etInputData.setClickable(false);
            holder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_tick));
            holder.arrowBgView.setVisibility(8);
            holder.countryView.setVisibility(8);
        } else {
            holder.etInputData.setHint((CharSequence)this.question.get(position).getQuestion());
            holder.myCustomEditTextListener.updatePosition(this.currentFormMsg, position);
            holder.etInputData.setEnabled(true);
            holder.etInputData.setSingleLine(true);
            holder.etInputData.setFocusable(true);
            holder.etInputData.setFocusableInTouchMode(true);
            holder.etInputData.setClickable(true);
            holder.actionView.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)R.drawable.hippo_ic_arrow));
            holder.arrowBgView.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)this.question.get((int)position).text)) {
                holder.etInputData.setText((CharSequence)this.question.get((int)position).text);
            }
            switch (this.question.get((int)position).type) {
                case "Number": {
                    holder.etInputData.setInputType(8194);
                    holder.etInputData.setSingleLine(true);
                    break;
                }
                case "email": {
                    holder.etInputData.setInputType(33);
                    break;
                }
                case "phone": {
                    holder.etInputData.setInputType(3);
                    holder.countryView.setVisibility(0);
                    if (!TextUtils.isEmpty((CharSequence)this.question.get((int)position).countryCode)) {
                        holder.countryView.setText((CharSequence)this.question.get((int)position).countryCode);
                        break;
                    }
                    String code = this.getDefaultCode();
                    if (!TextUtils.isEmpty((CharSequence)code)) {
                        holder.countryView.setText((CharSequence)this.getDefaultCode());
                        break;
                    }
                    holder.countryView.setText((CharSequence)"+91");
                }
            }
        }
    }

    public int getItemCount() {
        return this.question == null ? 0 : this.question.size();
    }

    public boolean isValid(String data, EditText edittext, String dataType, TextView tvError) {
        boolean isValid;
        if (data.isEmpty()) {
            tvError.setText((CharSequence)"Field can't be empty");
            tvError.setVisibility(0);
            return false;
        }
        String error = null;
        switch (dataType) {
            case "Number": {
                isValid = Utils.isNumeric(data);
                error = isValid ? null : "Enter numeric values only";
                break;
            }
            case "email": {
                isValid = Utils.isEmailValid(data);
                error = isValid ? null : "Enter valid email";
                break;
            }
            case "phone": {
                isValid = Utils.isValidPhoneNumber(data);
                error = isValid ? null : "Enter valid phone number";
                break;
            }
            default: {
                isValid = true;
            }
        }
        edittext.requestFocus();
        if (!TextUtils.isEmpty((CharSequence)error)) {
            tvError.setVisibility(0);
            tvError.setText((CharSequence)error);
        } else {
            tvError.setVisibility(8);
        }
        return isValid;
    }

    private String getDefaultCode() {
        try {
            CountryPicker countryPicker = new CountryPicker.Builder().with(this.context).build();
            return countryPicker.getCountryFromSIM().getDialCode();
        }
        catch (Exception e) {
            return "";
        }
    }

    private void openPicker(final TextView textView, final EditText editText) {
        CountryPicker countryPicker = new CountryPicker.Builder().with(this.context).sortBy(1).listener(new OnCountryPickerListener(){

            @Override
            public void onSelectCountry(Country country) {
                textView.setText((CharSequence)country.getDialCode());
                DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(country.getDialCode());
                editText.requestFocus();
            }
        }).build();
        countryPicker.showDialog(this.fragmentManager);
    }

    public class MyFormEditTextListener
    implements TextWatcher {
        private Message currentOrderItem;
        private int position;

        public void updatePosition(Message currentOrderItem, int position) {
            this.currentOrderItem = currentOrderItem;
            this.position = position;
        }

        public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
        }

        public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
            if (this.currentOrderItem != null) {
                this.currentOrderItem.setComment(charSequence.toString());
            }
        }

        public void afterTextChanged(Editable editable) {
            if (this.currentOrderItem != null) {
                DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(editable.toString());
            }
        }
    }

    public class Question {
        String question;
        String answer;
        String type;
        String text;
        String countryCode;
        boolean isAnswered;

        public Question(String question, String answer, String type, String text, String countryCode) {
            this.question = question;
            this.answer = answer;
            this.type = type;
            this.text = text;
            this.countryCode = countryCode;
            if (!TextUtils.isEmpty((CharSequence)answer)) {
                this.isAnswered = true;
            }
        }

        public String getQuestion() {
            return this.question;
        }

        public void setQuestion(String question) {
            this.question = question;
        }

        public String getAnswer() {
            return this.answer;
        }

        public void setAnswer(String answer) {
            this.answer = answer;
        }

        public boolean isAnswered() {
            return this.isAnswered;
        }

        public void setAnswered(boolean answered) {
            this.isAnswered = answered;
        }
    }

    public class QRViewHolder
    extends RecyclerView.ViewHolder {
        public MyFormEditTextListener myCustomEditTextListener;
        ImageView actionView;
        ImageView arrowBgView;
        private EditText etInputData;
        private TextView tvError;
        private TextView title;
        private TextView countView;
        private TextView countryView;

        public QRViewHolder(View itemView, MyFormEditTextListener myCustomEditTextListener) {
            super(itemView);
            this.etInputData = (EditText)itemView.findViewById(R.id.etInputData);
            this.myCustomEditTextListener = myCustomEditTextListener;
            this.etInputData.addTextChangedListener((TextWatcher)myCustomEditTextListener);
            this.title = (TextView)itemView.findViewById(R.id.title_view);
            this.tvError = (TextView)itemView.findViewById(R.id.tvError);
            this.countView = (TextView)itemView.findViewById(R.id.count_view);
            this.countryView = (TextView)itemView.findViewById(R.id.country_picker);
            this.actionView = (ImageView)itemView.findViewById(R.id.action_view);
            this.arrowBgView = (ImageView)itemView.findViewById(R.id.arrow_background_view);
            this.actionView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (DataFormAdapter.this.isValid(DataFormAdapter.this.currentFormMsg.getComment(), QRViewHolder.this.etInputData, ((Question)((DataFormAdapter)DataFormAdapter.this).question.get((int)QRViewHolder.this.getAdapterPosition())).type, QRViewHolder.this.tvError)) {
                        if (QRViewHolder.this.countryView.getVisibility() == 0) {
                            String message = DataFormAdapter.this.currentFormMsg.getComment();
                            DataFormAdapter.this.currentFormMsg.setComment(QRViewHolder.this.countryView.getText().toString().trim() + message);
                        }
                        DataFormAdapter.this.qrCallback.onFormClickListener(QRViewHolder.this.getAdapterPosition(), DataFormAdapter.this.currentFormMsg);
                        DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setTextValue(null);
                        DataFormAdapter.this.currentFormMsg.getContentValue().get(0).setCountryCode(null);
                    }
                }
            });
            this.countryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    DataFormAdapter.this.openPicker(QRViewHolder.this.countryView, QRViewHolder.this.etInputData);
                }
            });
        }
    }
}

