/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.activity.FuguChatActivity;
import com.hippo.database.CommonData;
import com.hippo.model.ActionButtonModel;
import com.hippo.support.Utils.Constants;
import java.util.ArrayList;

public class CustomActionButtonsAdapter
extends RecyclerView.Adapter<ActionButtonViewHolder> {
    private Context mContext;
    private LayoutInflater mLayoutInflater;
    private ArrayList<ActionButtonModel> mActionButtons;
    private boolean disAbleClick;
    private HippoColorConfig hippoColorConfig;

    public CustomActionButtonsAdapter(Context context, ArrayList<ActionButtonModel> actionButtons) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mActionButtons = actionButtons;
    }

    public CustomActionButtonsAdapter(Context context, ArrayList<ActionButtonModel> actionButtons, boolean disAbleClick) {
        this.mContext = context;
        this.mLayoutInflater = LayoutInflater.from((Context)context);
        this.mActionButtons = actionButtons;
        this.disAbleClick = disAbleClick;
        this.hippoColorConfig = CommonData.getColorConfig();
    }

    public ActionButtonViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View main = this.mLayoutInflater.inflate(R.layout.hippo_list_item_action_button, parent, false);
        return new ActionButtonViewHolder(main);
    }

    public void onBindViewHolder(ActionButtonViewHolder holder, int position) {
        int pos = holder.getAdapterPosition();
        ActionButtonModel actionButton = this.mActionButtons.get(pos);
        holder.btnAction.setText((CharSequence)actionButton.getButtonText());
    }

    public int getItemCount() {
        return this.mActionButtons.size();
    }

    class ActionButtonViewHolder
    extends RecyclerView.ViewHolder {
        AppCompatButton btnAction;
        RelativeLayout rlButton;

        ActionButtonViewHolder(View itemView) {
            super(itemView);
            this.btnAction = (AppCompatButton)itemView.findViewById(R.id.btnAction);
            this.rlButton = (RelativeLayout)itemView.findViewById(R.id.rl_button);
            this.btnAction.setTextColor(CustomActionButtonsAdapter.this.hippoColorConfig.getHippoActionBarText());
            int radius = (int)Constants.convertDpToPixel(1.0f);
            GradientDrawable drawable2 = (GradientDrawable)this.rlButton.getBackground();
            drawable2.setStroke(radius, CustomActionButtonsAdapter.this.hippoColorConfig.getHippoActionBarText());
            drawable2.setColor(CustomActionButtonsAdapter.this.hippoColorConfig.getHippoActionBarBg());
            this.btnAction.setEnabled(!CustomActionButtonsAdapter.this.disAbleClick);
            this.btnAction.setClickable(!CustomActionButtonsAdapter.this.disAbleClick);
            this.btnAction.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!CustomActionButtonsAdapter.this.disAbleClick) {
                        ((FuguChatActivity)CustomActionButtonsAdapter.this.mContext).onCustomActionClicked(((ActionButtonModel)CustomActionButtonsAdapter.this.mActionButtons.get(ActionButtonViewHolder.this.getAdapterPosition())).getButtonAction());
                    }
                }
            });
        }
    }
}

