/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.activity;

import android.animation.ObjectAnimator;
import android.app.DownloadManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.util.Property;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.hippo.R;
import com.hippo.activity.FuguBaseActivity;
import com.hippo.agent.database.AgentCommonData;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.Image;
import com.hippo.utils.filepicker.Util;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.hippo.utils.zoomview.ZoomageView;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class ImageDisplayActivity
extends FuguBaseActivity {
    private static final String TAG = ImageDisplayActivity.class.getSimpleName();
    private String imageUrl = "";
    ImageView ivImage;
    ImageView ivDownload;
    LinearLayout llTopBar;
    TextView tvDateTime;
    ZoomageView ivOriginalImage;
    ProgressWheel progressWheel;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.hippo_activity_image_display);
        this.progressWheel = (ProgressWheel)this.findViewById(R.id.progress);
        this.progressWheel.spin();
        this.ivImage = (ImageView)this.findViewById(R.id.ivMsgImage);
        this.ivDownload = (ImageView)this.findViewById(R.id.ivDownload);
        this.ivOriginalImage = (ZoomageView)this.findViewById(R.id.ivOriginalImage);
        this.llTopBar = (LinearLayout)this.findViewById(R.id.llTopBar);
        TextView tvChannelName = (TextView)this.findViewById(R.id.tvChannelName);
        this.tvDateTime = (TextView)this.findViewById(R.id.tvDateTime);
        ImageView ivBack = (ImageView)this.findViewById(R.id.ivBack);
        final Image image = (Image)this.getIntent().getSerializableExtra("image");
        if (!TextUtils.isEmpty((CharSequence)image.getChannelName())) {
            tvChannelName.setText((CharSequence)image.getChannelName());
        } else {
            tvChannelName.setText((CharSequence)"Message");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM, hh:mm a");
        SimpleDateFormat formatter2 = new SimpleDateFormat("hh:mm a");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.ENGLISH);
        try {
            String date = formatter.format(sdf.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime())));
            if (DateUtils.isToday((long)sdf.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime())).getTime())) {
                String time = formatter2.format(sdf.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime())));
                this.tvDateTime.setText((CharSequence)("Today, " + time));
            } else {
                this.tvDateTime.setText((CharSequence)formatter.format(sdf.parse(com.hippo.utils.DateUtils.getInstance().convertToLocal(image.getDateTime()))));
            }
        }
        catch (Exception e) {
            this.tvDateTime.setVisibility(8);
        }
        ivBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageDisplayActivity.this.onBackPressed();
            }
        });
        this.ivDownload.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageDisplayActivity.this.downloadFile(image.getImageUrl());
            }
        });
        new RequestOptions();
        RequestOptions requestOptions = RequestOptions.placeholderOf((int)R.drawable.hippo_placeholder).dontAnimate().onlyRetrieveFromCache(true).diskCacheStrategy(DiskCacheStrategy.ALL).error(R.drawable.hippo_call_placeholder).dontTransform();
        final RequestOptions requestOptions2 = new RequestOptions().dontAnimate().diskCacheStrategy(DiskCacheStrategy.ALL).error(R.drawable.hippo_call_placeholder).dontTransform();
        Glide.with((FragmentActivity)this).load(image.getThumbnailUrl()).apply(requestOptions).into((Target)new SimpleTarget<Drawable>(){

            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                ImageDisplayActivity.this.supportStartPostponedEnterTransition();
                ImageDisplayActivity.this.ivImage.setImageDrawable(resource);
                ImageDisplayActivity.this.progressWheel.setVisibility(8);
                new ObjectAnimator();
                ObjectAnimator alphaAnimation = ObjectAnimator.ofFloat((Object)ImageDisplayActivity.this.llTopBar, (Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
                alphaAnimation.setDuration(500L);
                alphaAnimation.setStartDelay(200L);
                alphaAnimation.start();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Glide.with((FragmentActivity)ImageDisplayActivity.this).load(image.getImageUrl()).apply(requestOptions2).into((Target)new SimpleTarget<Drawable>(){

                            public void onResourceReady(@NonNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                                ImageDisplayActivity.this.supportStartPostponedEnterTransition();
                                ImageDisplayActivity.this.ivImage.setVisibility(8);
                                ImageDisplayActivity.this.ivOriginalImage.setImageDrawable(resource);
                            }
                        });
                    }
                }, 500L);
            }
        });
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private Long downloadFile(String url) {
        String fileName = Util.extractFileNameWithoutSuffix(url);
        String ext = Util.getExtension(url);
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)url));
        if (AgentCommonData.isAgentFlow()) {
            request.setDescription((CharSequence)AgentCommonData.getUserData().getBusinessName());
        } else {
            request.setDescription((CharSequence)CommonData.getUserDetails().getData().getBusinessName());
        }
        request.setTitle((CharSequence)fileName);
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        String directory = Util.getOrCreateDirectoryPath(FuguAppConstant.DocumentType.IMAGE.toString());
        request.setDestinationInExternalPublicDir(directory, fileName + ext);
        request.setMimeType("image/jpeg");
        DownloadManager manager = (DownloadManager)this.getSystemService("download");
        if (manager != null) {
            return manager.enqueue(request);
        }
        return null;
    }
}

