/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils.filepicker;

import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.os.CancellationSignal;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.DocumentsProvider;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.hippo.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@RequiresApi(api=19)
public class LocalStorageProvider
extends DocumentsProvider {
    private static final String[] a = new String[]{"root_id", "flags", "title", "document_id", "icon", "available_bytes"};
    private static final String[] b = new String[]{"document_id", "_display_name", "flags", "mime_type", "_size", "last_modified"};

    public Cursor queryRoots(String[] stringArray) throws FileNotFoundException {
        MatrixCursor matrixCursor = new MatrixCursor(stringArray != null ? stringArray : a);
        File file = Environment.getExternalStorageDirectory();
        MatrixCursor.RowBuilder rowBuilder = matrixCursor.newRow();
        rowBuilder.add("root_id", (Object)file.getAbsolutePath());
        rowBuilder.add("document_id", (Object)file.getAbsolutePath());
        rowBuilder.add("title", (Object)this.getContext().getString(R.string.hippo_select_string));
        rowBuilder.add("flags", (Object)3);
        rowBuilder.add("icon", (Object)R.drawable.hippo_ic_photo_icon);
        rowBuilder.add("available_bytes", (Object)file.getFreeSpace());
        return matrixCursor;
    }

    public String createDocument(String string2, String string3, String string4) throws FileNotFoundException {
        File file = new File(string2, string4);
        try {
            file.createNewFile();
            return file.getAbsolutePath();
        }
        catch (IOException iOException) {
            Log.e((String)LocalStorageProvider.class.getSimpleName(), (String)("Error creating new file " + file));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AssetFileDescriptor openDocumentThumbnail(String string2, Point point, CancellationSignal cancellationSignal) throws FileNotFoundException {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        int n2 = 2 * point.y;
        int n3 = 2 * point.x;
        int n4 = options.outHeight;
        int n5 = options.outWidth;
        options.inSampleSize = 1;
        if (n4 > n2 || n5 > n3) {
            int n6 = n4 / 2;
            int n7 = n5 / 2;
            while (n6 / options.inSampleSize > n2 || n7 / options.inSampleSize > n3) {
                options.inSampleSize *= 2;
            }
        }
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        File file = null;
        FileOutputStream fileOutputStream = null;
        try {
            file = File.createTempFile("thumbnail", null, this.getContext().getCacheDir());
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)fileOutputStream);
        }
        catch (IOException iOException) {
            Log.e((String)LocalStorageProvider.class.getSimpleName(), (String)"Error writing thumbnail", (Throwable)iOException);
            AssetFileDescriptor assetFileDescriptor = null;
            return assetFileDescriptor;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)LocalStorageProvider.class.getSimpleName(), (String)"Error closing thumbnail", (Throwable)iOException);
                }
            }
        }
        return new AssetFileDescriptor(ParcelFileDescriptor.open((File)file, (int)0x10000000), 0L, -1L);
    }

    public Cursor queryChildDocuments(String string2, String[] stringArray, String string3) throws FileNotFoundException {
        MatrixCursor matrixCursor = new MatrixCursor(stringArray != null ? stringArray : b);
        File file = new File(string2);
        for (File file2 : file.listFiles()) {
            if (file2.getName().startsWith(".")) continue;
            this.a(matrixCursor, file2);
        }
        return matrixCursor;
    }

    public Cursor queryDocument(String string2, String[] stringArray) throws FileNotFoundException {
        MatrixCursor matrixCursor = new MatrixCursor(stringArray != null ? stringArray : b);
        this.a(matrixCursor, new File(string2));
        return matrixCursor;
    }

    private void a(MatrixCursor matrixCursor, File file) throws FileNotFoundException {
        int n2;
        MatrixCursor.RowBuilder rowBuilder = matrixCursor.newRow();
        rowBuilder.add("document_id", (Object)file.getAbsolutePath());
        rowBuilder.add("_display_name", (Object)file.getName());
        String string2 = this.getDocumentType(file.getAbsolutePath());
        rowBuilder.add("mime_type", (Object)string2);
        int n3 = n2 = file.canWrite() ? 6 : 0;
        if (string2.startsWith("image/")) {
            n2 |= 1;
        }
        rowBuilder.add("flags", (Object)n2);
        rowBuilder.add("_size", (Object)file.length());
        rowBuilder.add("last_modified", (Object)file.lastModified());
    }

    public String getDocumentType(String string2) throws FileNotFoundException {
        File file = new File(string2);
        if (file.isDirectory()) {
            return "vnd.android.document/directory";
        }
        int n2 = file.getName().lastIndexOf(46);
        if (n2 >= 0) {
            String string3 = file.getName().substring(n2 + 1);
            String string4 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string3);
            if (string4 != null) {
                return string4;
            }
        }
        return "application/octet-stream";
    }

    public void deleteDocument(String string2) throws FileNotFoundException {
        new File(string2).delete();
    }

    public ParcelFileDescriptor openDocument(String string2, String string3, CancellationSignal cancellationSignal) throws FileNotFoundException {
        boolean bl;
        File file = new File(string2);
        boolean bl2 = bl = string3.indexOf(119) != -1;
        if (bl) {
            return ParcelFileDescriptor.open((File)file, (int)0x30000000);
        }
        return ParcelFileDescriptor.open((File)file, (int)0x10000000);
    }

    public boolean onCreate() {
        return true;
    }
}

