/*
 * Decompiled with CFR 0.152.
 */
package com.hippo.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import com.hippo.R;

public class SelectableRoundedImageView
extends ImageView {
    private int a = 0;
    private static final ImageView.ScaleType[] b = new ImageView.ScaleType[]{ImageView.ScaleType.MATRIX, ImageView.ScaleType.FIT_XY, ImageView.ScaleType.FIT_START, ImageView.ScaleType.FIT_CENTER, ImageView.ScaleType.FIT_END, ImageView.ScaleType.CENTER, ImageView.ScaleType.CENTER_CROP, ImageView.ScaleType.CENTER_INSIDE};
    private ImageView.ScaleType c = ImageView.ScaleType.FIT_CENTER;
    private float d = 0.0f;
    private float e = 0.0f;
    private float f = 0.0f;
    private float g = 0.0f;
    private float h = 0.0f;
    private ColorStateList i = ColorStateList.valueOf((int)-16777216);
    private boolean j = false;
    private Drawable k;
    private float[] l = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};

    public SelectableRoundedImageView(Context context) {
        super(context);
    }

    public SelectableRoundedImageView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public SelectableRoundedImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SelectableRoundedImageView, n2, 0);
        int n3 = typedArray.getInt(R.styleable.SelectableRoundedImageView_android_scaleType, -1);
        if (n3 >= 0) {
            this.setScaleType(b[n3]);
        }
        this.d = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_left_top_corner_radius, 0);
        this.e = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_right_top_corner_radius, 0);
        this.f = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_left_bottom_corner_radius, 0);
        this.g = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_right_bottom_corner_radius, 0);
        if (this.d < 0.0f || this.e < 0.0f || this.f < 0.0f || this.g < 0.0f) {
            throw new IllegalArgumentException("radius values cannot be negative.");
        }
        this.l = new float[]{this.d, this.d, this.e, this.e, this.g, this.g, this.f, this.f};
        this.h = typedArray.getDimensionPixelSize(R.styleable.SelectableRoundedImageView_sriv_border_width, 0);
        if (this.h < 0.0f) {
            throw new IllegalArgumentException("border width cannot be negative.");
        }
        this.i = typedArray.getColorStateList(R.styleable.SelectableRoundedImageView_sriv_border_color);
        if (this.i == null) {
            this.i = ColorStateList.valueOf((int)-16777216);
        }
        this.j = typedArray.getBoolean(R.styleable.SelectableRoundedImageView_sriv_oval, false);
        typedArray.recycle();
        this.b();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }

    public ImageView.ScaleType getScaleType() {
        return this.c;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        super.setScaleType(scaleType);
        this.c = scaleType;
        this.b();
    }

    public void setImageDrawable(Drawable drawable2) {
        this.a = 0;
        this.k = com.hippo.utils.SelectableRoundedImageView$a.a(drawable2, this.getResources());
        super.setImageDrawable(this.k);
        this.b();
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.a = 0;
        this.k = com.hippo.utils.SelectableRoundedImageView$a.a(bitmap, this.getResources());
        super.setImageDrawable(this.k);
        this.b();
    }

    public void setImageResource(int n2) {
        if (this.a != n2) {
            this.a = n2;
            this.k = this.a();
            super.setImageDrawable(this.k);
            this.b();
        }
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.setImageDrawable(this.getDrawable());
    }

    private Drawable a() {
        Resources resources = this.getResources();
        if (resources == null) {
            return null;
        }
        Drawable drawable2 = null;
        if (this.a != 0) {
            try {
                drawable2 = resources.getDrawable(this.a);
            }
            catch (Resources.NotFoundException notFoundException) {
                Log.w((String)"SelectableRoundedImageView", (String)("Unable to find resource: " + this.a), (Throwable)notFoundException);
                this.a = 0;
            }
        }
        return com.hippo.utils.SelectableRoundedImageView$a.a(drawable2, this.getResources());
    }

    private void b() {
        if (this.k == null) {
            return;
        }
        ((a)this.k).a(this.c);
        ((a)this.k).a(this.l);
        ((a)this.k).a(this.h);
        ((a)this.k).a(this.i);
        ((a)this.k).a(this.j);
    }

    public float getCornerRadius() {
        return this.d;
    }

    public float getBorderWidth() {
        return this.h;
    }

    public void setBorderWidthDP(float f2) {
        float f3 = this.getResources().getDisplayMetrics().density * f2;
        if (this.h == f3) {
            return;
        }
        this.h = f3;
        this.b();
        this.invalidate();
    }

    public int getBorderColor() {
        return this.i.getDefaultColor();
    }

    public void setBorderColor(int n2) {
        this.setBorderColor(ColorStateList.valueOf((int)n2));
    }

    public ColorStateList getBorderColors() {
        return this.i;
    }

    public void setBorderColor(ColorStateList colorStateList) {
        if (this.i.equals(colorStateList)) {
            return;
        }
        this.i = colorStateList != null ? colorStateList : ColorStateList.valueOf((int)-16777216);
        this.b();
        if (this.h > 0.0f) {
            this.invalidate();
        }
    }

    public void setOval(boolean bl) {
        this.j = bl;
        this.b();
        this.invalidate();
    }

    static class a
    extends Drawable {
        private RectF a = new RectF();
        private RectF b = new RectF();
        private final RectF c = new RectF();
        private final int d;
        private final int e;
        private final Paint f;
        private final Paint g;
        private BitmapShader h;
        private float[] i = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private float[] j = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        private boolean k = false;
        private float l = 0.0f;
        private ColorStateList m = ColorStateList.valueOf((int)-16777216);
        private ImageView.ScaleType n = ImageView.ScaleType.FIT_CENTER;
        private Path o = new Path();
        private Bitmap p;
        private boolean q = false;

        public a(Bitmap bitmap, Resources resources) {
            this.p = bitmap;
            this.h = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            if (bitmap != null) {
                this.d = bitmap.getScaledWidth(resources.getDisplayMetrics());
                this.e = bitmap.getScaledHeight(resources.getDisplayMetrics());
            } else {
                this.e = -1;
                this.d = -1;
            }
            this.c.set(0.0f, 0.0f, (float)this.d, (float)this.e);
            this.f = new Paint(1);
            this.f.setStyle(Paint.Style.FILL);
            this.f.setShader((Shader)this.h);
            this.g = new Paint(1);
            this.g.setStyle(Paint.Style.STROKE);
            this.g.setColor(this.m.getColorForState(this.getState(), -16777216));
            this.g.setStrokeWidth(this.l);
        }

        public static a a(Bitmap bitmap, Resources resources) {
            if (bitmap != null) {
                return new a(bitmap, resources);
            }
            return null;
        }

        public static Drawable a(Drawable drawable2, Resources resources) {
            if (drawable2 != null) {
                if (drawable2 instanceof a) {
                    return drawable2;
                }
                if (drawable2 instanceof LayerDrawable) {
                    LayerDrawable layerDrawable = (LayerDrawable)drawable2;
                    int n2 = layerDrawable.getNumberOfLayers();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Drawable drawable3 = layerDrawable.getDrawable(i2);
                        layerDrawable.setDrawableByLayerId(layerDrawable.getId(i2), com.hippo.utils.SelectableRoundedImageView$a.a(drawable3, resources));
                    }
                    return layerDrawable;
                }
                Bitmap bitmap = com.hippo.utils.SelectableRoundedImageView$a.a(drawable2);
                if (bitmap != null) {
                    return new a(bitmap, resources);
                }
                Log.w((String)"SelectableRoundedCornerDrawable", (String)"Failed to create bitmap from drawable!");
            }
            return drawable2;
        }

        public static Bitmap a(Drawable drawable2) {
            Bitmap bitmap;
            if (drawable2 == null) {
                return null;
            }
            if (drawable2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)drawable2).getBitmap();
            }
            int n2 = Math.max(drawable2.getIntrinsicWidth(), 2);
            int n3 = Math.max(drawable2.getIntrinsicHeight(), 2);
            try {
                bitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas = new Canvas(bitmap);
                drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                drawable2.draw(canvas);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                bitmap = null;
            }
            return bitmap;
        }

        public boolean isStateful() {
            return this.m.isStateful();
        }

        protected boolean onStateChange(int[] nArray) {
            int n2 = this.m.getColorForState(nArray, 0);
            if (this.g.getColor() != n2) {
                this.g.setColor(n2);
                return true;
            }
            return super.onStateChange(nArray);
        }

        private void a(Canvas canvas) {
            Rect rect = canvas.getClipBounds();
            Matrix matrix = canvas.getMatrix();
            if (ImageView.ScaleType.CENTER == this.n) {
                this.a.set(rect);
            } else if (ImageView.ScaleType.CENTER_CROP == this.n) {
                this.a(matrix);
                this.a.set(rect);
            } else if (ImageView.ScaleType.FIT_XY == this.n) {
                Matrix matrix2 = new Matrix();
                matrix2.setRectToRect(this.c, new RectF(rect), Matrix.ScaleToFit.FILL);
                this.h.setLocalMatrix(matrix2);
                this.a.set(rect);
            } else if (ImageView.ScaleType.FIT_START == this.n || ImageView.ScaleType.FIT_END == this.n || ImageView.ScaleType.FIT_CENTER == this.n || ImageView.ScaleType.CENTER_INSIDE == this.n) {
                this.a(matrix);
                this.a.set(this.c);
            } else if (ImageView.ScaleType.MATRIX == this.n) {
                this.a(matrix);
                this.a.set(this.c);
            }
        }

        private void a(Matrix matrix) {
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            for (int i2 = 0; i2 < this.i.length; ++i2) {
                this.i[i2] = this.i[i2] / fArray[0];
            }
        }

        private void b(Canvas canvas) {
            Matrix matrix = canvas.getMatrix();
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            float f2 = fArray[0];
            float f3 = fArray[4];
            float f4 = fArray[2];
            float f5 = fArray[5];
            float f6 = this.a.width() / (this.a.width() + this.l + this.l);
            float f7 = this.a.height() / (this.a.height() + this.l + this.l);
            canvas.scale(f6, f7);
            if (ImageView.ScaleType.FIT_START == this.n || ImageView.ScaleType.FIT_END == this.n || ImageView.ScaleType.FIT_XY == this.n || ImageView.ScaleType.FIT_CENTER == this.n || ImageView.ScaleType.CENTER_INSIDE == this.n || ImageView.ScaleType.MATRIX == this.n) {
                canvas.translate(this.l, this.l);
            } else if (ImageView.ScaleType.CENTER == this.n || ImageView.ScaleType.CENTER_CROP == this.n) {
                canvas.translate(-f4 / (f6 * f2), -f5 / (f7 * f3));
                canvas.translate(-(this.a.left - this.l), -(this.a.top - this.l));
            }
        }

        private void c(Canvas canvas) {
            Matrix matrix = canvas.getMatrix();
            float[] fArray = new float[9];
            matrix.getValues(fArray);
            float f2 = fArray[0];
            float f3 = this.a.width() * f2;
            this.l = this.l * this.a.width() / (f3 - 2.0f * this.l);
            this.g.setStrokeWidth(this.l);
            this.b.set(this.a);
            this.b.inset(-this.l / 2.0f, -this.l / 2.0f);
        }

        private void a() {
            for (int i2 = 0; i2 < this.i.length; ++i2) {
                if (!(this.i[i2] > 0.0f)) continue;
                this.j[i2] = this.i[i2];
                this.i[i2] = this.i[i2] - this.l;
            }
        }

        public void draw(Canvas canvas) {
            canvas.save();
            if (!this.q) {
                this.a(canvas);
                if (this.l > 0.0f) {
                    this.c(canvas);
                    this.a();
                }
                this.q = true;
            }
            if (this.k) {
                if (this.l > 0.0f) {
                    this.b(canvas);
                    this.o.addOval(this.a, Path.Direction.CW);
                    canvas.drawPath(this.o, this.f);
                    this.o.reset();
                    this.o.addOval(this.b, Path.Direction.CW);
                    canvas.drawPath(this.o, this.g);
                } else {
                    this.o.addOval(this.a, Path.Direction.CW);
                    canvas.drawPath(this.o, this.f);
                }
            } else if (this.l > 0.0f) {
                this.b(canvas);
                this.o.addRoundRect(this.a, this.i, Path.Direction.CW);
                canvas.drawPath(this.o, this.f);
                this.o.reset();
                this.o.addRoundRect(this.b, this.j, Path.Direction.CW);
                canvas.drawPath(this.o, this.g);
            } else {
                this.o.addRoundRect(this.a, this.i, Path.Direction.CW);
                canvas.drawPath(this.o, this.f);
            }
            canvas.restore();
        }

        public void a(float[] fArray) {
            if (fArray == null) {
                return;
            }
            if (fArray.length != 8) {
                throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
            }
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                this.i[i2] = fArray[i2];
            }
        }

        public int getOpacity() {
            return this.p == null || this.p.hasAlpha() || this.f.getAlpha() < 255 ? -3 : -1;
        }

        public void setAlpha(int n2) {
            this.f.setAlpha(n2);
            this.invalidateSelf();
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.f.setColorFilter(colorFilter);
            this.invalidateSelf();
        }

        public void setDither(boolean bl) {
            this.f.setDither(bl);
            this.invalidateSelf();
        }

        public void setFilterBitmap(boolean bl) {
            this.f.setFilterBitmap(bl);
            this.invalidateSelf();
        }

        public int getIntrinsicWidth() {
            return this.d;
        }

        public int getIntrinsicHeight() {
            return this.e;
        }

        public void a(float f2) {
            this.l = f2;
            this.g.setStrokeWidth(f2);
        }

        public void a(ColorStateList colorStateList) {
            if (colorStateList == null) {
                this.l = 0.0f;
                this.m = ColorStateList.valueOf((int)0);
                this.g.setColor(0);
            } else {
                this.m = colorStateList;
                this.g.setColor(this.m.getColorForState(this.getState(), -16777216));
            }
        }

        public void a(boolean bl) {
            this.k = bl;
        }

        public void a(ImageView.ScaleType scaleType) {
            if (scaleType == null) {
                return;
            }
            this.n = scaleType;
        }
    }
}

