/*
 * Decompiled with CFR 0.152.
 */
package com.hippo;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.media.AudioAttributes;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.hippo.CallData;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.a;
import com.hippo.activity.FuguChannelsActivity;
import com.hippo.activity.FuguChatActivity;
import com.hippo.agent.AgentChatActivity;
import com.hippo.agent.AgentListActivity;
import com.hippo.agent.Util.FragmentType;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.FuguConversation;
import com.hippo.model.UnreadCountModel;
import com.hippo.retrofit.b;
import com.hippo.retrofit.c;
import com.hippo.retrofit.f;
import com.hippo.retrofit.g;
import com.hippo.service.FuguPushIntentService;
import com.hippo.utils.d;
import io.paperdb.Paper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Callback;

public class HippoNotificationConfig
implements FuguAppConstant {
    private static final String TAG = HippoNotificationConfig.class.getSimpleName();
    public static final String CHANNEL_ONE_ID = "com.hippo.ONE";
    public static Long pushChannelId = -1L;
    public static Long pushLabelId = -1L;
    public static Long agentPushChannelId = -1L;
    public static boolean isChannelActivityOnPause = false;
    public static final String CHANNEL_ONE_NAME = "Default notification";
    private boolean notificationSoundEnabled = true;
    private int smallIcon = -1;
    private int largeIcon;
    private int priority;
    private static NotificationManager notificationManager;

    public void setNotificationSoundEnabled(boolean bl) {
        this.notificationSoundEnabled = bl;
    }

    public void setSmallIcon(int n2) {
        this.smallIcon = n2;
    }

    public void setLargeIcon(int n2) {
        this.largeIcon = n2;
    }

    public void setPriority(int n2) {
        this.priority = n2;
    }

    public boolean isFuguNotification(Map<String, String> map) {
        return map.containsKey("push_source") && map.get("push_source").equalsIgnoreCase("FUGU");
    }

    public boolean isHippoCallNotification(Map<String, String> map) {
        if (map.containsKey("push_source") && map.get("push_source").equalsIgnoreCase("FUGU")) {
            try {
                JSONObject jSONObject = new JSONObject(map.get("message"));
                try {
                    if (com.hippo.database.a.I() && jSONObject.optInt("notification_type") == 14 && (jSONObject.optString("video_call_type").equalsIgnoreCase("START_CALL") || jSONObject.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                        return true;
                    }
                    if (jSONObject.optInt("notification_type") == 14) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return false;
        }
        return false;
    }

    public static void handleHippoPushNotification(final Context context, final Bundle bundle) {
        if (bundle == null) {
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (com.hippo.agent.database.a.c()) {
                    com.hippo.agent.model.d.a a2 = (com.hippo.agent.model.d.a)new Gson().fromJson(bundle.getString("conversation"), com.hippo.agent.model.d.a.class);
                    if (a2 != null && HippoConfig.getInstance() != null && !HippoConfig.getInstance().isDataCleared()) {
                        Intent intent = new Intent(context, AgentChatActivity.class);
                        if (a2.f() < 0L) {
                            intent = new Intent(context, AgentListActivity.class);
                        }
                        intent.putExtra("fragment_type", FragmentType.MY_CHAT.getOrdinal());
                        intent.putExtra("conversation", new Gson().toJson((Object)a2, com.hippo.agent.model.d.a.class));
                        context.startActivity(intent);
                    }
                } else {
                    FuguConversation fuguConversation = (FuguConversation)new Gson().fromJson(bundle.getString("conversation"), FuguConversation.class);
                    if (fuguConversation != null && fuguConversation.isStartChannelsActivity() && HippoConfig.getInstance() != null && !HippoConfig.getInstance().isDataCleared()) {
                        d.c(TAG, "conversation: " + new Gson().toJson((Object)fuguConversation));
                        Intent intent = new Intent(context, FuguChatActivity.class);
                        if (fuguConversation.getChannelId() < 0L && fuguConversation.getLabelId() < 0L) {
                            intent = new Intent(context, FuguChannelsActivity.class);
                        }
                        intent.putExtra("conversation", new Gson().toJson((Object)fuguConversation, FuguConversation.class));
                        context.startActivity(intent);
                    }
                }
            }
        }, 1000L);
    }

    public static void cancelNotification(Context context, int n2) {
        String string2 = "notification";
        NotificationManager notificationManager = (NotificationManager)context.getSystemService(string2);
        notificationManager.cancel(n2);
    }

    public void showNotification(Context context, Map<String, String> map) {
        Paper.init((Context)context);
        if (com.hippo.agent.database.a.c()) {
            this.showAgentNotification(context, map);
        } else {
            this.showUserNotification(context, map);
        }
    }

    private void showAgentNotification(Context context, Map<String, String> map) {
        AudioAttributes audioAttributes;
        JSONObject jSONObject;
        d.c(TAG, "Init time: " + new Date());
        try {
            int n6;
            jSONObject = new JSONObject(map.get("message"));
            d.c(TAG, "Push message: " + map.get("message"));
            try {
                if (com.hippo.database.a.I() && jSONObject.optInt("notification_type") == 14 && (jSONObject.optString("video_call_type").equalsIgnoreCase("START_CALL") || jSONObject.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                    if (HippoConfig.getInstance().getCallData() != null) {
                        HippoConfig.getInstance().getCallData().onNotificationReceived(context, jSONObject);
                    } else {
                        String string2 = new Gson().toJson((Object)jSONObject);
                        Intent intent = new Intent();
                        intent.putExtra("FUGU_CUSTOM_ACTION_PAYLOAD", string2);
                        intent.setAction("hippo_call_notification_data");
                        context.sendBroadcast(intent);
                    }
                    return;
                }
                if (jSONObject.optInt("notification_type") == 14) {
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            audioAttributes = new Intent("notification_received");
            Bundle bundle = new Bundle();
            for (String object2 : map.keySet()) {
                bundle.putString(object2, map.get(object2));
            }
            audioAttributes.putExtras(bundle);
            LocalBroadcastManager.getInstance((Context)context).sendBroadcast((Intent)audioAttributes);
            int n3 = jSONObject.optInt("disable_reply", 0);
            Long l2 = jSONObject.optLong("channel_id", -1L);
            String string2 = jSONObject.optString("label", "");
            if (l2 > 0L && agentPushChannelId.compareTo(l2) == 0 && !isChannelActivityOnPause) {
                return;
            }
            Intent intent = new Intent(context, FuguPushIntentService.class);
            intent.putExtra("channelId", (Serializable)l2);
            intent.putExtra("label", string2);
            intent.putExtra("userId", (Serializable)com.hippo.agent.database.a.b().f());
            intent.putExtra("is_from_push", true);
            intent.putExtra("disable_reply", n3);
            Bundle bundle2 = new Bundle();
            for (String n4 : map.keySet()) {
                bundle2.putString(n4, map.get(n4));
            }
            intent.putExtra("data", bundle2);
            if (com.hippo.database.a.c() != -1) {
                intent.setFlags(com.hippo.database.a.c());
            }
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)l2.intValue(), (Intent)intent, (int)0);
            int n2 = -1;
            if (!this.notificationSoundEnabled) {
                n2 = 4;
            }
            String string3 = jSONObject.optString("date_time", "");
            String string4 = "com.hippo.ONE." + l2;
            String string5 = CHANNEL_ONE_NAME + l2;
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, string4);
            builder.setAutoCancel(true);
            builder.setContentTitle((CharSequence)jSONObject.getString("title"));
            builder.setContentIntent(pendingIntent);
            builder.setDefaults(1);
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)jSONObject.getString("new_message")));
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                builder.setWhen(HippoNotificationConfig.getTimeMilliSec(com.hippo.utils.a.a().a(string3)));
            }
            builder.setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon);
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon));
            builder.setContentText((CharSequence)jSONObject.getString("new_message"));
            builder.setPriority(1);
            builder.setAutoCancel(true);
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (Build.VERSION.SDK_INT >= 26) {
                int notification = 4;
                NotificationChannel n22 = new NotificationChannel(string4, (CharSequence)string5, notification);
                n22.enableLights(true);
                n22.setLightColor(-65536);
                n22.enableVibration(true);
                n22.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
                assert (notificationManager != null);
                builder.setChannelId(string4);
                notificationManager.createNotificationChannel(n22);
            }
            Notification notification = builder.build();
            if (Build.VERSION.SDK_INT >= 21 && (n6 = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                if (notification.headsUpContentView != null) {
                    notification.headsUpContentView.setViewVisibility(n6, 4);
                }
                if (notification.bigContentView != null) {
                    notification.bigContentView.setViewVisibility(n6, 4);
                }
            }
            notificationManager = (NotificationManager)context.getSystemService("notification");
            int n4 = (int)System.currentTimeMillis();
            notificationManager.notify(n4, notification);
            com.hippo.agent.database.a.a(l2, (Integer)n4);
            try {
                if (l2 != 0L && agentPushChannelId != l2) {
                    if (!TextUtils.isEmpty((CharSequence)jSONObject.optString("user_unique_key", ""))) {
                        a.a().pushUpdateCount(jSONObject.optString("user_unique_key", ""), true);
                    }
                    if (HippoConfig.getInstance() != null && !HippoConfig.getInstance().isChannelActivity()) {
                        a.a().addTotalPushUnread(jSONObject.getInt("channel_id"));
                    }
                }
            }
            catch (Exception exception) {}
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            jSONObject = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
            audioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(4).build();
            jSONObject.setSound(RingtoneManager.getDefaultUri((int)2), audioAttributes);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel((NotificationChannel)jSONObject);
            }
        }
        d.c(TAG, "Creation at: " + new Date());
    }

    private void showUserNotification(Context context, Map<String, String> map) {
        Intent intent;
        JSONObject jSONObject;
        block26: {
            com.hippo.database.a.b(true);
            if (com.hippo.database.a.d() != null && com.hippo.database.a.d().size() <= 0) {
                com.hippo.database.a.c(true);
            }
            try {
                int n2;
                jSONObject = new JSONObject(map.get("message"));
                try {
                    if (com.hippo.database.a.I() && jSONObject.optInt("notification_type") == 14 && (jSONObject.optString("video_call_type").equalsIgnoreCase("START_CALL") || jSONObject.optString("video_call_type").equalsIgnoreCase("CALL_HUNG_UP"))) {
                        if (HippoConfig.getInstance().getCallData() != null) {
                            HippoConfig.getInstance().getCallData().onNotificationReceived(context, jSONObject);
                        } else {
                            HippoConfig.getInstance().setCallListener(new CallData(){

                                @Override
                                public void onNotificationReceived(Context context, JSONObject jSONObject) {
                                }

                                @Override
                                public void onCallClick(Context context, int n2, Long l2, Long l3, boolean bl, boolean bl2, String string2, String string3) {
                                }
                            });
                        }
                        return;
                    }
                    if (jSONObject.optInt("notification_type") == 14) {
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                intent = new Intent("notification_received");
                Bundle bundle = new Bundle();
                for (String string2 : map.keySet()) {
                    bundle.putString(string2, map.get(string2));
                }
                intent.putExtras(bundle);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                Paper.init((Context)context);
                long l2 = -1L;
                long l3 = -1L;
                int n3 = jSONObject.optInt("disable_reply", 0);
                String string3 = jSONObject.optString("label", "");
                String string4 = jSONObject.optString("title", "");
                String string5 = jSONObject.optString("new_message", "");
                if (jSONObject.has("channel_id")) {
                    l2 = jSONObject.optLong("channel_id", -1L);
                }
                if (jSONObject.has("label_id")) {
                    l3 = jSONObject.optLong("label_id", -1L);
                }
                if (pushChannelId != null && l2 > 0L && pushChannelId.compareTo(l2) == 0) {
                    return;
                }
                if (pushLabelId != null && l3 > 0L && pushLabelId.compareTo(l3) == 0) {
                    return;
                }
                Intent intent2 = new Intent(context, FuguPushIntentService.class);
                intent2.putExtra("channelId", l2);
                intent2.putExtra("en_user_id", com.hippo.database.a.e().getData().getEn_user_id());
                intent2.putExtra("userId", (Serializable)com.hippo.database.a.e().getData().getUserId());
                intent2.putExtra("labelId", l3);
                intent2.putExtra("label", string3);
                intent2.putExtra("disable_reply", n3);
                Bundle bundle2 = new Bundle();
                for (String string6 : map.keySet()) {
                    bundle2.putString(string6, map.get(string6));
                }
                intent2.putExtra("data", bundle2);
                if (com.hippo.database.a.c() != -1) {
                    intent2.setFlags(com.hippo.database.a.c());
                }
                PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE)), (Intent)intent2, (int)0);
                int n4 = -1;
                if (!this.notificationSoundEnabled) {
                    n4 = 4;
                }
                NotificationCompat.Builder builder = new NotificationCompat.Builder(context, CHANNEL_ONE_ID).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string5)).setSmallIcon(this.smallIcon == -1 ? R.drawable.hippo_default_notif_icon : this.smallIcon).setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)this.largeIcon)).setContentTitle((CharSequence)string4).setContentText((CharSequence)string5).setContentIntent(pendingIntent).setDefaults(n4).setPriority(this.priority).setAutoCancel(true);
                builder.setChannelId(CHANNEL_ONE_ID);
                Notification notification = builder.build();
                if (Build.VERSION.SDK_INT >= 21 && (n2 = context.getResources().getIdentifier("right_icon", "id", "android")) != 0) {
                    if (notification.headsUpContentView != null) {
                        notification.headsUpContentView.setViewVisibility(n2, 4);
                    }
                    if (notification.bigContentView != null) {
                        notification.bigContentView.setViewVisibility(n2, 4);
                    }
                }
                notificationManager = (NotificationManager)context.getSystemService("notification");
                notificationManager.notify((int)(new Date().getTime() / 1000L % Integer.MAX_VALUE), notification);
                try {
                    if (HippoConfig.getInstance() == null || HippoConfig.getInstance().isChannelActivity() || (!jSONObject.has("channel_id") || pushChannelId.compareTo(jSONObject.getLong("channel_id")) == 0) && (!jSONObject.has("label_id") || pushLabelId.compareTo(jSONObject.getLong("label_id")) == 0)) break block26;
                    try {
                        long l4 = l2;
                        long l5 = l3;
                        this.addUnreadCount(l4, l5);
                    }
                    catch (Exception exception) {
                    }
                }
                catch (Exception exception) {}
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (Build.VERSION.SDK_INT >= 26) {
            jSONObject = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
            intent = new AudioAttributes.Builder().setContentType(4).setUsage(4).build();
            jSONObject.setSound(RingtoneManager.getDefaultUri((int)2), (AudioAttributes)intent);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel((NotificationChannel)jSONObject);
            }
        }
    }

    private void addUnreadCount(Long l2, Long l3) {
        try {
            d.c(TAG, "In count");
            if (!HippoConfig.getInstance().isChannelActivity()) {
                int n2;
                ArrayList<UnreadCountModel> arrayList;
                int n3;
                int n4 = -1;
                if (l2 > 0L) {
                    n4 = com.hippo.database.a.r().indexOf(new UnreadCountModel(l2));
                } else if (l3 > 0L && com.hippo.database.a.r() != null) {
                    ArrayList<UnreadCountModel> arrayList2 = com.hippo.database.a.r();
                    for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                        if (arrayList2.get(n3).getLabelId().compareTo(l3) != 0) continue;
                        n4 = n3;
                        break;
                    }
                }
                d.d(TAG, "index = " + n4);
                if (n4 > -1) {
                    arrayList = com.hippo.database.a.r();
                    d.d(TAG, "unreadCountModels = " + arrayList.size());
                    d.d(TAG, "unreadCountModels.get(index).getCount() = " + arrayList.get(n4).getCount());
                    n2 = arrayList.get(n4).getCount() + 1;
                    d.d(TAG, "channelCount = " + n2);
                    arrayList.get(n4).setCount(n2);
                    com.hippo.database.a.a(new ArrayList<UnreadCountModel>());
                    com.hippo.database.a.a(arrayList);
                } else {
                    n2 = 1;
                    UnreadCountModel unreadCountModel = new UnreadCountModel(l2, l3, n2);
                    arrayList = com.hippo.database.a.r();
                    d.d(TAG, "unreadCountModels = " + arrayList.size());
                    arrayList.add(unreadCountModel);
                    com.hippo.database.a.a(arrayList);
                }
                n2 = 0;
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    n2 += arrayList.get(n3).getCount();
                }
                d.d(TAG, "count = " + n2);
                if (HippoConfig.getInstance().getCallbackListener() != null) {
                    HippoConfig.getInstance().getCallbackListener().count(n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void clearNotifications(Context context, ArrayList<Integer> arrayList) {
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        if (arrayList != null && arrayList.size() > 0) {
            for (Integer n2 : arrayList) {
                notificationManager.cancel(n2.intValue());
            }
        }
    }

    public static long getTimeMilliSec(String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                Date date = simpleDateFormat.parse(string2);
                return date.getTime();
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return 0L;
    }

    private void sendAck() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    b b2 = new b.a().a("", "").a();
                    g.a().sendAckToServer(b2.a()).enqueue((Callback)new f<c>(){

                        @Override
                        public void a(c c2) {
                        }

                        @Override
                        public void a(com.hippo.retrofit.a a2) {
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }).start();
    }
}

