package com.hippo.apis;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import com.hippo.*;
import com.hippo.HippoNotificationConfig;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.model.FuguDeviceDetails;
import com.hippo.model.FuguPutUserDetailsResponse;
import com.hippo.model.UserInfoModel;
import com.hippo.retrofit.*;
import com.hippo.utils.HippoLog;
import com.hippo.utils.UniqueIMEIID;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;

import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * Created by ankit on 07/09/17.
 */

public class ApiPutUserDetails implements FuguAppConstant {

    public Activity activity;
    private Callback callback;
    private CaptureUserData userData = HippoConfig.getInstance().getUserData();

    public ApiPutUserDetails(Activity activity, Callback callback) {
        this.activity = activity;
        this.callback = callback;
    }

    public void sendUserDetails(String resellerToken, int referenceId) {
        sendUserDetails(resellerToken, referenceId, true);
    }

    public void sendUserDetails(String resellerToken, int referenceId, boolean showLoading) {
        HippoLog.v("inside sendUserDetails", "inside sendUserDetails");
        Gson gson = new GsonBuilder().create();
        JsonObject deviceDetailsJson = null;
        try {
            deviceDetailsJson = gson.toJsonTree(new FuguDeviceDetails(getAppVersion()).getDeviceDetails()).getAsJsonObject();
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }

        HashMap<String, Object> commonParamsMAp = new HashMap<>();
        if (!TextUtils.isEmpty(resellerToken)) {
            commonParamsMAp.put(RESELLER_TOKEN, resellerToken);
            commonParamsMAp.put(REFERENCE_ID, String.valueOf(referenceId));
        } else {
            commonParamsMAp.put(APP_SECRET_KEY, HippoConfig.getInstance().getAppKey());
        }
        commonParamsMAp.put(DEVICE_ID, UniqueIMEIID.getUniqueIMEIId(activity));
        commonParamsMAp.put(APP_TYPE, HippoConfig.getInstance().getAppType());
        commonParamsMAp.put(DEVICE_TYPE, ANDROID_USER);
        commonParamsMAp.put(APP_VERSION, BuildConfig.VERSION_NAME);
        commonParamsMAp.put(APP_VERSION_CODE, BuildConfig.VERSION_CODE);
        commonParamsMAp.put(DEVICE_DETAILS, deviceDetailsJson);
        if (userData != null) {
            if (!userData.getUserUniqueKey().trim().isEmpty())
                commonParamsMAp.put(USER_UNIQUE_KEY, userData.getUserUniqueKey());

            if (!userData.getFullName().trim().isEmpty())
                commonParamsMAp.put(FULL_NAME, userData.getFullName());

            if (!userData.getEmail().trim().isEmpty())
                commonParamsMAp.put(EMAIL, userData.getEmail());

            if (!userData.getPhoneNumber().trim().isEmpty())
                commonParamsMAp.put(PHONE_NUMBER, userData.getPhoneNumber());

            JSONObject attJson = new JSONObject();
            JSONObject addressJson = new JSONObject();
            JSONObject userInfo = new JSONObject();
            if(!TextUtils.isEmpty(CommonData.getUserCountryCode())) {
                try {
                    userInfo.put("country_code", CommonData.getUserCountryCode());
                    userInfo.put("continent_code", CommonData.getUserContCode());

                    attJson.put(COUNTRY_INFO, userInfo);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                if (!userData.getAddressLine1().trim().isEmpty()) {
                    addressJson.put(ADDRESS_LINE1, userData.getAddressLine1());
                }
                if (!userData.getAddressLine2().trim().isEmpty()) {
                    addressJson.put(ADDRESS_LINE2, userData.getAddressLine2());
                }
                if (!userData.getCity().trim().isEmpty()) {
                    addressJson.put(CITY, userData.getCity());
                }
                if (!userData.getRegion().trim().isEmpty()) {
                    addressJson.put(REGION, userData.getRegion());
                }
                if (!userData.getCountry().trim().isEmpty()) {
                    addressJson.put(COUNTRY, userData.getCountry());
                }
                if (!userData.getZipCode().trim().isEmpty()) {
                    addressJson.put(ZIP_CODE, userData.getZipCode());
                }
                if (userData.getLatitude() != 0 && userData.getLongitude() != 0) {
                    attJson.put(LAT_LONG, String.valueOf(userData.getLatitude() + "," + userData.getLongitude()));
                }
                attJson.put(IP_ADDRESS, CommonData.getLocalIpAddress());
                attJson.put(ADDRESS, addressJson);

            } catch (JSONException e) {
                e.printStackTrace();
            }
            commonParamsMAp.put(ATTRIBUTES, attJson);
            commonParamsMAp.put(CUSTOM_ATTRIBUTES, new JSONObject(userData.getCustom_attributes()));

            if(!userData.getTags().isEmpty()) {
                ArrayList<GroupingTag> groupingTags = new ArrayList<>();
                for(GroupingTag tag : userData.getTags()) {
                    GroupingTag groupingTag = new GroupingTag();
                    if(!TextUtils.isEmpty(tag.getTagName()))
                        groupingTag.setTagName(tag.getTagName());
                    if(tag.getTeamId() != null)
                        groupingTag.setTeamId(tag.getTeamId());

                    if(!TextUtils.isEmpty(tag.getTagName()) || tag.getTeamId() != null) {
                        groupingTags.add(groupingTag);
                    }
                }
                commonParamsMAp.put(GROUPING_TAGS, new Gson().toJson(groupingTags));
            } else {
                commonParamsMAp.put(GROUPING_TAGS, "[]");
            }
        }

        String deviceToken = CommonData.getAttributes().getDeviceToken();
        if (!TextUtils.isEmpty(deviceToken)) {
            commonParamsMAp.put(DEVICE_TOKEN, deviceToken);
        }

        HippoLog.e("Fugu Config sendUserDetails maps", "==" + commonParamsMAp.toString());
        if (!TextUtils.isEmpty(resellerToken)) {
            apiPutUserDetailReseller(commonParamsMAp);
        } else {
            apiPutUserDetail(commonParamsMAp, showLoading);
        }
    }

    private void apiPutUserDetail(HashMap<String, Object> commonParams, boolean showLoading) {
        CommonParams params = new CommonParams.Builder()
                .putMap(commonParams)
                .build();
        RestClient.getApiInterface().putUserDetails(params.getMap())
                .enqueue(new ResponseResolver<FuguPutUserDetailsResponse>(activity, showLoading, false) {
                    @Override
                    public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {

                        CommonData.setUserDetails(fuguPutUserDetailsResponse);
                        CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());

                        HippoConfig.getInstance().getUserData().setUserId(fuguPutUserDetailsResponse.getData().getUserId());
                        HippoConfig.getInstance().getUserData().setEnUserId(fuguPutUserDetailsResponse.getData().getEn_user_id());
                        CommonData.saveUserData(HippoConfig.getInstance().getUserData());
                        HippoLog.e("en_user_id",fuguPutUserDetailsResponse.getData().getEn_user_id());

                        callback.onSuccess();
                    }

                    @Override
                    public void failure(APIError error) {
                        callback.onFailure();
                    }
                });
    }

    private void apiPutUserDetailReseller(HashMap<String, Object> commonParams) {
        CommonParams params = new CommonParams.Builder()
                .putMap(commonParams)
                .build();
        RestClient.getApiInterface().putUserDetailsReseller(params.getMap())
                .enqueue(new ResponseResolver<FuguPutUserDetailsResponse>(activity, false, false) {
                    @Override
                    public void success(FuguPutUserDetailsResponse fuguPutUserDetailsResponse) {
                        CommonData.setUserDetails(fuguPutUserDetailsResponse);
                        CommonData.setConversationList(fuguPutUserDetailsResponse.getData().getFuguConversations());
                        HippoConfig.getInstance().getUserData().setUserId(fuguPutUserDetailsResponse.getData().getUserId());
                        HippoConfig.getInstance().getUserData().setEnUserId(fuguPutUserDetailsResponse.getData().getEn_user_id());
                        CommonData.saveUserData(HippoConfig.getInstance().getUserData());
                        HippoLog.e("en_user_id",fuguPutUserDetailsResponse.getData().getEn_user_id());
                        if (fuguPutUserDetailsResponse.getData().getAppSecretKey() != null && !TextUtils.isEmpty(fuguPutUserDetailsResponse.getData().getAppSecretKey())) {
                            HippoConfig.getInstance().appKey = fuguPutUserDetailsResponse.getData().getAppSecretKey();
                            CommonData.setAppSecretKey(fuguPutUserDetailsResponse.getData().getAppSecretKey());
                        }
                        callback.onSuccess();
                    }

                    @Override
                    public void failure(APIError error) {
                        callback.onFailure();
                    }
                });
    }

    private int getAppVersion() {
        try {
            return activity.getPackageManager().getPackageInfo(activity.getPackageName(), 0).versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void getUserContryInfo(final HippoConfigAttributes attributes, final UserCallback callback) {
        try {
            Gson gson = new GsonBuilder()
                    .setLenient()
                    .create();

            Retrofit retrofit = new Retrofit.Builder()
                    .baseUrl("https://ip.tookanapp.com:8000")
                    .addConverterFactory(GsonConverterFactory.create(gson))
                    .build();

            ApiInterface gerritAPI = retrofit.create(ApiInterface.class);

            Call<UserInfoModel> call = gerritAPI.getUserInfo();
            call.enqueue(new ResponseResolver<UserInfoModel>() {
                @Override
                public void success(UserInfoModel userInfoModel) {
                    try {
                        CommonData.setUserContCode(userInfoModel.getData().getContinentCode());
                        CommonData.setUserCountryCode(userInfoModel.getData().getCountryCode());
                    } catch (Exception e) {

                    }
                    if(callback != null) {
                        callback.onSuccess(userInfoModel, attributes);
                    }
                }
                @Override
                public void failure(APIError error) {
                    if(callback != null) {
                        callback.onSuccess(null, attributes);
                    }
                }
            });
        } catch (Exception e) {
            if(callback != null) {
                callback.onSuccess(null, attributes);
            }
        }
    }

    public interface Callback {
        void onSuccess();
        void onFailure();
    }

    public interface UserCallback {
        void onSuccess(UserInfoModel userInfoModel, HippoConfigAttributes attributes);
    }


}
