package com.hippo.agent.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import com.hippo.HippoColorConfig;
import com.hippo.R;
import com.hippo.agent.model.broadcastStatus.BroadcastInfo;
import com.hippo.database.CommonData;
import com.hippo.utils.DateUtils;

import java.util.ArrayList;

/**
 * Created by gurmail on 30/07/18.
 *
 * @author gurmail
 */

public class BroadcastStatusAdapter extends RecyclerView.Adapter<BroadcastStatusAdapter.ViewHolder> {

    private static final String TAG = BroadcastStatusAdapter.class.getSimpleName();
    private Context context;
    private ArrayList<BroadcastInfo> arrayList = new ArrayList<>();
    private HippoColorConfig hippoColorConfig;

    public BroadcastStatusAdapter(ArrayList<BroadcastInfo> arrayList) {
        this.arrayList = arrayList;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        context = parent.getContext();
        hippoColorConfig = CommonData.getColorConfig();
        View view = LayoutInflater.from(parent.getContext())
                .inflate(R.layout.hippo_item_broadcast_status, parent, false);
        return new ViewHolder(view);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        BroadcastInfo info = arrayList.get(position);
        holder.textViewStatusValue.setText(info.getStatus() == 1 ? "SUCCESS" : "PENDING");
        holder.textViewFromValue.setText(info.getFullName());
        holder.textViewTitleValue.setText(info.getBroadcastTitle());
        holder.textViewMsgValue.setText(info.getUserFirstMessage());
        holder.textViewDateValue.setText(DateUtils.getInstance().convertToLocal(info.getCreatedAt(), DateUtils.STANDARD_DATE_ONLY_FORMAT));
    }

    @Override
    public int getItemCount() {
        return arrayList == null ? 0 : arrayList.size();
    }

    class ViewHolder extends RecyclerView.ViewHolder {
        private TextView textViewStatus, textViewStatusValue, textViewFrom, textViewFromValue, textViewTitle, textViewTitleValue,
                textViewMsg, textViewMsgValue, textViewDate, textViewDateValue;

        public ViewHolder(View itemView) {
            super(itemView);

            textViewStatus = itemView.findViewById(R.id. textViewStatus);
            textViewFrom = itemView.findViewById(R.id. textViewFrom);
            textViewTitle = itemView.findViewById(R.id. textViewTitle);
            textViewMsg = itemView.findViewById(R.id. textViewMsg);
            textViewDate = itemView.findViewById(R.id. textViewDate);

            textViewStatusValue = itemView.findViewById(R.id. textViewStatusValue);
            textViewFromValue = itemView.findViewById(R.id. textViewFromValue);
            textViewTitleValue = itemView.findViewById(R.id. textViewTitleValue);
            textViewMsgValue = itemView.findViewById(R.id. textViewMsgValue);
            textViewDateValue = itemView.findViewById(R.id. textViewDateValue);

            textViewStatusValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewFromValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewTitleValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewMsgValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());
            textViewDateValue.setTextColor(hippoColorConfig.getHippoTextColorPrimary());

            textViewStatus.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewFrom.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewTitle.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewMsg.setTextColor(hippoColorConfig.getHippoTextColorSecondary());
            textViewDate.setTextColor(hippoColorConfig.getHippoTextColorSecondary());

        }
    }
}
