package com.hippo.adapter;

import android.support.annotation.NonNull;

import android.text.TextUtils;
import com.hippo.constant.FuguAppConstant;
import com.hippo.model.Message;

public class EventItem extends ListItem implements FuguAppConstant {

    @NonNull
    private Message event;

    public EventItem(@NonNull Message event) {
        this.event = event;
    }

    @NonNull
    public Message getEvent() {
        return event;
    }

    // here getters and setters
    // for title and so on, built
    // using event

    /*case none = 0,
        normal = 1,
        assignAgent = 2,
        privateNote = 3,
        imageFile = 10,
        attachment = 11,
        actionableMessage = 12,
        feedback = 14,
        botText = 15,
        quickReply = 16,
        botFormMessage = 17,
        call = 18,
        hippoPay = 19

        // for agent sdk
        [.normal, .imageFile, .privateNote, .assignAgent, .botText, .call, .attachment]

    three-dots-icon
    var customerHandledMessages: [MessageType] {
        return [.normal, .imageFile, .feedback, .actionableMessage, .botFormMessage, .quickReply, .botText, .call, .hippoPay, .attachment]
    }*/

    @Override
    public int getType() {
        int messageType = event.getMessageType();
        switch (messageType) {
            case TEXT_MESSAGE:
            case IMAGE_MESSAGE:
            case ACTION_MESSAGE:
            case ACTION_MESSAGE_NEW:
                if(event.isSelf())
                    return ITEM_TYPE_SELF;
                return ITEM_TYPE_OTHER;
            case HIPPO_FILE_VIEW:
                if(event.isSelf()){
                    if(event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                        return HIPPO_VIDEO_MESSGAE_SELF;
                    } else {
                        return HIPPO_SELF_FILE_VIEW;
                    }
                } else {
                    if(event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString())) {
                        return HIPPO_VIDEO_MESSGAE_OTHER;
                    } else {
                        return HIPPO_FILE_VIEW;
                    }
                }
            case FEEDBACK_MESSAGE:
                return ITEM_TYPE_RATING;
            case FUGU_TEXT_VIEW:
                return ITEM_TYPE_OTHER;
            case FUGU_QUICK_REPLY_VIEW:
                if(event.getValues() == null || event.getValues().size() == 0)
                    return FUGU_QUICK_REPLY_VIEW;
                return ITEM_TYPE_OTHER;
            case FUGU_FORUM_VIEW:
                return FUGU_FORUM_VIEW;
            case FUGU_SELF_VIDEO_VIEW:
                if(event.isSelf())
                    return FUGU_SELF_VIDEO_VIEW;
                return FUGU_OTHER_VIDEO_VIEW;
            case FUGU_GALLERY_VIEW:
                return FUGU_GALLERY_VIEW;
            default:
                if(event.isSelf())
                    return HIPPO_UNKNOWN_MESSAGE_SELF;
                return HIPPO_UNKNOWN_MESSAGE_OTHER;
        }

        /*if(event.getMessageType() == FUGU_SELF_VIDEO_VIEW && event.isSelf())
            return FUGU_SELF_VIDEO_VIEW;
        else if(event.getMessageType() == FUGU_SELF_VIDEO_VIEW)
            return FUGU_OTHER_VIDEO_VIEW;
        else if (event.getMessageType() == FUGU_FORUM_VIEW)
            return FUGU_FORUM_VIEW;
        else if (event.getMessageType() == FUGU_GALLERY_VIEW)
            return FUGU_GALLERY_VIEW;
        else if (event.getMessageType() == FUGU_QUICK_REPLY_VIEW && (event.getValues() == null || event.getValues().size() == 0))
            return FUGU_QUICK_REPLY_VIEW;
        else if (event.getMessageType() == FUGU_TEXT_VIEW)
            return ITEM_TYPE_OTHER;
        else if(event.getMessageType() == HIPPO_FILE_VIEW && event.isSelf() && !TextUtils.isEmpty(event.getDocumentType()) && event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString()))
            return HIPPO_VIDEO_MESSGAE_SELF;
        else if(event.getMessageType() == HIPPO_FILE_VIEW && !TextUtils.isEmpty(event.getDocumentType()) && event.getDocumentType().equalsIgnoreCase(FuguAppConstant.DocumentType.VIDEO.toString()))
            return HIPPO_VIDEO_MESSGAE_OTHER;
        else if(event.getMessageType() == HIPPO_FILE_VIEW && event.isSelf())
            return HIPPO_SELF_FILE_VIEW;
        else if(event.getMessageType() == HIPPO_FILE_VIEW)
            return HIPPO_FILE_VIEW;
        else if (event.isSelf())
            return ITEM_TYPE_SELF;
        else if (event.isRating())
            return ITEM_TYPE_RATING;
        else
            return ITEM_TYPE_OTHER;*/
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof EventItem) {
            Message message = ((EventItem) obj).getEvent();
//            if (message.getId() != null && getEvent().getId() != null) {

            try {
                if (message.getId() != null && getEvent().getId() != null) {
                    return message.getId().equals(getEvent().getId());
                }
            } catch (Exception e) {
                //e.printStackTrace();
            }
        }
        return false;
    }
}
