package com.hippo.activity;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Dialog;
import android.app.NotificationManager;
import android.content.*;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SimpleItemAnimator;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.*;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.RequestOptions;
import com.google.gson.*;
import com.google.gson.reflect.TypeToken;
import com.hippo.*;
import com.hippo.adapter.*;
import com.hippo.apis.ApiPutUserDetails;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.datastructure.ChannelStatus;
import com.hippo.datastructure.ChatType;
import com.hippo.interfaces.fayeClient;
import com.hippo.model.*;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.MultipartParams;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.*;
import com.hippo.utils.beatAnimation.AVLoadingIndicatorView;
import com.hippo.utils.easypermissions.AfterPermissionGranted;
import com.hippo.utils.easypermissions.AppSettingsDialog;
import com.hippo.utils.easypermissions.EasyPermissions;
import com.hippo.utils.fileUpload.FileManager;
import com.hippo.utils.fileUpload.FileuploadModel;
import com.hippo.utils.fileUpload.Prefs;
import com.hippo.utils.filepicker.*;
import com.hippo.utils.filepicker.filter.entity.AudioFile;
import com.hippo.utils.filepicker.filter.entity.ImageFile;
import com.hippo.utils.filepicker.filter.entity.NormalFile;
import com.hippo.utils.filepicker.filter.entity.VideoFile;
import com.hippo.utils.loadingBox.LoadingBox;
import com.hippo.utils.loadingBox.ProgressWheel;
import com.hippo.utils.zoomview.ZoomageView;
import faye.FayeClient;
import faye.FayeClientListener;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.*;

import static com.hippo.adapter.ListItem.*;

//import com.hippo.utils.compressor.Compressor;


public class FuguChatActivity extends FuguBaseActivity implements Animation.AnimationListener, FayeClientListener,
        FuguMessageAdapter.OnRatingListener, QuickReplyAdapaterActivityCallback,
        KeyboardUtil.SoftKeyboardToggleListener, EasyPermissions.PermissionCallbacks {

    private String TAG = getClass().getSimpleName();
    private static final int NOT_CONNECTED = 0;
    private static final int CONNECTED_TO_INTERNET = 1;
    private static final int CONNECTED_TO_INTERNET_VIA_WIFI = 2;
    // Initial FayeClient
    private static FayeClient mClient = null;


    // Declaring Views
    private RelativeLayout rlRoot;
    private CustomLinear llRoot;
    private CardView cvTypeMessage;
    private LinearLayout llMessageLayout;
    private TextView tvClosed;
    private TextView tvNoInternet;
    private EditText etMsg;
    private RecyclerView rvMessages;
    private FuguMessageAdapter fuguMessageAdapter;
    private Toolbar myToolbar;
    private AVLoadingIndicatorView aviTyping;
    private LinearLayout llTyping;
    private ProgressBar pbLoading;
    private FuguConversation conversation;
    private ProgressBar pbSendingImage;
    private ImageView ivSend;
    private boolean isNetworkStateChanged = false;
    private boolean isFayeChannelActive = false;
    private boolean firstTime = true;
    private boolean isFirst = true;
    private Animation animSlideUp, animSlideDown;
    private ProgressBar pbPeerChat;
    private FuguGetMessageResponse mFuguGetMessageResponse;

    private String AgentName = "";
    private String sentAtUTC = "";
    private Long channelId = -1L;
    public static Long currentChannelId = -1L;
    private Long userId = -1L;
    private String enUserId = "";
    private Long labelId = -1L;
    private String userName = "";
    private int isTyping = TYPING_SHOW_MESSAGE;
    private String label = "";
    private String defaultMessage = "";
    private String businessName = "";
    private int status;
    private boolean isConversationCreated;
    private FuguImageUtils fuguImageUtils;
    private int onSubscribe = CHANNEL_UNSUBSCRIBED;
    private boolean showLoading = true;
    private boolean allMessagesFetched = false;
    private DateUtils dateUtils;
    private int pageStart = 1, position;
    private int dateItemCount = 0;
    private HippoColorConfig hippoColorConfig;
    private CustomLinearLayoutManager layoutManager;

    private boolean isP2P = false;
    private FuguCreateConversationParams fuguCreateConversationParams;
    private int previousPos = 0;
    private boolean runAnim = true, runAnim2 = false;
    private Handler handler = null;
    @SuppressLint("StaticFieldLeak")
    private static LinearLayout llInternet;
    @SuppressLint("StaticFieldLeak")
    private static TextView tvStatus;
    private TextView tvDateLabel;
    private HashMap<String, Long> transactionIdsMap;
    private String globalUuid;


    // new key for code cleanning
//    private HelperConnectionListener connectionListener;
    @NonNull
    private ArrayList<ListItem> fuguMessageList = new ArrayList<>();
    private LinkedHashMap<String, ListItem> sentMessages = new LinkedHashMap<>();
    private LinkedHashMap<String, ListItem> unsentMessages = new LinkedHashMap<>();
    @NonNull
    private LinkedHashMap<String, JSONObject> unsentMessageMapNew = new LinkedHashMap<>();
    private String inputFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private String outputFormat = "yyyy-MM-dd";
    private LinearLayout retryLayout;
    private TextView btnRetry;
    private ProgressWheel progressWheel;
    private int messageIndex = -1;
    private ImageView ivVideoView, ivAudioView;
    private boolean keyboardVisibility;
    public String audioMuid = "";
    public int playingItem = -1;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.fugu_activity_chat);
        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiverChat, new IntentFilter(NOTIFICATION_INTENT));
        LocalBroadcastManager.getInstance(this).registerReceiver(nullListenerReceiver, new IntentFilter(FuguAppConstant.FUGU_LISTENER_NULL));
        LocalBroadcastManager.getInstance(this).registerReceiver(fileUploadReceiver, new IntentFilter(FuguAppConstant.HIPPO_FILE_UPLOAD));
        isFirstTimeOpened = true;
        initViews();
        fetchIntentData();
        getClient();
        CommonData.clearPushChannel();
    }

    private void getClient() {
        HippoConfig.getClient(new fayeClient() {
            @Override
            public void Listener(FayeClient client) {
                mClient = client;
                aftergettingClient();
            }
        });
    }

    private void aftergettingClient() {
        setUpFayeConnection();
        setUpUI();
        stateChangeListeners();

        LocalBroadcastManager.getInstance(this).registerReceiver(mMessageReceiver, getIntentFilter());
    }

    private void updateUnreadCount(Long channelId, Long labelId) {
        ArrayList<UnreadCountModel> unreadCountModels = CommonData.getUnreadCountModel();
        if (unreadCountModels.size() == 0)
            return;
        int index = -1;
        if (channelId > 0) {
            index = unreadCountModels.indexOf(new UnreadCountModel(channelId));
        } else if (labelId > 0) {
            for (int i = 0; i < unreadCountModels.size(); i++) {
                if (unreadCountModels.get(i).getLabelId().compareTo(labelId) == 0) {
                    index = i;
                    break;
                }
            }
        }
        HippoLog.v(TAG, "index = " + index);
        HippoLog.v(TAG, "unreadCountModels = " + unreadCountModels.size());
        if (index > -1)
            unreadCountModels.remove(index);

        HippoLog.v(TAG, "unreadCountModels = " + new Gson().toJson(unreadCountModels));
        HippoLog.v(TAG, "unreadCountModels = " + unreadCountModels.size());
        CommonData.setUnreadCount(unreadCountModels);

        int count = 0;
        for (int i = 0; i < unreadCountModels.size(); i++) {
            count = count + unreadCountModels.get(i).getCount();
            HippoLog.v(TAG, i + " count = " + unreadCountModels.get(i).getCount());
        }

        HippoLog.v(TAG, "count = " + count);

        if (HippoConfig.getInstance().getCallbackListener() != null) {
            HippoConfig.getInstance().getCallbackListener().count(count);
        }
    }

    // intentFilter to add multiple actions
    private IntentFilter getIntentFilter() {
        IntentFilter intent = new IntentFilter();
        intent.addAction(NETWORK_STATE_INTENT);
        intent.addAction(NOTIFICATION_TAPPED);
        return intent;
    }

    private void initViews() {
        transactionIdsMap = CommonData.getTransactionIdsMap();
        myToolbar = (Toolbar) findViewById(R.id.my_toolbar);
        setSupportActionBar(myToolbar);
        hippoColorConfig = CommonData.getColorConfig();
        rlRoot = (RelativeLayout) findViewById(R.id.rlRoot);
        llRoot = (CustomLinear) findViewById(R.id.llRoot);
        tvDateLabel = (TextView) findViewById(R.id.tvDateLabel);
        cvTypeMessage = (CardView) findViewById(R.id.cvTypeMessage);
        tvClosed = (TextView) findViewById(R.id.tvClosed);
        tvNoInternet = (TextView) findViewById(R.id.tvNoInternet);
        aviTyping = (AVLoadingIndicatorView) findViewById(R.id.aviTyping);
        llTyping = (LinearLayout) findViewById(R.id.llTyping);
        etMsg = (EditText) findViewById(R.id.etMsg);
        pbLoading = (ProgressBar) findViewById(R.id.pbLoading);
        pbSendingImage = (ProgressBar) findViewById(R.id.pbSendingImage);
        ivSend = (ImageView) findViewById(R.id.ivSend);
        tvStatus = (TextView) findViewById(R.id.tvStatus);
        llInternet = (LinearLayout) findViewById(R.id.llInternet);
        llMessageLayout = (LinearLayout) findViewById(R.id.llMessageLayout);
        fuguImageUtils = new FuguImageUtils(FuguChatActivity.this);
        dateUtils = DateUtils.getInstance();
        pbPeerChat = (ProgressBar) findViewById(R.id.pbPeerChat);
        rvMessages = (RecyclerView) findViewById(R.id.rvMessages);
        btnRetry = findViewById(R.id.btnRetry);
        retryLayout = findViewById(R.id.retry_layout);
        progressWheel = findViewById(R.id.retry_loader);
        ivVideoView = findViewById(R.id.ivVideoView);
        ivAudioView = findViewById(R.id.ivAudioView);

        // TODO: 31/12/18 Exposs drawable to end user
        ivAudioView.setImageResource(R.drawable.hippo_ic_call_black);
        ivVideoView.setImageResource(R.drawable.hippo_ic_videocam);

        /*ivAudioView.setImageResource(HippoConfig.getInstance().getAudioCallDrawableId() == -1
                ? R.drawable.hippo_ic_call_black : HippoConfig.getInstance().getAudioCallDrawableId());
        if(HippoConfig.getInstance().getAudioCallDrawableId() == -1) {
            ivAudioView.getDrawable().setColorFilter(hippoColorConfig.getHippoAudioCallBg(), PorterDuff.Mode.SRC_IN);
        }

        ivVideoView.setImageResource(HippoConfig.getInstance().getVideoCallDrawableId() == -1
                ? R.drawable.hippo_ic_videocam : HippoConfig.getInstance().getVideoCallDrawableId());
        if(HippoConfig.getInstance().getVideoCallDrawableId() == -1) {
            ivVideoView.getDrawable().setColorFilter(hippoColorConfig.getHippoVideoCallBg(), PorterDuff.Mode.SRC_IN);
        }*/

        ivAudioView.setVisibility(View.GONE);
        ivVideoView.setVisibility(View.GONE);
        configColors();
        /*if (!isNetworkAvailable()) {
            llInternet.setVisibility(View.VISIBLE);
            llInternet.setBackgroundColor(Color.parseColor("#FF0000"));
            tvStatus.setText(R.string.fugu_not_connected_to_internet);
        }*/
        animSlideUp = AnimationUtils.loadAnimation(getApplicationContext(),
                R.anim.fugu_slide_up_time);
        animSlideUp.setAnimationListener(this);

        animSlideDown = AnimationUtils.loadAnimation(getApplicationContext(),
                R.anim.fugu_slide_down_time);
        animSlideDown.setAnimationListener(this);

    }

    private void configColors() {
        rlRoot.setBackgroundColor(hippoColorConfig.getHippoChatBg());
        GradientDrawable drawable = (GradientDrawable) llTyping.getBackground();
        drawable.setColor(hippoColorConfig.getHippoBgMessageFrom());
        drawable.setStroke((int) getResources().getDimension(R.dimen.fugu_border_width), hippoColorConfig.getHippoBorderColor()); // set stroke width and stroke color
        aviTyping.setIndicatorColor(hippoColorConfig.getHippoPrimaryTextMsgFrom());
        tvClosed.setTextColor(hippoColorConfig.getHippoThemeColorPrimary());
        tvClosed.getBackground().setColorFilter(hippoColorConfig.getHippoChannelItemBg(), PorterDuff.Mode.SRC_ATOP);
        cvTypeMessage.getBackground().setColorFilter(hippoColorConfig.getHippoTypeMessageBg(), PorterDuff.Mode.SRC_ATOP);
        etMsg.setHintTextColor(hippoColorConfig.getHippoTypeMessageHint());
        etMsg.setTextColor(hippoColorConfig.getHippoTypeMessageText());
        tvNoInternet.setTextColor(hippoColorConfig.getHippoThemeColorPrimary());
    }

    private BroadcastReceiver mMessageReceiverChat = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            // Get extra data included in the Intent
            try {
                JSONObject messageJson = new JSONObject(intent.getStringExtra(MESSAGE));
                HippoLog.d("receiver", "Got message: " + messageJson.toString());
                if (messageJson.getInt(NOTIFICATION_TYPE) == 5) {
                    CommonData.setIsNewchat(true);
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    };

    private BroadcastReceiver nullListenerReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra("status", 0);
            setListener(status);
        }
    };

    private void setListener(int status) {
        HippoLog.e(TAG, "Listener added");
        mClient.setListener(this);
        switch (status) {
            case 1:
                onPongReceived();
                break;
            case 2:
                onWebSocketError();
                break;
            default:

                break;
        }

    }

    private void fetchIntentData() {
        conversation = new Gson().fromJson(getIntent().getStringExtra(FuguAppConstant.CONVERSATION), FuguConversation.class);
        if (conversation.getUnreadCount() > 0) {
            rvMessages.setAlpha(0);
        }
        getUnreadCount();
        HippoLog.d("userName in SDK", "FuguChatActivity onCreate " + conversation.getUserName());
        int chatType = getIntent().getIntExtra(CHAT_TYPE, ChatType.P2P.getOrdinal());
        if (!TextUtils.isEmpty(conversation.getLabel())) {
            label = conversation.getLabel();
        } else {
            label = conversation.getBusinessName();
        }
        if (conversation.getLabelId() != null) {
            labelId = conversation.getLabelId();
        }
        if (conversation.isDisableReply()) {
            llMessageLayout.setVisibility(View.GONE);
        }
        channelId = conversation.getChannelId();
        updateUnreadCount(channelId, labelId);
        HippoNotificationConfig.pushLabelId = labelId;
        HippoNotificationConfig.pushChannelId = conversation.getChannelId();
        currentChannelId = conversation.getChannelId();
        HippoLog.e(TAG, "==" + HippoNotificationConfig.pushChannelId);

        userId = conversation.getUserId();
        enUserId = conversation.getEnUserId();
        userName = StringUtil.toCamelCase(conversation.getUserName());
        status = conversation.getStatus();
        defaultMessage = conversation.getDefaultMessage();
        businessName = conversation.getBusinessName();


        HippoLog.v("is p2p chat", "---> " + isP2P);

        if (chatType == ChatType.GROUP_CHAT.getOrdinal()) {
            isP2P = true;
            fuguCreateConversationParams = new Gson().fromJson(getIntent()
                    .getStringExtra(FuguAppConstant.PEER_CHAT_PARAMS), FuguCreateConversationParams.class);
        } else if (chatType == ChatType.CHAT_BY_TRANSACTION_ID.getOrdinal()) {
            isP2P = true;
            fuguCreateConversationParams = new Gson().fromJson(getIntent()
                    .getStringExtra(FuguAppConstant.PEER_CHAT_PARAMS), FuguCreateConversationParams.class);
            label = "";
        }else {
            fuguCreateConversationParams = new FuguCreateConversationParams(HippoConfig.getInstance().getAppKey(), labelId,
                    enUserId);
        }

        HippoLog.d(TAG, "fuguCreateConversationParams 1 = "+new Gson().toJson(fuguCreateConversationParams));
        setToolbar(myToolbar, label);

        mFuguGetMessageResponse = CommonData.getSingleAgentData(channelId);

    }

    private void setRecyclerViewData1() {
        rvMessages = (RecyclerView) findViewById(R.id.rvMessages);
        fuguMessageAdapter = new FuguMessageAdapter(FuguChatActivity.this, fuguMessageList, rvMessages,
                labelId, conversation, this, this, getSupportFragmentManager());
        if(mFuguGetMessageResponse != null) {
            setAgentName();
        }

        layoutManager = new CustomLinearLayoutManager(FuguChatActivity.this);
        layoutManager.setStackFromEnd(true);
        rvMessages.setHasFixedSize(false);
        rvMessages.setLayoutManager(layoutManager);
        rvMessages.setAdapter(fuguMessageAdapter);
        rvMessages.setItemAnimator(null);

        RecyclerView.ItemAnimator animator = rvMessages.getItemAnimator();

        if (animator instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator) animator).setSupportsChangeAnimations(false);
        }

        setRecyclerViewData();
        rvMessages.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, final int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                switch (newState) {
                    case RecyclerView.SCROLL_STATE_IDLE:
                        runAnim2 = false;
                        if (handler == null) {
                            handler = new Handler();
                            handler.postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    if (!runAnim2) {
                                        animSlideUp = AnimationUtils.loadAnimation(getApplicationContext(),
                                                R.anim.fugu_slide_up_time);
                                        tvDateLabel.startAnimation(animSlideUp);
                                        tvDateLabel.setVisibility(View.INVISIBLE);
                                        animSlideUp.setAnimationListener(new Animation.AnimationListener() {
                                            @Override
                                            public void onAnimationStart(Animation animation) {
                                            }

                                            @Override
                                            public void onAnimationEnd(Animation animation) {
                                                runAnim = true;
                                                handler = null;
                                            }

                                            @Override
                                            public void onAnimationRepeat(Animation animation) {

                                            }
                                        });
                                    } else {
                                        handler = null;
                                    }
                                }
                            }, 1200);
                        }


                        break;
                    case RecyclerView.SCROLL_STATE_SETTLING:
                        break;
                    case AbsListView.OnScrollListener.SCROLL_STATE_TOUCH_SCROLL:
                        HippoLog.d(TAG, "scroll down triggered");
                        tvDateLabel.clearAnimation();
                        runAnim2 = true;
                        if (runAnim) {
                            tvDateLabel.setVisibility(View.VISIBLE);
                            tvDateLabel.clearAnimation();
                            animSlideDown = AnimationUtils.loadAnimation(getApplicationContext(),
                                    R.anim.fugu_slide_down_time);
                            tvDateLabel.startAnimation(animSlideDown);
                            animSlideDown.setAnimationListener(new Animation.AnimationListener() {
                                @Override
                                public void onAnimationStart(Animation animation) {
                                    runAnim = false;
                                }

                                @Override
                                public void onAnimationEnd(Animation animation) {
                                }

                                @Override
                                public void onAnimationRepeat(Animation animation) {

                                }
                            });
                            break;
                        }
                }
            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                position = layoutManager.findFirstVisibleItemPosition();

                if (previousPos > position && fuguMessageList.size() != 0) {
                    if (fuguMessageList.get(position).getType() == ListItem.ITEM_TYPE_SELF || fuguMessageList.get(position).getType() == ListItem.ITEM_TYPE_OTHER) {
                        if (!TextUtils.isEmpty(((EventItem) fuguMessageList.get(position)).getEvent().getSentAtUtc())) {
                            tvDateLabel.setText(DateUtils.getDate(dateUtils.convertToLocal(((EventItem) fuguMessageList.get(position)).getEvent().getSentAtUtc())));
                        }
                    }
                } else if (fuguMessageList.size() != 0) {
                    if (fuguMessageList.get(position).getType() == ListItem.TYPE_HEADER) {
                        String date = DateUtils.getInstance().getDate(((HeaderItem) fuguMessageList.get(position)).getDate());
                        tvDateLabel.setText(date);
                    }
                }
                if (position == 0 && fuguMessageList.size() >= 25
                        && !allMessagesFetched && pbLoading.getVisibility() == View.GONE) {
                    if (isNetworkAvailable()) {
                        pbLoading.setVisibility(View.VISIBLE);
                        getMessages(null);
                    }
                }
                previousPos = position;
            }
        });
    }

    private void setUpUI() {
        allMessagesFetched = false;
        setRecyclerViewData1();
        if (channelId.compareTo(-1L) == 0 && labelId.compareTo(-1L) != 0 && !conversation.isOpenChat()) {
            globalUuid = UUID.randomUUID().toString();
            fuguMessageList.add(new EventItem(
                    new Message(businessName,
                            -1L,
                            defaultMessage,
                            "",
                            false,
                            onSubscribe == CHANNEL_SUBSCRIBED ? MESSAGE_READ : MESSAGE_UNSENT,
                            0,
                            TEXT_MESSAGE, globalUuid)));
        }

        if (isP2P) {
            HippoLog.v("call createConversation", "setUpUI");
            transactionIdsMap = new HashMap<>();
            if (CommonData.getTransactionIdsMap() != null) {
                transactionIdsMap = CommonData.getTransactionIdsMap();
            }
            if (!transactionIdsMap.isEmpty() && transactionIdsMap.get(fuguCreateConversationParams.getTransactionId()) != null) {
                channelId = transactionIdsMap.get(fuguCreateConversationParams.getTransactionId());
                pbLoading.setVisibility(View.GONE);
                pbPeerChat.setVisibility(View.GONE);
                llMessageLayout.setVisibility(View.VISIBLE);
                cvTypeMessage.setVisibility(View.VISIBLE);
                //getMessagesFromCache();
                getSavedMessages();
            } else {
                pbPeerChat.setVisibility(View.VISIBLE);
                llMessageLayout.setVisibility(View.GONE);
                cvTypeMessage.setVisibility(View.GONE);
            }
            createConversation(TEXT_MESSAGE, getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, isP2P);
            pbSendingImage.setVisibility(View.GONE);
        } else if (conversation.getChannelId() != null && conversation.getChannelId() > 0) {
            getSavedMessages();
            llRoot.setVisibility(View.VISIBLE);
            try {
                if (CommonData.getMessageResponse(conversation.getChannelId()) != null) {
                    label = CommonData.getLabelIdResponse(conversation.getChannelId()).getData().getLabel();
                    setToolbar(myToolbar, label);
                }
            } catch (Exception e) {

            }
            if (status == 0) {
                cvTypeMessage.setVisibility(View.GONE);
                llMessageLayout.setVisibility(View.GONE);
                tvClosed.setVisibility(View.VISIBLE);
            } else {
                getMessages(null);
            }
        } else if (conversation.getLabelId() != null && conversation.getLabelId() > 0) {
            getSavedMessages();
            getByLabelId();
        } else {
            setRecyclerViewData();
            llRoot.setVisibility(View.VISIBLE);

            if (status == 0) {
                cvTypeMessage.setVisibility(View.GONE);
                llMessageLayout.setVisibility(View.GONE);
                tvClosed.setVisibility(View.VISIBLE);
            }
        }
    }

    private void getSavedMessages() {
        showLoading = false;
        //LoadingBox.showOn(this);
        sentMessages = new LinkedHashMap<>();
        unsentMessages = new LinkedHashMap<>();
        fuguMessageList.clear();
        dateItemCount = 0;
        sentAtUTC = "";

        if (channelId > 0 && CommonData.getSentMessageByChannel(channelId) != null) {
            sentMessages = CommonData.getSentMessageByChannel(channelId);
            fuguMessageList.addAll(sentMessages.values());
        }
        List<String> reverseOrderedKeys = new ArrayList<String>(sentMessages.keySet());
        Collections.reverse(reverseOrderedKeys);
        sentAtUTC = "";
        for (String key : reverseOrderedKeys) {
            if (sentMessages.get(key) instanceof HeaderItem) {
                sentAtUTC = key;
                break;
            }
        }

        if(channelId > 0 && CommonData.getUnsentMessageMapByChannel(channelId) != null) {
            unsentMessageMapNew = CommonData.getUnsentMessageMapByChannel(channelId);
        }

        if (channelId > 0 && CommonData.getUnsentMessageByChannel(channelId) != null) {
            unsentMessages = CommonData.getUnsentMessageByChannel(channelId);
            if (unsentMessages == null)
                unsentMessages = new LinkedHashMap<>();

            for (String key : unsentMessages.keySet()) {
                ListItem listItem = unsentMessages.get(key);
                Message message = ((EventItem) listItem).getEvent();
                String time = message.getSentAtUtc();
                int expireTimeCheck = message.getIsMessageExpired();

                if (message.getMessageType() != IMAGE_MESSAGE && expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                    message.setIsMessageExpired(1);
                    try {
                        JSONObject messageJson = unsentMessageMapNew.get(key);
                        if(messageJson != null) {
                            messageJson.put("is_message_expired", 1);
                            unsentMessageMapNew.put(key, messageJson);
                        }
                    } catch (Exception e) {
                        //e.printStackTrace();
                    }
                } else if(message.getMessageType() == IMAGE_MESSAGE) {
                    JSONObject messageJson = unsentMessageMapNew.get(key);
                    if(messageJson == null) {
                        message.setMessageStatus(MESSAGE_IMAGE_RETRY);
                    }
                }
            }
            CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
            CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);

            for (String key : unsentMessages.keySet()) {
                ListItem listItem = unsentMessages.get(key);
                String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                    fuguMessageList.add(new HeaderItem(localDate));
                    sentAtUTC = localDate;
                    System.out.println("Date 1: " + localDate);
                }
                fuguMessageList.add(unsentMessages.get(key));
            }
        }
    }

    private Timer timer = new Timer();
    private final long DELAY = 3000; // milliseconds

    private void stateChangeListeners() {
        etMsg.requestFocus();
        etMsg.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }
            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                if (charSequence.length() > 0) {
                    if (isNetworkAvailable()) {
                        ivSend.setClickable(true);
                        ivSend.setAlpha(1f);
                    }
                } else {
                    ivSend.setClickable(false);
                    ivSend.setAlpha(0.5f);
                }
            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (isNetworkAvailable()) {
                    if (isTyping != TYPING_STARTED) {
                        HippoLog.d(TAG, isTyping + "started typing");
                        // publish start typing event
                        if (channelId > -1 && !etMsg.getText().toString().isEmpty()) {
                            isTyping = TYPING_STARTED;
                            publishOnFaye(getString(R.string.fugu_empty), TEXT_MESSAGE, getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, NOTIFICATION_DEFAULT, null);
                        }
                    }

                    timer.cancel();
                    timer = new Timer();
                    timer.schedule(new TimerTask() {
                        @Override
                        public void run() {
                        HippoLog.d(TAG, isTyping + "stopped typing");
                        stopTyping();
                      }
                    },DELAY);
                }
            }
        });

        llRoot.setOnKeyBoardStateChanged(new CustomLinear.OnKeyboardOpened() {
            @Override
            public boolean onKeyBoardStateChanged(boolean isVisible) {
                if (etMsg.hasFocus() && isVisible && fuguMessageAdapter != null && fuguMessageAdapter.getItemCount() > 0) {
                    rvMessages.scrollToPosition(fuguMessageAdapter.getItemCount() - 1);
                }
                return false;
            }
        });
    }

    private void stopTyping() {
        if (isTyping == TYPING_STARTED) {
            isTyping = TYPING_STOPPED;
            publishOnFaye(getString(R.string.fugu_empty), TEXT_MESSAGE,
                    getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, NOTIFICATION_DEFAULT, null);
        }
    }

    private void setUpFayeConnection() {
        // Set FayeClient listener
        if(mClient == null) {
            HippoConfig.getClient(new fayeClient() {
                @Override
                public void Listener(FayeClient client) {
                    mClient = client;
                    afterSetUpFayeConnection();
                }
            });
        } else {
            afterSetUpFayeConnection();
        }
    }

    private void afterSetUpFayeConnection() {
        mClient.setListener(this);
        if (!mClient.isConnectedServer() && isNetworkAvailable()) {
            mClient.connectServer();
        } else {
            if (!isNetworkAvailable()) {
                setConnectionMessage(1);
            }
        }
    }

    private void sendReadAcknowledgement() {
        if (channelId > -1) {
            publishOnFaye(getString(R.string.fugu_empty), 0,
                    getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, NOTIFICATION_READ_ALL, null);
        }
    }

    private void updateFeedback(final int position) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                fuguMessageAdapter.notifyItemChanged(position);
            }
        });
    }

    private void updateFeedback(final int position, final boolean scrollDown) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (scrollDown) {
                    fuguMessageAdapter.notifyDataSetChanged();
                    scrollListToBottom();
                } else {
                    fuguMessageAdapter.notifyItemChanged(position);
                }
            }
        });
    }

    private void scrollListToBottom() {
        try {
            rvMessages.scrollToPosition(fuguMessageList.size() - 1);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void readFunctionality(JSONObject messageJson) {
        if (HippoConfig.getInstance().getUserData().getUserId().compareTo(messageJson.optLong(USER_ID)) != 0) {
            for (int i = 0; i < fuguMessageList.size(); i++) {
                if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF) {
                    if (((EventItem) fuguMessageList.get(i)).getEvent().getMessageStatus() == MESSAGE_SENT) {
                        ((EventItem) fuguMessageList.get(i)).getEvent().setMessageStatus(MESSAGE_READ);
                    }
//                    else {
//                        int status = ((EventItem) fuguMessageList.get(i)).getEvent().getMessageStatus();
//                        ((EventItem) fuguMessageList.get(i)).getEvent().setMessageStatus(status);
//                    }
                }
            }
        }
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                rvMessages.getRecycledViewPool().clear();
                fuguMessageAdapter.notifyDataSetChanged();
            }
        });
    }

    void removeItemAndUpdateUI() {
        if (CommonData.getQuickReplyData() != null) {
            try {
                String defaultActionId;
                if (!TextUtils.isEmpty(CommonData.getQuickReplyData().getDefaultActionId())) {
                    defaultActionId = CommonData.getQuickReplyData().getDefaultActionId();
                } else {
                    defaultActionId = CommonData.getQuickReplyData().getContentValue().get(0).getActionId();
                }
                sendQuickReply(CommonData.getQuickReplyData(), 0, defaultActionId);

                fuguMessageList.remove(new EventItem(CommonData.getQuickReplyData()));
                CommonData.clearQuickReplyData();
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        fuguMessageAdapter.notifyDataSetChanged();
                    }
                });
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
//            if(CommonData.getQuickReplyData() != null)
//                fuguMessageList.remove(new EventItem(CommonData.getQuickReplyData()));
        }
    }

    private JSONObject prepareMessageJson(int onSubscribe) {
        JSONObject messageJson = new JSONObject();
        try {
            messageJson.put(USER_ID, String.valueOf(userId));
            messageJson.put(FULL_NAME, userName);
            messageJson.put(IS_TYPING, isTyping);
            messageJson.put(MESSAGE, "");
            messageJson.put(MESSAGE_TYPE, TEXT_MESSAGE);
            messageJson.put(USER_TYPE, ANDROID_USER);
            messageJson.put(ON_SUBSCRIBE, onSubscribe);
            messageJson.put(CHANNEL_ID, channelId);

            String localDate = DateUtils.getFormattedDate(new Date());
            messageJson.put(DATE_TIME, DateUtils.getInstance().convertToUTC(localDate));

        } catch (JSONException e) {
            e.printStackTrace();
        }

        return messageJson;
    }


    private void publishOnFaye(final String message, final int messageType, final String url, final String thumbnailUrl,
                               final FuguFileDetails fileDetails, final int notificationType, String uuid) {
        try {
            publishMessage(message, messageType, url, thumbnailUrl, fileDetails, notificationType, uuid, 0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void publishMessage(String message, int messageType, String url, String thumbnailUrl, FuguFileDetails fileDetails,
                                int notificationType, String uuid, int position) throws JSONException {
        if (isNetworkAvailable()) {
            String localDate = DateUtils.getFormattedDate(new Date());
            HippoLog.d("userName in SDK", "publishOnFaye " + userName);
            //To be shifted
            JSONObject messageJson = new JSONObject();

            if (notificationType == NOTIFICATION_READ_ALL) {
                messageJson.put(NOTIFICATION_TYPE, notificationType);
                messageJson.put(CHANNEL_ID, channelId);
            } else {
                messageJson.put(FULL_NAME, userName);
                messageJson.put(MESSAGE, message);
                messageJson.put(MESSAGE_TYPE, messageType);
                messageJson.put(DATE_TIME, DateUtils.getInstance().convertToUTC(localDate));
                if (position == 0) {
                    messageJson.put(MESSAGE_INDEX, fuguMessageList.size() - 1);
                } else {
                    messageJson.put(MESSAGE_INDEX, position);
                }
                if (uuid != null) {
                    messageJson.put("UUID", uuid);
                }
                if (messageType == IMAGE_MESSAGE && !url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put(IMAGE_URL, url);
                    messageJson.put(THUMBNAIL_URL, thumbnailUrl);
                }

                if (messageType == FILE_MESSAGE && !url.trim().isEmpty()) {
                    messageJson.put("url", url);
                    messageJson.put("file_name", fileDetails.getFileName());
                    messageJson.put("file_size", fileDetails.getFileSize());
                }

                if (messageType == TEXT_MESSAGE) {
                    messageJson.put(IS_TYPING, isTyping);
                } else {
                    messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
                }

                messageJson.put(MESSAGE_STATUS, MESSAGE_UNSENT);
            }

            messageJson.put(USER_ID, String.valueOf(userId));
            messageJson.put(USER_TYPE, ANDROID_USER);

            if (mClient.isConnectedServer())
                mClient.publish("/" + String.valueOf(channelId), messageJson);
            else {
                setListener(0);
                mClient.connectServer();
            }
            //end to be shifted
        } else if (!message.isEmpty() && messageType == TEXT_MESSAGE) {

        }
    }


    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            //noinspection ConstantConditions
            switch (intent.getAction()) {
                case NETWORK_STATE_INTENT:
                    HippoLog.d(TAG, "Network connectivity change " + intent.getBooleanExtra("isConnected", false));
                    if (intent.getBooleanExtra("isConnected", false)) {
                        if (mClient != null) {
                            mClient.setListener(FuguChatActivity.this);
                            new Handler().postDelayed(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        connectAgainToServer();
                                    } catch (Exception e) {

                                    }
                                }
                            }, 500);

                        }
                        if (unsentMessageMapNew.size() == 0) {
                            pageStart = 1;
                            if (isP2P)
                                getMessages(label);
                            else
                                getMessages(null);
                        } else {
                            isNetworkStateChanged = true;
                            btnRetry.setText("Connecting...");
                        }
                        enableButtons();
                    } else {
                        setConnectionMessage(4);
                    }
                    break;

                case NOTIFICATION_TAPPED:

                    conversation = new Gson().fromJson(intent.getStringExtra(FuguAppConstant.CONVERSATION), FuguConversation.class);

                    channelId = conversation.getChannelId();
                    userId = conversation.getUserId();
                    labelId = conversation.getLabelId();
                    HippoNotificationConfig.pushChannelId = channelId;
                    HippoNotificationConfig.pushLabelId = labelId;
                    currentChannelId = channelId;

                    pageStart = 1;
                    setUpUI();
                    if (mClient.isConnectedServer()) {
                        mClient.unsubscribeAll();
                        mClient.subscribeChannel("/" + String.valueOf(channelId));
                    } else {
                        mClient.connectServer();
                    }
                    break;
            }

        }
    };

    private void enableButtons() {
        try {
            if (etMsg.getText().toString().trim().length() > 0 && isNetworkAvailable()) {
                ivSend.setClickable(true);
                ivSend.setAlpha(1f);
            } else {
                ivSend.setClickable(false);
                ivSend.setAlpha(0.5f);
            }
            if(!isNetworkAvailable() && fayeDisconnect) {
                ivSend.setAlpha(0.5f);
            }
        } catch (Exception e) {

        }
    }

    private void startAnim() {
        aviTyping.show();
        aviTyping.setVisibility(View.VISIBLE);
        llTyping.setVisibility(View.VISIBLE);

    }

    private void stopAnim() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                llTyping.setVisibility(View.GONE);
                aviTyping.setVisibility(View.GONE);
                aviTyping.hide();
            }
        });
    }

    private boolean isFirstTimeOpened = true;
    private boolean isFromFilePicker = false;

    @Override
    protected void onResume() {
        super.onResume();
        NotificationManager nm = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        if (nm != null) {
            nm.cancelAll();
        }
        HippoNotificationConfig.pushChannelId = channelId;
        HippoNotificationConfig.pushLabelId = labelId;
        currentChannelId = channelId;
        KeyboardUtil.addKeyboardToggleListener(FuguChatActivity.this, this);

        if (isNetworkAvailable())
            setUpFayeConnection();

        if(isFromFilePicker) {
            isFromFilePicker = false;
        } else {
            if (CommonData.getPushBoolean() && CommonData.getPushChannel().compareTo(channelId) == 0) {
                allMessagesFetched = false;
                pageStart = 1;
                //setConnectionMessage(1);
                //apiGetMessages(null, true);
                getMessages(null);
            } else if (!isFirstTimeOpened && isNetworkAvailable()) {
                allMessagesFetched = false;
                pageStart = 1;
                apiGetMessages(null, true);
            }
            isFirstTimeOpened = false;
            CommonData.setPushBoolean(false);
            CommonData.clearPushChannel();
        }

        new Thread(new Runnable() {
            @Override
            public void run() {
                if(fuguMessageAdapter != null)
                    fuguMessageAdapter.attachObservers(true);
            }
        }).start();
    }

    @Override
    protected void onPause() {
        super.onPause();
        HippoNotificationConfig.pushChannelId = -1L;
        HippoNotificationConfig.pushLabelId = -1L;
        CommonData.setPushChannel(channelId);

        if (unsentMessageMapNew != null && unsentMessageMapNew.size() == 0) {
            CommonData.removeUnsentMessageMapChannel(channelId);
        } else {
            CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
        }

        if(unsentMessages != null && unsentMessages.size() == 0) {
            CommonData.removeUnsentMessageChannel(channelId);
        } else {
            CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
        }

        if (channelId > 0) {
            if(!TextUtils.isEmpty(audioMuid)) {
                ListItem listItem = sentMessages.get(audioMuid);
                ((EventItem) listItem).getEvent().setAudioPlaying(false);
                CommonMediaPlayer.getInstance().stopMedia();
            }
            CommonData.setSentMessageByChannel(channelId, sentMessages);
        }

        // Fire stop typing event on Faye before close the chat
        stopTyping();
        stopAnim();
        KeyboardUtil.removeKeyboardToggleListener(this);
        new Thread(new Runnable() {
            @Override
            public void run() {
                if(fuguMessageAdapter != null)
                    fuguMessageAdapter.attachObservers(false);
            }
        }).start();
    }


    @Override
    protected void onDestroy() {
        CommonData.clearQuickReplyData();
        HippoLog.e(TAG, "onDestroy");
        try {
            if (unsentMessageMapNew != null && unsentMessageMapNew.size() == 0) {
                CommonData.removeUnsentMessageMapChannel(channelId);
            } else {
                CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
            }

            if(unsentMessages != null && unsentMessages.size() == 0) {
                CommonData.removeUnsentMessageChannel(channelId);
            } else {
                CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
            }
        } catch (Exception e) {

        }
        if (channelId > 0) {
            HippoLog.e(TAG, "count in onDestroy: " + channelId);
            CommonData.setSentMessageByChannel(channelId, sentMessages);
        }
        try {
            LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiver);
            LocalBroadcastManager.getInstance(this).unregisterReceiver(mMessageReceiverChat);
            LocalBroadcastManager.getInstance(this).unregisterReceiver(nullListenerReceiver);
            LocalBroadcastManager.getInstance(this).unregisterReceiver(fileUploadReceiver);

            updateUnreadCount(channelId, labelId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        messagesApi.clear();
        super.onDestroy();
        try {
            // Fire stop typing event on Faye before closing the chat
            stopTyping();
            stopFayeClient();

            HippoNotificationConfig.pushChannelId = -1L;
            HippoNotificationConfig.pushLabelId = -1L;
            currentChannelId = -1L;
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopFayeClient() {
        try {
            HandlerThread thread = new HandlerThread("TerminateThread");
            thread.start();
            new Handler(thread.getLooper()).post(new Runnable() {
                @Override
                public void run() {
                    if (mClient.isConnectedServer()) {
                        mClient.disconnectServer();
                        mClient.setListener(null);
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.ivSend) {
            if (!isNetworkAvailable() || fayeDisconnect) {
                try {
                    connectAgainToServer();
                } catch (Exception e) {

                }
                return;
            }
            if (!etMsg.getText().toString().trim().isEmpty()) {
                if (channelId.compareTo(-1L) > 0) {
                    removeItemAndUpdateUI();
                    sendMessage(etMsg.getText().toString().trim(), TEXT_MESSAGE, "", "", null, null, null);
                } else {
                    if (mClient.isConnectedServer()) {
                        if (!isConversationCreated) {
                            conversation.setChannelStatus(ChannelStatus.OPEN.getOrdinal());
                            HippoLog.v("call createConversation", "onClick");
                            createConversation(TEXT_MESSAGE, "", "", null, isP2P);
                        }
                    } else {
                        mClient.connectServer();
                        Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                    }
                }
            }
        } else if(v.getId() == R.id.ivVideoView) {
            if(CommonData.getVideoCallStatus())
                videoCallInit(VIDEO_CALL_VIEW);
            else
                Toast.makeText(FuguChatActivity.this, "This feature not supported", Toast.LENGTH_SHORT).show();
        } else if(v.getId() == R.id.ivAudioView) {
            videoCallInit(AUDIO_CALL_VIEW);
        } else if (v.getId() == R.id.ivAttachment) {
            if (checkButtonClick()) {
//                showChooser();
                selectImage(v);
            }
//            else {
//                Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
//            }
        } else if (v.getId() == R.id.tvNoInternet) {
            if (isP2P) {
                pbPeerChat.setVisibility(View.VISIBLE);
                tvNoInternet.setVisibility(View.GONE);
                HippoLog.v("call createConversation", "onClick no internet");
                createConversation(TEXT_MESSAGE, getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, isP2P);
            } else if (conversation.isOpenChat() && conversation.getLabelId().compareTo(-1L) != 0) {
                HippoLog.e(TAG, "onClick: " + CommonData.getConversationList().get(0).getLabelId());
                tvNoInternet.setVisibility(View.GONE);
                getByLabelId();
            } else {
                pageStart = 1;
                tvNoInternet.setVisibility(View.GONE);
                getMessages(null);
            }
        }
    }

    private void createConversation(JSONObject jsonObject) {
        createConversation(IMAGE_MESSAGE, "", "", null, isP2P, jsonObject);
    }

    private void createConversation(final int messageType, final String url, final String thumbnailUrl,
                                    final FuguFileDetails fileDetails, final boolean isP2P) {
        createConversation(messageType, url, thumbnailUrl, fileDetails, isP2P, null);
    }


    private boolean isChannelCreated = false;
    private void createConversation(final JSONObject jsonObject, Long labelId) {
        if(isChannelCreated && channelId.compareTo(-1l) > 0) {
            try {
                new Handler().postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        if (mClient.isConnectedServer())
                            mClient.publish("/" + String.valueOf(channelId), jsonObject);
                    }
                }, 500);
            } catch (Exception e) {

            }
            return;
        }
        if (isNetworkAvailable()) {
            ArrayList<String> groupingTags = new ArrayList<>();
            if (fuguCreateConversationParams.getGroupingTags() != null && fuguCreateConversationParams.getGroupingTags().size() > 0)
                groupingTags.addAll(fuguCreateConversationParams.getGroupingTags());

            try {
                if (CommonData.getUserDetails() != null && CommonData.getUserDetails().getData() != null
                        && CommonData.getUserDetails().getData().getGroupingTags() != null
                        && CommonData.getUserDetails().getData().getGroupingTags().size() > 0) {
                    for (com.hippo.model.GroupingTag groupingTag : CommonData.getUserDetails().getData().getGroupingTags()) {
                        groupingTags.add(groupingTag.getTagName());
                    }
                }
            } catch (Exception e) {

            }
            fuguCreateConversationParams.setGroupingTags(groupingTags);
            if(labelId.compareTo(-1l)>0) {
                fuguCreateConversationParams.setLabelId(labelId);
            }

            RestClient.getApiInterface().createConversation(fuguCreateConversationParams)
                    .enqueue(new ResponseResolver<FuguCreateConversationResponse>() {
                        @Override
                        public void success(FuguCreateConversationResponse fuguCreateConversationResponse) {
                            isConversationCreated = true;
                            isFayeChannelActive = true;
                            channelId = fuguCreateConversationResponse.getData().getChannelId();
                            try {
                                transactionIdsMap.put(fuguCreateConversationParams.getTransactionId(),
                                        fuguCreateConversationResponse.getData().getChannelId());
                            } catch (Exception e) {

                            }
                            if (transactionIdsMap != null)
                                CommonData.setTransactionIdsMap(transactionIdsMap);
                            HippoNotificationConfig.pushChannelId = channelId;
                            currentChannelId = channelId;

                            HippoLog.v("channelId in createConversation is", "--> " + fuguCreateConversationResponse.getData().getChannelId());
                            mClient.subscribeChannel("/" + String.valueOf(channelId));
                            mClient.publish("/" + String.valueOf(channelId), prepareMessageJson(1));

                            isTyping = TYPING_SHOW_MESSAGE;

                            if(jsonObject != null) {
                                try {
                                    new Handler().postDelayed(new Runnable() {
                                        @Override
                                        public void run() {
                                            if (mClient.isConnectedServer())
                                                mClient.publish("/" + String.valueOf(channelId), jsonObject);
                                        }
                                    }, 500);
                                } catch (Exception e) {

                                }
                            }


                            FuguGetMessageResponse fuguGetMessageResponse = new FuguGetMessageResponse();

                            fuguGetMessageResponse.setStatusCode(fuguCreateConversationResponse.getStatusCode());
                            fuguGetMessageResponse.setMessage(fuguCreateConversationResponse.getMessage());

                            FuguGetMessageResponse.Data data = fuguGetMessageResponse.getData();


                            data.getMessages().add((new Message(businessName, -1L, defaultMessage, "", false,
                                    MESSAGE_SENT, 0, TEXT_MESSAGE, globalUuid)));

                            if (isP2P)
                                label = fuguCreateConversationResponse.getData().getlabel();
                            data.setLabel(label);
                            data.setFullName(userName);
                            data.setOnSubscribe(onSubscribe);
                            data.setPageSize(25);
                            data.setChannelId(channelId);
                            data.setStatus(STATUS_CHANNEL_OPEN);
                            data.setBusinessName(businessName);

                            fuguGetMessageResponse.setData(data);

                            HippoLog.v("set data is", "--> " + fuguGetMessageResponse.getData().getChannelId());

                            CommonData.setMessageResponse(channelId, fuguGetMessageResponse);
                            isChannelCreated = true;
//                            if (isP2P) {
//
//                                try {
//                                    final String label = fuguCreateConversationResponse.getData().getlabel();
//                                    new Handler().postDelayed(new Runnable() {
//                                        @Override
//                                        public void run() {
//                                            setRecyclerViewData();
//                                            llRoot.setVisibility(View.VISIBLE);
//                                            getMessages(label);
//                                        }
//                                    }, 500);
//                                } catch (Exception e) {
//
//                                }
//
//                            } else {
//                                getUnreadCount();
//                            }
                        }

                        @Override
                        public void failure(APIError error) {

                        }
                    });
        }
    }

    private void createConversation(final int messageType, final String url, final String thumbnailUrl,
                                    final FuguFileDetails fileDetails, final boolean isP2P, final JSONObject jsonObject) {
        if (isNetworkAvailable()) {
            HippoLog.d("userName in SDK", "createConversation " + isP2P);
            HippoLog.d("Chat type in SDK", "chat type value " + fuguCreateConversationParams.toString());

            ArrayList<String> groupingTags = new ArrayList<>();
            if (fuguCreateConversationParams.getGroupingTags() != null && fuguCreateConversationParams.getGroupingTags().size() > 0)
                groupingTags.addAll(fuguCreateConversationParams.getGroupingTags());

            try {
                if (CommonData.getUserDetails() != null && CommonData.getUserDetails().getData() != null
                        && CommonData.getUserDetails().getData().getGroupingTags() != null
                        && CommonData.getUserDetails().getData().getGroupingTags().size() > 0) {
                    for (com.hippo.model.GroupingTag groupingTag : CommonData.getUserDetails().getData().getGroupingTags()) {
                        groupingTags.add(groupingTag.getTagName());
                    }
                }
            } catch (Exception e) {

            }
            fuguCreateConversationParams.setGroupingTags(groupingTags);

            pbSendingImage.setVisibility(View.VISIBLE);
            ivSend.setVisibility(View.VISIBLE);

            RestClient.getApiInterface().createConversation(fuguCreateConversationParams)
                    .enqueue(new ResponseResolver<FuguCreateConversationResponse>(FuguChatActivity.this, false, false) {
                        @Override
                        public void success(FuguCreateConversationResponse fuguCreateConversationResponse) {
                            try {
                                globalUuid = UUID.randomUUID().toString();
                                isConversationCreated = true;
                                isFayeChannelActive = true;
                                channelId = fuguCreateConversationResponse.getData().getChannelId();
                                try {
                                    transactionIdsMap.put(fuguCreateConversationParams.getTransactionId(),
                                            fuguCreateConversationResponse.getData().getChannelId());
                                } catch (Exception e) {

                                }
                                if (transactionIdsMap != null)
                                    CommonData.setTransactionIdsMap(transactionIdsMap);
                                HippoNotificationConfig.pushChannelId = channelId;
                                currentChannelId = channelId;

                                HippoLog.v("channelId in createConversation is", "--> " + fuguCreateConversationResponse.getData().getChannelId());
                                mClient.subscribeChannel("/" + String.valueOf(channelId));
                                mClient.publish("/" + String.valueOf(channelId), prepareMessageJson(1));

                                isTyping = TYPING_SHOW_MESSAGE;

                                pbSendingImage.setVisibility(View.GONE);
                                ivSend.setVisibility(View.VISIBLE);

                                if (messageType == TEXT_MESSAGE && !TextUtils.isEmpty(etMsg.getText().toString().trim())) {
                                    sendMessage(etMsg.getText().toString().trim(), TEXT_MESSAGE, "", "", null, null, null);

//                                    publishOnFaye(etMsg.getText().toString().trim(), TEXT_MESSAGE,
//                                            getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, NOTIFICATION_DEFAULT, globalUuid);
                                } else if (messageType == IMAGE_MESSAGE && jsonObject != null) {
                                    sendMessages();
                                } else if (messageType == IMAGE_MESSAGE) {
                                    publishOnFaye(getString(R.string.fugu_empty), messageType, url,
                                            thumbnailUrl, null, NOTIFICATION_DEFAULT, globalUuid);
                                } else if (messageType == FILE_MESSAGE) {
                                    publishOnFaye(getString(R.string.fugu_empty), messageType, url,
                                            thumbnailUrl, fileDetails, NOTIFICATION_DEFAULT, globalUuid);
                                }

                                FuguGetMessageResponse fuguGetMessageResponse = new FuguGetMessageResponse();

                                fuguGetMessageResponse.setStatusCode(fuguCreateConversationResponse.getStatusCode());
                                fuguGetMessageResponse.setMessage(fuguCreateConversationResponse.getMessage());

                                FuguGetMessageResponse.Data data = fuguGetMessageResponse.getData();


                                data.getMessages().add((new Message(businessName, -1L, defaultMessage, "", false,
                                        MESSAGE_SENT, 0, TEXT_MESSAGE, globalUuid)));

                                if (isP2P)
                                    label = fuguCreateConversationResponse.getData().getlabel();
                                data.setLabel(label);
                                data.setFullName(userName);
                                data.setOnSubscribe(onSubscribe);
                                data.setPageSize(25);
                                data.setChannelId(channelId);
                                data.setStatus(STATUS_CHANNEL_OPEN);
                                data.setBusinessName(businessName);

                                fuguGetMessageResponse.setData(data);

                                HippoLog.v("set data is", "--> " + fuguGetMessageResponse.getData().getChannelId());

                                CommonData.setMessageResponse(channelId, fuguGetMessageResponse);

                                if (isP2P) {
                                    setRecyclerViewData();
                                    llRoot.setVisibility(View.VISIBLE);
                                    getMessages(fuguCreateConversationResponse.getData().getlabel());
                                } else {
                                    getUnreadCount();
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }

                        @Override
                        public void failure(APIError error) {
                            if (error.getStatusCode() == FuguAppConstant.SESSION_EXPIRE) {
                                Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                finish();
                            } else {
                                if (isP2P) {
                                    tvNoInternet.setVisibility(View.VISIBLE);
                                    tvNoInternet.setText(error.getMessage());
                                } else {
                                    Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                                }
                            }

                            pbSendingImage.setVisibility(View.GONE);
                            ivSend.setVisibility(View.VISIBLE);
                        }
                    });
        } else {

            if (isP2P) {
                tvNoInternet.setVisibility(View.VISIBLE);
                pbPeerChat.setVisibility(View.GONE);
            } else {
                Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
            }
            pbSendingImage.setVisibility(View.GONE);
            ivSend.setVisibility(View.VISIBLE);
        }
    }

    private void updateRecycler() {
        if (fuguMessageAdapter != null) {

            fuguMessageAdapter.updateList(fuguMessageList);
            //fuguMessageAdapter.notifyDataSetChanged();
        }

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                try {
                    if (fuguMessageAdapter != null) {
                        try {
//                            fuguMessageAdapter.notifyDataSetChanged();
                            fuguMessageAdapter.notifyItemInserted(fuguMessageList.size() - 1);
                            if (fuguMessageAdapter.getItemCount() > 0) {
                                rvMessages.scrollToPosition(fuguMessageAdapter.getItemCount() - 1);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMessages(final String channelName) {
        HippoLog.d("userName in SDK", "getMessages before call" + userName);
        if (isNetworkAvailable()) {
            if ((HippoConfig.getInstance().getUserData() == null)
                    || (TextUtils.isEmpty(HippoConfig.getInstance().getAppKey()))) {
                new ApiPutUserDetails(FuguChatActivity.this, new ApiPutUserDetails.Callback() {
                    @Override
                    public void onSuccess() {
                        apiGetMessages(channelName);
                    }

                    @Override
                    public void onFailure() {

                    }
                }).sendUserDetails(HippoConfig.getmResellerToken(), HippoConfig.getmReferenceId());
            } else {
                apiGetMessages(channelName);
            }
        } else {
            if (pageStart == 1 &&
                    (CommonData.getMessageResponse(channelId) == null ||
                            CommonData.getMessageResponse(channelId).getData().getMessages().size() == 0)) {
                llRoot.setVisibility(View.GONE);
                tvNoInternet.setVisibility(View.VISIBLE);
            }
            if (isP2P) {
                tvNoInternet.setVisibility(View.VISIBLE);
                pbPeerChat.setVisibility(View.GONE);
            }
            pbLoading.setVisibility(View.GONE);
        }
    }

    boolean isApiRunning;
    private HashSet<String> messagesApi = new HashSet<>();

    private void apiGetMessages(String channelName) {
        apiGetMessages(channelName, false);
    }

    private void apiGetMessages(final String channelName, final boolean isFromOnResume) {
        if (channelId < 0 || isApiRunning) {
            messagesApi.add("getMessages");
            return;
        }
        showLoading = false;
        if (!allMessagesFetched || isNetworkStateChanged) {
            FuguGetMessageParams commonParams = new FuguGetMessageParams(HippoConfig.getInstance().getAppKey(),
                    channelId,
                    enUserId,
                    pageStart,
                    channelName);

            if (isFromOnResume && fuguMessageList.size() > 100)
                commonParams.setPageEnd(fuguMessageList.size() - dateItemCount);

            if(sentMessages == null || sentMessages.size()==0) {
                showLoading = true;
                setConnectionMessage(0);
            } else if (pageStart == 1) {
                //if(!isFromOnResume) {
                    setConnectionMessage(1);
                //}
            }

            isApiRunning = true;
            final int localPageSize = pageStart;

            RestClient.getApiInterface().getMessages(commonParams).enqueue(new ResponseResolver<FuguGetMessageResponse>(FuguChatActivity.this, showLoading, false) {
                @Override
                public void success(FuguGetMessageResponse fuguGetMessageResponse) {
                    isApiRunning = false;
                    if(messagesApi != null && messagesApi.size()>0) {
                        messagesApi.remove("getMessages");
                        isNetworkStateChanged = true;
                        apiGetMessages(channelName, isFromOnResume);
                    }

                    mFuguGetMessageResponse = fuguGetMessageResponse;

                    if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() != null && mFuguGetMessageResponse.getData().getChannelId() != null)
                        CommonData.saveVideoCallAgent(mFuguGetMessageResponse.getData().getChannelId(), mFuguGetMessageResponse);

//                    if(!isFromOnResume)
//                        LoadingBox.showOn(FuguChatActivity.this);
                    HippoLog.e("size of list--->", fuguGetMessageResponse.getData().getMessages().size() + "");
                    if (isP2P) {
                        pbPeerChat.setVisibility(View.GONE);
                        cvTypeMessage.setVisibility(View.VISIBLE);
                        llMessageLayout.setVisibility(View.VISIBLE);
                    }
                    label = fuguGetMessageResponse.getData().getLabel();
                    setToolbar(myToolbar, label);
                    if (fuguGetMessageResponse.getData().isDisableReply()) {
                        llMessageLayout.setVisibility(View.GONE);
                    }
                    if (fuguGetMessageResponse.getData().getMessages() != null) {

                        LinkedHashMap<String, ListItem> tempMessages = new LinkedHashMap<>();
                        LinkedHashMap<String, ListItem> tempSentMessages = new LinkedHashMap<>();

                        String tempSentAtUtc = "";

                        if (localPageSize == 1) {
                            tempSentMessages.putAll(sentMessages);
                            fuguMessageList.clear();
                            sentMessages.clear();
                            dateItemCount = 0;
                            HippoLog.e(TAG, "This is a first page");
                        } else {
                            HippoLog.e(TAG, "No first page");
                        }

                        FuguGetMessageResponse.Data messageResponseData = fuguGetMessageResponse.getData();
                        if (messageResponseData.getMessages().size() < messageResponseData.getPageSize()) {
                            allMessagesFetched = true;
                        } else {
                            allMessagesFetched = false;
                        }
                        onSubscribe = messageResponseData.getOnSubscribe();
                        HippoLog.e("getMessages onSubscribe", "==" + onSubscribe);

                        int dateCount = 0;
                        for (int i = 0; i < messageResponseData.getMessages().size(); i++) {
                            Message messageObj = messageResponseData.getMessages().get(i);
                            boolean isSelf = false;
                            if (messageObj.getUserId().compareTo(userId) == 0)
                                isSelf = true;

                            String localDate = dateUtils.convertToLocal(messageObj.getSentAtUtc(), inputFormat, outputFormat);

                            if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                tempMessages.put(localDate, new HeaderItem(localDate));
                                tempSentAtUtc = localDate;
                                dateItemCount = dateItemCount + 1;
                                dateCount = dateCount + 1;
                            }

                            String muid = messageObj.getMuid();
                            if (TextUtils.isEmpty(muid))
                                muid = TextUtils.isEmpty(String.valueOf(messageObj.getId()))
                                        ? UUID.randomUUID().toString() : String.valueOf(messageObj.getId());

                            Message message = new Message(messageObj.getId(), messageObj.getfromName(),
                                    messageObj.getUserId(),
                                    messageObj.getMessage(),
                                    messageObj.getSentAtUtc(),
                                    isSelf,
                                    messageObj.getMessageStatus(),
                                    i,
                                    messageObj.getUrl(),
                                    messageObj.getThumbnailUrl(),
                                    messageObj.getMessageType(),
                                    messageObj.getMuid());

                            if (messageObj.getCustomAction() != null) {
                                message.setCustomAction(messageObj.getCustomAction());
                            }

                            if(!TextUtils.isEmpty(messageObj.getCallType())) {
                                message.setCallType(messageObj.getCallType());
                            }

                            if (messageObj.getMessageType() == FILE_MESSAGE) {
                                message.setFileExtension(messageObj.getFileExtension());
                                message.setFileName(messageObj.getFileName());
                                message.setFileSize(messageObj.getFileSize());
                                message.setFilePath(messageObj.getFilePath());
                                message.setFileUrl(messageObj.getFileUrl());
                                message.setDocumentType(messageObj.getDocumentType());
                            } else if (messageObj.getMessageType() == FEEDBACK_MESSAGE) {
                                message.setIsRatingGiven(messageObj.getIsRatingGiven());
                                message.setTotalRating(messageObj.getTotalRating());
                                message.setRatingGiven(messageObj.getRatingGiven());
                                message.setComment(messageObj.getComment());
                                message.setLineBeforeFeedback(messageObj.getLineBeforeFeedback());
                                message.setLineAfterFeedback_1(messageObj.getLineAfterFeedback_1());
                                message.setLineAfterFeedback_2(messageObj.getLineAfterFeedback_2());
                            } else if (messageObj.getMessageType() == FUGU_QUICK_REPLY_VIEW) {
                                message.setContentValue(messageObj.getContentValue());
                                message.setDefaultActionId(messageObj.getDefaultActionId());
                                message.setValues(messageObj.getValues());
                                if (messageObj.getValues() != null && messageObj.getValues().size() > 0)
                                    continue;
                            } else if (messageObj.getMessageType() == FUGU_FORUM_VIEW) {
                                message.setContentValue(messageObj.getContentValue());
                                message.setValues(messageObj.getValues());
                                message.setId(messageObj.getId());
                            }

                            message.setVideoCallDuration(messageObj.getVideoCallDuration());
                            message.setMessageState(messageObj.getMessageState());

                            tempMessages.put(muid, new EventItem(message));
                            tempSentMessages.remove(muid);

                            if (!TextUtils.isEmpty(messageObj.getMuid())) {
                                if(unsentMessageMapNew.size() > 0) {
                                    unsentMessageMapNew.remove(messageObj.getMuid());
                                }
                                if(unsentMessages.size() > 0) {
                                    unsentMessages.remove(messageObj.getMuid());
                                }
                            }
                        }

                        if (pageStart == 1) {
                            fuguMessageList.clear();
                        }

                        if (sentMessages.containsKey(tempSentAtUtc)) {
                            sentMessages.remove(tempSentAtUtc);
                            dateItemCount = dateItemCount - 1;
                            dateCount = dateCount - 1;
                        }

                        tempMessages.putAll(sentMessages);
                        sentMessages.clear();
                        sentMessages.putAll(tempMessages);

                        // put local sent messages into updated sent list
                        try {
                            if (tempSentMessages.values().size() > 0) {
                                long lastMessageTime = dateUtils.getTimeInLong(messageResponseData.getMessages()
                                        .get(messageResponseData.getMessages().size() - 1).getSentAtUtc());
                                if (lastMessageTime > 0) {
                                    for (String key : tempSentMessages.keySet()) {
                                        try {
                                            if (tempSentMessages.get(key) instanceof EventItem) {
                                                ListItem listItem = tempSentMessages.get(key);
                                                long localMessageTime = dateUtils.getTimeInLong(((EventItem) listItem).getEvent().getSentAtUtc());
                                                HippoLog.i(TAG, "localMessageTime: " + localMessageTime+" > "+lastMessageTime);
                                                if (localMessageTime > lastMessageTime) {
                                                    HippoLog.e(TAG, "localMessageTime: " + localMessageTime+" > "+lastMessageTime);
                                                    sentMessages.put(((EventItem) listItem).getEvent().getMuid(), listItem);
                                                }
                                            }
                                        } catch (Exception e) {
                                            if(HippoConfig.DEBUG)
                                                e.printStackTrace();
                                        }
                                    }
                                }
                            }
                        } catch (Exception e) {

                        }

                        tempSentMessages.clear();

                        fuguMessageList = new ArrayList<>();
                        fuguMessageList.addAll(sentMessages.values());

                        for (String key : unsentMessages.keySet()) {
                            ListItem listItem = unsentMessages.get(key);
                            String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                            if (!sentMessages.containsKey(localDate)) {
                                if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                    fuguMessageList.add(new HeaderItem(localDate));
                                    tempSentAtUtc = localDate;
                                    System.out.println("Date 2: " + localDate);
                                }
                            }
                            if(unsentMessageMapNew != null && unsentMessageMapNew.size() == 0) {
                                CommonData.removeUnsentMessageMapChannel(channelId);
                            } else {
                                CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMapNew);
                            }


                            if (unsentMessages != null && unsentMessages.size() == 0) {
                                CommonData.removeUnsentMessageChannel(channelId);
                            } else {
                                CommonData.setUnsentMessageByChannel(channelId, unsentMessages);
                            }

                            // update
                            try {
                                JSONObject messageJson = unsentMessageMapNew.get(key);
                                if (messageJson != null) {
                                    messageJson.put("message_index", fuguMessageList.size());
                                    unsentMessageMapNew.put(key, messageJson);
                                }
                                fuguMessageList.add(unsentMessages.get(key));
                            } catch (Exception e) {

                            }
                        }

                        tvNoInternet.setVisibility(View.GONE);
                        llRoot.setVisibility(View.VISIBLE);
                        if (conversation.getUnreadCount() > 0) {
                            rvMessages.setAlpha(0);
                        }

                        if(CommonData.getVideoCallStatus() && fuguGetMessageResponse.getData() != null) {
                            if((fuguGetMessageResponse.getData().isAllowVideoCall() && fuguGetMessageResponse.getData().getAgentId() != null && fuguGetMessageResponse.getData().getAgentId().intValue() > 0)
                                && (fuguGetMessageResponse.getData().isAllowVideoCall()))
                                ivVideoView.setVisibility(View.VISIBLE);
                        } else {
                            ivVideoView.setVisibility(View.GONE);
                        }

                        if(CommonData.getAudioCallStatus() && fuguGetMessageResponse.getData() != null) {
                            if((fuguGetMessageResponse.getData().isAllowAudioCall() && fuguGetMessageResponse.getData().getAgentId() != null && fuguGetMessageResponse.getData().getAgentId().intValue() > 0)
                                    && (fuguGetMessageResponse.getData().isAllowAudioCall()))
                                ivAudioView.setVisibility(View.VISIBLE);
                        } else {
                            ivAudioView.setVisibility(View.GONE);
                        }

                        setAgentName();
                        if (pageStart == 1) {
                            showLoading = false;
                            sentAtUTC = tempSentAtUtc;
                            CommonData.setMessageResponse(channelId, fuguGetMessageResponse);

//                            setRecyclerViewData1();

                            updateRecycler();
                            scrollListToBottom();
//                            fuguMessageAdapter.updateList(fuguMessageList);
//                            fuguMessageAdapter.notifyDataSetChanged();
//                            rvMessages.scrollToPosition(fuguMessageList.size() - 1);
                            /*runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    fuguMessageAdapter.notifyDataSetChanged();
                                    rvMessages.scrollToPosition(fuguMessageList.size() - 1);
                                }
                            });*/
                        } else {
                            pbLoading.setVisibility(View.GONE);
                            fuguMessageAdapter.updateList(fuguMessageList, false);
                            fuguMessageAdapter.notifyItemRangeInserted(0, messageResponseData.getMessages().size() + dateCount);
                        }
                        pageStart = sentMessages.values().size() + 1 - dateItemCount;
                    } else {
                        allMessagesFetched = true;
                    }
                    pbLoading.setVisibility(View.GONE);
                    isP2P = false;
//                    if(!isFromOnResume)
//                        LoadingBox.hide();
                    //if(!isFromOnResume)
                        setConnectionMessage(0);
                    getUnreadCount();
                }

                @Override
                public void failure(APIError error) {
                    setConnectionMessage(0);
                    isApiRunning = false;
                    if (error.getStatusCode() == FuguAppConstant.SESSION_EXPIRE) {
                        Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                        finish();
                    } else {
                        pbLoading.setVisibility(View.GONE);
                        if(messagesApi != null && messagesApi.size()>0) {
                            messagesApi.remove("getMessages");
                            isNetworkStateChanged = true;
                            apiGetMessages(channelName, isFromOnResume);
                        } else if(isP2P) {
                            tvNoInternet.setVisibility(View.VISIBLE);
                            pbPeerChat.setVisibility(View.GONE);
                        } else if (pageStart == 1 &&
                                (CommonData.getMessageResponse(channelId) == null ||
                                        CommonData.getMessageResponse(channelId).getData().getMessages().size() == 0)) {
                            llRoot.setVisibility(View.GONE);
                            tvNoInternet.setVisibility(View.VISIBLE);
                        }
                    }
                }
            });
        }
    }

    private void setAgentName() {
        String agentName = "";

        if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() !=null &&
                !TextUtils.isEmpty(mFuguGetMessageResponse.getData().getAgentName())) {
            agentName = mFuguGetMessageResponse.getData().getAgentName();
        }
        if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() != null && mFuguGetMessageResponse.getData().getOtherUsers() != null
                && mFuguGetMessageResponse.getData().getOtherUsers().size()>0) {
            agentName = mFuguGetMessageResponse.getData().getOtherUsers().get(0).getFullName();
        }

        fullname = agentName;
        if(fuguMessageAdapter != null) {
            fuguMessageAdapter.setAgentName(agentName);
            if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() !=null &&
                    mFuguGetMessageResponse.getData().getAgentId() != null && mFuguGetMessageResponse.getData().getAgentId().intValue() > 0) {
                fuguMessageAdapter.isAudioCallEnabled(mFuguGetMessageResponse.getData().isAllowAudioCall());
                fuguMessageAdapter.isVideoCallEnabled(mFuguGetMessageResponse.getData().isAllowVideoCall());
            }
        }
    }

    private void getByLabelId() {
        if (isNetworkAvailable()) {
            CommonData.clearQuickReplyData();
            if (!allMessagesFetched) {
                FuguGetByLabelIdParams commonParams = new FuguGetByLabelIdParams(HippoConfig.getInstance().getAppKey(),
                        labelId,
                        enUserId,
                        pageStart);

                if(sentMessages == null || sentMessages.size()==0) {
                    showLoading = true;
                    setConnectionMessage(0);
                } else if (pageStart == 1) {
                    setConnectionMessage(1);
                }

                RestClient.getApiInterface().getByLabelId(commonParams)
                        .enqueue(new ResponseResolver<FuguGetMessageResponse>(FuguChatActivity.this, showLoading, false) {
                            @Override
                            public void success(FuguGetMessageResponse fuguGetMessageResponse) {
                                if (pageStart == 1) {
                                    fuguMessageList.clear();
                                    dateItemCount = 0;
                                }

                                mFuguGetMessageResponse = fuguGetMessageResponse;
                                if (!TextUtils.isEmpty(fuguGetMessageResponse.getData().getLabel())) {
                                    label = fuguGetMessageResponse.getData().getLabel();
                                } else if (!TextUtils.isEmpty(conversation.getLabel())) {
                                    label = fuguGetMessageResponse.getData().getLabel();
                                }

                                setToolbar(myToolbar, label);
                                if (fuguGetMessageResponse.getData().isDisableReply()) {
                                    llMessageLayout.setVisibility(View.GONE);
                                }

                                if(CommonData.getVideoCallStatus() && fuguGetMessageResponse.getData() != null
                                        && fuguGetMessageResponse.getData().isAllowVideoCall()
                                        && fuguGetMessageResponse.getData().getAgentId() != null
                                        && fuguGetMessageResponse.getData().getAgentId().intValue() > 0){
                                        ivVideoView.setVisibility(View.VISIBLE);
                                } else {
                                    ivVideoView.setVisibility(View.GONE);
                                }

                                if (fuguGetMessageResponse.getData() != null && fuguGetMessageResponse.getData().getMessages() != null) {
                                    showLoading = false;

                                    LinkedHashMap<String, ListItem> tempMessages = new LinkedHashMap<>();
                                    LinkedHashMap<String, ListItem> tempSentMessages = new LinkedHashMap<>();

                                    String tempSentAtUtc = sentAtUTC;

                                    FuguGetMessageResponse.Data data = fuguGetMessageResponse.getData();
                                    if (data.getMessages().size() < data.getPageSize()) {
                                        allMessagesFetched = true;
                                    } else {
                                        allMessagesFetched = false;
                                    }


                                    HippoLog.d("userName in SDK", "getByLabelId " + userName);
                                    onSubscribe = data.getOnSubscribe();
                                    channelId = data.getChannelId();
                                    HippoNotificationConfig.pushChannelId = data.getChannelId();
                                    conversation.setChannelId(data.getChannelId());
                                    currentChannelId = data.getChannelId();
                                    status = data.getStatus();
                                    businessName = data.getBusinessName();

                                    HippoLog.e("getByLabelId onSubscribe", "==" + onSubscribe);

                                    if (status == STATUS_CHANNEL_CLOSED) {
                                        cvTypeMessage.setVisibility(View.GONE);
                                        llMessageLayout.setVisibility(View.GONE);
                                        tvClosed.setVisibility(View.VISIBLE);
                                    }
                                    for (int i = 0; i < data.getMessages().size(); i++) {
                                        Message messageObj = data.getMessages().get(i);
                                        boolean isSelf = false;
                                        if (messageObj.getUserId().compareTo(userId) == 0)
                                            isSelf = true;

                                        String localDate = dateUtils.convertToLocal(messageObj.getSentAtUtc(), inputFormat, outputFormat);

                                        if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                            tempMessages.put(localDate, new HeaderItem(localDate));
                                            tempSentAtUtc = localDate;
                                            dateItemCount = dateItemCount + 1;
                                        }

                                        String muid = messageObj.getMuid();
                                        if (TextUtils.isEmpty(muid))
                                            muid = UUID.randomUUID().toString();

                                        Message message = new Message(messageObj.getId(), messageObj.getfromName(),
                                                messageObj.getUserId(),
                                                messageObj.getMessage(),
                                                messageObj.getSentAtUtc(),
                                                isSelf,
                                                messageObj.getMessageStatus(),
                                                i,
                                                messageObj.getUrl(),
                                                messageObj.getThumbnailUrl(),
                                                messageObj.getMessageType(),
                                                messageObj.getMuid());

                                        if (messageObj.getCustomAction() != null) {
                                            message.setCustomAction(messageObj.getCustomAction());
                                        }
                                        if(!TextUtils.isEmpty(messageObj.getCallType())) {
                                            message.setCallType(messageObj.getCallType());
                                        }
                                        if (messageObj.getMessageType() == FILE_MESSAGE) {
                                            message.setFileExtension(messageObj.getFileExtension());
                                            message.setFileName(messageObj.getFileName());
                                            message.setFileSize(messageObj.getFileSize());
                                            message.setFilePath(messageObj.getFilePath());
                                            message.setFileUrl(messageObj.getFileUrl());
                                            message.setDocumentType(messageObj.getDocumentType());
                                        } else if (messageObj.getMessageType() == FEEDBACK_MESSAGE) {
                                            message.setIsRatingGiven(messageObj.getIsRatingGiven());
                                            message.setTotalRating(messageObj.getTotalRating());
                                            message.setRatingGiven(messageObj.getRatingGiven());
                                            message.setComment(messageObj.getComment());
                                            message.setLineBeforeFeedback(messageObj.getLineBeforeFeedback());
                                            message.setLineAfterFeedback_1(messageObj.getLineAfterFeedback_1());
                                            message.setLineAfterFeedback_2(messageObj.getLineAfterFeedback_2());
                                        } else if (messageObj.getMessageType() == FUGU_QUICK_REPLY_VIEW) {
                                            message.setContentValue(messageObj.getContentValue());
                                            message.setDefaultActionId(messageObj.getDefaultActionId());
                                            message.setValues(messageObj.getValues());
                                            if (messageObj.getValues() != null && messageObj.getValues().size() > 0)
                                                continue;
                                        } else if (messageObj.getMessageType() == FUGU_FORUM_VIEW) {
                                            message.setContentValue(messageObj.getContentValue());
                                            message.setValues(messageObj.getValues());
                                            message.setId(messageObj.getId());
                                        }

                                        try {
                                            message.setMessageState(messageObj.getMessageState());
                                            message.setVideoCallDuration(messageObj.getVideoCallDuration());
                                        } catch (Exception e) {

                                        }

                                        tempMessages.put(muid, new EventItem(message));
                                        tempSentMessages.remove(muid);

                                        if (!TextUtils.isEmpty(messageObj.getMuid()) && unsentMessageMapNew.size() > 0) {
                                            unsentMessageMapNew.remove(messageObj.getMuid());
                                            unsentMessages.remove(messageObj.getMuid());
                                        }
                                    }

                                    if (sentMessages.containsKey(tempSentAtUtc)) {
                                        sentMessages.remove(tempSentAtUtc);
                                        dateItemCount = dateItemCount - 1;
                                    }

                                    tempMessages.putAll(sentMessages);
                                    sentMessages.clear();
                                    sentMessages.putAll(tempMessages);

                                    // put local sent messages into updated sent list
                                    if (tempSentMessages.values().size() > 0) {
                                        long lastMessageTime = dateUtils.getTimeInLong(data.getMessages().get(data.getMessages().size() - 1).getSentAtUtc());
                                        if (lastMessageTime > 0) {
                                            for (String key : tempSentMessages.keySet()) {
                                                try {
                                                    if (tempSentMessages.get(key) instanceof EventItem) {
                                                        ListItem listItem = tempSentMessages.get(key);
                                                        long localMessageTime = dateUtils.getTimeInLong(((EventItem) listItem).getEvent().getSentAtUtc());
                                                        Log.i(TAG, "localMessageTime: " + localMessageTime);
                                                        if (localMessageTime > lastMessageTime) {
                                                            sentMessages.put(((EventItem) listItem).getEvent().getMuid(), listItem);
                                                        }
                                                    }
                                                } catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        }
                                    }

                                    tempSentMessages.clear();

                                    fuguMessageList = new ArrayList<>();
                                    fuguMessageList.addAll(sentMessages.values());

                                    for (String key : unsentMessages.keySet()) {
                                        ListItem listItem = unsentMessages.get(key);
                                        String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                                        String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                                        //String date = dateUtils.getDate();
                                        if (!tempSentAtUtc.equalsIgnoreCase(localDate)) {
                                            fuguMessageList.add(new HeaderItem(localDate));
                                            tempSentAtUtc = localDate;
                                            System.out.println("Date 3: " + localDate);
                                        }

                                        // update
                                        try {
                                            JSONObject messageJson = unsentMessageMapNew.get(key);
                                            if (messageJson != null) {
                                                messageJson.put("message_index", fuguMessageList.size());
                                                unsentMessageMapNew.put(key, messageJson);
                                                fuguMessageList.add(unsentMessages.get(key));
                                            } else {
                                                fuguMessageList.remove(key);
                                            }
                                        } catch (JSONException e) {

                                        }
                                    }

                                    tvNoInternet.setVisibility(View.GONE);
                                    llRoot.setVisibility(View.VISIBLE);
                                    if (conversation.getUnreadCount() > 0) {
                                        rvMessages.setAlpha(0);
                                    }
                                    if (pageStart == 1) {
                                        showLoading = false;
                                        sentAtUTC = tempSentAtUtc;
                                        CommonData.setMessageResponse(channelId, fuguGetMessageResponse);
                                        fuguMessageAdapter.updateList(fuguMessageList);
                                        runOnUiThread(new Runnable() {
                                            @Override
                                            public void run() {
                                                fuguMessageAdapter.notifyDataSetChanged();
                                                rvMessages.scrollToPosition(fuguMessageList.size() - 1);
                                            }
                                        });
//                                        fuguMessageAdapter.notifyDataSetChanged();
//                                        rvMessages.scrollToPosition(fuguMessageList.size() - 1);
                                    } else {
                                        pbLoading.setVisibility(View.GONE);
                                        fuguMessageAdapter.notifyItemRangeInserted(0, data.getMessages().size());
                                    }
                                    pageStart = fuguMessageList.size() + 1 - dateItemCount;
                                } else {
                                    allMessagesFetched = true;
                                    fuguMessageList.clear();
                                }
                                pbLoading.setVisibility(View.GONE);
                                getUnreadCount();
                            }

                            @Override
                            public void failure(APIError error) {
                                HippoLog.e("error type", error.getType() + "");
                                if (error.getStatusCode() == FuguAppConstant.SESSION_EXPIRE) {
                                    Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                    finish();
                                } else if ((error.getStatusCode() == DATA_UNAVAILABLE && error.getType() == 1)) {
                                    ChatByUniqueIdAttributes attributes = new ChatByUniqueIdAttributes.Builder()
                                            .setTransactionId("7865")
                                            //.setHippoChatType(HippoChatType.CHAT_BY_TRANSACTION_ID)
                                            .setUserUniqueKey(HippoConfig.getInstance().getUserData().getUserUniqueKey())
                                            .setChannelName("Fugu Default")
                                            .setTags(null)
                                            .build();
                                    HippoConfig.getInstance().openChatByUniqueId(attributes);

//                                    HippoConfig.getInstance().openChatByTransactionId("7865",
//                                            HippoConfig.getInstance().getUserData().getUserUniqueKey(), "Fugu Default", null);
                                    //Toast.makeText(FuguChatActivity.this, error.getMessage(), Toast.LENGTH_SHORT).show();
                                    //finish();
                                } else {
                                    if (pageStart == 1 && (CommonData.getLabelIdResponse(labelId) == null
                                            || CommonData.getLabelIdResponse(labelId).getData().getMessages().size() == 0)) {
                                        llRoot.setVisibility(View.GONE);
                                        tvNoInternet.setVisibility(View.VISIBLE);
                                    }

                                    pbLoading.setVisibility(View.GONE);
                                }
                            }
                        });
            }
        } else {
            if (pageStart == 1 && (CommonData.getLabelIdResponse(labelId) == null
                    || CommonData.getLabelIdResponse(labelId).getData().getMessages().size() == 0)) {
                llRoot.setVisibility(View.GONE);
                tvNoInternet.setVisibility(View.VISIBLE);
            }
            pbLoading.setVisibility(View.GONE);
        }
    }

    private void dateParse(ArrayList<Message> messages, boolean isByLabelId) {

    }

    private void setRecyclerViewData() {
        fuguMessageAdapter.notifyDataSetChanged();
        fuguMessageAdapter.setOnRetryListener(new FuguMessageAdapter.OnRetryListener() {
            @Override
            public void onRetry(String file, int messageIndex, int messageType, FuguFileDetails fileDetails, String muid) {
                //uploadFileServerCall(file, "image/*", messageIndex, muid);
            }

            @Override
            public void onMessageRetry(String muid, int position) {
                try {
                    JSONObject jsonObject = unsentMessageMapNew.get(muid);

                    if(jsonObject == null) {
                        return;
                    }
                    ListItem listItem = unsentMessages.get(muid);
//                    Message currentOrderItem = ((EventItem) listItem).getEvent();
//                    JSONObject messageJson = new JSONObject(new Gson().toJson(currentOrderItem));

                    jsonObject.put("is_message_expired", 0);
                    jsonObject.put("message_index", position);
                    String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                    jsonObject.put("date_time", DateUtils.getInstance().convertToUTC(localDate));

                    ((EventItem) listItem).getEvent().setIsMessageExpired(0);
                    ((EventItem) listItem).getEvent().setMessageIndex(position);
                    ((EventItem) listItem).getEvent().setSentAtUtc(DateUtils.getInstance().convertToUTC(localDate));

                    unsentMessageMapNew.put(muid, jsonObject);
                    unsentMessages.put(muid, listItem);
                    fuguMessageList.remove(position);
                    fuguMessageList.add(position, listItem);

                    updateRecycler();
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                    }
                    fuguMessageAdapter.notifyItemRangeChanged(position, fuguMessageList.size());

                    sendMessages();
                } catch (JSONException e) {

                }
            }

            @Override
            public void onMessageCancel(String muid, int position) {
                fuguMessageList.remove(position);
                fuguMessageAdapter.notifyItemRemoved(position);
                boolean isItemFound = false;


                for (String key : unsentMessageMapNew.keySet()) {
                    if (key.equalsIgnoreCase(muid)) {
                        isItemFound = true;
                        continue;
                    }
                    if (isItemFound) {
                        try {
                            ListItem listItem = unsentMessages.get(key);
                            int index = ((EventItem) listItem).getEvent().getMessageIndex();
                            ((EventItem) listItem).getEvent().setMessageIndex(index - 1);
                            JSONObject jsonObject = unsentMessageMapNew.get(key);
                            jsonObject.put("message_index", index);
                            unsentMessageMapNew.put(key, jsonObject);
                            unsentMessages.put(key, listItem);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                unsentMessageMapNew.remove(muid);
                unsentMessages.remove(muid);

                try {
                    String data = Prefs.with(FuguChatActivity.this).getString(KEY, "");
                    ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
                    for(int i=0;i<fileuploadModels.size();i++) {
                        FileuploadModel fileuploadModel = fileuploadModels.get(i);
                        if(fileuploadModel.getMuid().equalsIgnoreCase(muid)) {
                            fileuploadModels.remove(i);
                            String dataNew = new Gson().toJson(fileuploadModels, fileuploadType);
                            Prefs.with(FuguChatActivity.this).save(KEY, dataNew);
                            return;
                        }
                    }
                } catch (Exception e) {
                    if(HippoConfig.DEBUG)
                        e.printStackTrace();
                }

            }

            @Override
            public void onFileMessageRetry(final String muid, final int position) {
                try {
                    ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(FuguChatActivity.this).getString(KEY, ""), fileuploadType);
                    if(fileuploadModels == null)
                        fileuploadModels = new ArrayList<>();
                    if(fileuploadModels.size()>4) {
                        Toast.makeText(FuguChatActivity.this, "Already files in queue. Please wait", Toast.LENGTH_SHORT).show();
                        return;
                    }

                    JSONObject jsonObject = unsentMessageMapNew.get(muid);

                    if(jsonObject == null) {
                        new AlertDialog.Builder(FuguChatActivity.this)
                                .setMessage("Something went wrong. Please try again")
                                .setPositiveButton(R.string.fugu_ok, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(final DialogInterface dialog, final int which) {
                                        onMessageCancel(muid, position);
                                    }
                                })
                                .setNegativeButton(R.string.fugu_cancel, new DialogInterface.OnClickListener() {
                                    @Override
                                    public void onClick(DialogInterface dialog, int which) {

                                    }
                                })
                                .setCancelable(false)
                                .show();
                        return;
                    }
                    ListItem listItem = unsentMessages.get(muid);

                    jsonObject.put("is_message_expired", 0);
                    jsonObject.put("message_index", position);
                    String localDate = DateUtils.getInstance().getFormattedDate(new Date());
                    jsonObject.put("date_time", DateUtils.getInstance().convertToUTC(localDate));

                    ((EventItem) listItem).getEvent().setIsMessageExpired(0);
                    ((EventItem) listItem).getEvent().setMessageIndex(position);
                    ((EventItem) listItem).getEvent().setSentAtUtc(DateUtils.getInstance().convertToUTC(localDate));

                    ((EventItem) listItem).getEvent().setUploadStatus(FuguAppConstant.UPLOAD_IN_PROGRESS);

                    unsentMessageMapNew.put(muid, jsonObject);
                    unsentMessages.put(muid, listItem);
                    fuguMessageList.remove(position);
                    fuguMessageList.add(position, listItem);

                    updateRecycler();
                    if (fuguMessageAdapter != null) {
                        fuguMessageAdapter.updateList(fuguMessageList);
                    }
                    fuguMessageAdapter.notifyItemRangeChanged(position, fuguMessageList.size());

                    if (!TextUtils.isEmpty(jsonObject.optString("local_url"))) {
                        String fileName = jsonObject.optString("file_name");
                        String fileSize = jsonObject.optString("file_size");
                        String filePath = jsonObject.optString("local_url");

                        FileuploadModel fileuploadModel = new FileuploadModel(fileName, fileSize, filePath, muid);

                        fileuploadModel.setChannelId(channelId);
                        fileuploadModel.setFileUploaded(false);
                        fileuploadModel.setDocumentType(jsonObject.optString("document_type"));
                        fileuploadModel.setMessageIndex(jsonObject.optInt("message_index"));
                        fileuploadModel.setMessageType(jsonObject.optInt("message_type"));
                        fileuploadModel.setMessageObject(jsonObject);

                        uploadFile(fileuploadModel);
                    } else {
                        if (isNetworkAvailable()) {
                            sendMessages();
                        }
                    }

                    //sendMessages();
                } catch (JSONException e) {

                }
            }
        });

        // Add the scroll listener
        rvMessages.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                if (layoutManager.findFirstVisibleItemPosition() == 0 && fuguMessageList.size() >= 25
                        && !allMessagesFetched && pbLoading.getVisibility() == View.GONE) {
                    if (mClient.isConnectedServer()) {
                        pbLoading.setVisibility(View.VISIBLE);
                    }
                    if (unsentMessages.size() == 0) {
                        getMessages(null);
                    }
                }
            }
        });

        fuguMessageAdapter.setOnVideoCallListener(new FuguMessageAdapter.onVideoCall() {
            @Override
            public void onVideoCallClicked(int callType) {
                videoCallInit(callType);
//                if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() != null
//                        && !mFuguGetMessageResponse.getData().isAllowVideoCall()) {
//                    Toast.makeText(FuguChatActivity.this, "", Toast.LENGTH_SHORT).show();
//                } else
//                    {
                    //if (CommonData.getVideoCallStatus() && isAllowVideoCall())
                        //videoCallInit();
//                }
            }
        });



        String agentName = "";
        if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() !=null &&
                !TextUtils.isEmpty(mFuguGetMessageResponse.getData().getAgentName())) {
            agentName = mFuguGetMessageResponse.getData().getAgentName();
        }
        if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData() != null && mFuguGetMessageResponse.getData().getOtherUsers() != null
                && mFuguGetMessageResponse.getData().getOtherUsers().size()>0) {
            agentName = mFuguGetMessageResponse.getData().getOtherUsers().get(0).getFullName();
        }

        if(fuguMessageAdapter != null)
            fuguMessageAdapter.setAgentName(agentName);
    }

    private boolean isAllowVideoCall() {
        try {
            if(mFuguGetMessageResponse != null && mFuguGetMessageResponse.getData().isAllowVideoCall())
                return true;
            else
                return false;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            hideKeyboard(FuguChatActivity.this);
            onBackPressed(); // close this context and return to preview context (if there is any)
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onBackPressed() {
        CommonData.clearQuickReplyData();
        if (mClient.isConnectedServer()) {
            isTyping = TYPING_STOPPED;
            publishOnFaye(getString(R.string.fugu_empty), TEXT_MESSAGE,
                    getString(R.string.fugu_empty), getString(R.string.fugu_empty), null, NOTIFICATION_DEFAULT, null);
            mClient.publish("/" + String.valueOf(channelId), prepareMessageJson(CHANNEL_UNSUBSCRIBED));
        }

        FuguChannelsActivity.isRefresh = true;
        FuguChannelsActivity.readChannelId = channelId;
        FuguChannelsActivity.readLabelId = labelId;

        Intent intent = new Intent();
        if (fuguMessageList.size() > 0) {
            conversation.setChannelId(channelId);
            conversation.setLabelId(labelId);
            conversation.setDefaultMessage(((EventItem) fuguMessageList.get(fuguMessageList.size() - 1)).getEvent().getMessage());
            conversation.setDateTime(((EventItem) fuguMessageList.get(fuguMessageList.size() - 1)).getEvent().getSentAtUtc());
            conversation.setLast_sent_by_id(((EventItem) fuguMessageList.get(fuguMessageList.size() - 1)).getEvent().getUserId());
            conversation.setLast_message_status(((EventItem) fuguMessageList.get(fuguMessageList.size() - 1)).getEvent().getMessageStatus());
            conversation.setMessage_type(((EventItem) fuguMessageList.get(fuguMessageList.size() - 1)).getEvent().getMessageType());
            intent.putExtra(FuguAppConstant.CONVERSATION, new Gson().toJson(conversation, FuguConversation.class));

            setResult(RESULT_OK, intent);
        } else {
            setResult(RESULT_CANCELED, intent);
        }

        super.onBackPressed();
    }



    /*private void compressAndSaveImageBitmap() {
        try {
            String image = fuguImageUtils.compressAndSaveBitmap(FuguChatActivity.this);//(null, squareEdge);
            if (image == null) {
                Toast.makeText(FuguChatActivity.this, "Could not read from source", Toast.LENGTH_LONG).show();
            } else {
                globalUuid = UUID.randomUUID().toString();
//                addMessageToList(getString(R.string.fugu_empty), IMAGE_MESSAGE, image, image, null, globalUuid);
            }
        } catch (Exception e) {
            e.printStackTrace();
            Toast.makeText(FuguChatActivity.this, "Could not read from source", Toast.LENGTH_LONG).show();
        }
    }*/


    @Override
    public void onAnimationStart(Animation animation) {
        if (!(tvDateLabel.getVisibility() == View.VISIBLE)) {
            tvDateLabel.clearAnimation();
        }

    }

    @Override
    public void onAnimationEnd(Animation animation) {
    }

    @Override
    public void onAnimationRepeat(Animation animation) {

    }

    /**
     * Called when a custom action button is clicked
     *
     * @param buttonAction the action button object associated with this button
     */
    public void onCustomActionClicked(final Object buttonAction) {
        //send a broadcast to listening parent app
        String payload = new Gson().toJson(buttonAction);
        Intent intent = new Intent();
        intent.putExtra(FUGU_CUSTOM_ACTION_PAYLOAD, payload);
        intent.setAction(FUGU_CUSTOM_ACTION_SELECTED);
        sendBroadcast(intent);

    }

    private void getUnreadCount() {
//        try {
//            if(!HippoConfig.getInstance().isChannelActivity()) {
//                HippoConfig.getInstance().getUnreadCount();
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
    }

    @Override
    public void onSubmitRating(String text, Message currentOrderItem, int position) {
        try {
            sendFeedbackData(currentOrderItem, position);
        } catch (Exception e) {
            e.printStackTrace();
            showErrorMessage();
        }
    }

    private void showErrorMessage() {
        new CustomAlertDialog.Builder(FuguChatActivity.this)
                .setMessage("Error in publishing message to faye")
                .setPositiveButton("Ok", null)
                .show();
    }

    @Override
    public void onRatingSelected(int rating, Message currentOrderItem) {
        currentOrderItem.setRatingGiven(rating);
    }

    @Override
    public void onFormDataCallback(Message currentOrderItem) {
        try {
            sendFormData(currentOrderItem);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendFeedbackData(Message currentOrderItem, int position) throws Exception {
        if (isNetworkAvailable()) {
            currentOrderItem.setIsRatingGiven(1);
            currentOrderItem.setTotalRating(5);
            currentOrderItem.setUserId(CommonData.getUserDetails().getData().getUserId());
            JSONObject messageJson = new JSONObject(new Gson().toJson(currentOrderItem));
            messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
            messageJson.put(USER_TYPE, ANDROID_USER);
            HippoLog.d("userName in SDK", "currentOrderItem " + new Gson().toJson(messageJson));
            mClient.setListener(this);
            if (mClient.isConnectedServer()) {
                mClient.publish("/" + String.valueOf(channelId), messageJson);
            } else {
                mClient.connectServer();
            }
        }
    }

    private void sendFormData(Message message) throws Exception {
        if (isNetworkAvailable()) {

            List<String> arrayList = new ArrayList<>();
            if (message.getValues() != null)
                arrayList.addAll(message.getValues());
            arrayList.add(message.getComment());

            message.setValues((ArrayList<String>) arrayList);
            message.setComment("");

            message.setUserId(CommonData.getUserDetails().getData().getUserId());
            message.setMessageId(message.getId());

            JSONObject messageJson = new JSONObject(new Gson().toJson(message));
            messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
            messageJson.put(USER_TYPE, ANDROID_USER);
            HippoLog.d("userName in SDK", "currentOrderItem " + new Gson().toJson(messageJson));
            mClient.setListener(this);
            if (mClient.isConnectedServer()) {
                mClient.publish("/" + String.valueOf(channelId), messageJson);
            } else {
                mClient.connectServer();
            }
        }
    }

    private void sendQuickReply(Message message, int position, String defaultActionId) throws Exception {

        if (isNetworkAvailable()) {
            List<String> arrayList = new ArrayList<>();
            arrayList.add(defaultActionId);
            message.setValues((ArrayList<String>) arrayList);

            message.setUserId(CommonData.getUserDetails().getData().getUserId());
            if (message.getId() > 0) {
                message.setMessageId(message.getId());
            }

            JSONObject messageJson = new JSONObject(new Gson().toJson(message));
            messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
            messageJson.put(MESSAGE_TYPE, FUGU_QUICK_REPLY_VIEW);
            messageJson.put(USER_TYPE, ANDROID_USER);

            messageJson.put("bot_button_reply", 1);
            HippoLog.d("userName in SDK", "currentOrderItem for bot " + new Gson().toJson(messageJson));
            mClient.setListener(this);
            if (mClient.isConnectedServer()) {
                mClient.publish("/" + String.valueOf(channelId), messageJson);
            } else {
                mClient.connectServer();
            }
        }
    }


    @Override
    public void QuickReplyListener(Message message, int pos) {
        try {
            if (channelId.compareTo(-1L) > 0) {
                fuguMessageList.remove(new EventItem(message));
                conversation.setChannelStatus(ChannelStatus.OPEN.getOrdinal());
                isTyping = TYPING_SHOW_MESSAGE;
                globalUuid = UUID.randomUUID().toString();
                publishOnFaye(message.getContentValue().get(pos).getButtonTitle(), TEXT_MESSAGE, getString(R.string.fugu_empty), getString(R.string.fugu_empty),
                        null, NOTIFICATION_DEFAULT, globalUuid);
                //unsentMessageMap.put(globalUuid, fuguMessageList.get(fuguMessageList.size() - 1));

            } else {
                if (mClient.isConnectedServer()) {
                    if (!isConversationCreated) {
                        conversation.setChannelStatus(ChannelStatus.OPEN.getOrdinal());
                        HippoLog.v("call createConversation", "onClick");
                        createConversation(TEXT_MESSAGE, "", "", null, isP2P);
                    }
                } else {
                    mClient.setListener(this);
                    mClient.connectServer();
                    Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
                }
            }

            CommonData.clearQuickReplyData();
        } catch (Exception e) {
            e.printStackTrace();
        }


        try {
            sendQuickReply(message, pos, message.getContentValue().get(pos).getActionId());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendActionId(Message event) {
        try {
            sendQuickReply(event, position, event.getDefaultActionId());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReceivedMessage(FayeClient fc, String msg, String channel) {

        try {
            // TODO: 19/01/19 check channel id in case of server class.
            if(!channel.equalsIgnoreCase("/"+String.valueOf(channelId))) {
                HippoLog.e(TAG, "Other channel id message received");
                return;
            }
            ActivityManager mngr = (ActivityManager) getSystemService(ACTIVITY_SERVICE);
            List<ActivityManager.RunningTaskInfo> taskList = mngr.getRunningTasks(10);

            if (!taskList.get(0).topActivity.getClassName().equals("com.hippo.activity.FuguChatActivity")) {
                HippoLog.e(TAG, "FuguChatActivity false");
                return;
            }
        } catch (Exception e) {
            if (HippoConfig.DEBUG)
                e.printStackTrace();
        }

        HippoLog.e(TAG, "FuguMessage: " + msg);
        HippoLog.e(TAG, "channel" + channel);

        boolean isSelf = false;
        try {
            final JSONObject messageJson = new JSONObject(msg);

            try {
                if (messageJson.optInt(MESSAGE_TYPE, 0) == 1 && TextUtils.isEmpty(messageJson.optString("message"))
                        && ! messageJson.has("is_typing")) {
                    return;
                }
                if(retryLayout.getVisibility() == View.VISIBLE) {
                    setConnectionMessage(0);
                }
            } catch (Exception e) {

            }
            if ((messageJson.optInt(IS_TYPING) == TYPING_STOPPED) && !messageJson.getString(USER_ID).equals(String.valueOf(userId))) {
                HippoLog.v("onReceivedMessage", "in elseIf stopAnim");
                stopAnim();
            }
            if (!String.valueOf(messageJson.optString("user_id")).equals(String.valueOf(userId)) && messageJson.has("on_subscribe")) {
                onSubscribe = messageJson.getInt("on_subscribe");
                HippoLog.e("onReceivedMessage onSubscribe", "==" + onSubscribe);
            }
            try {
                if (messageJson.optInt(MESSAGE_TYPE, 0) == 14) {
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == ITEM_TYPE_RATING) {
                            Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                            if (!TextUtils.isEmpty(currentMessage.getMuid()) && currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                                currentMessage.setRatingGiven(messageJson.getInt("rating_given"));
                                currentMessage.setComment(messageJson.getString("comment"));
                                currentMessage.setIsRatingGiven(messageJson.getInt("is_rating_given"));
                                currentMessage.setTotalRating(messageJson.getInt("total_rating"));

                                currentMessage.setLineBeforeFeedback(messageJson.getString("line_before_feedback"));
                                currentMessage.setLineAfterFeedback_1(messageJson.getString("line_after_feedback_1"));
                                currentMessage.setLineAfterFeedback_2(messageJson.getString("line_after_feedback_2"));

                                updateFeedback(i);
                                removeItemAndUpdateUI();
                                return;
                            }
                        }
                    }
                } else if (messageJson.optInt(MESSAGE_TYPE, 0) == FUGU_FORUM_VIEW && !messageJson.has("id")) {
                    return;
                } else if (messageJson.optInt(MESSAGE_TYPE, 0) == FUGU_FORUM_VIEW) {
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i).getType() == FUGU_FORUM_VIEW) {
                            Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                            if (currentMessage.getId() == messageJson.getLong("id")) {
                                //currentMessage.getValues()

                                ArrayList<String> values = new ArrayList<>();
                                JSONArray valuesArray = messageJson.getJSONArray("values");

                                if (valuesArray != null) {
                                    for (int b = 0; b < valuesArray.length(); b++) {
                                        values.add(valuesArray.getString(b));
                                    }
                                }
                                currentMessage.setValues(values);
                                //updateFeedback(i);
                                if (values != null) {
                                    updateFeedback(i, false);
                                    return;
                                }
                                removeItemAndUpdateUI();
                                return;
                            }
                        }
                    }
                } else if (messageJson.optInt(MESSAGE_TYPE, 0) == FUGU_QUICK_REPLY_VIEW) {
                    for (int i = 0; i < fuguMessageList.size(); i++) {
                        if (fuguMessageList.get(i) instanceof EventItem) {
                            Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();

                            if (currentMessage.getId() == messageJson.getLong("id")) {
                                ArrayList<String> values = new ArrayList<>();
                                JSONArray valuesArray = messageJson.getJSONArray("values");

                                if (valuesArray != null) {
                                    for (int b = 0; b < valuesArray.length(); b++) {
                                        values.add(valuesArray.getString(b));
                                    }
                                }
                                currentMessage.setValues(values);

//                                    if (values != null) {
//                                        updateFeedback(i, false);
//                                        return;
//                                    }
                            }
                        }
                    }
                }
                        /*else  if(messageJson.optInt(MESSAGE_TYPE, 0) == FUGU_TEXT_VIEW){
//
                            for (int i = 0; i < fuguMessageList.size(); i++) {
                                if (fuguMessageList.get(i).getType() == FUGU_FORUM_VIEW) {
                                    Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                                    String message=messageJson.getString("message");
                                        currentMessage.setMessage(message);
                                        //updateFeedback(i);
                                        if (message != null && !message.isEmpty()) {
                                            updateFeedback(i, false);
                                            return;
                                        }
                                        return;
                                    }
                                }
                            }*/


//                        else if(messageJson.optInt(MESSAGE_TYPE, 0) == 16 && messageJson.getString(USER_ID).equals(String.valueOf(userId)) ) {
//                            return;
//                        }
            } catch (JSONException e) {
                //e.printStackTrace();
            }

            if (String.valueOf(messageJson.get("user_id")).equals(String.valueOf(userId))) {
                HippoLog.v("onReceivedMessage", "isSelf");
                isSelf = true;
            }
            if (messageJson.optInt(NOTIFICATION_TYPE, 0) == READ_MESSAGE) {
                readFunctionality(messageJson);
            } else {
                if (messageJson.optInt(IS_TYPING, TYPING_STOPPED) == TYPING_STARTED) {
                    isFayeChannelActive = true;
                    readFunctionality(messageJson);
                }
                if(messageJson.optInt(IS_TYPING, 0) == TYPING_SHOW_MESSAGE &&
                        messageJson.getInt(MESSAGE_TYPE) == VIDEO_CALL && messageJson.has("muid")) {

                    /*String localDate = dateUtils.convertToLocal(messageJson.getString("date_time"), inputFormat, outputFormat);
                    if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                        sentMessages.put(localDate, new HeaderItem(localDate));
                        fuguMessageList.add(new HeaderItem(localDate));
                        sentAtUTC = localDate;
                        dateItemCount = dateItemCount + 1;
                    }

                    Message message = new Message(0, messageJson.getString(FULL_NAME),
                            Long.parseLong(messageJson.getString(USER_ID)),
                            messageJson.optString(MESSAGE),
                            messageJson.optString(DATE_TIME),
                            isSelf,
                            onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                            fuguMessageList.size(),
                            "",
                            messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                            messageJson.getInt(MESSAGE_TYPE),
                            messageJson.optString("muid", ""));

                    message.setMuid(messageJson.optString("muid", ""));

                    if(!sentMessages.containsValue(messageJson.optString("muid", ""))) {
                        fuguMessageList.add(new EventItem(message));
                        sentMessages.put(messageJson.optString("muid", ""), new EventItem(message));
                        pageStart = pageStart + 1;
                    }*/

                    //12345
                } else if (messageJson.optInt(IS_TYPING, 0) == TYPING_SHOW_MESSAGE &&
                        (messageJson.has("message") && !messageJson.getString(MESSAGE).isEmpty() ||
                        (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) ||
                        (messageJson.has("url") && !messageJson.getString("url").isEmpty()) || messageJson.has(CUSTOM_ACTION))
                        && (messageJson.getInt(MESSAGE_TYPE) == TEXT_MESSAGE
                        || messageJson.getInt(MESSAGE_TYPE) == IMAGE_MESSAGE
                        || messageJson.getInt(MESSAGE_TYPE) == FILE_MESSAGE
                        || messageJson.getInt(MESSAGE_TYPE) == ACTION_MESSAGE
                        || messageJson.getInt(MESSAGE_TYPE) == ACTION_MESSAGE_NEW)
                        || messageJson.getInt(MESSAGE_TYPE) == FEEDBACK_MESSAGE
                        || messageJson.getInt(MESSAGE_TYPE) == FUGU_QUICK_REPLY_VIEW
                        || messageJson.getInt(MESSAGE_TYPE) == FUGU_TEXT_VIEW
                        || messageJson.getInt(MESSAGE_TYPE) == FUGU_FORUM_VIEW) {
                    HippoLog.v("onReceivedMessage", "in if 1");
                    if (isSelf && messageJson.has(MESSAGE_STATUS) && messageJson.has("muid")
                            && messageJson.getInt(MESSAGE_STATUS) == MESSAGE_UNSENT) {
                        try {
                            HippoLog.v("onReceivedMessage", "in if 2");

                            messageIndex = messageJson.getInt("message_index");
                            try {
                                if (fuguMessageList.get(messageJson.getInt("message_index")).getType() == ListItem.TYPE_HEADER
                                        && (messageJson.getInt(MESSAGE_INDEX) + 1 < fuguMessageList.size())) {
                                    HippoLog.v("onReceivedMessage", "in if 3");
                                    messageIndex = messageIndex + 1;
                                    ((EventItem) fuguMessageList.get(messageJson.getInt(MESSAGE_INDEX) + 1))
                                            .getEvent().setMessageStatus(MESSAGE_SENT);
                                } else if (messageJson.getInt(MESSAGE_INDEX) < fuguMessageList.size()) {
                                    HippoLog.v("onReceivedMessage", "in elseIf 1");
                                    ((EventItem) fuguMessageList.get(messageJson.getInt(MESSAGE_INDEX)))
                                            .getEvent().setMessageStatus(MESSAGE_SENT);
                                }
                            } catch (Exception e) {

                                //e.printStackTrace();

                                try {
                                    for(int i = fuguMessageList.size()-1; i>=0; i--) {
                                        if (fuguMessageList.get(i) instanceof EventItem) {
                                            Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                                            if (currentMessage.getMuid().equals(messageJson.getString("muid"))) {
                                                messageIndex = i;
                                                try {
                                                    if (fuguMessageList.get(messageJson.getInt("message_index")).getType() == ListItem.TYPE_HEADER
                                                            && (messageJson.getInt(MESSAGE_INDEX) + 1 < fuguMessageList.size())) {
                                                        HippoLog.v("onReceivedMessage", "in if 3");
                                                        messageIndex = messageIndex + 1;
                                                        ((EventItem) fuguMessageList.get(messageJson.getInt(MESSAGE_INDEX) + 1))
                                                                .getEvent().setMessageStatus(MESSAGE_SENT);
                                                    } else if (messageJson.getInt(MESSAGE_INDEX) < fuguMessageList.size()) {
                                                        HippoLog.v("onReceivedMessage", "in elseIf 1");
                                                        ((EventItem) fuguMessageList.get(messageJson.getInt(MESSAGE_INDEX)))
                                                                .getEvent().setMessageStatus(MESSAGE_SENT);
                                                    }
                                                } catch (Exception e1) {
                                                    e1.printStackTrace();
                                                }

                                                break;
                                            }
                                        }
                                    }
                                } catch (Exception e1) {
                                    e1.printStackTrace();
                                }


                            }


                            ListItem listItem = unsentMessages.get(messageJson.getString("muid"));
                            if (listItem == null)
                                return;
                            ((EventItem) listItem).getEvent().setMessageStatus(MESSAGE_SENT);

                            if(messageJson.has("thumbnail_url")) {
                                ((EventItem) listItem).getEvent().setThumbnailUrl(messageJson.optString("thumbnail_url"));
                                ((EventItem) listItem).getEvent().setUrl(messageJson.optString("image_url"));
                                ((EventItem) listItem).getEvent().setFileUrl(messageJson.optString("image_url"));
                                if(messageJson.has("url"))
                                    ((EventItem) listItem).getEvent().setFileUrl(messageJson.optString("url"));
                            }

                            List<String> reverseOrderedKeys = new ArrayList<>(sentMessages.keySet());
                            Collections.reverse(reverseOrderedKeys);
                            String tempSentAtUTC = "";
                            for (String key : reverseOrderedKeys) {
                                if (sentMessages.get(key) instanceof HeaderItem) {
                                    tempSentAtUTC = key;
                                    break;
                                }
                            }
                            String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                            String localDate = dateUtils.convertToLocal(time, inputFormat, outputFormat);
                            if (!tempSentAtUTC.equalsIgnoreCase(localDate)) {
                                sentMessages.put(localDate, new HeaderItem(localDate));
                            }

//                            try {
//                                messageJson.setMessageState(messageJson.optInt("message_state"));
//                            } catch (Exception e) {
//                                e.printStackTrace();
//                            }

                            sentMessages.put(messageJson.getString("muid"), listItem);
                            unsentMessageMapNew.remove(messageJson.getString("muid"));
                            unsentMessages.remove(messageJson.getString("muid"));
                            pageStart = pageStart + 1;
                            if (unsentMessageMapNew.size() == 0 && isNetworkStateChanged) {
                                pageStart = 1;
                                //getMessages(null);
                                isNetworkStateChanged = false;
                            }

                            runOnUiThread(new Runnable() {
                                @Override
                                public void run() {
                                    try {
                                        HippoLog.e(TAG, "notifyItemChanged at: " + messageIndex);
                                        fuguMessageAdapter.updateList(fuguMessageList, false);
                                        fuguMessageAdapter.notifyItemChanged(messageIndex);
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });



                            messageSending = false;
                            sendMessages();
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        HippoLog.v("onReceivedMessage", "in else 1");
                        String localDate = dateUtils.convertToLocal(messageJson.getString("date_time"), inputFormat, outputFormat);
                        if (!sentAtUTC.equalsIgnoreCase(localDate)) {
                            sentMessages.put(localDate, new HeaderItem(localDate));
                            fuguMessageList.add(new HeaderItem(localDate));
                            sentAtUTC = localDate;
                            dateItemCount = dateItemCount + 1;
                        }
                        /*String date = DateUtils.getDate(dateUtils.convertToLocal(messageJson.getString(DATE_TIME)));
                        if (!sentAtUTC.equalsIgnoreCase(date)) {
                            fuguMessageList.add(new HeaderItem(date));
                            sentAtUTC = date;
                            dateItemCount = dateItemCount + 1;
                        }*/

                        String url = "";
                        if (messageJson.getInt(MESSAGE_TYPE) == IMAGE_MESSAGE) {
                            url = messageJson.optString("image_url", "");
                        } else if (messageJson.getInt(MESSAGE_TYPE) == FILE_MESSAGE) {
                            url = messageJson.optString("url", "");
                        }
                        String sentUuid;
                        try {
                            sentUuid = messageJson.getString("UUID");
                        } catch (Exception e) {
                            sentUuid = UUID.randomUUID().toString();
                        }
                        Message message = new Message(0, messageJson.getString(FULL_NAME),
                                Long.parseLong(messageJson.getString(USER_ID)),
                                messageJson.getString(MESSAGE),
                                messageJson.getString(DATE_TIME),
                                isSelf,
                                onSubscribe == 1 ? MESSAGE_READ : MESSAGE_SENT,
                                fuguMessageList.size(),
                                url,
                                messageJson.has("thumbnail_url") ? messageJson.getString("thumbnail_url") : "",
                                messageJson.getInt(MESSAGE_TYPE),
                                sentUuid);
                        if (messageJson.has(CUSTOM_ACTION)) {
                            message.setCustomAction(new Gson().fromJson(messageJson.getJSONObject(CUSTOM_ACTION).toString(), CustomAction.class));
                        }

                        message.setMuid(messageJson.optString("muid", ""));

                        if (message.getMessageType() == FUGU_QUICK_REPLY_VIEW) {
                            JSONArray valuesArray = messageJson.getJSONArray("values");
                            ArrayList<String> values = new ArrayList<>();
                            if (valuesArray != null) {
                                for (int b = 0; b < valuesArray.length(); b++) {
                                    values.add(valuesArray.getString(b));
                                }
                            }
                            if (values.size() > 0)
                                return;
                            if (messageJson.has("default_action_id")) {
                                message.setDefaultActionId(messageJson.getString("default_action_id"));
                            }

                            if (messageJson.has("id")) {
                                message.setId(messageJson.optLong("id"));
                                List<ContentValue> contentValue = new ArrayList<>();

                                JSONArray contentvaluesArray = messageJson.getJSONArray("content_value");
                                if (contentvaluesArray != null) {

                                    for (int a = 0; a < contentvaluesArray.length(); a++) {
                                        JSONObject object = contentvaluesArray.getJSONObject(a);
                                        ContentValue contentValue1 = new ContentValue();
                                        contentValue1.setBotId(object.getString("bot_id"));
                                        //contentValue1.setId(object.getString("_id"));
                                        contentValue1.setButtonId(object.getString("button_id"));
                                        contentValue1.setButtonType(object.getString("button_type"));
                                        contentValue1.setButtonTitle(object.getString("button_title"));
//                                            contentValue1.isDeleted(object.getBoolean("isDeleted"));
                                        contentValue1.setActionId(object.getString("action_id"));

                                        contentValue.add(contentValue1);
                                    }
                                }
                                message.setContentValue(contentValue);
                                CommonData.setQuickReplyData(message);
                            } else {
                                return;
                            }


                        } else if (message.getMessageType() == FUGU_FORUM_VIEW && message.getId() != null) {
                            message.setMuid(messageJson.optString("muid", ""));
                            message.setId(messageJson.optLong("id"));
                            List<ContentValue> contentValue = new ArrayList<>();
                            ArrayList<String> values = new ArrayList<>();


                            JSONArray contentvaluesArray = messageJson.getJSONArray("content_value");
                            JSONArray valuesArray = messageJson.getJSONArray("values");

                            if (contentvaluesArray != null) {

                                for (int a = 0; a < contentvaluesArray.length(); a++) {
                                    JSONObject object = contentvaluesArray.getJSONObject(a);
                                    ContentValue contentValue1 = new ContentValue();
                                    contentValue1.setBotId(object.getString("bot_id"));
                                    //contentValue1.setId(object.getString("_id"));
                                    JSONArray array = object.getJSONArray("questions");
                                    JSONArray dataTypeArray = object.getJSONArray("data_type");
                                    ArrayList<String> questions = new ArrayList<>();
                                    ArrayList<String> dataType = new ArrayList<>();

                                    for (int x = 0; x < array.length(); x++) {
                                        questions.add(array.getString(x));
                                    }

                                    for (int y = 0; y < dataTypeArray.length(); y++) {
                                        dataType.add(dataTypeArray.getString(y));
                                    }
                                    contentValue1.setQuestions(questions);
                                    contentValue1.setData_type(dataType);

                                    contentValue.add(contentValue1);
                                }
                            }

                            if (valuesArray != null) {
                                for (int b = 0; b < valuesArray.length(); b++) {
                                    values.add(valuesArray.getString(b));
                                }
                            }


                            message.setValues(values);
                            message.setContentValue(contentValue);
                            removeItemAndUpdateUI();
                        } else if (message.getMessageType() == FEEDBACK_MESSAGE) {

                            message.setRatingGiven(messageJson.getInt("rating_given"));
                            message.setComment(messageJson.getString("comment"));
                            message.setIsRatingGiven(messageJson.getInt("is_rating_given"));
                            message.setTotalRating(messageJson.getInt("total_rating"));

                            message.setLineBeforeFeedback(messageJson.getString("line_before_feedback"));
                            message.setLineAfterFeedback_1(messageJson.getString("line_after_feedback_1"));
                            message.setLineAfterFeedback_2(messageJson.getString("line_after_feedback_2"));
                        } else if(message.getMessageType() == FILE_MESSAGE) {
                            message.setFileName(messageJson.optString("file_name"));
                            message.setFileSize(messageJson.optString("file_size"));
                            message.setUrl(messageJson.optString("image_url"));
                            message.setFileUrl(messageJson.optString("url"));
                            message.setThumbnailUrl(messageJson.optString("thumbnail_url"));
                            message.setDocumentType(messageJson.optString("document_type"));
                            String fileExt = Util.getExtension(messageJson.optString("url"));
                            if(!TextUtils.isEmpty(fileExt))
                                message.setFileExtension(fileExt);
                        }

                        try {
                            message.setMessageState(messageJson.optInt("message_state"));
                            message.setVideoCallDuration(messageJson.optInt("video_call_duration"));
                        } catch (Exception e) {
                            e.printStackTrace();
                        }

                        //fuguMessageList.add(new EventItem(message));
                        if(!sentMessages.containsValue(messageJson.optString("muid", ""))) {
                            fuguMessageList.add(new EventItem(message));
                            sentMessages.put(messageJson.optString("muid", ""), new EventItem(message));
                        }
                        pageStart = pageStart + 1;
                        stopAnim();

                        if (!isSelf) {
                            sendReadAcknowledgement();
                        }
                    }
                }
            }

            if (!messageJson.getString(USER_ID).equals(String.valueOf(userId)) &&
                    onSubscribe == 1 && messageJson.has("on_subscribe")) {
                HippoLog.v("onReceivedMessage", "in If 4");
                for (int i = 0; i < fuguMessageList.size(); i++) {
                    if (fuguMessageList.get(i).getType() == ListItem.ITEM_TYPE_SELF &&
                            ((EventItem) fuguMessageList.get(i)).getEvent().getMessageStatus() == MESSAGE_SENT) {
                        ((EventItem) fuguMessageList.get(i)).getEvent().setMessageStatus(MESSAGE_READ);
                    }
                }
                /*runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        fuguMessageAdapter.notifyItemInserted(fuguMessageList.size() - 1);
                    }
                });*/
            }

            if (messageJson.optInt(MESSAGE_TYPE) == FUGU_QUICK_REPLY_VIEW || messageJson.optInt(MESSAGE_TYPE) == FUGU_FORUM_VIEW
                    || messageJson.optInt(MESSAGE_TYPE) == FUGU_TEXT_VIEW) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        updateRecycler();

                    }
                });
            }

            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (messageJson.has(MESSAGE_TYPE) && (messageJson.optInt(MESSAGE_TYPE) == TEXT_MESSAGE ||
                                messageJson.optInt(MESSAGE_TYPE) == IMAGE_MESSAGE ||
                                messageJson.optInt(MESSAGE_TYPE) == FILE_MESSAGE ||
                                messageJson.optInt(MESSAGE_TYPE) == ACTION_MESSAGE ||
                                messageJson.getInt(MESSAGE_TYPE) == ACTION_MESSAGE_NEW)) {
                            HippoLog.v("onReceivedMessage", "in If 5");
                            if ((messageJson.getInt(IS_TYPING) == 0) &&
                                    (!messageJson.getString(MESSAGE).isEmpty() ||
                                            (messageJson.has("image_url") && !messageJson.getString("image_url").isEmpty()) ||
                                            (messageJson.has("url") && !messageJson.getString("url").isEmpty()) ||
                                            messageJson.has(CUSTOM_ACTION)) &&
                                    !String.valueOf(messageJson.get(USER_ID)).equals(String.valueOf(userId))) {
                                HippoLog.v("onReceivedMessage", "in If 6");
                                updateRecycler();
                                if (CommonData.getQuickReplyData() != null
                                        && CommonData.getQuickReplyData().getDefaultActionId() != null
                                        && !CommonData.getQuickReplyData().getDefaultActionId().isEmpty()) {
                                    try {
                                        //qwe
                                        sendQuickReply(CommonData.getQuickReplyData(), 0,
                                                CommonData.getQuickReplyData().getDefaultActionId());
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    fuguMessageList.remove(new EventItem(CommonData.getQuickReplyData()));
                                    CommonData.clearQuickReplyData();

                                    fuguMessageAdapter.notifyDataSetChanged();


                                } else {
                                    fuguMessageList.remove(new EventItem(CommonData.getQuickReplyData()));
                                }


                            } else if ((messageJson.getInt(IS_TYPING) == TYPING_STARTED) &&
                                    !messageJson.getString(USER_ID).equals(String.valueOf(userId))) {
                                HippoLog.v("onReceivedMessage", "in elseIf startAnim");
                                startAnim();
                            } else if ((messageJson.getInt(IS_TYPING) == TYPING_STOPPED) &&
                                    !messageJson.getString(USER_ID).equals(String.valueOf(userId))) {
                                HippoLog.v("onReceivedMessage", "in elseIf stopAnim");
                                stopAnim();
                            }
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (JSONException e) {
            e.printStackTrace();
        }

//        String data = Prefs.with(FuguChatActivity.this).getString(KEY, "empty");
//        if(data.equals("empty")) {
//            HippoLog.v(TAG, "data = "+data);
//            return;
//        }
//        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(data, fileuploadType);
//        int index = fileuploadModels.indexOf(new FileuploadModel(channelId));
//        if(index != -1) {
//            fileuploadModels.remove(index);
//            data = new Gson().toJson(fileuploadModels);
//            Prefs.with(FuguChatActivity.this).save(KEY, data);
//        }
    }

    boolean messageSending = false;
    boolean messageSendingRecursion = false;
    boolean fayeDisconnect = true;
    boolean fayeConnecting = false;
    int sendingTry = 0;

    private void sendMessage(String message, int messageType, String imageUrl, String thumbnailUrl,
                             String localPath, FuguFileDetails fileDetails, FileuploadModel fileuploadModel) {
        sendMessage(message, messageType, imageUrl, thumbnailUrl, localPath, fileDetails, null, -1, fileuploadModel);
    }

    private void sendMessage(String message, int messageType, String url, String thumbnailUrl,
                             String localPath, FuguFileDetails fileDetails, String localMuid, int localIndex, FileuploadModel fileuploadModel) {
        String removsinglequote = message.trim();
        String localDate = DateUtils.getInstance().getFormattedDate(new Date());
        int index = fuguMessageList.size();
        if(localIndex>0)
            index = localIndex;
        String muid;
        if(TextUtils.isEmpty(localMuid)) {
            muid = UUID.randomUUID().toString() + "." + new Date().getTime();
            if(fileuploadModel != null && !TextUtils.isEmpty(fileuploadModel.getMuid())) {
                muid = fileuploadModel.getMuid();
            }
            addMessageToList(removsinglequote, messageType, url, thumbnailUrl, localPath, fileuploadModel, muid, index);
        } else {
            muid = localMuid;
        }
        try {
            JSONObject messageJson = new JSONObject();
            messageJson.put("muid", muid);
            messageJson.put("is_message_expired", 0);
            messageJson.put(MESSAGE, removsinglequote);
            messageJson.put(MESSAGE_TYPE, messageType);
            messageJson.put(DATE_TIME, DateUtils.getInstance().convertToUTC(localDate));
            messageJson.put(MESSAGE_INDEX, index);

            if (messageType == IMAGE_MESSAGE) {
                if (!url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put(IMAGE_URL, url);
                    messageJson.put(THUMBNAIL_URL, thumbnailUrl);
                } else if (!TextUtils.isEmpty(localPath)) {
                    messageJson.put("local_url", localPath);
                }
                if(fileuploadModel != null && fileuploadModel.getDimns() != null && fileuploadModel.getDimns().size()>0) {
                    messageJson.put("image_height", fileuploadModel.getDimns().get(0));
                    messageJson.put("image_width", fileuploadModel.getDimns().get(1));
                } else {
                    messageJson.put("image_height", 700);
                    messageJson.put("image_width", 700);
                }
            } else if (messageType == FILE_MESSAGE) {
                if (!url.trim().isEmpty() && !thumbnailUrl.trim().isEmpty()) {
                    messageJson.put("url", url);
                    messageJson.put(THUMBNAIL_URL, thumbnailUrl);
                } else if (!TextUtils.isEmpty(localPath)) {
                    messageJson.put("local_url", localPath);
                }
                messageJson.put("file_name", fileuploadModel.getFileName());
                messageJson.put("file_size", fileuploadModel.getFileSizeReadable());
                messageJson.put("document_type", fileuploadModel.getDocumentType());
            }

            messageJson.put(IS_TYPING, TYPING_SHOW_MESSAGE);
            messageJson.put("message_status", MESSAGE_UNSENT);
            messageJson.put(FULL_NAME, userName);
            messageJson.put(MESSAGE_STATUS, MESSAGE_UNSENT);
            messageJson.put(USER_ID, String.valueOf(userId));
            messageJson.put(USER_TYPE, ANDROID_USER);
            unsentMessageMapNew.put(muid, messageJson);
            if(conversation != null && conversation.getChannelId() != null)
                CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

            if (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE) {
                if (!TextUtils.isEmpty(localPath)) {
                    fileuploadModel.setMuid(muid);
                    fileuploadModel.setMessageIndex(index);
                    fileuploadModel.setChannelId(channelId);
                    if(channelId == -1) {
                        fileuploadModel.setLabelId(labelId);
                        CommonData.setFirstTimeCreated(true);
                    }
                    HippoLog.e(TAG, "messageJson = "+new Gson().toJson(messageJson));
                    fileuploadModel.setMessageObject(messageJson);
                    HippoLog.d(TAG, "fileuploadModel = "+new Gson().toJson(fileuploadModel));
                    uploadFile(fileuploadModel);
                } else {
                    if (isNetworkAvailable()) {
                        sendMessages();
                    }
                }
            } else {
                if (!messageSendingRecursion && isNetworkAvailable()) {
                    sendMessages();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    private LinkedHashMap<String, JSONObject> unsentMessageMap = new LinkedHashMap<>();

    private synchronized void sendMessages() {
        if (mClient != null && mClient.isConnectedServer()) {
            if (unsentMessageMapNew == null || unsentMessageMapNew.size() == 0)
                messageSendingRecursion = false;

            sendingTry = sendingTry + 1;
            if (sendingTry == 3) {
                messageSendingRecursion = false;
                messageSending = false;
            }

            try {
                if (unsentMessageMapNew.keySet().iterator().hasNext()) {
                    String key = unsentMessageMapNew.keySet().iterator().next();
                    Log.e(TAG, "key: " + key);
                    JSONObject messageJson = unsentMessageMapNew.get(key);
                    if (messageJson.optInt("is_message_expired", 0) == 1) {
                        unsentMessageMap.put(key, messageJson);
                        unsentMessageMapNew.remove(key);
                        sendMessages();
                    } else {
                        int messageType = messageJson.optInt(MESSAGE_TYPE);
                        if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0 && (messageType != IMAGE_MESSAGE && messageType != FILE_MESSAGE)) {
                            Log.e(TAG, "Sending: " + new Gson().toJson(messageJson));
                            sendingTry = 0;
                            messageSending = true;
                            mClient.publish("/" + String.valueOf(channelId), messageJson);
                        }
                        if (!messageSending && messageJson.optInt("is_message_expired", 0) == 0 && (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE)) {
                            String localPath = messageJson.optString("local_url", "");
                            String url = messageJson.optString("url");
                            String muid = messageJson.optString("muid");
                            int index = messageJson.optInt(MESSAGE_INDEX);
                            if(!TextUtils.isEmpty(url)) {
                                localPath = null;
                                messageJson.remove("local_url");
                            }
                            if (!TextUtils.isEmpty(localPath)) {
                                //uploadFileServerCall(localPath, "image/*", index, muid);
                                for(String muidKey : unsentMessageMapNew.keySet()) {
                                    JSONObject newMessageJson = unsentMessageMapNew.get(muidKey);
                                    if (newMessageJson.optInt("is_message_expired", 0) == 1) {
                                        unsentMessageMap.put(muidKey, newMessageJson);
                                        unsentMessageMapNew.remove(muidKey);
                                        sendMessages();
                                        return;
                                    } else {
                                        int newMessageType = newMessageJson.optInt(MESSAGE_TYPE);
                                        if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0 && ((!TextUtils.isEmpty(newMessageJson.optString("url", ""))) || (newMessageType != IMAGE_MESSAGE && newMessageType != FILE_MESSAGE))) {
                                            sendingTry = 0;
                                            messageSending = true;
                                            mClient.publish("/" + String.valueOf(channelId), newMessageJson);
                                            return;
                                        } else if (!messageSending && newMessageJson.optInt("is_message_expired", 0) == 0 && (newMessageType == IMAGE_MESSAGE || newMessageType == FILE_MESSAGE)) {
                                            continue;
                                        }
                                    }
                                }
                            } else {
                                sendingTry = 0;
                                messageSending = true;
                                mClient.publish("/" + String.valueOf(channelId), messageJson);
                            }
                        }
                    }
                } else if (unsentMessageMap.size() > 0) {
                    unsentMessageMapNew.putAll(unsentMessageMap);
                    unsentMessageMap.clear();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }

//                    if (isTyping == TYPING_SHOW_MESSAGE && messageType == TEXT_MESSAGE) {
//                        isTyping = TypingMode.TYPING_START.getOrdinal();
//                    }
        } else {
            try {
                connectAgainToServer();
            } catch (Exception e) {

            }
        }
        /*connectionListener.connectionCheck(new HelperConnectionListener.CheckListener() {
            @Override
            public void status(boolean flag) {
                if(flag)  else {
                    try {
                        connectionListener.connect();
                    } catch (Exception e) {

                    }
                }
            }
        });*/
    }

    /**
     * @param message
     * @param messageType
     * @param imageUrl
     * @param thumbnailUrl
     * @param localPath
     * @param fileDetails
     * @param muid
     */
    private void addMessageToList(String message, int messageType, String imageUrl, String thumbnailUrl,
                                  String localPath, FileuploadModel fileDetails, String muid, int index) {
        try {
            String localDate = DateUtils.getInstance().getFormattedDate(new Date());
            String localDate1 = DateUtils.getInstance().getFormattedDate(new Date(), outputFormat);

            if (!sentAtUTC.equalsIgnoreCase(localDate1)) {
                fuguMessageList.add(new HeaderItem(localDate1));
                sentAtUTC = localDate1;
                dateItemCount = dateItemCount + 1;
            }

            HippoLog.d("userName in SDK", "addMessageToList " + userName);

            Message messageObj = new Message(0,
                    userName,
                    userId,
                    message,
                    DateUtils.getInstance().convertToUTC(localDate),
                    true,
                    MESSAGE_UNSENT,
                    index,
                    imageUrl.isEmpty() ? localPath : imageUrl,
                    thumbnailUrl.isEmpty() ? localPath : thumbnailUrl,
                    messageType,
                    muid);

            messageObj.setMuid(muid);
            messageObj.setIsMessageExpired(0);
            messageObj.setLocalImagePath(localPath);
            messageObj.setMessageState(MESSAGE_UNSENT);

            if (fileDetails != null) {
                messageObj.setFileName(fileDetails.getFileName());
                messageObj.setFileSize(fileDetails.getFileSizeReadable());
                messageObj.setFileExtension(fileDetails.getFileMime());
                messageObj.setFilePath(fileDetails.getFilePath());
                messageObj.setFileUrl(fileDetails.getFilePath());
                messageObj.setDocumentType(fileDetails.getDocumentType());
                messageObj.setUploadStatus(UPLOAD_IN_PROGRESS);
                if(fileDetails.getDimns() != null && fileDetails.getDimns().size() > 1) {
                    messageObj.setImageHeight(fileDetails.getDimns().get(0));
                    messageObj.setImageWidth(fileDetails.getDimns().get(1));
                }
            }

            fuguMessageList.add(new EventItem(messageObj));
            unsentMessages.put(muid, new EventItem(messageObj));
            etMsg.setText("");
            updateRecycler();

            scrollListToBottom();

            HippoLog.d("messageObj", "messageObj = "+new Gson().toJson(messageObj));
            /*if (messageType == IMAGE_MESSAGE || messageType == FILE_MESSAGE) {
                FuguLog.v("upload pic", "ready for upload");
                FuguLog.v("upload pic", "ready for upload" + imageUrl + " " + messageType);
                unsentMessageMap.put(muid, fuguMessageList.get(fuguMessageList.size() - 1));
                CommonData.setUnsentMessageMapByChannel(channelId, unsentMessageMap);
                uploadFileServerCall(imageUrl, fuguMessageList.size() - 1, messageType, fileDetails);
            }*/
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /*public void fayeStatus(int status) {
        switch (status) {
            case 0:
                messageSending = false;
                messageSendingRecursion = false;
                fayeDisconnect = true;
                enableButtons();
                break;
            default:

                break;
        }
    }*/

    @Override
    public void onConnectedServer(FayeClient fc) {
        fayeDisconnect = false;
        if (channelId > -1) {
            mClient.subscribeChannel("/" + String.valueOf(channelId));
            mClient.publish("/" + String.valueOf(channelId), prepareMessageJson(1));

            pageStart = 1;
            isApiRunning = false;
            allMessagesFetched = false;
            if (isP2P && !TextUtils.isEmpty(label))
                getMessages(label);
            else
                getMessages(null);
            /*try {
                retryLayout.setVisibility(View.VISIBLE);
//                progressWheel.setVisibility(View.VISIBLE);
//                btnRetry.setText(stringConfig.getFuguFetchingMessages());
//                retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
            } catch (Exception e) {

            }*/

//            try {
//                setConnectionMessage(0);
//            } catch (Exception e) {
//
//            }
        }
    }

    private boolean isFirstTimeDisconnected = true;
    Handler handlerDisable = new Handler();
    Runnable runnableDisable = new Runnable() {
        @Override
        public void run() {
            setConnectionMessage(2);
        }
    };


    private Handler newhandler = new Handler();
    private final static Integer RECONNECTION_TIME = 2000;
    private int index = -1;

    @Override
    public void onDisconnectedServer(FayeClient fc) {
//        fayeStatus(0);
        messageSending = false;
        messageSendingRecursion = false;
        fayeDisconnect = true;
        enableButtons();
        try {
            if (isNetworkAvailable())
                newhandler.postDelayed(runnable, RECONNECTION_TIME);

//            setConnectionMessage(2);
            handlerDisable.postDelayed(runnableDisable, 2000);
            isFirstTimeDisconnected = false;

        } catch (Exception e) {

        }
    }

    @Override
    public void onPongReceived() {
        //sendMessages();
        fayeDisconnect = false;
        enableButtons();
        checkUnsentMessageStatus(new RefreshDone() {
            @Override
            public void onRefreshComplete() {
                sendMessages();
            }
        });

        if (retryLayout.getVisibility() == View.VISIBLE) {
            setConnectionMessage(0);
        }
    }

    @Override
    public void onWebSocketError() {
        //fayeStatus(0);

        messageSending = false;
        messageSendingRecursion = false;
        fayeDisconnect = true;
        enableButtons();
        try {
            if (isNetworkAvailable())
                newhandler.postDelayed(runnable, RECONNECTION_TIME);

            setConnectionMessage(2);

        } catch (Exception e) {

        }
    }

    @Override
    public void onErrorReceived(FayeClient fc, String msg, String channel) {

    }

    Runnable runnable = new Runnable() {
        @Override
        public void run() {
            try {
                if (HippoNotificationConfig.pushLabelId > 0 && fayeDisconnect) {
                    connectAgainToServer();
                    setConnectionMessage(3);
                }
                try {
                    handlerDisable.removeCallbacks(runnableDisable);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } catch (Exception e) {

            }
        }
    };

    private void connectAgainToServer() throws Exception {
        if (!isNetworkAvailable()) {
            return;
        }
        if (!fayeConnecting) {
            fayeConnecting = true;
            newhandler.removeCallbacks(runnable);
            mClient.setListener(this);
            mClient.connectServer();
        }

        HandlerThread thread = new HandlerThread("FayeReconnect");
        thread.start();

        try {
            new Handler(thread.getLooper()).postDelayed(new Runnable() {
                @Override
                public void run() {
                    fayeConnecting = false;
                }
            }, 1000);
        } catch (Exception e) {
            e.printStackTrace();
            fayeConnecting = false;
        }
    }

    private void uploadFileServerCall(String file, String fileType, final int messageIndex, final String muid) {
        try {
            if (isNetworkAvailable()) {
                //File file1;
                /*try {
                    file1 = new Compressor(this).compressToFile(new File(file));
                } catch (Exception e) {
                    e.printStackTrace();
                    file1 = new File(file);
                }*/
                MultipartParams.Builder multipartBuilder = new MultipartParams.Builder();
                MultipartParams multipartParams = multipartBuilder
                        .add(APP_SECRET_KEY, HippoConfig.getInstance().getAppKey())
                        .add(APP_VERSION, BuildConfig.VERSION_NAME)
                        .add(DEVICE_TYPE, 1)
                        .addFile("file", new File(file))
                        .build();

                HippoLog.v("map = ", multipartParams.getMap().toString());
                HippoLog.v("app_secret_key", "---> " + HippoConfig.getInstance().getAppKey());
                RestClient.getApiInterface()
                        .uploadFile(multipartParams.getMap())
                        .enqueue(new ResponseResolver<FuguUploadImageResponse>(FuguChatActivity.this, false, false) {
                            @Override
                            public void success(FuguUploadImageResponse fuguUploadImageResponse) {

                                String image_url = fuguUploadImageResponse.getData().getUrl();
                                String thumbnail_url = fuguUploadImageResponse.getData().getThumbnailUrl();

                                sendMessage("", IMAGE_MESSAGE, image_url, thumbnail_url, null, null, muid, messageIndex, null);
                                getUnreadCount();
                            }

                            @Override
                            public void failure(APIError error) {
                                ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_IMAGE_RETRY);
                                fuguMessageAdapter.notifyItemChanged(messageIndex);
                            }
                        });
            } else {
                ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_IMAGE_RETRY);
                fuguMessageAdapter.notifyItemChanged(messageIndex);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private void checkUnsentMessageStatus(RefreshDone done) {
        try {
            index = -1;
            if (unsentMessages == null)
                unsentMessages = new LinkedHashMap<>();
            for (String key : unsentMessages.keySet()) {
                ListItem listItem = unsentMessages.get(key);
                String time = ((EventItem) listItem).getEvent().getSentAtUtc();
                int expireTimeCheck = ((EventItem) listItem).getEvent().getIsMessageExpired();
                if (expireTimeCheck == 0 && DateUtils.getTimeDiff(time)) {
                    ((EventItem) listItem).getEvent().setIsMessageExpired(1);
                    try {
                        JSONObject messageJson = unsentMessageMapNew.get(key);
                        messageJson.put("is_message_expired", 1);
                        unsentMessageMapNew.put(key, messageJson);
                        if (index == -1)
                            index = messageJson.optInt("message_index", -1);
                    } catch (Exception e) {
                        //e.printStackTrace();
                    }
                }
            }
            CommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
            CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

            if (index > -1 && fuguMessageAdapter != null) {
                try {
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            fuguMessageAdapter.notifyItemRangeChanged(index, fuguMessageList.size());
                        }
                    });
                } catch (Exception e) {

                }
            }

            if (done != null) {
                done.onRefreshComplete();
            }
        } catch (Exception e) {
            if(HippoConfig.DEBUG)
                e.printStackTrace();
        }
    }

    @Override
    public void onToggleSoftKeyboard(boolean isVisible) {
        keyboardVisibility = isVisible;
    }

    public interface RefreshDone {
        void onRefreshComplete();
    }

    private void setConnectionMessage(final int status) {
        try {
            new Handler(Looper.getMainLooper()).post(new Runnable() {
                @Override
                public void run() {
                    try {
                        if (isNetworkAvailable()) {
                            switch (status) {
                                case 0:
                                    retryLayout.setVisibility(View.GONE);
                                    break;
                                case 1:
                                    retryLayout.setVisibility(View.VISIBLE);
                                    progressWheel.setVisibility(View.VISIBLE);
                                    btnRetry.setText(getString(R.string.hippo_fetching_messages));
                                    retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
                                    break;
                                case 2:
                                    retryLayout.setVisibility(View.VISIBLE);
                                    progressWheel.setVisibility(View.GONE);
                                    btnRetry.setText(getString(R.string.hippo_server_disconnect));
                                    retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                                    enableButtons();
                                    break;
                                case 3:
                                    retryLayout.setVisibility(View.VISIBLE);
                                    progressWheel.setVisibility(View.GONE);
                                    btnRetry.setText(getString(R.string.hippo_no_network_connected));
                                    retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                                    enableButtons();
                                    break;
                                case 4:
                                    retryLayout.setVisibility(View.VISIBLE);
                                    progressWheel.setVisibility(View.GONE);
                                    btnRetry.setText(getString(R.string.hippo_server_connecting));
                                    retryLayout.setBackgroundColor(hippoColorConfig.getHippoConnected());
                                    enableButtons();
                                    break;
                                default:

                                    break;
                            }
                        } else {
                            retryLayout.setVisibility(View.VISIBLE);
                            progressWheel.setVisibility(View.GONE);
                            btnRetry.setText(getString(R.string.hippo_no_network_connected));
                            retryLayout.setBackgroundColor(hippoColorConfig.getHippoNotConnected());
                            enableButtons();
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    String fullname = "";
    String image = "";
    private void videoCallInit(int callType) {

        if(HippoConfig.getInstance().getCallData() != null) {
            HippoConfig.getInstance().getCallData().onCallClick(this, callType, channelId, userId);
        }
    }


    /**
     * Method to select an image for Position in
     * the List of AddImages
     */
    public void selectImage(View view) {
        if(fuguImageUtils == null)
            fuguImageUtils = new FuguImageUtils(FuguChatActivity.this);

        FileSharingUtils fileSharingUtils = new FileSharingUtils(FuguChatActivity.this, view,  keyboardVisibility, fuguImageUtils);
        fileSharingUtils.selectFiles(new FileSharingUtils.FileSharingListner() {
            @Override
            public void onCameraOpened() {
                openCamera();
            }
        });


        /*fuguImageUtils.showImageChooser(OPEN_CAMERA_ADD_IMAGE, OPEN_GALLERY_ADD_IMAGE, SELECT_FILE, new FuguImageUtils.ViewOpened() {
            @Override
            public void open() {
                isFirstTimeOpened = true;
            }
        });*/
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case Constant.REQUEST_CODE_PICK_IMAGE:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<ImageFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_IMAGE);
                    StringBuilder builder = new StringBuilder();
                    String path = null;

                    ImageFile actualfile = list.get(0);
                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Util.getExtension(actualfile.getPath());
                    String fileName = actualfile.getName();


                    if(!TextUtils.isEmpty(fileExt)) {
                        actualfile.setName(actualfile.getName() + "." + fileExt);
                        //actualfile.setName(actualfile.getName() + "_" + muid + "." + fileExt);
                    }
                    actualfile.setMuid(muid);
                    String localPath = Util.setImageFullPath(fileName + "_" + muid + "." + fileExt);
                    actualfile.setDestinationPath(localPath);

                    if(actualfile != null)
                        compressImage(actualfile);

                    //HippoLog.v(TAG, "Image: "+builder.toString());
                }
                break;
            case Constant.REQUEST_CODE_PICK_VIDEO:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<VideoFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_VIDEO);
                    VideoFile file = list.get(0);

                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Util.getExtension(file.getPath());
                    String fileName = file.getName();
                    if(!TextUtils.isEmpty(fileExt)) {
                        fileName = file.getName() + "." + fileExt;
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.VIDEO.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, VIDEO_FOLDER);

                    HippoLog.v(TAG, "File List: "+new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_PICK_AUDIO:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<AudioFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_AUDIO);
                    AudioFile file = list.get(0);
                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Util.getExtension(file.getPath());
                    String fileName = file.getName();
                    if(!TextUtils.isEmpty(fileExt)) {
//                        fileName = file.getName() + "_" + muid + "." + fileExt;
                        fileName = file.getName() + "." + fileExt;
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.AUDIO.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, AUDIO_FOLDER);

                    HippoLog.v(TAG, "File List: "+new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_PICK_FILE:
                if (resultCode == RESULT_OK) {
                    isFromFilePicker = true;
                    ArrayList<NormalFile> list = data.getParcelableArrayListExtra(Constant.RESULT_PICK_FILE);
                    StringBuilder builder = new StringBuilder();
                    NormalFile file = list.get(0);
                    /*for (NormalFile file : list) {
                        String path = file.getPath();
                        builder.append(path + "\n");
                        builder.append(file.getMimeType() +"\n");
                        builder.append(file.getSize() +"\n");
                    }*/

                    String muid = UUID.randomUUID().toString() + "." + new Date().getTime();
                    String fileExt = Util.getExtension(file.getPath());
                    String fileName = file.getName();
                    if(!TextUtils.isEmpty(fileExt)) {
                        fileName = file.getName() + "." + fileExt;
//                        fileName = file.getName() + "_" + muid + "." + fileExt;
                    }

                    String filePath = "";

                    FileuploadModel fileuploadModel = new FileuploadModel(fileName, String.valueOf(file.getSize()), file.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(file.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.FILE.toString());
                    fileuploadModel.setMessageType(FILE_MESSAGE);

                    copingFileToLocal(fileuploadModel, DOC_FOLDER);
                    //sendMessage(getString(R.string.fugu_empty), FILE_MESSAGE, "", "", file.getPath(), null, fileuploadModel);


                    HippoLog.v(TAG, "File: "+builder.toString());
                    HippoLog.v(TAG, "File List: "+new Gson().toJson(list));
                }
                break;
            case Constant.REQUEST_CODE_TAKE_IMAGE:
                if(resultCode == RESULT_OK) {
                    String path = CommonData.getTime();
                    ImageFile imageFile = new ImageFile();
                    imageFile.setPath(path);
                    imageFile.setDestinationPath(path);
                    imageFile.setMuid(CommonData.getImageMuid());
                    imageFile.setSize(new File(path).length());
                    imageFile.setName(Util.extractFileNameWithSuffix(path));
                    HippoLog.d(TAG, "camera imageFile: " + new Gson().toJson(imageFile));
                    compressImage(imageFile);

                }
                break;
            case AppSettingsDialog.DEFAULT_SETTINGS_REQ_CODE:
                if (EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE")) {
                    openFileIntent();
                }
                break;
        }
    }

    private void copingFileToLocal(FileuploadModel fileuploadModel, String folderType) {
        LoadingBox.showOn(FuguChatActivity.this);
        try {
            FileManager.getInstance().copyFile(fileuploadModel.getFilePath(), FOLDER_TYPE.get(folderType), fileuploadModel, new FileManager.FileCopyListener() {
                @Override
                public void onCopingFile(boolean flag, FileuploadModel fileuploadModel) {
                    sendMessage(getString(R.string.fugu_empty), FILE_MESSAGE, "", "", fileuploadModel.getFilePath(), null, fileuploadModel);
                    LoadingBox.hide();
                }

                @Override
                public void largeFileSize() {
                    showErrorMessage(getString(R.string.hippo_large_file, Util.humanReadableSize(HippoConfig.getMaxSize(), true)), "OK");
                    LoadingBox.hide();
                }

                @Override
                public void onError() {

                }
            });
        } catch (IOException e) {
            e.printStackTrace();
        }

    }

    boolean isCameraPermission;
    private void openCamera() {
        if(fuguImageUtils == null)
            fuguImageUtils = new FuguImageUtils(FuguChatActivity.this);
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        isCameraPermission = true;
        if (isGranted) {
            fuguImageUtils.startCamera();
        } else {
            EasyPermissions.requestPermissions(this, getString(R.string.vw_rationale_storage),
                    RC_OPEN_CAMERA, "android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        HippoLog.e(TAG, "onRequestPermissionsResult" + requestCode);
        // Forward results to EasyPermissions
        EasyPermissions.onRequestPermissionsResult(requestCode, permissions, grantResults, this);
    }

    @Override
    public void onPermissionsGranted(int requestCode, @NonNull List<String> perms) {
        if(isCameraPermission) {
            if (fuguImageUtils == null)
                fuguImageUtils = new FuguImageUtils(FuguChatActivity.this);
            fuguImageUtils.startCamera();
            isCameraPermission = false;
        } else {

        }
    }

    @Override
    public void onPermissionsDenied(int requestCode, @NonNull List<String> perms) {
        // If Permission permanently denied, ask user again
        if (EasyPermissions.somePermissionPermanentlyDenied(this, perms)) {
            new AppSettingsDialog.Builder(this).build().show();
        } else {
            Toast.makeText(FuguChatActivity.this, "Please grant permission", Toast.LENGTH_SHORT).show();
            //finish();
        }
    }

    /**
     * Read external storage file
     */
    @AfterPermissionGranted(RC_READ_EXTERNAL_STORAGE)
    public void readExternalStorage() {
        boolean isGranted = EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        if (isGranted) {
            openFileIntent();
        } else {
            EasyPermissions.requestPermissions(this, getString(R.string.vw_rationale_storage),
                    RC_READ_EXTERNAL_STORAGE, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        }
    }

    public boolean checkPermission() {
        return EasyPermissions.hasPermissions(this, "android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    private void openFileIntent() {

    }

    public void compressImage(final ImageFile actualFile) {
        try {
            int screenWidth = getResources().getDisplayMetrics().widthPixels;
            if (screenWidth > 1024)
                screenWidth = 1024;

            new Compressor()
                    .setMaxWidth(screenWidth)
                    .setMaxHeight(screenWidth)
                    .setQuality(75)
                    .setCompressFormat(Bitmap.CompressFormat.JPEG)
                    .setListener(new CompressorListener() {
                        @Override
                        public void onImageCompressed(File file, String path, ImageFile imageFile, ArrayList<Integer> integers) {
                            showImageDialog(FuguChatActivity.this, file, path, imageFile, integers);
                        }
                    })
                    .compressToFile(new File(actualFile.getPath()), actualFile);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showImageDialog(Context activity, File imgUrl, final String image, final ImageFile imageFile, final ArrayList<Integer> integers) {

        try {
            final Dialog dialog = new Dialog(activity, android.R.style.Theme_Translucent_NoTitleBar);
            //setting custom layout to dialog
            dialog.setContentView(R.layout.fugu_image_dialog);

            Window dialogWindow = dialog.getWindow();
            WindowManager.LayoutParams layoutParams = dialogWindow.getAttributes();
            layoutParams.dimAmount = 1.0f;

            dialogWindow.getAttributes().windowAnimations = R.style.CustomDialog;

            dialogWindow.addFlags(WindowManager.LayoutParams.FLAG_DIM_BEHIND);

            dialog.setCancelable(true);
            dialog.setCanceledOnTouchOutside(false);
            ZoomageView ivImage = dialog.findViewById(R.id.ivImage);
            RequestOptions myOptions = RequestOptions
                    .bitmapTransform(new RoundedCornersTransformation(activity, 7, 2))
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .priority(Priority.HIGH)
                    .error(ContextCompat.getDrawable(activity, R.drawable.hippo_placeholder));

            RequestOptions options = new RequestOptions()
                    .centerCrop()
                    .dontAnimate()
                    .diskCacheStrategy(DiskCacheStrategy.ALL)
                    .placeholder(R.drawable.hippo_placeholder)
                    .error(R.drawable.hippo_placeholder)
                    .fitCenter()
                    .priority(Priority.HIGH)
                    .transforms(new CenterCrop(), new RoundedCorners(3));

            Glide.with(activity).asBitmap()
                    .apply(options)
                    .load(imgUrl)
                    //.transition(withCrossFade())
                    .into(ivImage);
            TextView tvCross = dialog.findViewById(R.id.tvCross);
//            LinearLayout linearLayout = dialog.findViewById(R.id.llMessageLayout);
//            linearLayout.setVisibility(View.VISIBLE);
//
            ImageView ivSend = dialog.findViewById(R.id.ivSend);
            ivSend.setVisibility(View.VISIBLE);
            ivSend.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String muid = Util.getMuid(imageFile.getName());
                    if(!TextUtils.isEmpty(imageFile.getMuid())) {
                        muid = imageFile.getMuid();
                    }
                    FileuploadModel fileuploadModel = new FileuploadModel(imageFile.getName(), String.valueOf(imageFile.getSize()), imageFile.getPath(), muid);
                    fileuploadModel.setFileSizeReadable(Util.humanReadableByteCount(imageFile.getSize(), true));
                    fileuploadModel.setDocumentType(DocumentType.IMAGE.toString());
                    fileuploadModel.setMessageType(IMAGE_MESSAGE);
                    fileuploadModel.setDimns(integers);
                    fileuploadModel.setMuid(imageFile.getMuid());
                    sendMessage(getString(R.string.fugu_empty), IMAGE_MESSAGE, "", "", imageFile.getPath(), null, fileuploadModel);
                    dialog.dismiss();
                    //sendMessage(getString(R.string.fugu_empty), IMAGE_MESSAGE, "", "", image, null);
                }
            });
            tvCross.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    dialog.dismiss();
                }
            });
            dialog.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList<Integer> getIMGSize(String url){
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile(url, options);
        int imageHeight = options.outHeight;
        int imageWidth = options.outWidth;
        ArrayList<Integer> dimns = new ArrayList<>();
        dimns.add(imageHeight);
        dimns.add(imageWidth);
        return dimns;
    }

    private Type fileuploadType = new TypeToken<List<FileuploadModel>>() {
    }.getType();
    private void uploadFile(FileuploadModel fileuploadModel) {

        ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
        if(fileuploadModels == null)
            fileuploadModels = new ArrayList<>();
        if(fileuploadModels.size()>4) {
            Toast.makeText(FuguChatActivity.this, "Already files in queue. Please wait", Toast.LENGTH_SHORT).show();
            return;
        }
        fileuploadModels.add(fileuploadModel);
        String data = new Gson().toJson(fileuploadModels, fileuploadType);
        HippoLog.e(TAG, "data = "+data);

        Prefs.with(this).save(KEY, data);

        if(!isMyServiceRunning(MyForeGroundService.class)) {
            Intent intent = new Intent(getBaseContext(), MyForeGroundService.class);
            intent.setAction("start");
            if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
                startForegroundService(intent);
            } else {
                //lower then Oreo, just start the service.
                startService(intent);
            }
        } else {
            //ToastUtil.getInstance(this).showToast("Already running");
        }

        if(channelId.compareTo(-1l) == 0) {
            createConversation(null, -1l);
        }
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            }
        }
        return false;
    }



    private BroadcastReceiver fileUploadReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra(BROADCAST_STATUS, 0);
            switch (status) {
                case BroadCastStatus.UPLOADED_SUCESSFULLY:
                    if(channelId != null && channelId.equals(intent.getLongExtra("channelId", -2))) {
                        String muid = intent.getStringExtra("muid");
                        int messageIndex = intent.getIntExtra("messageIndex", 0);
                        String imageUrl = intent.getStringExtra("image_url");
                        String thumbnailUrl = intent.getStringExtra("thumbnail_url");
                        FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);

                        unsentMessageMapNew.put(muid, fileuploadModel.getMessageObject());

                        ListItem listItem = unsentMessages.get(fileuploadModel.getMuid());
                        if (listItem == null)
                            return;
                        Message message = ((EventItem) listItem).getEvent();
                        message.setMessageStatus(MESSAGE_FILE_UPLOADED);
                        message.setFileUrl(imageUrl);
                        message.setUrl(imageUrl);
                        message.setLocalImagePath("");
                        message.setThumbnailUrl(thumbnailUrl);
                        message.setUploadStatus(UPLOAD_COMPLETED);

                        unsentMessages.put(muid, new EventItem(message));

                        try {
                            ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_FILE_UPLOADED);
                            fuguMessageAdapter.notifyItemChanged(messageIndex);
                            if (!messageSendingRecursion && isNetworkAvailable()) {
                                sendMessages();
                            }
                        } catch (Exception e) {
                            try {
                                for(int i = fuguMessageList.size()-1; i>=0; i--) {
                                    if (fuguMessageList.get(i) instanceof EventItem) {
                                        Message currentMessage = ((EventItem) fuguMessageList.get(i)).getEvent();
                                        if (currentMessage.getMuid().equals(muid)) {
                                            messageIndex = i;
                                            ((EventItem) fuguMessageList.get(messageIndex)).getEvent().setMessageStatus(MESSAGE_FILE_UPLOADED);
                                            fuguMessageAdapter.notifyItemChanged(messageIndex);
                                            if (!messageSendingRecursion && isNetworkAvailable()) {
                                                sendMessages();
                                            }
                                            break;
                                        }
                                    }
                                }
                            } catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    break;
                case BroadCastStatus.UPLOADING_FAILED:

                    break;
                case BroadCastStatus.PUBLISHED:

                    break;
                case BroadCastStatus.CREATE_CHANNEL:
                    if(CommonData.isFirstTimeCreated()) {
                        CommonData.setFirstTimeCreated(false);
                        final FileuploadModel fileuploadModel = new Gson().fromJson(intent.getStringExtra("fileuploadModel"), FileuploadModel.class);
                        runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                createConversation(fileuploadModel.getMessageObject(), fileuploadModel.getLabelId());
                            }
                        });

                    }
                    break;
                case BroadCastStatus.MESSAGE_EXPIRED:
                    String muid = intent.getStringExtra("muid");
                    int messageIndex = intent.getIntExtra("messageIndex", 0);

                    if (unsentMessages == null)
                        unsentMessages = new LinkedHashMap<>();

                    ListItem listItem = unsentMessages.get(muid);
                    if(listItem != null) {
                        ((EventItem) listItem).getEvent().setIsMessageExpired(1);
                        ((EventItem) listItem).getEvent().setUploadStatus(UPLOAD_FAILED);
                    }

                    try {
                        JSONObject messageJson = unsentMessageMapNew.get(muid);
                        messageJson.put("is_message_expired", 1);
                        unsentMessageMapNew.put(muid, messageJson);
                        index = messageJson.optInt("message_index", -1);
                        fuguMessageAdapter.notifyItemChanged(index);
                    } catch (Exception e) {
                        //e.printStackTrace();
                    }

                    CommonData.setUnsentMessageByChannel(conversation.getChannelId(), unsentMessages);
                    CommonData.setUnsentMessageMapByChannel(conversation.getChannelId(), unsentMessageMapNew);

                    break;
                default:

                    break;
            }
        }
    };

    private boolean checkButtonClick() {
        boolean click = false;
        if(isNetworkAvailable()) {
            click = true;
            ArrayList<FileuploadModel> fileuploadModels = new Gson().fromJson(Prefs.with(this).getString(KEY, ""), fileuploadType);
            try {
                if (fileuploadModels != null && fileuploadModels.size() > 5) {
                    click = false;
                    Toast.makeText(FuguChatActivity.this, "Already files in queue. Please wait", Toast.LENGTH_SHORT).show();
                }
            } catch (Exception e) {
                click = true;
            }
        } else {
            Toast.makeText(FuguChatActivity.this, getString(R.string.fugu_unable_to_connect_internet), Toast.LENGTH_SHORT).show();
        }
        return click;
    }

    private void checkFileExpireyData() {
        checkUnsentMessageStatus(new RefreshDone() {
            @Override
            public void onRefreshComplete() {
                sendMessages();
            }
        });
    }

}