package com.hippo.activity;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;

import com.hippo.BuildConfig;
import com.hippo.HippoConfig;
import com.hippo.R;
import com.hippo.constant.FuguAppConstant;
import com.hippo.database.CommonData;
import com.hippo.retrofit.APIError;
import com.hippo.retrofit.CommonParams;
import com.hippo.retrofit.CommonResponse;
import com.hippo.retrofit.ResponseResolver;
import com.hippo.retrofit.RestClient;
import com.hippo.utils.HippoLog;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;

/**
 * Created by rajatdhamija  14/12/17.
 */

public class FuguBaseActivity extends AppCompatActivity implements FuguAppConstant {
    private static final String TAG = FuguBaseActivity.class.getSimpleName();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        uncaughtExceptionError();
        /*if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            try {
                registerReceiver(new FuguNetworkStateReceiver(),
                        new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
            } catch (Exception e) {
                HippoLog.e(TAG, "Error in broadcasting");
            }
        }*/
    }

    /**
     * Uncaught Exception encountered
     */
    private void uncaughtExceptionError() {
        Thread.setDefaultUncaughtExceptionHandler(
                new Thread.UncaughtExceptionHandler() {
                    @Override
                    public void uncaughtException(Thread paramThread, Throwable paramThrowable) {
                        //Do your own error handling here
                        HippoLog.e("unCaughtException paramThread", "---> " + paramThread.toString());
                        HippoLog.e("unCaughtException paramThrowable", "---> " + paramThrowable.toString());
                        StringWriter stackTrace = new StringWriter();
                        paramThrowable.printStackTrace(new PrintWriter(stackTrace));
                        HippoLog.e("unCaughtException stackTrace", "---> " + stackTrace);
                        System.err.println(stackTrace);
                        if(!HippoConfig.DEBUG)
                            apiSendError(stackTrace.toString());
                    }
                });
    }

    /**
     * APi to send error messages to server
     *
     * @param logs log to be sent
     */
    public void apiSendError(String logs) {
        if (isNetworkAvailable()) {
            PackageInfo pInfo = null;
            try {
                pInfo = this.getPackageManager().getPackageInfo(getPackageName(), 0);
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            JSONObject error = new JSONObject();
            try {
                error.put("log", logs);
                if (pInfo != null) {
                    error.put("version", pInfo.versionCode);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            HashMap<String, Object> params = new HashMap<>();
            params.put(FuguAppConstant.APP_SECRET_KEY, HippoConfig.getInstance().getAppKey());
            params.put(FuguAppConstant.DEVICE_TYPE, ANDROID_USER);
            params.put(APP_VERSION, BuildConfig.VERSION_NAME);
            params.put(FuguAppConstant.DEVICE_DETAILS, CommonData.deviceDetails(FuguBaseActivity.this));
            params.put(FuguAppConstant.ERROR, error.toString());

            CommonParams commonParams = new CommonParams.Builder()
                    .putMap(params)
                    .build();

            RestClient.getApiInterface().sendError(commonParams.getMap())
                    .enqueue(new ResponseResolver<CommonResponse>(FuguBaseActivity.this, false, true) {
                        @Override
                        public void success(CommonResponse commonResponse) {
                            HippoLog.v("success", commonResponse.toString());
                        }

                        @Override
                        public void failure(APIError error) {
                            HippoLog.v("failure", error.toString());
                        }
                    });
        }
    }

    /**
     * Check Network Connection
     *
     * @return boolean
     */
    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager) getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = null;
        if (cm != null) {
            networkInfo = cm.getActiveNetworkInfo();
        }
        return networkInfo != null && networkInfo.isConnected();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // handle arrow click here
        if (item.getItemId() == android.R.id.home) {
            // close this context and return to preview context (if there is any)
            finish();
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onPause() {
        super.onPause();
    }

    /**
     * Set toolbar data
     *
     * @param toolbar  toolbar instance
     * @param title    title to be displayed
     * @param subTitle subtitle to be displayed
     * @return action bar
     */
    public ActionBar setToolbar(Toolbar toolbar, String title, String subTitle) {

        ActionBar ab = getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable(new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            toolbar.setSubtitleTextColor(CommonData.getColorConfig().getHippoActionBarText());
            // TODO: 31/12/18 exposs drawable method
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);
//            if (HippoConfig.getInstance().getHomeUpIndicatorDrawableId() != -1)
//                ab.setHomeAsUpIndicator(HippoConfig.getInstance().getHomeUpIndicatorDrawableId());

            ab.setTitle(title);
            ab.setSubtitle(subTitle);

        }
        return getSupportActionBar();
    }

    /**
     * Hide softkeyboard of opened
     * @param activity
     */
    protected void hideKeyboard(Activity activity) {
        try {
            View view = activity.getCurrentFocus();
            InputMethodManager imm = (InputMethodManager) activity.getSystemService(Context.INPUT_METHOD_SERVICE);
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

        /**
         * Set toolbar data
         *
         * @param toolbar toolbar instance
         * @param title   title to be displayed
         * @return action bar
         */
    public ActionBar setToolbar(Toolbar toolbar, String title) {

        ActionBar ab = getSupportActionBar();
        if (ab != null) {
            ab.setDisplayHomeAsUpEnabled(true);
            ab.setBackgroundDrawable(new ColorDrawable(CommonData.getColorConfig().getHippoActionBarBg()));
            ab.setHomeAsUpIndicator(R.drawable.hippo_ic_arrow_back);

            // TODO: 31/12/18 exposs drawable name
//            if (HippoConfig.getInstance().getHomeUpIndicatorDrawableId() != -1)
//                ab.setHomeAsUpIndicator(HippoConfig.getInstance().getHomeUpIndicatorDrawableId());

            ab.setTitle("");

            toolbar.setTitleTextColor(CommonData.getColorConfig().getHippoActionBarText());

            ((TextView) toolbar.findViewById(R.id.tv_toolbar_name)).setText(title);
            ((TextView) toolbar.findViewById(R.id.tv_toolbar_name)).setTextColor(CommonData.getColorConfig().getHippoActionBarText());
        }
        return getSupportActionBar();
    }

    public void showErrorMessage(final String errorMessage, final String positiveButtonText) {
        showErrorMessage(errorMessage, positiveButtonText, false);
    }
    public void showErrorMessage(final String errorMessage, final String positiveButtonText, final boolean isFinish) {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                new AlertDialog.Builder(FuguBaseActivity.this)
                        .setMessage(errorMessage)
                        .setPositiveButton(positiveButtonText, new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(final DialogInterface dialog, final int which) {
                                if(isFinish)
                                    finish();
                            }
                        })
                        .setCancelable(false)
                        .show();
            }
        });
    }

}
