/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder.helper;

import android.app.Application;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Handler;
import android.util.Log;
import com.serenegiant.encoder.MediaAudioEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaMuxerWrapper;
import com.serenegiant.encoder.MediaVideoBufferEncoder;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.utils.HandlerThreadHandler;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.utils.UriHelper;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaVideoBufferEncoderHelper {
    private static final String TAG = MediaVideoBufferEncoderHelper.class.getSimpleName();
    private final Object mSync = new Object();
    private MediaMuxerWrapper mMuxer;
    private MediaVideoBufferEncoder mVideoEncoder;
    private Size mSize;
    private boolean mIsRecording;
    private Handler mAsyncHandler = HandlerThreadHandler.createHandler(TAG);
    private final IFrameCallback mIFrameCallback = new IFrameCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrame(ByteBuffer frame) {
            MediaVideoBufferEncoder videoEncoder;
            Object object = MediaVideoBufferEncoderHelper.this.mSync;
            synchronized (object) {
                videoEncoder = MediaVideoBufferEncoderHelper.this.mVideoEncoder;
            }
            if (videoEncoder != null) {
                videoEncoder.frameAvailableSoon();
                videoEncoder.encode(frame);
            }
        }
    };
    public static final int PIXEL_FORMAT = 2;
    private final MediaEncoder.MediaEncoderListener mVideoEncoderListener = new MediaEncoder.MediaEncoderListener(){

        @Override
        public void onPrepared(MediaEncoder encoder) {
            MediaVideoBufferEncoderHelper.this.mIsRecording = true;
        }

        @Override
        public void onStopped(MediaEncoder encoder) {
            try {
                MediaVideoBufferEncoderHelper.this.mIsRecording = false;
                Uri uri = encoder.getOutputUri();
                if (uri != null) {
                    MediaVideoBufferEncoderHelper.this.mAsyncHandler.postDelayed(() -> {
                        Application context = UVCUtils.getApplication();
                        String path = UriHelper.getPath((Context)context, uri);
                        try {
                            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{path}, null, null);
                        }
                        catch (Exception e) {
                            Log.e((String)TAG, (String)"MediaScannerConnection:", (Throwable)e);
                        }
                    }, 500L);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"onStopped:", (Throwable)e);
            }
        }
    };
    private final MediaEncoder.MediaEncoderListener mAudioEncoderListener = new MediaEncoder.MediaEncoderListener(){

        @Override
        public void onPrepared(MediaEncoder encoder) {
        }

        @Override
        public void onStopped(MediaEncoder encoder) {
        }
    };

    public MediaVideoBufferEncoderHelper(Size mSize) {
        this.mSize = mSize;
    }

    public boolean isRecording() {
        return this.mIsRecording;
    }

    public IFrameCallback getFrameCallback() {
        return this.mIFrameCallback;
    }

    public void startRecording(Uri uri) {
        this.mAsyncHandler.post(() -> {
            try {
                if (this.mMuxer != null) {
                    return;
                }
                MediaMuxerWrapper muxer = new MediaMuxerWrapper(uri);
                MediaVideoBufferEncoder videoEncoder = new MediaVideoBufferEncoder(muxer, this.mSize.width, this.mSize.height, this.mVideoEncoderListener);
                new MediaAudioEncoder(muxer, this.mAudioEncoderListener);
                muxer.prepare();
                muxer.startRecording();
                Object object = this.mSync;
                synchronized (object) {
                    this.mMuxer = muxer;
                    this.mVideoEncoder = videoEncoder;
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"startRecording:", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseRecording() {
        Object object = this.mSync;
        synchronized (object) {
            this.mMuxer.pauseRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeRecording() {
        Object object = this.mSync;
        synchronized (object) {
            this.mMuxer.resumeRecording();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() {
        MediaMuxerWrapper muxer;
        Object object = this.mSync;
        synchronized (object) {
            muxer = this.mMuxer;
            this.mMuxer = null;
            this.mVideoEncoder = null;
        }
        if (muxer != null) {
            muxer.stopRecording();
        }
    }
}

