/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Log;
import com.serenegiant.encoder.IVideoEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaMuxerWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaVideoBufferEncoder
extends MediaEncoder
implements IVideoEncoder {
    private static final boolean DEBUG = false;
    private static final String TAG = "MediaVideoBufferEncoder";
    private static final String MIME_TYPE = "video/avc";
    private static final int FRAME_RATE = 25;
    private static final int I_FRAME_INTERVAL = 10;
    private static final float BPP = 0.25f;
    private final int mWidth;
    private final int mHeight;
    protected int mColorFormat;
    protected static int[] recognizedFormats = new int[]{21, 2141391872, 2135033992};

    public MediaVideoBufferEncoder(MediaMuxerWrapper muxer, int width, int height, MediaEncoder.MediaEncoderListener listener) {
        super(muxer, listener);
        this.mWidth = width;
        this.mHeight = height;
    }

    public void encode(ByteBuffer buffer) {
        if (!this.mIsCapturing) {
            return;
        }
        this.encode(buffer, buffer.capacity(), this.getPTSUs());
    }

    @Override
    protected void prepare() throws IOException {
        this.mTrackIndex = -1;
        this.mMuxerStarted = false;
        MediaCodecInfo videoCodecInfo = this.selectVideoCodec(MIME_TYPE);
        if (videoCodecInfo == null) {
            Log.e((String)TAG, (String)"Unable to find an appropriate codec for video/avc");
            return;
        }
        MediaFormat format = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)this.mWidth, (int)this.mHeight);
        format.setInteger("color-format", this.mColorFormat);
        format.setInteger("bitrate", this.calcBitRate());
        format.setInteger("frame-rate", 25);
        format.setInteger("i-frame-interval", 10);
        this.mMediaCodec = MediaCodec.createEncoderByType((String)MIME_TYPE);
        this.mMediaCodec.configure(format, null, null, 1);
        this.mMediaCodec.start();
        if (this.mListener != null) {
            try {
                this.mListener.onPrepared(this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"prepare:", (Throwable)e);
            }
        }
    }

    private int calcBitRate() {
        int bitrate = (int)(6.25f * (float)this.mWidth * (float)this.mHeight);
        Log.i((String)TAG, (String)String.format("bitrate=%5.2f[Mbps]", Float.valueOf((float)bitrate / 1024.0f / 1024.0f)));
        return bitrate;
    }

    protected final MediaCodecInfo selectVideoCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                int format;
                if (!type.equalsIgnoreCase(mimeType) || (format = MediaVideoBufferEncoder.selectColorFormat(codecInfo, mimeType)) <= 0) continue;
                this.mColorFormat = format;
                return codecInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities caps;
        int result = 0;
        try {
            Thread.currentThread().setPriority(10);
            caps = codecInfo.getCapabilitiesForType(mimeType);
        }
        finally {
            Thread.currentThread().setPriority(5);
        }
        for (int i = 0; i < caps.colorFormats.length; ++i) {
            int colorFormat = caps.colorFormats[i];
            if (!MediaVideoBufferEncoder.isRecognizedViewFormat(colorFormat)) continue;
            result = colorFormat;
            break;
        }
        if (result == 0) {
            Log.e((String)TAG, (String)("couldn't find a good color format for " + codecInfo.getName() + " / " + mimeType));
        }
        return result;
    }

    private static final boolean isRecognizedViewFormat(int colorFormat) {
        int n = recognizedFormats != null ? recognizedFormats.length : 0;
        for (int i = 0; i < n; ++i) {
            if (recognizedFormats[i] != colorFormat) continue;
            return true;
        }
        return false;
    }
}

