/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import com.serenegiant.encoder.MediaMuxerWrapper;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public abstract class MediaEncoder
extends Thread {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaEncoder.class.getSimpleName();
    protected static final int TIMEOUT_US = 10000;
    protected volatile boolean mIsCapturing;
    protected boolean mMuxerStarted;
    protected volatile boolean mIsPaused;
    protected volatile long mStartTime;
    protected volatile long mLastPauseTime;
    protected volatile long mPauseTotalTime;
    protected int mTrackIndex;
    protected MediaCodec mMediaCodec;
    protected final WeakReference<MediaMuxerWrapper> mWeakMuxer;
    private MediaCodec.BufferInfo mBufferInfo;
    protected final MediaEncoderListener mListener;
    protected Surface mSurface;
    long prevPTS = 0L;

    public MediaEncoder(MediaMuxerWrapper muxer, MediaEncoderListener listener) {
        if (listener == null) {
            throw new NullPointerException("MediaEncoderListener is null");
        }
        if (muxer == null) {
            throw new NullPointerException("MediaMuxerWrapper is null");
        }
        this.mWeakMuxer = new WeakReference<MediaMuxerWrapper>(muxer);
        muxer.addEncoder(this);
        this.mListener = listener;
        this.mBufferInfo = new MediaCodec.BufferInfo();
    }

    public Uri getOutputUri() {
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        return muxer != null ? muxer.getOutputUri() : null;
    }

    public Surface getInputSurface() {
        return this.mSurface;
    }

    public boolean frameAvailableSoon() {
        return this.mIsCapturing;
    }

    @Override
    public void run() {
        this.drain();
        this.release();
    }

    abstract void prepare() throws IOException;

    void startRecording() {
        this.mIsCapturing = true;
        this.mIsPaused = false;
        this.mStartTime = System.nanoTime();
        this.mLastPauseTime = 0L;
        this.mPauseTotalTime = 0L;
        this.start();
    }

    void pauseRecording() {
        this.mIsPaused = true;
        this.mLastPauseTime = System.nanoTime();
    }

    void resumeRecording() {
        this.mIsPaused = false;
        long pauseTime = System.nanoTime() - this.mLastPauseTime;
        if (pauseTime > 0L) {
            this.mPauseTotalTime += pauseTime / 1000L;
        }
    }

    void stopRecording() {
        if (!this.mIsCapturing) {
            return;
        }
        this.mIsPaused = false;
        this.signalEndOfInputStream();
    }

    protected void release() {
        try {
            this.mListener.onStopped(this);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"failed onStopped", (Throwable)e);
        }
        this.mIsCapturing = false;
        if (this.mMediaCodec != null) {
            try {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"failed releasing MediaCodec", (Throwable)e);
            }
        }
        if (this.mMuxerStarted) {
            MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
            if (muxer != null) {
                try {
                    muxer.stop();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)"failed stopping muxer", (Throwable)e);
                }
            }
            this.mMuxerStarted = false;
        }
        this.mBufferInfo = null;
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
    }

    protected void signalEndOfInputStream() {
        try {
            if (this.mSurface != null) {
                this.mMediaCodec.signalEndOfInputStream();
            } else {
                this.encode(null, 0, this.getPTSUs());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void encode(ByteBuffer buffer, int length, long presentationTimeUs) {
        block8: {
            if (!this.mIsCapturing || this.mIsPaused) {
                return;
            }
            try {
                if (length <= 0) {
                    while (this.mIsCapturing) {
                        int inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(10000L);
                        if (inputBufferIndex < 0) continue;
                        this.mMediaCodec.queueInputBuffer(inputBufferIndex, 0, 0, presentationTimeUs, 4);
                        break block8;
                    }
                    break block8;
                }
                int current = 0;
                while (this.mIsCapturing && current < length) {
                    int inputBufferId = this.mMediaCodec.dequeueInputBuffer(10000L);
                    if (inputBufferId >= 0) {
                        ByteBuffer inputBuffer = Build.VERSION.SDK_INT < 21 ? this.mMediaCodec.getInputBuffers()[inputBufferId] : this.mMediaCodec.getInputBuffer(inputBufferId);
                        inputBuffer.clear();
                        int inputSize = inputBuffer.capacity();
                        int n = inputSize = current + inputSize < length ? inputSize : length - current;
                        if (inputSize > 0 && buffer != null) {
                            buffer.position(current);
                            buffer.limit(current + inputSize);
                            inputBuffer.put(buffer);
                        }
                        current += inputSize;
                        this.mMediaCodec.queueInputBuffer(inputBufferId, 0, inputSize, presentationTimeUs, 0);
                        continue;
                    }
                    if (inputBufferId != -1) continue;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drain() {
        if (this.mMediaCodec == null) {
            return;
        }
        MediaMuxerWrapper muxer = (MediaMuxerWrapper)this.mWeakMuxer.get();
        if (muxer == null) {
            Log.w((String)TAG, (String)"muxer is unexpectedly null");
            return;
        }
        block7: while (this.mIsCapturing) {
            try {
                ByteBuffer encodedData;
                int outputBufferId = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 10000L);
                if (outputBufferId == -1 || outputBufferId == -3) continue;
                if (outputBufferId == -2) {
                    if (this.mMuxerStarted) {
                        throw new RuntimeException("format changed twice");
                    }
                    MediaFormat format = this.mMediaCodec.getOutputFormat();
                    this.mTrackIndex = muxer.addTrack(format);
                    this.mMuxerStarted = true;
                    if (muxer.start()) continue;
                    MediaMuxerWrapper mediaMuxerWrapper = muxer;
                    synchronized (mediaMuxerWrapper) {
                        while (!muxer.isStarted()) {
                            try {
                                muxer.wait(100L);
                            }
                            catch (InterruptedException e) {
                                break block7;
                            }
                        }
                        continue;
                    }
                }
                if (outputBufferId < 0) continue;
                ByteBuffer byteBuffer = encodedData = Build.VERSION.SDK_INT < 21 ? this.mMediaCodec.getOutputBuffers()[outputBufferId] : this.mMediaCodec.getOutputBuffer(outputBufferId);
                if (encodedData == null) {
                    throw new RuntimeException("encoderOutputBuffer " + outputBufferId + " was null");
                }
                if ((this.mBufferInfo.flags & 2) != 0) {
                    // empty if block
                }
                if ((this.mBufferInfo.flags & 1) != 0) {
                    // empty if block
                }
                if (!this.mMuxerStarted) {
                    throw new RuntimeException("drain:muxer hasn't started");
                }
                this.mBufferInfo.presentationTimeUs = this.getPTSUs();
                if ((this.mBufferInfo.flags & 4) != 0) {
                    this.mIsCapturing = false;
                } else {
                    muxer.writeSampleData(this.mTrackIndex, encodedData, this.mBufferInfo);
                }
                this.mMediaCodec.releaseOutputBuffer(outputBufferId, false);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                break;
            }
        }
    }

    protected long getPTSUs() {
        long currentTime = System.nanoTime();
        long pts = (currentTime - this.mStartTime - this.mPauseTotalTime) / 1000L;
        if (pts < this.prevPTS) {
            pts = this.prevPTS;
        }
        return pts;
    }

    public static interface MediaEncoderListener {
        public void onPrepared(MediaEncoder var1);

        public void onStopped(MediaEncoder var1);
    }
}

