/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import android.view.Surface;
import com.herohan.uvcapp.CameraException;
import com.herohan.uvcapp.CameraPreviewConfig;
import com.herohan.uvcapp.CameraRendererHolder;
import com.herohan.uvcapp.ICameraInternal;
import com.herohan.uvcapp.ICameraRendererHolder;
import com.herohan.uvcapp.IImageCapture;
import com.herohan.uvcapp.ImageCapture;
import com.herohan.uvcapp.ImageCapture2;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.VideoCapture;
import com.herohan.uvcapp.VideoCaptureConfig;
import com.serenegiant.opengl.renderer.RendererHolderCallback;
import com.serenegiant.usb.Format;
import com.serenegiant.usb.IButtonCallback;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCCamera;
import com.serenegiant.usb.UVCControl;
import com.serenegiant.usb.UVCParam;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.uvccamera.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

final class CameraInternal
implements ICameraInternal {
    private static final boolean DEBUG = false;
    private static final String TAG = CameraInternal.class.getSimpleName();
    private static final String KEY_ARG_1 = "key_arg1";
    private static final String KEY_ARG_2 = "key_arg2";
    private static final int DEFAULT_WIDTH = 640;
    private static final int DEFAULT_HEIGHT = 480;
    private int mFrameWidth = 640;
    private int mFrameHeight = 480;
    private final Object mSync = new Object();
    private final WeakReference<Context> mWeakContext;
    private final USBMonitor.UsbControlBlock mCtrlBlock;
    private ICameraRendererHolder mRendererHolder;
    private volatile boolean mIsPreviewing = false;
    private volatile UVCCamera mUVCCamera;
    private final List<ICameraInternal.StateCallback> mCallbacks = new ArrayList<ICameraInternal.StateCallback>();
    private IImageCapture mImageCapture;
    private VideoCapture mVideoCapture;

    public CameraInternal(Context context, USBMonitor.UsbControlBlock ctrlBlock, int vid, int pid) {
        this.mWeakContext = new WeakReference<Context>(context);
        this.mCtrlBlock = ctrlBlock;
        this.mRendererHolder = new CameraRendererHolder(this.mFrameWidth, this.mFrameHeight, new RendererHolderCallback(){

            @Override
            public void onPrimarySurfaceCreate(Surface surface) {
                if (CameraInternal.this.mIsPreviewing) {
                    CameraInternal.this.startPreview();
                }
            }

            @Override
            public void onFrameAvailable() {
            }

            @Override
            public void onPrimarySurfaceDestroy() {
            }
        });
    }

    @Override
    public void registerCallback(ICameraInternal.StateCallback callback) {
        this.mCallbacks.add(callback);
    }

    @Override
    public void unregisterCallback(ICameraInternal.StateCallback callback) {
        this.mCallbacks.remove(callback);
    }

    @Override
    public void clearCallbacks() {
        this.mCallbacks.clear();
    }

    @Override
    public List<Format> getSupportedFormatList() {
        if (this.mUVCCamera != null) {
            return this.mUVCCamera.getSupportedFormatList();
        }
        return null;
    }

    @Override
    public List<Size> getSupportedSizeList() {
        if (this.mUVCCamera != null) {
            return this.mUVCCamera.getSupportedSizeList();
        }
        return null;
    }

    @Override
    public Size getPreviewSize() {
        if (this.mUVCCamera != null) {
            return this.mUVCCamera.getPreviewSize();
        }
        return null;
    }

    @Override
    public void setPreviewSize(Size size) {
        try {
            this.mUVCCamera.setPreviewSize(size);
            this.mVideoCapture.setResolution(this.getPreviewSize());
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"setPreviewSize:", (Throwable)e);
            this.mUVCCamera.destroy();
            this.mUVCCamera = null;
        }
    }

    private void updateRendererSize(int width, int height) {
        this.mFrameWidth = width;
        this.mFrameHeight = height;
        if (this.mRendererHolder != null) {
            this.mRendererHolder.updatePrimarySize(width, height);
        }
    }

    @Override
    public void addSurface(Object surface, boolean isRecordable) {
        if (this.mRendererHolder != null) {
            this.mRendererHolder.addSlaveSurface(surface.hashCode(), surface, isRecordable);
        }
    }

    @Override
    public void removeSurface(Object surface) {
        if (this.mRendererHolder != null) {
            this.mRendererHolder.removeSlaveSurface(surface.hashCode());
        }
    }

    @Override
    public void setButtonCallback(IButtonCallback callback) {
        try {
            this.mUVCCamera.setButtonCallback(callback);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"setButtonCallback:", (Throwable)e);
        }
    }

    @Override
    public void setFrameCallback(IFrameCallback callback, int pixelFormat) {
        try {
            this.mUVCCamera.setFrameCallback(callback, pixelFormat);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"setFrameCallback:", (Throwable)e);
        }
    }

    @Override
    public void openCamera(UVCParam param, CameraPreviewConfig previewConfig, ImageCaptureConfig imageCaptureConfig, VideoCaptureConfig videoCaptureConfig) {
        if (!this.isCameraOpened()) {
            this.openUVCCamera(param, previewConfig, imageCaptureConfig, videoCaptureConfig);
        } else {
            this.processOnCameraOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetUVCCamera() {
        this.stopRecording();
        Class<CameraInternal> clazz = CameraInternal.class;
        synchronized (CameraInternal.class) {
            if (this.mUVCCamera != null) {
                this.mUVCCamera.stopPreview();
                this.mUVCCamera.destroy(true);
                this.mUVCCamera = null;
            }
            this.mRendererHolder.removeSlaveSurfaceAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openUVCCamera(UVCParam param, CameraPreviewConfig previewConfig, ImageCaptureConfig imageCaptureConfig, VideoCaptureConfig videoCaptureConfig) {
        this.resetUVCCamera();
        try {
            int result = 0;
            Class<CameraInternal> clazz = CameraInternal.class;
            synchronized (CameraInternal.class) {
                this.mUVCCamera = new UVCCamera(param);
                result = this.mUVCCamera.open(this.mCtrlBlock);
                // ** MonitorExit[var6_7] (shouldn't be in output)
                if (result != 0) {
                    Application context = UVCUtils.getApplication();
                    switch (result) {
                        case -6: {
                            throw new CameraException(CameraException.CAMERA_OPEN_ERROR_BUSY, context.getString(R.string.error_messge_camera_open_busy));
                        }
                    }
                    throw new CameraException(CameraException.CAMERA_OPEN_ERROR_UNKNOWN, context.getString(R.string.error_messge_camera_open_unknown));
                }
                this.setPreviewConfig(previewConfig);
                this.createImageCapture(imageCaptureConfig);
                this.mVideoCapture = new VideoCapture(this.mRendererHolder, videoCaptureConfig, this.getPreviewSize());
                this.processOnCameraOpen();
            }
        }
        catch (Exception e) {
            CameraException ex = null;
            ex = e instanceof CameraException ? (CameraException)e : new CameraException(CameraException.CAMERA_OPEN_ERROR_UNKNOWN, e);
            this.processOnError(ex);
        }
    }

    private void createImageCapture(ImageCaptureConfig config) {
        if (this.mImageCapture != null) {
            this.mImageCapture.release();
            this.mImageCapture = null;
        }
        switch (config.getCaptureStrategy()) {
            case 1: {
                this.mImageCapture = new ImageCapture2(this, config, this.getPreviewSize());
                break;
            }
            default: {
                this.mImageCapture = new ImageCapture(this.mRendererHolder, config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCamera() {
        this.stopRecording();
        boolean closed = false;
        Class<CameraInternal> clazz = CameraInternal.class;
        synchronized (CameraInternal.class) {
            if (this.mUVCCamera != null) {
                this.mUVCCamera.stopPreview();
                this.mUVCCamera.destroy();
                this.mUVCCamera = null;
                closed = true;
            }
            if (closed) {
                this.processOnCameraClose();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.mImageCapture != null) {
                this.mImageCapture.release();
                this.mImageCapture = null;
            }
            if (this.mVideoCapture != null) {
                this.mVideoCapture.release();
                this.mVideoCapture = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startPreview() {
        Class<CameraInternal> clazz = CameraInternal.class;
        synchronized (CameraInternal.class) {
            if (this.mUVCCamera == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Size size = this.mUVCCamera.getPreviewSize();
            if (size != null) {
                this.updateRendererSize(size.width, size.height);
            }
            this.mUVCCamera.setPreviewDisplay(this.mRendererHolder.getPrimarySurface());
            this.mUVCCamera.startPreview();
            this.mIsPreviewing = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopPreview() {
        Class<CameraInternal> clazz = CameraInternal.class;
        synchronized (CameraInternal.class) {
            if (this.mUVCCamera != null) {
                this.mUVCCamera.stopPreview();
            }
            this.mIsPreviewing = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public UVCControl getUVCControl() {
        if (this.mUVCCamera != null) {
            return this.mUVCCamera.getControl();
        }
        return null;
    }

    @Override
    public void takePicture(IImageCapture.OutputFileOptions options, IImageCapture.OnImageCaptureCallback callback) {
        if (this.isCameraOpened() && this.mImageCapture != null) {
            this.mImageCapture.takePicture(options, callback);
        } else {
            String message = "Not bound to a Camera";
            callback.onError(4, message, new IllegalStateException(message));
        }
    }

    @Override
    public boolean isRecording() {
        return this.mVideoCapture != null && this.mVideoCapture.isRecording();
    }

    @Override
    public void startRecording(VideoCapture.OutputFileOptions options, VideoCapture.OnVideoCaptureCallback callback) {
        if (this.isCameraOpened() && this.mVideoCapture != null) {
            this.mVideoCapture.startRecording(options, callback);
        } else {
            String message = "Not bound to a Camera";
            callback.onError(5, message, new IllegalStateException(message));
        }
    }

    @Override
    public void stopRecording() {
        if (this.mVideoCapture != null) {
            this.mVideoCapture.stopRecording();
        }
    }

    @Override
    public boolean isCameraOpened() {
        return this.mUVCCamera != null;
    }

    @Override
    public void release() {
        if (this.isCameraOpened()) {
            this.closeCamera();
        }
        this.releaseResource();
    }

    @Override
    public void setPreviewConfig(CameraPreviewConfig config) {
        int rotation = config.getRotation();
        if (this.mRendererHolder != null) {
            this.mRendererHolder.rotateTo(rotation);
        }
        int mirror = config.getMirror();
        if (this.mRendererHolder != null) {
            this.mRendererHolder.setMirrorMode(mirror);
        }
    }

    @Override
    public void setImageCaptureConfig(ImageCaptureConfig config) {
        this.createImageCapture(config);
    }

    @Override
    public void setVideoCaptureConfig(VideoCaptureConfig config) {
        if (this.mVideoCapture != null) {
            this.mVideoCapture.setConfig(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResource() {
        Class<CameraInternal> clazz = CameraInternal.class;
        synchronized (CameraInternal.class) {
            this.clearCallbacks();
            if (this.mRendererHolder != null) {
                this.mRendererHolder.release();
                this.mRendererHolder = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void processOnCameraOpen() {
        try {
            for (ICameraInternal.StateCallback callback : this.mCallbacks) {
                try {
                    callback.onCameraOpen();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
    }

    private void processOnCameraClose() {
        for (ICameraInternal.StateCallback callback : this.mCallbacks) {
            try {
                callback.onCameraClose();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void processOnError(CameraException ex) {
        for (ICameraInternal.StateCallback callback : this.mCallbacks) {
            try {
                callback.onError(ex);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

