/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.state.EContinue;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.ToStringGenerator;
import com.helger.servlet.filter.AbstractHttpServletFilter;
import com.helger.servlet.response.StatusAwareHttpResponseWrapper;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.impl.RequestWebScope;
import com.helger.web.scope.multipart.RequestWebScopeMultipart;
import com.helger.web.scope.request.RequestScopeInitializer;
import com.helger.xservlet.exception.IXServletExceptionHandler;
import com.helger.xservlet.exception.XServletLoggingExceptionHandler;
import java.io.IOException;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractXFilter
extends AbstractHttpServletFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractXFilter.class);
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsTotal = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.total"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsBeforeContinue = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.before-continue"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsBeforeBreak = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.before-break"));
    private final IMutableStatisticsHandlerCounter m_aCounterRequestsWithException = StatisticsManager.getCounterHandler((String)(((Object)((Object)this)).getClass().getName() + "$requests.withexception"));
    private final CallbackList<IXServletExceptionHandler> m_aExceptionHandler = new CallbackList();
    private boolean m_bIsMultipartEnabled = true;

    public AbstractXFilter() {
        this.m_aExceptionHandler.add((ICallback)new XServletLoggingExceptionHandler());
    }

    @Nonnull
    @ReturnsMutableObject
    protected final CallbackList<IXServletExceptionHandler> exceptionHandler() {
        return this.m_aExceptionHandler;
    }

    protected final boolean isMultipartEnabled() {
        return this.m_bIsMultipartEnabled;
    }

    protected final void setMultipartEnabled(boolean bl) {
        this.m_bIsMultipartEnabled = bl;
    }

    @Nonnull
    @OverrideOnDemand
    public EContinue onFilterBefore(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull IRequestWebScope iRequestWebScope) throws IOException, ServletException {
        return EContinue.CONTINUE;
    }

    @OverrideOnDemand
    public void onFilterAfter(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull IRequestWebScope iRequestWebScope) throws IOException, ServletException {
    }

    public void doHttpFilter(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull FilterChain filterChain) throws IOException, ServletException {
        this.m_aCounterRequestsTotal.increment();
        StatusAwareHttpResponseWrapper statusAwareHttpResponseWrapper = StatusAwareHttpResponseWrapper.wrap((HttpServletResponse)httpServletResponse);
        BiFunction<HttpServletRequest, HttpServletResponse, IRequestWebScope> biFunction = this.m_bIsMultipartEnabled ? RequestWebScopeMultipart::new : RequestWebScope::new;
        try (RequestScopeInitializer requestScopeInitializer = RequestScopeInitializer.create((HttpServletRequest)httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, biFunction);){
            IRequestWebScope iRequestWebScope = requestScopeInitializer.getRequestScope();
            try {
                if (this.onFilterBefore(httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, iRequestWebScope).isContinue()) {
                    this.m_aCounterRequestsBeforeContinue.increment();
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    this.onFilterAfter(httpServletRequest, (HttpServletResponse)statusAwareHttpResponseWrapper, iRequestWebScope);
                } else {
                    this.m_aCounterRequestsBeforeBreak.increment();
                }
            }
            catch (Exception exception) {
                this.m_aCounterRequestsWithException.increment();
                if (this.m_aExceptionHandler.forEachBreakable(iXServletExceptionHandler -> iXServletExceptionHandler.onException(iRequestWebScope, exception)).isContinue()) {
                    LOGGER.error("Filter exception propagated to the outside", (Throwable)exception);
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    if (exception instanceof ServletException) {
                        throw (ServletException)exception;
                    }
                    throw new ServletException("Wrapped " + exception.getClass().getName(), (Throwable)exception);
                }
            }
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ExceptionHandler", this.m_aExceptionHandler).getToString();
    }
}

