/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.commons.http.EHttpMethod;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import com.helger.web.scope.IRequestWebScope;
import com.helger.xservlet.AbstractXServlet;
import com.helger.xservlet.filter.IXServletHighLevelFilter;
import javax.annotation.Nonnull;

public final class XServletFilterTimer
implements IXServletHighLevelFilter {
    private final IMutableStatisticsHandlerKeyedTimer m_aTimer;
    private StopWatch m_aSW;

    public XServletFilterTimer(@Nonnull AbstractXServlet abstractXServlet) {
        this.m_aTimer = StatisticsManager.getKeyedTimerHandler((String)((Object)((Object)abstractXServlet)).getClass().getName());
    }

    @Override
    public void beforeRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        this.m_aSW = StopWatch.createdStarted();
    }

    @Override
    public void afterRequest(@Nonnull IRequestWebScope iRequestWebScope) {
        EHttpMethod eHttpMethod = iRequestWebScope.getHttpMethod();
        if (eHttpMethod != null) {
            this.m_aTimer.addTime(eHttpMethod.getName(), this.m_aSW.stopAndGetMillis());
        }
    }
}

