/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.http.EHttpReferrerPolicy;
import com.helger.servlet.response.EXFrameOptionType;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class XServletSettings
implements Serializable,
ICloneable<XServletSettings> {
    public static final EHttpReferrerPolicy DEFAULT_HTTP_REFERRER_POLICY = EHttpReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN;
    public static final boolean DEFAULT_MULTIPART_ENABLED = true;
    private EHttpReferrerPolicy m_eHttpReferrerPolicy = DEFAULT_HTTP_REFERRER_POLICY;
    private EXFrameOptionType m_eXFrameOptionsType = EXFrameOptionType.DEFAULT;
    private ISimpleURL m_aXFrameOptionsDomain;
    private boolean m_bIsMultipartEnabled = true;

    public XServletSettings() {
    }

    public XServletSettings(@Nonnull XServletSettings xServletSettings) {
        ValueEnforcer.notNull((Object)xServletSettings, (String)"Other");
        this.m_eHttpReferrerPolicy = xServletSettings.m_eHttpReferrerPolicy;
        this.m_eXFrameOptionsType = xServletSettings.m_eXFrameOptionsType;
        this.m_aXFrameOptionsDomain = xServletSettings.m_aXFrameOptionsDomain == null ? null : new SimpleURL(xServletSettings.m_aXFrameOptionsDomain);
        this.m_bIsMultipartEnabled = xServletSettings.m_bIsMultipartEnabled;
    }

    @Nullable
    public final EHttpReferrerPolicy getHttpReferrerPolicy() {
        return this.m_eHttpReferrerPolicy;
    }

    public final boolean hasHttpReferrerPolicy() {
        return this.m_eHttpReferrerPolicy != null;
    }

    @Nonnull
    public final XServletSettings setHttpReferrerPolicy(@Nullable EHttpReferrerPolicy eHttpReferrerPolicy) {
        this.m_eHttpReferrerPolicy = eHttpReferrerPolicy;
        return this;
    }

    @Nullable
    public final EXFrameOptionType getXFrameOptionsType() {
        return this.m_eXFrameOptionsType;
    }

    @Nullable
    public final ISimpleURL getXFrameOptionsDomain() {
        return this.m_aXFrameOptionsDomain;
    }

    public final boolean hasXFrameOptions() {
        return this.m_eXFrameOptionsType != null;
    }

    @Nonnull
    public final XServletSettings setXFrameOptions(@Nullable EXFrameOptionType eXFrameOptionType, @Nullable ISimpleURL iSimpleURL) {
        if (eXFrameOptionType != null && eXFrameOptionType.isURLRequired()) {
            ValueEnforcer.notNull((Object)iSimpleURL, (String)"Domain");
        }
        this.m_eXFrameOptionsType = eXFrameOptionType;
        this.m_aXFrameOptionsDomain = iSimpleURL;
        return this;
    }

    public final boolean isMultipartEnabled() {
        return this.m_bIsMultipartEnabled;
    }

    @Nonnull
    public final XServletSettings setMultipartEnabled(boolean bl) {
        this.m_bIsMultipartEnabled = bl;
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public XServletSettings getClone() {
        return new XServletSettings(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        XServletSettings xServletSettings = (XServletSettings)object;
        return EqualsHelper.equals((Object)this.m_eHttpReferrerPolicy, (Object)xServletSettings.m_eHttpReferrerPolicy) && EqualsHelper.equals((Object)this.m_eXFrameOptionsType, (Object)xServletSettings.m_eXFrameOptionsType) && EqualsHelper.equals((Object)this.m_aXFrameOptionsDomain, (Object)xServletSettings.m_aXFrameOptionsDomain) && this.m_bIsMultipartEnabled == xServletSettings.m_bIsMultipartEnabled;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Enum)this.m_eHttpReferrerPolicy).append((Enum)this.m_eXFrameOptionsType).append((Object)this.m_aXFrameOptionsDomain).append(this.m_bIsMultipartEnabled).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("HttpReferrerPolicy", (Enum)this.m_eHttpReferrerPolicy).append("XFrameOptionsType", (Enum)this.m_eXFrameOptionsType).append("XFrameOptionsDomain", (Object)this.m_aXFrameOptionsDomain).append("IsMultipartEnabled", this.m_bIsMultipartEnabled).getToString();
    }
}

