/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.servletstatus;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsEnumMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.string.ToStringGenerator;
import com.helger.xservlet.servletstatus.EServletStatus;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class ServletStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletStatus.class);
    private final String m_sClassName;
    private EServletStatus m_eCurrentStatus;
    private final ICommonsMap<EServletStatus, LocalDateTime> m_aStatusChangeDates = new CommonsEnumMap(EServletStatus.class);
    private final AtomicInteger m_aInvocationCount = new AtomicInteger(0);

    public ServletStatus(@Nonnull @Nonempty String string) {
        this.m_sClassName = (String)ValueEnforcer.notEmpty((CharSequence)string, (String)"ClassName");
    }

    @Nonnull
    @Nonempty
    public String getClassName() {
        return this.m_sClassName;
    }

    @Nullable
    public EServletStatus getCurrentStatus() {
        return this.m_eCurrentStatus;
    }

    void internalSetCurrentStatus(@Nonnull EServletStatus eServletStatus) {
        ValueEnforcer.notNull((Object)((Object)eServletStatus), (String)"NewStatus");
        if (!EServletStatus.isValidSuccessorOf(this.m_eCurrentStatus, eServletStatus) && LOGGER.isErrorEnabled()) {
            LOGGER.error("The new status " + (Object)((Object)eServletStatus) + " is not a valid successor of the old status " + (Object)((Object)this.m_eCurrentStatus) + " for " + this.m_sClassName);
        }
        this.m_eCurrentStatus = (EServletStatus)((Object)ValueEnforcer.notNull((Object)((Object)eServletStatus), (String)"NewStatus"));
        this.m_aStatusChangeDates.put((Object)eServletStatus, (Object)PDTFactory.getCurrentLocalDateTime());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EServletStatus, LocalDateTime> getStatusChangeMap() {
        return (ICommonsMap)this.m_aStatusChangeDates.getClone();
    }

    @Nullable
    public LocalDateTime getDateTimeOfStatus(@Nonnull EServletStatus eServletStatus) {
        return eServletStatus == null ? null : (LocalDateTime)this.m_aStatusChangeDates.get((Object)eServletStatus);
    }

    void internalIncrementInvocationCount() {
        this.m_aInvocationCount.incrementAndGet();
    }

    @Nonnegative
    public int getInvocationCount() {
        return this.m_aInvocationCount.get();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("ClassName", (Object)this.m_sClassName).append("CurrentStatus", (Enum)this.m_eCurrentStatus).append("StatusChangeDates", this.m_aStatusChangeDates).append("InvocationCount", this.m_aInvocationCount.get()).getToString();
    }
}

