/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.commons.http.EHttpMethod;
import com.helger.commons.state.EContinue;
import com.helger.http.EHttpVersion;
import com.helger.servlet.request.RequestLogger;
import com.helger.xservlet.filter.IXServletLowLevelFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XServletFilterSecurityPoxy
implements IXServletLowLevelFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletFilterSecurityPoxy.class);
    public static final XServletFilterSecurityPoxy INSTANCE = new XServletFilterSecurityPoxy();

    protected XServletFilterSecurityPoxy() {
    }

    @Override
    @Nonnull
    public EContinue beforeRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod) throws IOException {
        String string = httpServletRequest.getHeader("proxy");
        if (string != null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("httpoxy request successfully blocked: " + httpServletRequest);
            }
            RequestLogger.logRequestComplete((HttpServletRequest)httpServletRequest);
            httpServletResponse.sendError(400);
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }
}

