/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.StringHelper;
import com.helger.http.EHttpVersion;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.ResponseHelper;
import com.helger.servlet.response.StatusAwareHttpResponseWrapper;
import com.helger.xservlet.filter.IXServletLowLevelFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XServletFilterConsistency
implements IXServletLowLevelFilter {
    public static final XServletFilterConsistency INSTANCE = new XServletFilterConsistency();
    private static final Logger LOGGER = LoggerFactory.getLogger(XServletFilterConsistency.class);
    private static final AtomicBoolean SILENT_MODE = new AtomicBoolean(true);

    protected XServletFilterConsistency() {
    }

    public static boolean isSilentMode() {
        return SILENT_MODE.get();
    }

    public static boolean setSilentMode(boolean bl) {
        return SILENT_MODE.getAndSet(bl);
    }

    @Override
    @Nonnull
    public EContinue beforeRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod) {
        return EContinue.CONTINUE;
    }

    @OverrideOnDemand
    protected void checkStatusCode(@Nonnull String string, int n, @Nonnull EHttpMethod eHttpMethod) {
        if ((n < 200 || n >= 400) && !XServletFilterConsistency.isSilentMode() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("HTTP status code " + n + " in response to " + eHttpMethod.getName() + " '" + string + "'");
        }
    }

    private static boolean _isContentExpected(int n) {
        return n >= 200 && n < 300 && !ResponseHelper.isEmptyStatusCode((int)n);
    }

    @OverrideOnDemand
    protected void checkCharacterEncoding(@Nonnull String string, @Nullable String string2, int n, @Nonnull EHttpMethod eHttpMethod) {
        if (StringHelper.hasNoText((String)string2) && XServletFilterConsistency._isContentExpected(n) && !XServletFilterConsistency.isSilentMode() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("No character encoding on HTTP " + n + " response to " + eHttpMethod.getName() + " '" + string + "'");
        }
    }

    @OverrideOnDemand
    protected void checkContentType(@Nonnull String string, @Nullable String string2, int n, @Nonnull EHttpMethod eHttpMethod) {
        if (StringHelper.hasNoText((String)string2) && XServletFilterConsistency._isContentExpected(n) && !XServletFilterConsistency.isSilentMode() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("No content type on HTTP " + n + " response to " + eHttpMethod.getName() + " '" + string + "'");
        }
    }

    @OverrideOnDemand
    protected void checkHeaders(@Nonnull String string, @Nonnull HttpHeaderMap httpHeaderMap, int n, @Nonnull EHttpMethod eHttpMethod) {
    }

    @Override
    public void afterRequest(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull EHttpVersion eHttpVersion, @Nonnull EHttpMethod eHttpMethod, boolean bl, @Nullable Throwable throwable, boolean bl2) {
        ValueEnforcer.isTrue((boolean)(httpServletResponse instanceof StatusAwareHttpResponseWrapper), (String)"Must be a StatusAwareHttpResponseWrapper");
        String string = RequestHelper.getURLDecoded((HttpServletRequest)httpServletRequest);
        int n = ((StatusAwareHttpResponseWrapper)httpServletResponse).getStatusCode();
        HttpHeaderMap httpHeaderMap = ((StatusAwareHttpResponseWrapper)httpServletResponse).headerMap();
        String string2 = httpServletResponse.getCharacterEncoding();
        String string3 = httpServletResponse.getContentType();
        this.checkStatusCode(string, n, eHttpMethod);
        this.checkCharacterEncoding(string, string2, n, eHttpMethod);
        if (!bl2) {
            this.checkContentType(string, string3, n, eHttpMethod);
        }
        this.checkHeaders(string, httpHeaderMap, n, eHttpMethod);
    }
}

