/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.state.EContinue;
import com.helger.http.EHttpVersion;
import com.helger.servlet.request.RequestHelper;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.AbstractXFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class AbstractXFilterUnifiedResponse
extends AbstractXFilter {
    protected AbstractXFilterUnifiedResponse() {
    }

    @Nonnull
    protected abstract EContinue onFilterBefore(@Nonnull IRequestWebScopeWithoutResponse var1, @Nonnull UnifiedResponse var2) throws IOException, ServletException;

    @Override
    @Nonnull
    @OverrideOnDemand
    public final EContinue onFilterBefore(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull IRequestWebScope iRequestWebScope) throws IOException, ServletException {
        EHttpVersion eHttpVersion = RequestHelper.getHttpVersion((HttpServletRequest)httpServletRequest);
        if (eHttpVersion == null) {
            httpServletResponse.sendError(505);
            return EContinue.BREAK;
        }
        EHttpMethod eHttpMethod = RequestHelper.getHttpMethod((HttpServletRequest)httpServletRequest);
        if (eHttpMethod == null) {
            if (eHttpVersion.is10()) {
                httpServletResponse.sendError(400);
            } else {
                httpServletResponse.sendError(405);
            }
            return EContinue.BREAK;
        }
        UnifiedResponse unifiedResponse = new UnifiedResponse(eHttpVersion, eHttpMethod, httpServletRequest);
        if (this.onFilterBefore((IRequestWebScopeWithoutResponse)iRequestWebScope, unifiedResponse).isBreak()) {
            unifiedResponse.applyToResponse(httpServletResponse);
            return EContinue.BREAK;
        }
        return EContinue.CONTINUE;
    }
}

