/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xservlet.requesttrack;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.ICallbackList;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.scope.IScope;
import com.helger.servlet.mock.OfflineHttpServletRequest;
import com.helger.web.scope.IGlobalWebScope;
import com.helger.web.scope.IRequestWebScope;
import com.helger.web.scope.mgr.WebScopeManager;
import com.helger.web.scope.mgr.WebScoped;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import com.helger.xservlet.requesttrack.ILongRunningRequestCallback;
import com.helger.xservlet.requesttrack.IParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.LoggingLongRunningRequestCallback;
import com.helger.xservlet.requesttrack.LoggingParallelRunningRequestCallback;
import com.helger.xservlet.requesttrack.RequestTrackerSettings;
import com.helger.xservlet.requesttrack.RequestTrackingManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class RequestTracker
extends AbstractGlobalWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestTracker.class);
    private static final CallbackList<ILongRunningRequestCallback> CB_LONG_RUNNING = new CallbackList();
    private static final CallbackList<IParallelRunningRequestCallback> CB_PARALLEL_RUNNING = new CallbackList();
    private final RequestTrackingManager m_aRequestTrackingMgr = new RequestTrackingManager();
    private final ScheduledExecutorService m_aExecSvc = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("RequestTrackerMonitor-%d").daemon(true).build());

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<ILongRunningRequestCallback> longRunningRequestCallbacks() {
        return CB_LONG_RUNNING;
    }

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IParallelRunningRequestCallback> parallelRunningRequestCallbacks() {
        return CB_PARALLEL_RUNNING;
    }

    @Deprecated(forRemoval=false)
    @UsedViaReflection
    public RequestTracker() {
        if (RequestTrackerSettings.isLongRunningRequestsCheckEnabled()) {
            long l = RequestTrackerSettings.getLongRunningRequestCheckIntervalMilliseconds();
            this.m_aExecSvc.scheduleAtFixedRate(new LongRunningRequestMonitor(), 0L, l, TimeUnit.MILLISECONDS);
            LOGGER.info("LongRunningRequestMonitor was installed successfully at an interval of " + l + " milliseconds.");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("LongRunningRequestMonitor is disabled.");
        }
    }

    protected void onDestroy(@Nonnull IScope iScope) {
        LOGGER.info("RequestTrackerMonitor is now shutting down");
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aExecSvc);
        LOGGER.info("RequestTrackerMonitor was uninstalled successfully.");
    }

    @Nonnull
    public static RequestTracker getInstance() {
        return (RequestTracker)RequestTracker.getGlobalSingleton(RequestTracker.class);
    }

    @Nonnull
    public RequestTrackingManager getRequestTrackingMgr() {
        return this.m_aRequestTrackingMgr;
    }

    @Nonnull
    public ScheduledExecutorService getExecutorService() {
        return this.m_aExecSvc;
    }

    public static void addRequest(@Nonnull @Nonempty String string, @Nonnull IRequestWebScope iRequestWebScope) {
        RequestTracker.getInstance().m_aRequestTrackingMgr.addRequest(string, iRequestWebScope, CB_PARALLEL_RUNNING);
    }

    public static void removeRequest(@Nonnull @Nonempty String string) {
        RequestTracker requestTracker = (RequestTracker)RequestTracker.getGlobalSingletonIfInstantiated(RequestTracker.class);
        if (requestTracker != null) {
            requestTracker.m_aRequestTrackingMgr.removeRequest(string, CB_PARALLEL_RUNNING);
        }
    }

    static {
        CB_LONG_RUNNING.add((ICallback)new LoggingLongRunningRequestCallback((IErrorLevel)EErrorLevel.ERROR));
        CB_PARALLEL_RUNNING.add((ICallback)new LoggingParallelRunningRequestCallback((IErrorLevel)EErrorLevel.WARN));
    }

    private final class LongRunningRequestMonitor
    implements Runnable {
        private final IGlobalWebScope m_aGlobalScope = WebScopeManager.getGlobalScope();

        @Override
        public void run() {
            if (this.m_aGlobalScope.isValid()) {
                OfflineHttpServletRequest offlineHttpServletRequest = new OfflineHttpServletRequest(this.m_aGlobalScope.getServletContext(), false);
                try (WebScoped webScoped = new WebScoped((HttpServletRequest)offlineHttpServletRequest);){
                    RequestTracker.this.m_aRequestTrackingMgr.checkForLongRunningRequests((ICallbackList<ILongRunningRequestCallback>)CB_LONG_RUNNING);
                }
                catch (Exception exception) {
                    LOGGER.error("Error checking for long running requests", (Throwable)exception);
                }
            }
        }
    }
}

