/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringReplace;
import com.helger.cache.regex.RegExHelper;
import com.helger.collection.CollectionFind;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.schematron.svrl.AbstractSVRLMessage;
import com.helger.schematron.svrl.DefaultSVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLErrorLevelDeterminator;
import com.helger.schematron.svrl.ISVRLLocationBeautifier;
import com.helger.schematron.svrl.SVRLFailedAssert;
import com.helger.schematron.svrl.SVRLLocationBeautifierRegistry;
import com.helger.schematron.svrl.SVRLSuccessfulReport;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import com.helger.schematron.svrl.jaxb.FailedAssert;
import com.helger.schematron.svrl.jaxb.PropertyReference;
import com.helger.schematron.svrl.jaxb.SchematronOutputType;
import com.helger.schematron.svrl.jaxb.SuccessfulReport;
import com.helger.schematron.svrl.jaxb.Text;
import java.util.regex.Matcher;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public final class SVRLHelper {
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    private static ISVRLErrorLevelDeterminator s_aELD = new DefaultSVRLErrorLevelDeterminator();
    private static final SVRLHelper INSTANCE = new SVRLHelper();

    private SVRLHelper() {
    }

    public static @Nullable String getAsString(@Nullable Text text) {
        if (text == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : text.getContent()) {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<SVRLFailedAssert> getAllFailedAssertions(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (!(object instanceof FailedAssert)) continue;
                commonsArrayList.add((Object)new SVRLFailedAssert((FailedAssert)object));
            }
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<SVRLFailedAssert> getAllFailedAssertionsMoreOrEqualSevereThan(@Nullable SchematronOutputType schematronOutputType, @NonNull IErrorLevel iErrorLevel) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                SVRLFailedAssert sVRLFailedAssert;
                if (!(object instanceof FailedAssert) || !(sVRLFailedAssert = new SVRLFailedAssert((FailedAssert)object)).getFlag().isGE(iErrorLevel)) continue;
                commonsArrayList.add((Object)sVRLFailedAssert);
            }
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReports(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (!(object instanceof SuccessfulReport)) continue;
                commonsArrayList.add((Object)new SVRLSuccessfulReport((SuccessfulReport)object));
            }
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<SVRLSuccessfulReport> getAllSuccessfulReportsMoreOrEqualSevereThan(@Nullable SchematronOutputType schematronOutputType, @NonNull IErrorLevel iErrorLevel) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                SVRLSuccessfulReport sVRLSuccessfulReport;
                if (!(object instanceof SuccessfulReport) || !(sVRLSuccessfulReport = new SVRLSuccessfulReport((SuccessfulReport)object)).getFlag().isGE(iErrorLevel)) continue;
                commonsArrayList.add((Object)sVRLSuccessfulReport);
            }
        }
        return commonsArrayList;
    }

    @ReturnsMutableCopy
    public static @NonNull ICommonsList<AbstractSVRLMessage> getAllFailedAssertionsAndSuccessfulReports(@Nullable SchematronOutputType schematronOutputType) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (schematronOutputType != null) {
            for (Object object : schematronOutputType.getActivePatternAndFiredRuleAndFailedAssert()) {
                if (object instanceof FailedAssert) {
                    commonsArrayList.add((Object)new SVRLFailedAssert((FailedAssert)object));
                    continue;
                }
                if (!(object instanceof SuccessfulReport)) continue;
                commonsArrayList.add((Object)new SVRLSuccessfulReport((SuccessfulReport)object));
            }
        }
        return commonsArrayList;
    }

    public static @NonNull IErrorLevel getErrorLevelFromFailedAssert(@NonNull FailedAssert failedAssert) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromFailedAssert(failedAssert);
    }

    public static @NonNull IErrorLevel getErrorLevelFromSuccessfulReport(@NonNull SuccessfulReport successfulReport) {
        return SVRLHelper.getErrorLevelDeterminator().getErrorLevelFromSuccessfulReport(successfulReport);
    }

    public static @NonNull ISVRLErrorLevelDeterminator getErrorLevelDeterminator() {
        return (ISVRLErrorLevelDeterminator)RW_LOCK.readLockedGet(() -> s_aELD);
    }

    public static void setErrorLevelDeterminator(@NonNull ISVRLErrorLevelDeterminator iSVRLErrorLevelDeterminator) {
        ValueEnforcer.notNull((Object)iSVRLErrorLevelDeterminator, (String)"ErrorLevelDeterminator");
        RW_LOCK.writeLocked(() -> {
            s_aELD = iSVRLErrorLevelDeterminator;
        });
    }

    public static @NonNull String getBeautifiedLocation(@NonNull String string) {
        return SVRLHelper.getBeautifiedLocation(string, SVRLLocationBeautifierRegistry::getBeautifiedLocation);
    }

    public static @NonNull String getBeautifiedLocation(@NonNull String string, @NonNull ISVRLLocationBeautifier iSVRLLocationBeautifier) {
        ValueEnforcer.notNull((Object)string, (String)"Location");
        ValueEnforcer.notNull((Object)iSVRLLocationBeautifier, (String)"LocationBeautifier");
        String string2 = string;
        Matcher matcher = RegExHelper.getMatcher((String)"\\Q*:\\E([a-zA-Z0-9_]+)\\Q[namespace-uri()='\\E([^']+)\\Q']\\E", (String)string2);
        while (matcher.find()) {
            String string3 = matcher.group(1);
            String string4 = matcher.group(2);
            String string5 = iSVRLLocationBeautifier.getReplacementText(string4, string3);
            if (string5 == null) continue;
            string2 = StringReplace.replaceAll((String)string2, (String)matcher.group(), (CharSequence)string5);
        }
        return string2;
    }

    public static @NonNull ICommonsList<DiagnosticReference> getAllDiagnosticReferences(@NonNull FailedAssert failedAssert) {
        return CommonsArrayList.createFiltered(failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), DiagnosticReference.class::isInstance, DiagnosticReference.class::cast);
    }

    public static @NonNull ICommonsList<PropertyReference> getAllPropertyReferences(@NonNull FailedAssert failedAssert) {
        return CommonsArrayList.createFiltered(failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), PropertyReference.class::isInstance, PropertyReference.class::cast);
    }

    public static @NonNull Text getText(@NonNull FailedAssert failedAssert) {
        return (Text)CollectionFind.findFirstMapped(failedAssert.getDiagnosticReferenceOrPropertyReferenceOrText(), Text.class::isInstance, Text.class::cast);
    }

    public static @NonNull ICommonsList<DiagnosticReference> getAllDiagnosticReferences(@NonNull SuccessfulReport successfulReport) {
        return CommonsArrayList.createFiltered(successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), DiagnosticReference.class::isInstance, DiagnosticReference.class::cast);
    }

    public static @NonNull ICommonsList<PropertyReference> getAllPropertyReferences(@NonNull SuccessfulReport successfulReport) {
        return CommonsArrayList.createFiltered(successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), PropertyReference.class::isInstance, PropertyReference.class::cast);
    }

    public static @NonNull Text getText(@NonNull SuccessfulReport successfulReport) {
        return (Text)CollectionFind.findFirstMapped(successfulReport.getDiagnosticReferenceOrPropertyReferenceOrText(), Text.class::isInstance, Text.class::cast);
    }
}

