/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron.svrl;

import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.diagnostics.error.level.IErrorLevel;
import com.helger.schematron.svrl.SVRLResourceError;
import com.helger.schematron.svrl.jaxb.DiagnosticReference;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractSVRLMessage {
    private final ICommonsList<DiagnosticReference> m_aDiagnosticReferences;
    private final String m_sText;
    private final String m_sID;
    private final String m_sLocation;
    private final String m_sTest;
    private final String m_sRole;
    private final IErrorLevel m_aFlag;

    public AbstractSVRLMessage(@Nullable List<DiagnosticReference> list, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable IErrorLevel iErrorLevel) {
        this.m_aDiagnosticReferences = new CommonsArrayList(list);
        this.m_sID = StringHelper.trim((String)string);
        this.m_sText = StringHelper.trim((String)string2);
        this.m_sLocation = string3;
        this.m_sTest = string4;
        this.m_sRole = string5;
        this.m_aFlag = iErrorLevel;
    }

    @ReturnsMutableCopy
    public final @NonNull ICommonsList<DiagnosticReference> getDiagnosticReferences() {
        return (ICommonsList)this.m_aDiagnosticReferences.getClone();
    }

    public final @Nullable String getID() {
        return this.m_sID;
    }

    public final @Nullable String getText() {
        return this.m_sText;
    }

    public final @Nullable String getLocation() {
        return this.m_sLocation;
    }

    public final @Nullable String getTest() {
        return this.m_sTest;
    }

    public final @Nullable String getRole() {
        return this.m_sRole;
    }

    public final @NonNull IErrorLevel getFlag() {
        return this.m_aFlag;
    }

    public @NonNull SVRLResourceError getAsResourceError(@Nullable String string) {
        return ((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)((SVRLResourceError.SVRLErrorBuilder)new SVRLResourceError.SVRLErrorBuilder(this.m_sTest).errorLevel(this.m_aFlag)).errorID(this.m_sID)).errorFieldName(this.m_sLocation)).errorLocation(string)).errorText(this.m_sText)).build();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DiagnosticRefs", this.m_aDiagnosticReferences).append("ID", (Object)this.m_sID).append("Text", (Object)this.m_sText).append("Location", (Object)this.m_sLocation).append("Test", (Object)this.m_sTest).appendIfNotNull("Role", (Object)this.m_sRole).append("Flag", (Object)this.m_aFlag).getToString();
    }
}

