/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schematron;

import com.helger.annotation.Nonempty;
import com.helger.base.id.IHasID;
import com.helger.base.string.StringHelper;
import com.helger.collection.commons.CommonsHashSet;
import com.helger.collection.commons.ICommonsSet;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ESchematronEngine implements IHasID<String>
{
    PURE("pure", (ICommonsSet<String>)new CommonsHashSet(), false),
    ISO_SCHEMATRON("iso-schematron", (ICommonsSet<String>)new CommonsHashSet((Object[])new String[]{"iso", "isoschematron"}), true),
    SCHXSLT1("schxslt", (ICommonsSet<String>)new CommonsHashSet((Object)"schxslt1"), true),
    SCHXSLT2("schxslt2", (ICommonsSet<String>)new CommonsHashSet(), true);

    @Nonempty
    private final @NonNull String m_sID;
    private final @NonNull ICommonsSet<String> m_aIDs;
    private final boolean m_bIsXSLTBased;

    private ESchematronEngine(String string2, ICommonsSet<String> iCommonsSet, boolean bl) {
        this.m_sID = string2;
        this.m_aIDs = iCommonsSet;
        this.m_aIDs.add((Object)string2);
        this.m_bIsXSLTBased = bl;
    }

    @Nonempty
    public @NonNull String getID() {
        return this.m_sID;
    }

    public boolean isXSLTBased() {
        return this.m_bIsXSLTBased;
    }

    public static @Nullable ESchematronEngine getFromIDOrNull(@Nullable String string) {
        if (StringHelper.isNotEmpty((String)string)) {
            for (ESchematronEngine eSchematronEngine : ESchematronEngine.values()) {
                if (!eSchematronEngine.m_aIDs.contains((Object)string)) continue;
                return eSchematronEngine;
            }
        }
        return null;
    }
}

