/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.resource.URLResource;
import com.helger.commons.io.stream.ByteBufferInputStream;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.url.URLHelper;
import com.helger.xml.sax.ReadableResourceSAXInputSource;
import com.helger.xml.sax.StringSAXInputSource;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.xml.sax.InputSource;

@Immutable
public final class InputSourceFactory {
    private static final InputSourceFactory s_aInstance = new InputSourceFactory();

    private InputSourceFactory() {
    }

    @Nullable
    public static InputSource create(@Nonnull File file) {
        return InputSourceFactory.create((IReadableResource)new FileSystemResource(file));
    }

    @Nonnull
    public static InputSource create(@Nonnull URI uRI) {
        return InputSourceFactory.create(URLHelper.getAsURL((URI)uRI));
    }

    @Nonnull
    public static InputSource create(@Nonnull URL uRL) {
        return InputSourceFactory.create((IReadableResource)new URLResource(uRL));
    }

    @Nullable
    public static InputSource create(@Nonnull IHasInputStream iHasInputStream) {
        if (iHasInputStream instanceof IReadableResource) {
            return InputSourceFactory.create((IReadableResource)iHasInputStream);
        }
        return InputSourceFactory.create(iHasInputStream.getInputStream());
    }

    @Nullable
    public static InputSource create(@Nonnull IReadableResource iReadableResource) {
        File file;
        if (iReadableResource instanceof FileSystemResource && (file = iReadableResource.getAsFile()) != null) {
            URL uRL;
            InputSource inputSource = InputSourceFactory.create(FileHelper.getInputStream((File)file));
            if (inputSource != null && (uRL = iReadableResource.getAsURL()) != null) {
                inputSource.setSystemId(uRL.toExternalForm());
            }
            return inputSource;
        }
        return new ReadableResourceSAXInputSource(iReadableResource);
    }

    @Nonnull
    public static InputSource create(@Nonnull CharSequence charSequence) {
        return new StringSAXInputSource(charSequence);
    }

    @Nonnull
    public static InputSource create(@Nonnull String string) {
        return new StringSAXInputSource(string);
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] cArray) {
        return new StringSAXInputSource(cArray);
    }

    @Nonnull
    public static InputSource create(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return new StringSAXInputSource(cArray, n, n2);
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] byArray) {
        return InputSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }

    @Nonnull
    public static InputSource create(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return InputSourceFactory.create((InputStream)new NonBlockingByteArrayInputStream(byArray, n, n2));
    }

    @Nonnull
    public static InputSource create(@Nonnull ByteBuffer byteBuffer) {
        return InputSourceFactory.create((InputStream)new ByteBufferInputStream(byteBuffer));
    }

    @Nullable
    public static InputSource create(@Nullable InputStream inputStream) {
        return inputStream == null ? null : new InputSource(inputStream);
    }

    @Nullable
    public static InputSource create(@Nullable Reader reader) {
        return reader == null ? null : new InputSource(reader);
    }
}

