/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.serialize;

import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.serialize.MicroSAXHandler;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.ISAXReaderSettings;
import com.helger.xml.serialize.read.SAXReader;
import com.helger.xml.serialize.read.SAXReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.ext.EntityResolver2;

@Immutable
public final class MicroReader {
    private static final MicroReader s_aInstance = new MicroReader();

    private MicroReader() {
    }

    @Nullable
    public static IMicroDocument readMicroXML(@WillClose @Nullable InputSource inputSource) {
        return MicroReader.readMicroXML(inputSource, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@WillClose @Nullable InputSource inputSource, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (inputSource == null) {
            return null;
        }
        EntityResolver entityResolver = iSAXReaderSettings == null ? null : iSAXReaderSettings.getEntityResolver();
        MicroSAXHandler microSAXHandler = new MicroSAXHandler(false, entityResolver);
        SAXReaderSettings sAXReaderSettings = SAXReaderSettings.createCloneOnDemand(iSAXReaderSettings);
        sAXReaderSettings.setEntityResolver(microSAXHandler).setDTDHandler(microSAXHandler).setContentHandler(microSAXHandler).setLexicalHandler(microSAXHandler);
        if (sAXReaderSettings.getErrorHandler() == null) {
            sAXReaderSettings.setErrorHandler(microSAXHandler);
        }
        if (entityResolver instanceof EntityResolver2) {
            sAXReaderSettings.setFeatureValue(EXMLParserFeature.USE_ENTITY_RESOLVER2, true);
        }
        if (SAXReader.readXMLSAX(inputSource, (ISAXReaderSettings)sAXReaderSettings).isFailure()) {
            return null;
        }
        return microSAXHandler.getDocument();
    }

    @Nullable
    public static IMicroDocument readMicroXML(@WillClose @Nullable InputStream inputStream) {
        return MicroReader.readMicroXML(inputStream, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@WillClose @Nullable InputStream inputStream, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (inputStream == null) {
            return null;
        }
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(InputSourceFactory.create(inputStream), iSAXReaderSettings);
            return iMicroDocument;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable File file) {
        return MicroReader.readMicroXML(file, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable File file, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (file == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(file), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable IReadableResource iReadableResource) {
        return MicroReader.readMicroXML(iReadableResource, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable IReadableResource iReadableResource, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (iReadableResource == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(iReadableResource), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable IHasInputStream iHasInputStream) {
        return MicroReader.readMicroXML(iHasInputStream, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable IHasInputStream iHasInputStream, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (iHasInputStream == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(iHasInputStream), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@WillClose @Nullable Reader reader) {
        return MicroReader.readMicroXML(reader, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@WillClose @Nullable Reader reader, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (reader == null) {
            return null;
        }
        try {
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(InputSourceFactory.create(reader), iSAXReaderSettings);
            return iMicroDocument;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable String string) {
        return MicroReader.readMicroXML(string, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable String string, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (string == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(string), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable CharSequence charSequence) {
        return MicroReader.readMicroXML(charSequence, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable CharSequence charSequence, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (charSequence == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(charSequence), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable byte[] byArray) {
        return MicroReader.readMicroXML(byArray, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable byte[] byArray, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (byArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(byArray), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return MicroReader.readMicroXML(byArray, n, n2, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (byArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(byArray, n, n2), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable char[] cArray) {
        return MicroReader.readMicroXML(cArray, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable char[] cArray, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (cArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(cArray), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return MicroReader.readMicroXML(cArray, n, n2, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (cArray == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(cArray, n, n2), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable ByteBuffer byteBuffer) {
        return MicroReader.readMicroXML(byteBuffer, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable ByteBuffer byteBuffer, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (byteBuffer == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(byteBuffer), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable URI uRI) {
        return MicroReader.readMicroXML(uRI, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable URI uRI, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (uRI == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(uRI), iSAXReaderSettings);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable URL uRL) {
        return MicroReader.readMicroXML(uRL, (ISAXReaderSettings)null);
    }

    @Nullable
    public static IMicroDocument readMicroXML(@Nullable URL uRL, @Nullable ISAXReaderSettings iSAXReaderSettings) {
        if (uRL == null) {
            return null;
        }
        return MicroReader.readMicroXML(InputSourceFactory.create(uRL), iSAXReaderSettings);
    }
}

