/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.system.SystemProperties;
import com.helger.xml.XMLFactory;
import com.helger.xml.serialize.read.DOMReader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class XMLSystemProperties {
    public static final String SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT = "jdk.xml.entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT = "entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT = "jdk.xml.elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR = "jdk.xml.maxOccurLimit";
    public static final String SYSTEM_PROPERTY_MAX_OCCUR = "maxOccurLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT = "jdk.xml.totalEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT = "jdk.xml.maxGeneralEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT = "jdk.xml.maxParameterEntitySizeLimit";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLSystemProperties.class);
    private static final XMLSystemProperties s_aInstance = new XMLSystemProperties();

    private XMLSystemProperties() {
    }

    private static void _onSystemPropertyChange() {
        XMLFactory.reinitialize();
        DOMReader.reinitialize();
        s_aLogger.info("XML processing system properties changed!");
    }

    public static void setXMLEntityExpansionLimit(int n) {
        XMLSystemProperties.setXMLEntityExpansionLimit(Integer.toString(n));
    }

    public static void setXMLEntityExpansionLimit(@Nullable String string) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT, (String)string);
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT, (String)string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLEntityExpansionLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
        }
        if (string == null) {
            return 64000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLElementAttributeLimit(int n) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT, (String)Integer.toString(n));
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT, (String)Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLElementAttributeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
        }
        if (string == null) {
            return 10000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxOccur(int n) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_MAX_OCCUR, (String)Integer.toString(n));
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR, (String)Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLMaxOccur() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_MAX_OCCUR);
        }
        if (string == null) {
            return 5000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLTotalEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT, (String)Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLTotalEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 500000000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxGeneralEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT, (String)Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLMaxGeneralEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxParameterEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue((String)SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT, (String)Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLMaxParameterEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull((String)SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }
}

