/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.factory.IFactory;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.pool.ObjectPool;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import com.helger.xml.XMLFactory;
import com.helger.xml.sax.CollectingSAXErrorHandler;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ThreadSafe
public final class DOMReader {
    private static final IMutableStatisticsHandlerTimer s_aDomTimerHdl = StatisticsManager.getTimerHandler((String)(DOMReader.class.getName() + "$DOM"));
    private static final IMutableStatisticsHandlerTimer s_aDomSchemaTimerHdl = StatisticsManager.getTimerHandler((String)(DOMReader.class.getName() + "$DOMwithSchema"));
    private static final IMutableStatisticsHandlerCounter s_aDomErrorCounterHdl = StatisticsManager.getCounterHandler((String)(DOMReader.class.getName() + "$DOMERRORS"));
    private static final ObjectPool<DocumentBuilder> s_aDOMPool = new ObjectPool(5, (IFactory & Serializable)() -> XMLFactory.createDocumentBuilder());
    private static final DOMReader s_aInstance = new DOMReader();

    private DOMReader() {
    }

    public static void reinitialize() {
        s_aDOMPool.clearUnusedItems();
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource) throws SAXException {
        return DOMReader.readXMLDOM(inputSource, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream) throws SAXException {
        return DOMReader.readXMLDOM(inputStream, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        try {
            Document document = DOMReader.readXMLDOM(InputSourceFactory.create(inputStream), iDOMReaderSettings);
            return document;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader) throws SAXException {
        return DOMReader.readXMLDOM(reader, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        try {
            Document document = DOMReader.readXMLDOM(InputSourceFactory.create(reader), iDOMReaderSettings);
            return document;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URI uRI) throws SAXException {
        return DOMReader.readXMLDOM(uRI, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URI uRI, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(uRI), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URL uRL) throws SAXException {
        return DOMReader.readXMLDOM(uRL, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URL uRL, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(uRL), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file) throws SAXException {
        return DOMReader.readXMLDOM(file, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(file), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource) throws SAXException {
        return DOMReader.readXMLDOM(iReadableResource, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(iReadableResource), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string) throws SAXException {
        return DOMReader.readXMLDOM(string, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(string), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull CharSequence charSequence) throws SAXException {
        return DOMReader.readXMLDOM(charSequence, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull CharSequence charSequence, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(charSequence), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull ByteBuffer byteBuffer) throws SAXException {
        return DOMReader.readXMLDOM(byteBuffer, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull ByteBuffer byteBuffer, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(byteBuffer), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray) throws SAXException {
        return DOMReader.readXMLDOM(byArray, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(byArray), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) throws SAXException {
        return DOMReader.readXMLDOM(byArray, n, n2, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(byArray, n, n2), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray) throws SAXException {
        return DOMReader.readXMLDOM(cArray, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(cArray), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) throws SAXException {
        return DOMReader.readXMLDOM(cArray, n, n2, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        return DOMReader.readXMLDOM(InputSourceFactory.create(cArray, n, n2), iDOMReaderSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nonnull IDOMReaderSettings iDOMReaderSettings) throws SAXException {
        ValueEnforcer.notNull((Object)inputSource, (String)"InputSource");
        ValueEnforcer.notNull((Object)iDOMReaderSettings, (String)"Settings");
        Document document = null;
        try {
            DocumentBuilder documentBuilder;
            Object object;
            StopWatch stopWatch = StopWatch.createdStarted();
            boolean bl = false;
            if (iDOMReaderSettings.requiresNewXMLParser()) {
                object = DocumentBuilderFactory.newInstance();
                iDOMReaderSettings.applyToDocumentBuilderFactory((DocumentBuilderFactory)object);
                documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            } else {
                documentBuilder = (DocumentBuilder)s_aDOMPool.borrowObject();
                bl = true;
            }
            try {
                iDOMReaderSettings.applyToDocumentBuilder(documentBuilder);
                ErrorHandler errorHandler = iDOMReaderSettings.getErrorHandler();
                if (errorHandler instanceof CollectingSAXErrorHandler) {
                    object = (CollectingSAXErrorHandler)errorHandler;
                } else {
                    object = new CollectingSAXErrorHandler(errorHandler);
                    documentBuilder.setErrorHandler((ErrorHandler)object);
                }
                document = documentBuilder.parse(inputSource);
                if (iDOMReaderSettings.getSchema() == null) {
                    s_aDomTimerHdl.addTime(stopWatch.stopAndGetMillis());
                } else {
                    s_aDomSchemaTimerHdl.addTime(stopWatch.stopAndGetMillis());
                }
                if (((CollectingSAXErrorHandler)object).containsAtLeastOneError()) {
                    Document document2 = null;
                    return document2;
                }
            }
            finally {
                if (bl) {
                    s_aDOMPool.returnObject((Object)documentBuilder);
                }
            }
        }
        catch (Throwable throwable) {
            iDOMReaderSettings.getExceptionHandler().onException(throwable);
            s_aDomErrorCounterHdl.increment();
            if (throwable instanceof SAXException) {
                throw (SAXException)throwable;
            }
        }
        finally {
            StreamHelper.close((AutoCloseable)inputSource.getByteStream());
            StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
        }
        return document;
    }
}

