/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringParser;
import com.helger.collection.commons.CommonsHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.css.ECSSUnit;
import com.helger.css.propertyvalue.CSSSimpleValueWithUnit;
import com.helger.text.compare.ComparatorHelper;
import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class CSSNumberHelper {
    private static final ICommonsMap<String, ECSSUnit> s_aNameToUnitMap;
    private static final CSSNumberHelper INSTANCE;

    private CSSNumberHelper() {
    }

    public static @Nullable ECSSUnit getMatchingUnitInclPercentage(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"CSSValue");
        for (Map.Entry entry : s_aNameToUnitMap.entrySet()) {
            if (!string.endsWith((String)entry.getKey())) continue;
            return (ECSSUnit)((Object)entry.getValue());
        }
        return null;
    }

    public static @Nullable ECSSUnit getMatchingUnitExclPercentage(@NonNull String string) {
        ECSSUnit eCSSUnit = CSSNumberHelper.getMatchingUnitInclPercentage(string);
        return eCSSUnit == null || eCSSUnit == ECSSUnit.PERCENTAGE ? null : eCSSUnit;
    }

    public static boolean isNumberValue(@Nullable String string) {
        String string2 = StringHelper.trim((String)string);
        return StringHelper.isNotEmpty((String)string2) && StringParser.isDouble((String)string2);
    }

    public static boolean isValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.isValueWithUnit(string, true);
    }

    public static boolean isValueWithUnit(@Nullable String string, boolean bl) {
        return CSSNumberHelper.getValueWithUnit(string, bl) != null;
    }

    public static @Nullable CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string) {
        return CSSNumberHelper.getValueWithUnit(string, true);
    }

    public static @Nullable CSSSimpleValueWithUnit getValueWithUnit(@Nullable String string, boolean bl) {
        String string2 = StringHelper.trim((String)string);
        if (StringHelper.isNotEmpty((String)string2)) {
            BigDecimal bigDecimal;
            ECSSUnit eCSSUnit;
            if (string2.equals("0")) {
                return new CSSSimpleValueWithUnit(BigDecimal.ZERO, ECSSUnit.PX);
            }
            ECSSUnit eCSSUnit2 = eCSSUnit = bl ? CSSNumberHelper.getMatchingUnitInclPercentage(string2) : CSSNumberHelper.getMatchingUnitExclPercentage(string2);
            if (eCSSUnit != null && (bigDecimal = StringParser.parseBigDecimal((String)(string2 = string2.substring(0, string2.length() - eCSSUnit.getName().length()).trim()))) != null) {
                return new CSSSimpleValueWithUnit(bigDecimal, eCSSUnit);
            }
        }
        return null;
    }

    static {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (ECSSUnit eCSSUnit : ECSSUnit.values()) {
            commonsHashMap.put((Object)eCSSUnit.getName(), (Object)eCSSUnit);
        }
        s_aNameToUnitMap = commonsHashMap.getSortedByKey((Comparator)ComparatorHelper.getComparatorStringLongestFirst());
        INSTANCE = new CSSNumberHelper();
    }
}

