/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.string.StringHex;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class LoggingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingCSSParseErrorHandler.class);
    private static final int TOKEN_EOF = 0;

    @Nonempty
    public static @NonNull String createLoggingStringParseError(@NonNull ParseException parseException) {
        if (parseException.currentToken == null) {
            return parseException.getMessage();
        }
        return LoggingCSSParseErrorHandler.createLoggingStringParseError(parseException.currentToken, parseException.expectedTokenSequences, parseException.tokenImage, null);
    }

    @Nonempty
    public static @NonNull String createLoggingStringParseError(@NonNull Token token, @NonNull int[][] nArray, @NonNull String[] stringArray, @Nullable Token token2) {
        ValueEnforcer.notNull((Object)token, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)nArray, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)stringArray, (String)"TokenImageVal");
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int[] nArray2 : nArray) {
            if (n < nArray2.length) {
                n = nArray2.length;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            for (int n2 : nArray2) {
                stringBuilder.append(' ').append(stringArray[n2]);
            }
        }
        Object object = new StringBuilder(1024);
        ((StringBuilder)object).append('[').append(token.next.beginLine).append(':').append(token.next.beginColumn).append(']');
        if (token2 != null) {
            ((StringBuilder)object).append("-[").append(token2.endLine).append(':').append(token2.endColumn).append(']');
        }
        ((StringBuilder)object).append(" Encountered");
        Token token3 = token.next;
        for (int i = 0; i < n; ++i) {
            ((StringBuilder)object).append(' ');
            if (token3.kind == 0) {
                ((StringBuilder)object).append(stringArray[0]);
                break;
            }
            ((StringBuilder)object).append("text '").append(token3.image).append("' corresponding to token ").append(stringArray[token3.kind]);
            token3 = token3.next;
        }
        ((StringBuilder)object).append(". ");
        if (token2 != null) {
            ((StringBuilder)object).append("Skipped until token ").append(token2).append(". ");
        }
        ((StringBuilder)object).append(nArray.length == 1 ? "Was expecting:" : "Was expecting one of:").append((CharSequence)stringBuilder);
        return ((StringBuilder)object).toString();
    }

    @Override
    public void onCSSParseError(@NonNull ParseException parseException, @Nullable Token token) throws ParseException {
        if (parseException.expectedTokenSequences == null) {
            LOGGER.warn(parseException.getMessage());
        } else {
            LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringParseError(parseException.currentToken, parseException.expectedTokenSequences, parseException.tokenImage, token));
        }
    }

    @Nonempty
    public static @NonNull String createLoggingStringUnexpectedRule(@NonNull Token token, @Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        return "[" + token.beginLine + ":" + token.beginColumn + "] Unexpected rule '" + string + "': " + string2;
    }

    @Override
    public void onCSSUnexpectedRule(@NonNull Token token, @Nonempty @NonNull String string, @Nonempty @NonNull String string2) throws ParseException {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(token, string, string2));
    }

    @Nonempty
    public static @NonNull String createLoggingStringDeprecatedProperty(@NonNull Token token, @NonNull Token token2) {
        return "[" + token.beginLine + ":" + token.beginColumn + "] Deprecated property name '" + token.image + token2.image + "'";
    }

    @Override
    public void onCSSDeprecatedProperty(@NonNull Token token, @NonNull Token token2) {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringDeprecatedProperty(token, token2));
    }

    @Nonempty
    public static @NonNull String createLoggingStringBrowserCompliantSkip(@Nullable ParseException parseException, @NonNull Token token, @NonNull Token token2) {
        StringBuilder stringBuilder = new StringBuilder("Browser compliant mode skipped CSS from [").append(token.beginLine).append(":").append(token.beginColumn).append("] starting at token '").append(token.image).append("' until [").append(token2.endLine).append(":").append(token2.endColumn).append("] to token '").append(token2.image).append("'");
        if (parseException != null) {
            stringBuilder.append(" (based on ").append(parseException.getClass().getName()).append(": ").append(parseException.getMessage()).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException parseException, @NonNull Token token, @NonNull Token token2) throws ParseException {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringBrowserCompliantSkip(parseException, token, token2));
    }

    @Nonempty
    public static @NonNull String createLoggingStringIllegalCharacter(char c) {
        return "Found illegal character: " + c + " (0x" + StringHex.getHexStringLeadingZero((int)c, (int)4) + ")";
    }

    @Override
    public void onIllegalCharacter(char c) {
        LOGGER.warn(LoggingCSSParseErrorHandler.createLoggingStringIllegalCharacter(c));
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

