/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.CSSParseError;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@ThreadSafe
public class CollectingCSSParseErrorHandler
implements ICSSParseErrorHandler {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<CSSParseError> m_aErrors = new CommonsArrayList();

    @Override
    public void onCSSParseError(@NonNull ParseException parseException, @Nullable Token token) throws ParseException {
        this.m_aRWLock.writeLocked(() -> {
            if (parseException.expectedTokenSequences == null) {
                this.m_aErrors.add((Object)new CSSParseError(parseException.getMessage()));
            } else {
                this.m_aErrors.add((Object)new CSSParseError(parseException.currentToken, parseException.expectedTokenSequences, parseException.tokenImage, token));
            }
        });
    }

    @Override
    public void onCSSUnexpectedRule(@NonNull Token token, @Nonempty @NonNull String string, @Nonempty @NonNull String string2) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createUnexpectedRule(token, string, string2)));
    }

    @Override
    public void onCSSDeprecatedProperty(@NonNull Token token, @NonNull Token token2) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createDeprecatedProperty(token, token2)));
    }

    @Override
    public void onCSSBrowserCompliantSkip(@Nullable ParseException parseException, @NonNull Token token, @NonNull Token token2) throws ParseException {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createBrowserCompliantSkip(parseException, token, token2)));
    }

    @Override
    public void onIllegalCharacter(char c) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.add((Object)CSSParseError.createIllegalCharacter(c)));
    }

    @Nonnegative
    public boolean hasParseErrors() {
        return this.m_aRWLock.readLockedBoolean(() -> this.m_aErrors.isNotEmpty());
    }

    @Nonnegative
    public int getParseErrorCount() {
        return this.m_aRWLock.readLockedInt(() -> this.m_aErrors.size());
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSParseError> getAllParseErrors() {
        return (ICommonsList)this.m_aRWLock.readLockedGet(() -> this.m_aErrors.getClone());
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Errors", this.m_aErrors).getToString();
    }
}

