/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.annotation.CheckReturnValue;
import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.numeric.BigHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ECSSUnit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.jspecify.annotations.NonNull;

@NotThreadSafe
public class CSSSimpleValueWithUnit {
    private BigDecimal m_aValue;
    private ECSSUnit m_eUnit;

    public CSSSimpleValueWithUnit(@NonNull BigDecimal bigDecimal, @NonNull ECSSUnit eCSSUnit) {
        this.setValue(bigDecimal);
        this.setUnit(eCSSUnit);
    }

    public CSSSimpleValueWithUnit(double d, @NonNull ECSSUnit eCSSUnit) {
        this(BigDecimal.valueOf(d), eCSSUnit);
    }

    public @NonNull CSSSimpleValueWithUnit setValue(@NonNull BigDecimal bigDecimal) {
        this.m_aValue = (BigDecimal)ValueEnforcer.notNull((Object)bigDecimal, (String)"Value");
        return this;
    }

    public @NonNull CSSSimpleValueWithUnit setValue(double d) {
        return this.setValue(BigDecimal.valueOf(d));
    }

    public @NonNull BigDecimal getAsBigDecimalValue() {
        return this.m_aValue;
    }

    public double getValue() {
        return this.m_aValue.doubleValue();
    }

    public int getAsIntValue() {
        return this.m_aValue.intValue();
    }

    public long getAsLongValue() {
        return this.m_aValue.longValue();
    }

    public @NonNull CSSSimpleValueWithUnit setUnit(@NonNull ECSSUnit eCSSUnit) {
        this.m_eUnit = (ECSSUnit)((Object)ValueEnforcer.notNull((Object)((Object)eCSSUnit), (String)"Unit"));
        return this;
    }

    public @NonNull ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Nonempty
    public @NonNull String getFormatted() {
        return this.m_eUnit.format(this.m_aValue);
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit add(@NonNull BigDecimal bigDecimal) {
        return new CSSSimpleValueWithUnit(this.m_aValue.add(bigDecimal), this.m_eUnit);
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit add(double d) {
        return this.add(BigDecimal.valueOf(d));
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit substract(@NonNull BigDecimal bigDecimal) {
        return new CSSSimpleValueWithUnit(this.m_aValue.subtract(bigDecimal), this.m_eUnit);
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit substract(double d) {
        return this.substract(BigDecimal.valueOf(d));
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit multiply(@NonNull BigDecimal bigDecimal) {
        return new CSSSimpleValueWithUnit(this.m_aValue.multiply(bigDecimal), this.m_eUnit);
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit multiply(double d) {
        return this.multiply(BigDecimal.valueOf(d));
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit divide(@NonNull BigDecimal bigDecimal, @Nonnegative int n, @NonNull RoundingMode roundingMode) {
        return new CSSSimpleValueWithUnit(this.m_aValue.divide(bigDecimal, n, roundingMode), this.m_eUnit);
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit divide(@NonNull BigDecimal bigDecimal) {
        return this.divide(bigDecimal, 16, RoundingMode.HALF_UP);
    }

    @CheckReturnValue
    public @NonNull CSSSimpleValueWithUnit divide(double d) {
        return this.divide(BigDecimal.valueOf(d));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSimpleValueWithUnit cSSSimpleValueWithUnit = (CSSSimpleValueWithUnit)object;
        return BigHelper.equalValues((BigDecimal)this.m_aValue, (BigDecimal)cSSSimpleValueWithUnit.m_aValue) && this.m_eUnit.equals((Object)cSSSimpleValueWithUnit.m_eUnit);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aValue).append((Object)this.m_eUnit).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Value", (Object)this.m_aValue).append("Unit", (Enum)this.m_eUnit).getToString();
    }
}

