/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSProperty;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSNumberHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSPropertyNumber
extends AbstractCSSProperty {
    private final boolean m_bWithPercentage;

    public CSSPropertyNumber(@NonNull ECSSProperty eCSSProperty, boolean bl) {
        this(eCSSProperty, (ICSSPropertyCustomizer)null, bl);
    }

    public CSSPropertyNumber(@NonNull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl) {
        this(eCSSProperty, null, iCSSPropertyCustomizer, bl);
    }

    public CSSPropertyNumber(@NonNull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, boolean bl) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        this.m_bWithPercentage = bl;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        return super.isValidValue(string) || CSSNumberHelper.isValueWithUnit(string, this.m_bWithPercentage);
    }

    @Override
    public @NonNull CSSPropertyNumber getClone(@NonNull ECSSProperty eCSSProperty) {
        return new CSSPropertyNumber(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.m_bWithPercentage);
    }

    @Override
    public @NonNull CSSPropertyNumber getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyNumber(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.m_bWithPercentage);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyNumber cSSPropertyNumber = (CSSPropertyNumber)object;
        return this.m_bWithPercentage == cSSPropertyNumber.m_bWithPercentage;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_bWithPercentage).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("withPercentage", this.m_bWithPercentage).getToString();
    }
}

