/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.regex.RegExHelper;
import com.helger.css.ECSSVendorPrefix;
import com.helger.css.property.AbstractCSSProperty;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.customizer.ICSSPropertyCustomizer;
import com.helger.css.utils.CSSColorHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSPropertyColors
extends AbstractCSSProperty {
    private final int m_nMinArgCount;
    private final int m_nMaxArgCount;

    public CSSPropertyColors(@NonNull ECSSProperty eCSSProperty, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, n, n2);
    }

    public CSSPropertyColors(@NonNull ECSSProperty eCSSProperty, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2) {
        this(eCSSProperty, null, iCSSPropertyCustomizer, n, n2);
    }

    public CSSPropertyColors(@NonNull ECSSProperty eCSSProperty, @Nullable ECSSVendorPrefix eCSSVendorPrefix, @Nullable ICSSPropertyCustomizer iCSSPropertyCustomizer, @Nonnegative int n, @Nonnegative int n2) {
        super(eCSSProperty, eCSSVendorPrefix, iCSSPropertyCustomizer);
        ValueEnforcer.isGT0((int)n, (String)"MinNumbers");
        ValueEnforcer.isGT0((int)n2, (String)"MaxNumbers");
        ValueEnforcer.isTrue((n <= n2 ? 1 : 0) != 0, () -> "MaxArgCount (" + n2 + ") must be >= MinArgCount (" + n + ")");
        this.m_nMinArgCount = n;
        this.m_nMaxArgCount = n2;
    }

    @Override
    @Nonnegative
    public final int getMinimumArgumentCount() {
        return this.m_nMinArgCount;
    }

    @Override
    @Nonnegative
    public final int getMaximumArgumentCount() {
        return this.m_nMaxArgCount;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isValidValue(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String[] stringArray = RegExHelper.getSplitToArray((CharSequence)string.trim(), (String)"\\s+");
        if (stringArray.length < this.getMinimumArgumentCount() || stringArray.length > this.getMaximumArgumentCount()) {
            return false;
        }
        for (String string2 : stringArray) {
            String string3 = string2.trim();
            if (super.isValidValue(string3) || CSSColorHelper.isColorValue(string3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public @NonNull CSSPropertyColors getClone(@NonNull ECSSProperty eCSSProperty) {
        return new CSSPropertyColors(eCSSProperty, this.getVendorPrefix(), this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount());
    }

    @Override
    public @NonNull CSSPropertyColors getClone(@Nullable ECSSVendorPrefix eCSSVendorPrefix) {
        return new CSSPropertyColors(this.getProp(), eCSSVendorPrefix, this.getCustomizer(), this.getMinimumArgumentCount(), this.getMaximumArgumentCount());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        CSSPropertyColors cSSPropertyColors = (CSSPropertyColors)object;
        return this.m_nMinArgCount == cSSPropertyColors.m_nMinArgCount && this.m_nMaxArgCount == cSSPropertyColors.m_nMaxArgCount;
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived((int)super.hashCode()).append(this.m_nMinArgCount).append(this.m_nMaxArgCount).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("MinArgCount", this.m_nMinArgCount).append("MaxArgCount", this.m_nMaxArgCount).getToString();
    }
}

