/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.media;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashSet;
import com.helger.collection.commons.ICommonsOrderedSet;
import com.helger.css.media.ECSSMedium;
import com.helger.css.media.ICSSMediaList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSMediaList
implements ICSSMediaList,
ICloneable<CSSMediaList> {
    public static final String DEFAULT_MEDIA_STRING_SEPARATOR = ", ";
    private final ICommonsOrderedSet<ECSSMedium> m_aMedia = new CommonsLinkedHashSet();

    public CSSMediaList() {
    }

    public CSSMediaList(@NonNull ECSSMedium eCSSMedium) {
        this.addMedium(eCSSMedium);
    }

    public CSSMediaList(ECSSMedium ... eCSSMediumArray) {
        if (eCSSMediumArray != null) {
            for (ECSSMedium eCSSMedium : eCSSMediumArray) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> iterable) {
        if (iterable != null) {
            for (ECSSMedium eCSSMedium : iterable) {
                this.addMedium(eCSSMedium);
            }
        }
    }

    public CSSMediaList(@NonNull ICSSMediaList iCSSMediaList) {
        ValueEnforcer.notNull((Object)iCSSMediaList, (String)"Other");
        this.m_aMedia.addAll(iCSSMediaList.getAllMedia());
    }

    public CSSMediaList(@NonNull CSSMediaList cSSMediaList) {
        ValueEnforcer.notNull((Object)cSSMediaList, (String)"Other");
        this.m_aMedia.addAll(cSSMediaList.m_aMedia);
    }

    public @NonNull CSSMediaList addMedium(@NonNull ECSSMedium eCSSMedium) {
        ValueEnforcer.notNull((Object)((Object)eCSSMedium), (String)"Medium");
        this.m_aMedia.add((Object)eCSSMedium);
        return this;
    }

    public @NonNull CSSMediaList addMedia(ECSSMedium ... eCSSMediumArray) {
        ValueEnforcer.notNull((Object)eCSSMediumArray, (String)"MediaList");
        this.m_aMedia.addAll((Object[])eCSSMediumArray);
        return this;
    }

    public @NonNull CSSMediaList addMedia(@NonNull ICSSMediaList iCSSMediaList) {
        ValueEnforcer.notNull((Object)iCSSMediaList, (String)"MediaList");
        this.m_aMedia.addAll(iCSSMediaList.getAllMedia());
        return this;
    }

    public @NonNull CSSMediaList addMedia(@NonNull Iterable<ECSSMedium> iterable) {
        ValueEnforcer.notNull(iterable, (String)"MediaList");
        this.m_aMedia.addAll(iterable);
        return this;
    }

    public @NonNull EChange removeMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMedia.removeObject((Object)eCSSMedium);
    }

    public @NonNull EChange removeAllMedia() {
        return this.m_aMedia.removeAll();
    }

    @Override
    @Nonnegative
    public int getMediaCount() {
        return this.m_aMedia.size();
    }

    @Override
    public boolean hasNoMedia() {
        return this.m_aMedia.isEmpty();
    }

    @Override
    public boolean containsMedium(@Nullable ECSSMedium eCSSMedium) {
        return this.m_aMedia.contains((Object)eCSSMedium);
    }

    @Override
    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedSet<ECSSMedium> getAllMedia() {
        return this.m_aMedia.getClone();
    }

    @Override
    public @NonNull String getMediaString(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"Separator");
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        return StringImplode.getImplodedMapped((String)string, this.m_aMedia, ECSSMedium::getName);
    }

    @ReturnsMutableCopy
    public @NonNull CSSMediaList getClone() {
        return new CSSMediaList(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaList cSSMediaList = (CSSMediaList)object;
        return this.m_aMedia.equals(cSSMediaList.m_aMedia);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMedia).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("media", this.m_aMedia).getToString();
    }

    @ReturnsMutableCopy
    public static @NonNull CSSMediaList createOnDemand(@Nullable ICSSMediaList iCSSMediaList) {
        return iCSSMediaList == null ? new CSSMediaList() : new CSSMediaList(iCSSMediaList);
    }
}

