/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl.shorthand;

import com.helger.annotation.style.OverrideOnDemand;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.decl.CSSDeclaration;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.CSSExpressionMemberTermSimple;
import com.helger.css.decl.ICSSExpressionMember;
import com.helger.css.decl.shorthand.CSSPropertyWithDefaultValue;
import com.helger.css.property.CSSPropertyFree;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.writer.CSSWriterSettings;
import org.jspecify.annotations.NonNull;

public class CSSShortHandDescriptor {
    private final ECSSProperty m_eProperty;
    private final ICommonsList<CSSPropertyWithDefaultValue> m_aSubProperties;

    public CSSShortHandDescriptor(@NonNull ECSSProperty eCSSProperty, CSSPropertyWithDefaultValue ... cSSPropertyWithDefaultValueArray) {
        ValueEnforcer.notNull((Object)((Object)eCSSProperty), (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])cSSPropertyWithDefaultValueArray, (String)"SubProperties");
        this.m_eProperty = eCSSProperty;
        this.m_aSubProperties = new CommonsArrayList((Object[])cSSPropertyWithDefaultValueArray);
        int n = cSSPropertyWithDefaultValueArray.length;
        for (int i = 0; i < n; ++i) {
            CSSPropertyWithDefaultValue cSSPropertyWithDefaultValue = cSSPropertyWithDefaultValueArray[i];
            ICSSProperty iCSSProperty = cSSPropertyWithDefaultValue.getProperty();
            if (!(iCSSProperty instanceof CSSPropertyFree) || i >= n - 1) continue;
            throw new IllegalArgumentException("The SubProperty " + String.valueOf(cSSPropertyWithDefaultValue) + " may not use an unspecified CSSPropertyFree except for the last element!");
        }
    }

    public @NonNull ECSSProperty getProperty() {
        return this.m_eProperty;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSPropertyWithDefaultValue> getAllSubProperties() {
        return (ICommonsList)this.m_aSubProperties.getClone();
    }

    @OverrideOnDemand
    protected void modifyExpressionMembers(@NonNull ICommonsList<ICSSExpressionMember> iCommonsList) {
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSDeclaration> getSplitIntoPieces(@NonNull CSSDeclaration cSSDeclaration) {
        Object object;
        int n;
        ValueEnforcer.notNull((Object)cSSDeclaration, (String)"Declaration");
        if (!cSSDeclaration.hasProperty(this.m_eProperty)) {
            throw new IllegalArgumentException("Cannot split a '" + cSSDeclaration.getProperty() + "' as a '" + this.m_eProperty.getName() + "'");
        }
        int n2 = this.m_aSubProperties.size();
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsList<ICSSExpressionMember> iCommonsList = cSSDeclaration.getExpression().getAllMembers();
        this.modifyExpressionMembers(iCommonsList);
        int n3 = iCommonsList.size();
        CSSWriterSettings cSSWriterSettings = new CSSWriterSettings(false);
        boolean[] blArray = new boolean[n2];
        block0: for (n = 0; n < n3; ++n) {
            object = (ICSSExpressionMember)iCommonsList.get(n);
            for (int i = 0; i < n2; ++i) {
                CSSPropertyWithDefaultValue cSSPropertyWithDefaultValue;
                ICSSProperty iCSSProperty;
                int n4;
                if (blArray[i] || n + (n4 = (iCSSProperty = (cSSPropertyWithDefaultValue = (CSSPropertyWithDefaultValue)this.m_aSubProperties.get(i)).getProperty()).getMinimumArgumentCount()) - 1 >= n3) continue;
                StringBuilder stringBuilder = new StringBuilder();
                for (int j = 0; j < n4; ++j) {
                    String string = object.getAsCSSString(cSSWriterSettings);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append(string);
                }
                if (!iCSSProperty.isValidValue(stringBuilder.toString())) continue;
                CSSExpression cSSExpression = new CSSExpression();
                for (int j = 0; j < n4; ++j) {
                    cSSExpression.addMember((ICSSExpressionMember)iCommonsList.get(n + j));
                }
                commonsArrayList.add((Object)new CSSDeclaration(cSSPropertyWithDefaultValue.getProperty().getPropertyName(), cSSExpression));
                n += n4 - 1;
                blArray[i] = true;
                continue block0;
            }
        }
        for (n = 0; n < n2; ++n) {
            if (blArray[n]) continue;
            object = (CSSPropertyWithDefaultValue)this.m_aSubProperties.get(n);
            CSSExpression cSSExpression = new CSSExpression();
            cSSExpression.addMember(new CSSExpressionMemberTermSimple(((CSSPropertyWithDefaultValue)object).getDefaultValue()));
            commonsArrayList.add((Object)new CSSDeclaration(((CSSPropertyWithDefaultValue)object).getProperty().getPropertyName(), cSSExpression));
        }
        return commonsArrayList;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("property", (Enum)this.m_eProperty).append("subProperties", this.m_aSubProperties).getToString();
    }
}

