/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.decl.ICSSExpressionMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSExpressionMemberFunction
implements ICSSExpressionMember,
ICSSSourceLocationAware,
ICSSExpressionMathMember {
    private final String m_sFunctionName;
    private final CSSExpression m_aExpression;
    private CSSSourceLocation m_aSourceLocation;

    private static @NonNull String _skipBracketsAtEnd(@NonNull String string) {
        String string2 = string.trim();
        if (string2.length() > 2 && string2.endsWith("()")) {
            return string2.substring(0, string2.length() - 2).trim();
        }
        return string2;
    }

    public CSSExpressionMemberFunction(@Nonempty @NonNull String string) {
        this(string, null);
    }

    public CSSExpressionMemberFunction(@Nonempty @NonNull String string, @Nullable CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FunctionName");
        this.m_sFunctionName = CSSExpressionMemberFunction._skipBracketsAtEnd(string);
        this.m_aExpression = cSSExpression;
    }

    @Nonempty
    public final @NonNull String getFunctionName() {
        return this.m_sFunctionName;
    }

    public boolean isExpressionFunction() {
        return this.m_sFunctionName.startsWith("expression(") || this.m_sFunctionName.equals("expression");
    }

    public final @Nullable CSSExpression getExpression() {
        return this.m_aExpression;
    }

    public final boolean hasExpression() {
        return this.m_aExpression != null;
    }

    public @NonNull CSSExpressionMemberFunction getClone() {
        return new CSSExpressionMemberFunction(this.m_sFunctionName, this.m_aExpression);
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (this.m_aExpression == null) {
            if (this.m_sFunctionName.endsWith(")")) {
                return this.m_sFunctionName;
            }
            return this.m_sFunctionName + "()";
        }
        return this.m_sFunctionName + "(" + this.m_aExpression.getAsCSSString(iCSSWriterSettings, n) + ")";
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberFunction cSSExpressionMemberFunction = (CSSExpressionMemberFunction)object;
        return this.m_sFunctionName.equals(cSSExpressionMemberFunction.m_sFunctionName) && EqualsHelper.equals((Object)this.m_aExpression, (Object)cSSExpressionMemberFunction.m_aExpression);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFunctionName).append((Object)this.m_aExpression).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("funcName", (Object)this.m_sFunctionName).appendIfNotNull("expression", (Object)this.m_aExpression).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

